/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.SequentialGroup;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.TaskCopiedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedOrTypeChangedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDueSoonEvent;
import com.xebialabs.xlrelease.domain.events.TaskMovedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdater;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Configurations;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Phases;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.TaskCreateCommand;
import com.xebialabs.xlrelease.repository.TaskDeleteCommand;
import com.xebialabs.xlrelease.repository.TaskExistsCommand;
import com.xebialabs.xlrelease.repository.TaskGetCommand;
import com.xebialabs.xlrelease.repository.TaskGetPollingStatusesCommand;
import com.xebialabs.xlrelease.repository.TaskMoveCommand;
import com.xebialabs.xlrelease.repository.TaskPropertyUpdateCommand;
import com.xebialabs.xlrelease.repository.TaskUpdateCommand;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import com.xebialabs.xlrelease.views.MovementIndexes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Tasks {
    private TaskAccessService taskAccessService;
    private XlrRepository xlrRepository;
    private CiIdService ciIdService;
    private Configurations configurations;
    private ArchivingService archivingService;
    private Teams teams;
    private Map<Class<? extends Task>, TaskUpdater> taskUpdatersPerType = new HashMap<Class<? extends Task>, TaskUpdater>();
    private InternalMetadataDecoratorService decoratorService;
    private XLReleaseEventBus eventBus;
    private Phases phases;

    @Autowired
    public Tasks(TaskAccessService taskAccessService, XlrRepository xlrRepository, CiIdService ciIdService, Configurations configurations, ArchivingService archivingService, Teams teams, InternalMetadataDecoratorService decoratorService, XLReleaseEventBus eventBus, Phases phases) {
        this.taskAccessService = taskAccessService;
        this.xlrRepository = xlrRepository;
        this.ciIdService = ciIdService;
        this.configurations = configurations;
        this.archivingService = archivingService;
        this.teams = teams;
        this.decoratorService = decoratorService;
        this.eventBus = eventBus;
        this.phases = phases;
    }

    @Autowired
    public void setTaskUpdaters(List<? extends TaskUpdater> taskUpdaters) {
        taskUpdaters.forEach(updater -> {
            Class<? extends Task> taskType = updater.getTaskClass();
            if (this.taskUpdatersPerType.containsKey(taskType)) {
                throw new IllegalStateException(String.format("Two updaters are registered for the same task type %s: %s and %s", taskType, this.taskUpdatersPerType.get(taskType), updater));
            }
            this.taskUpdatersPerType.put(taskType, (TaskUpdater)updater);
        });
    }

    @Timed
    public Task getTaskWithoutDecoration(String taskId) {
        return (Task)this.xlrRepository.handle(new TaskGetCommand(taskId));
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        Task task = (Task)this.xlrRepository.handle(new TaskGetCommand(taskId));
        this.teams.decorateWithEffectiveTeams(task.getRelease());
        this.decoratorService.decorate((ConfigurationItem)task.getRelease(), Collections.singletonList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES()));
        return (T)task;
    }

    @Timed
    public List<Task> findById(List<String> taskIds) {
        return taskIds.stream().map(this::findById).collect(Collectors.toList());
    }

    @Timed
    public List<Task> findByIdIncludingArchived(List<String> taskIds) {
        return taskIds.stream().map(this::findByIdIncludingArchived).collect(Collectors.toList());
    }

    @Timed
    public List<Task> findTasksForPolling(List<String> taskIds) {
        return this.xlrRepository.handle(new TaskGetPollingStatusesCommand(taskIds));
    }

    @Timed
    public Task findByIdIncludingArchived(String taskId) {
        if (this.exists(taskId)) {
            return this.findById(taskId);
        }
        if (this.archivingService.exists(taskId)) {
            Task task = this.archivingService.getTask(taskId);
            this.decoratorService.decorate((ConfigurationItem)task.getRelease(), Collections.singletonList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES()));
            return task;
        }
        throw new NotFoundException(String.format("Task [%s] does not exist in the repository or archive", taskId), new Object[0]);
    }

    @Timed
    public String getUniqueId(String parent) {
        return this.ciIdService.getUniqueId(Type.valueOf(Task.class), parent);
    }

    @Timed
    public Task updateTaskWith(Task task, Task updated) {
        this.checkTaskIsUpdatable(task);
        Preconditions.checkArgument((boolean)this.isScheduledStartDateUpdatable(task, updated), (String)"Can't update scheduled start date of task '%s' that is neither planned or pending", (Object[])new Object[]{task.getTitle()});
        TaskUpdater taskUpdater = this.getTaskUpdater(task.getClass());
        Preconditions.checkArgument((null != taskUpdater ? 1 : 0) != 0, (String)"Cannot update task because there is no updater defined for task type '%s'", (Object[])new Object[]{task.getType().toString()});
        Task original = CiCloneHelper.cloneCi(task);
        Changes changes = taskUpdater.update(task, updated);
        ArrayList createdOrUpdatedChildCis = Lists.newArrayList((Iterable)changes.getUpdatedItems());
        createdOrUpdatedChildCis.remove(task);
        ArrayList deletedChildCis = Lists.newArrayList((Iterable)changes.getRemovedIds());
        List<Variable> newVariables = VariablePersistenceHelper.scanAndBuildNewVariables(task.getRelease(), (VisitableItem)task, this.ciIdService);
        Release release = task.getRelease();
        release.updateRealFlagStatus();
        this.xlrRepository.handle(new TaskUpdateCommand(original, task, createdOrUpdatedChildCis, deletedChildCis, release, newVariables));
        this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
        return updated;
    }

    private TaskUpdater getTaskUpdater(Class<? extends Task> taskType) {
        TaskUpdater updater = this.taskUpdatersPerType.get(taskType);
        return updater != null ? updater : this.taskUpdatersPerType.get(Task.class);
    }

    @Timed
    public void reassignToOwner(Task task, String newOwner) {
        this.checkTaskIsUpdatable(task);
        Task original = CiCloneHelper.cloneCi(task);
        task.setOwner(newOwner);
        task.setOverdueNotified(false);
        task.setDueSoonNotified(false);
        List<Variable> newVariables = VariableHelper.containsVariables((String)newOwner) ? VariablePersistenceHelper.scanAndBuildNewVariables(task.getRelease(), (VisitableItem)task, this.ciIdService) : Collections.emptyList();
        this.xlrRepository.handle(new TaskPropertyUpdateCommand(original, task, newVariables));
        this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
    }

    @Timed
    public void reassignToTeam(Task task, String newTeam) {
        this.checkTaskIsUpdatable(task);
        Task original = CiCloneHelper.cloneCi(task);
        task.setTeam(newTeam);
        this.xlrRepository.handle(new TaskPropertyUpdateCommand(original, task, Collections.emptyList()));
        this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
    }

    private void checkTaskIsUpdatable(Task task) {
        Preconditions.checkArgument((boolean)task.isUpdatable(), (String)"Can't update task '%s' because it is in state %s", (Object[])new Object[]{task.getTitle(), task.getStatus()});
    }

    private boolean isScheduledStartDateUpdatable(Task original, Task updated) {
        return original.isPlanned() || original.isPending() || Objects.equal((Object)original.getScheduledStartDate(), (Object)updated.getScheduledStartDate());
    }

    @Timed
    public Task create(String containerId, Task task) {
        return this.create(containerId, task, null);
    }

    @Timed
    public Task create(String containerId, Task task, Integer position) {
        TaskContainer container = this.findContainerById(containerId);
        return this.create(container, null, task, position, TaskCreatedEvent::new);
    }

    public Task create(TaskContainer taskContainer, @Nullable String generatedTaskId, Task task, Integer position, Function<Task, TaskCreatedOrTypeChangedEvent> eventBuilder) {
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask(task);
        this.checkContainerConditionsForAdding(taskContainer, position);
        this.addToContainerAtPosition(taskContainer, task, position);
        if (generatedTaskId == null) {
            String id = this.getUniqueId(task.getContainer().getId());
            task.setId(id);
        }
        return this.createTask(task, eventBuilder);
    }

    private void checkContainerConditionsForAdding(TaskContainer container, Integer position) {
        String message = "Can't add a task to the %s '%s' because it is in state %s.";
        if (container instanceof Phase) {
            Phase phase = (Phase)container;
            Preconditions.checkArgument((boolean)phase.isUpdatable(), (String)"Can't add a task to the %s '%s' because it is in state %s.", (Object[])new Object[]{"phase", phase.getTitle(), phase.getStatus()});
            if (position != null) {
                Preconditions.checkArgument((position >= 0 && position <= phase.getTasks().size() ? 1 : 0) != 0, (Object)"Task index out of bounds");
                if (position < phase.getTasks().size()) {
                    Task taskAfterPosition = (Task)phase.getTasks().get(position);
                    Preconditions.checkArgument((taskAfterPosition.isPlanned() || taskAfterPosition.isDoneInAdvance() ? 1 : 0) != 0, (Object)"Can't add a task before a task that is active or done");
                }
            }
        } else if (container instanceof SequentialGroup) {
            SequentialGroup group = (SequentialGroup)container;
            Preconditions.checkArgument((boolean)group.isUpdatable(), (String)"Can't add a task to the %s '%s' because it is in state %s.", (Object[])new Object[]{"sequential group", group.getTitle(), group.getStatus()});
        } else if (container instanceof ParallelGroup) {
            ParallelGroup group = (ParallelGroup)container;
            Preconditions.checkArgument((boolean)group.getStatus().isOneOf(new TaskStatus[]{TaskStatus.PLANNED, TaskStatus.PENDING, TaskStatus.WAITING_FOR_INPUT}), (String)"Can't add a task to the %s '%s' because it is in state %s.", (Object[])new Object[]{"parallel group", group.getTitle(), group.getStatus()});
        }
    }

    private Task createTask(Task task, Function<Task, TaskCreatedOrTypeChangedEvent> eventBuilder) {
        task.checkDatesValidity();
        task.setStatus(TaskStatus.PLANNED);
        if (task instanceof CustomScriptTask) {
            PythonScript pythonScript = ((CustomScriptTask)task).getPythonScript();
            Preconditions.checkArgument((pythonScript != null ? 1 : 0) != 0, (Object)"Missing pythonScript definition");
            pythonScript.setId(task.getId() + "/" + "PythonScript");
            pythonScript.setCustomScriptTask((CustomScriptTask)task);
            this.populateCIReference(pythonScript);
        } else if (task instanceof CreateReleaseTask) {
            List variables = ((CreateReleaseTask)task).getTemplateVariables();
            VariablePersistenceHelper.fixUpVariableIds(task.getId(), variables, this.ciIdService);
        }
        List<Variable> newVariables = VariablePersistenceHelper.scanAndBuildNewVariables(task.getRelease(), (VisitableItem)task, this.ciIdService);
        Task createdTask = this.xlrRepository.handle(new TaskCreateCommand(task, newVariables));
        this.eventBus.publish((XLReleaseEvent)eventBuilder.apply(createdTask));
        return createdTask;
    }

    private void populateCIReference(PythonScript pythonScript) {
        for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
            List<Configuration> configurationItems;
            Type referencedType;
            if (propertyDescriptor.getKind() != PropertyKind.CI || !propertyDescriptor.isRequired() || propertyDescriptor.get((ConfigurationItem)pythonScript) != null || !(referencedType = propertyDescriptor.getReferencedType()).isSubTypeOf(Type.valueOf(Configuration.class)) || (configurationItems = this.configurations.searchByTypeAndTitle(referencedType, null, 1L)).size() <= 0) continue;
            propertyDescriptor.set((ConfigurationItem)pythonScript, (Object)configurationItems.get(0));
        }
    }

    @Timed
    public void delete(String taskId) {
        Object task = this.findById(taskId);
        Preconditions.checkArgument((boolean)task.isPlanned(), (String)"Only planned tasks can be deleted. Task '%s' is %s.", (Object[])new Object[]{task.getTitle(), task.getStatus()});
        List linksToDelete = task.getContainer() instanceof ParallelGroup ? ((ParallelGroup)task.getContainer()).getLinksOf(task) : Collections.emptyList();
        Release release = task.getRelease();
        release.deleteTask(task);
        release.updateRealFlagStatus();
        this.xlrRepository.handle(new TaskDeleteCommand((Task)task, linksToDelete, release));
        this.eventBus.publish((XLReleaseEvent)new TaskDeletedEvent(task));
    }

    @Timed
    public void notifyOverdueTask(Task task) {
        this.eventBus.publish((XLReleaseEvent)new TaskOverdueEvent(task));
        Task original = CiCloneHelper.cloneCi(task);
        task.setOverdueNotified(true);
        this.xlrRepository.handle(new TaskPropertyUpdateCommand(original, task, Collections.emptyList()));
    }

    @Timed
    public void notifyTaskDueSoon(Task task) {
        this.eventBus.publish((XLReleaseEvent)new TaskDueSoonEvent(task));
        Task original = CiCloneHelper.cloneCi(task);
        task.setDueSoonNotified(true);
        this.xlrRepository.handle(new TaskPropertyUpdateCommand(original, task, Collections.emptyList()));
    }

    @Timed
    public boolean exists(String taskId) {
        return (Boolean)this.xlrRepository.handle(new TaskExistsCommand(taskId));
    }

    @Timed
    public boolean existsInArchive(String taskId) {
        return this.archivingService.exists(taskId);
    }

    @Timed
    public Task copyTask(String taskToCopyId, String targetContainerId, int targetPosition) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)taskToCopyId), (Object)"Id of task to copy must be provided");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)targetContainerId), (Object)"Target container id must be provided");
        Object taskToCopy = this.findById(taskToCopyId);
        TaskContainer taskContainer = this.findContainerById(targetContainerId);
        Preconditions.checkArgument((targetPosition <= taskContainer.getTasks().size() ? 1 : 0) != 0, (String)"Target position must be between 0 and %s.", (Object[])new Object[]{taskContainer.getTasks().size()});
        return this.copyTask((Task)taskToCopy, taskContainer, targetPosition);
    }

    private Task copyTask(Task taskToCopy, TaskContainer taskContainer, int targetPosition) {
        boolean isInProgressParallelGroup = taskContainer instanceof ParallelGroup && ((ParallelGroup)taskContainer).isInProgress();
        boolean isUpdatableOrDoneInAdvance = taskToCopy.isUpdatable() || taskToCopy.isDoneInAdvance();
        Preconditions.checkArgument((!isInProgressParallelGroup ? 1 : 0) != 0, (Object)"Can't copy task within 'in progress' parallel group.");
        Preconditions.checkArgument((boolean)isUpdatableOrDoneInAdvance, (String)"Can't copy task '%s' because it is %s.", (Object[])new Object[]{taskToCopy.getTitle(), taskToCopy.getStatus()});
        Preconditions.checkArgument((targetPosition >= 0 ? 1 : 0) != 0, (Object)"Target position must be greater or equal to 0.");
        String newTaskId = this.getUniqueId(taskContainer.getId());
        Task copiedTaskTemplate = CiCloneHelper.cloneCi(taskToCopy);
        copiedTaskTemplate.setTitle(copiedTaskTemplate.getTitle() + " (copy)");
        copiedTaskTemplate.resetToPlanned();
        CiHelper.rewriteWithNewId((ConfigurationItem)copiedTaskTemplate, (String)newTaskId);
        return this.create(taskContainer, newTaskId, copiedTaskTemplate, targetPosition, TaskCopiedEvent::new);
    }

    @Timed
    public Task duplicateTask(String originTaskId) {
        Object taskToCopy = this.findById(originTaskId);
        TaskContainer container = taskToCopy.getContainer();
        int targetPosition = container.getTasks().indexOf(taskToCopy) + 1;
        return this.copyTask((Task)taskToCopy, container, targetPosition);
    }

    @Timed
    public Task moveTask(MovementIndexes movementIndexes) {
        if (this.isTaskMovedWithinSameContainer(movementIndexes)) {
            return this.moveTaskWithinContainer(movementIndexes.getOriginContainerId(), movementIndexes.getOriginIndex(), movementIndexes.getTargetIndex());
        }
        return this.moveTaskBetweenContainers(movementIndexes.getOriginContainerId(), movementIndexes.getOriginIndex(), movementIndexes.getTargetContainerId(), movementIndexes.getTargetIndex());
    }

    private Task moveTaskWithinContainer(String containerId, Integer originIndex, Integer targetIndex) {
        TaskContainer taskContainer = this.findContainerById(containerId);
        List tasks = taskContainer.getTasks();
        Task taskToMove = (Task)tasks.get(originIndex);
        Preconditions.checkArgument((((PlanItem)taskContainer).isUpdatable() && taskToMove.isMovable() ? 1 : 0) != 0, (Object)"Only planned and completed in advance tasks can be moved");
        tasks.remove(taskToMove);
        tasks.add(targetIndex, taskToMove);
        Task savedTask = this.xlrRepository.handle(new TaskMoveCommand(taskToMove, taskToMove, taskContainer, taskContainer, Collections.emptyList()));
        this.eventBus.publish((XLReleaseEvent)new TaskMovedEvent(savedTask, originIndex.intValue(), targetIndex.intValue(), containerId, containerId));
        return savedTask;
    }

    private boolean isTaskMovedWithinSameContainer(MovementIndexes movementIndexes) {
        return movementIndexes.getOriginContainerId().equals(movementIndexes.getTargetContainerId());
    }

    private Task moveTaskBetweenContainers(String originContainerId, Integer originIndex, String targetContainerId, Integer targetIndex) {
        Release release = this.xlrRepository.handle(new ReleaseGetCommand(Ids.releaseIdFrom((String)originContainerId), Integer.MAX_VALUE, false, null));
        TaskContainer originContainer = this.getTaskContainer(release, originContainerId);
        TaskContainer targetContainer = this.getTaskContainer(release, targetContainerId);
        List originContainerTasks = originContainer.getTasks();
        Task taskToMove = (Task)originContainerTasks.get(originIndex);
        Preconditions.checkArgument((taskToMove.isMovable() && ((PlanItem)originContainer).isUpdatable() && ((PlanItem)targetContainer).isUpdatable() ? 1 : 0) != 0, (Object)"Only planned and completed in advance tasks can be moved");
        List<Link> linksToDelete = this.clearLinks(originContainer, taskToMove);
        String newId = this.getUniqueId(targetContainer.getId());
        Task movedTask = CiCloneHelper.cloneCi(taskToMove);
        CiHelper.rewriteWithNewId((ConfigurationItem)movedTask, (String)newId);
        originContainer.getTasks().remove(taskToMove);
        targetContainer.addTask(movedTask, targetIndex.intValue());
        movedTask.setContainer(targetContainer);
        Task savedTask = this.xlrRepository.handle(new TaskMoveCommand(taskToMove, movedTask, originContainer, targetContainer, linksToDelete));
        this.eventBus.publish((XLReleaseEvent)new TaskMovedEvent(savedTask, originIndex.intValue(), targetIndex.intValue(), originContainerId, targetContainerId));
        return savedTask;
    }

    private TaskContainer getTaskContainer(Release release, String containerId) {
        if (Ids.isPhaseId((String)containerId)) {
            return release.getPhase(containerId);
        }
        return (TaskContainer)release.getTask(containerId);
    }

    private List<Link> clearLinks(TaskContainer originContainer, Task taskToMove) {
        if (!(originContainer instanceof ParallelGroup)) {
            return Collections.emptyList();
        }
        ParallelGroup parallelGroup = (ParallelGroup)originContainer;
        return parallelGroup.getLinksOf(taskToMove);
    }

    private void addToContainerAtPosition(TaskContainer container, Task task, Integer position) {
        container.addTask(task, position != null ? position.intValue() : container.getTasks().size());
        task.setContainer(container);
    }

    private TaskContainer findContainerById(String containerId) {
        if (Ids.isPhaseId((String)containerId)) {
            return this.phases.findById(containerId);
        }
        Object container = this.findById(containerId);
        if (!(container instanceof TaskGroup)) {
            throw new IllegalArgumentException("Task can only be added to phases or task groups");
        }
        return (TaskGroup)container;
    }
}

