/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.XLReleaseServiceHolder;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlrScriptContext
extends SimpleScriptContext {
    private static final Logger scriptLogger = LoggerFactory.getLogger((String)"xlrelease.script");
    private String scriptPathForLog;

    public void addDomainObjects(Task task) {
        Release release = task.getRelease();
        this.setAttribute("release", release, 100);
        this.setAttribute("phase", task.getPhase(), 100);
        this.setAttribute("task", task, 100);
    }

    public void addApi() {
        XLReleaseServiceHolder.getApiServices().forEach(apiService -> this.setAttribute("_" + apiService.serviceName(), apiService, 100));
    }

    public void addRepositoryService() {
        this.setAttribute("_repositoryService", XLReleaseServiceHolder.getRepositoryService(), 100);
    }

    public void addScriptLogger() {
        this.setAttribute("logger", scriptLogger, 100);
    }

    void addReleaseVariables(Release release, PermissionChecker permissions, Map<String, Object> releaseVariables) {
        if (!permissions.isAuthenticated() || !permissions.hasPermission(XLReleasePermissions.EDIT_RELEASE, release)) {
            releaseVariables = Collections.unmodifiableMap(releaseVariables);
        }
        this.setAttribute("_releaseVariables", releaseVariables, 100);
    }

    void addGlobalVariables(PermissionChecker permissions, Map<String, Object> globalVariables) {
        if (!permissions.isAuthenticated() || !permissions.hasGlobalPermission(XLReleasePermissions.EDIT_GLOBAL_VARIABLES)) {
            globalVariables = Collections.unmodifiableMap(globalVariables);
        }
        this.setAttribute("_globalVariables", globalVariables, 100);
    }

    public void addProperties(ConfigurationItem configurationItem, Collection<PropertyDescriptor> properties) {
        for (PropertyDescriptor propertyDescriptor : properties) {
            String propertyName = propertyDescriptor.getName();
            if (this.ciIsSubTypeOfConfiguration(propertyDescriptor)) {
                this.setAttribute(propertyName, this.getPropertiesMap(configurationItem, propertyName), 100);
                continue;
            }
            this.setAttribute(propertyName, configurationItem.getProperty(propertyName), 100);
            this.addBindingToSugarify(propertyName, this, "_contextBindingsToWrap");
        }
    }

    public void addPropertyBindings(Collection<PropertyDescriptor> properties) {
        properties.forEach(pd -> this.addBindingToSugarify(pd.getName(), this, "_contextBindingsToUnwrap"));
    }

    public void setScriptPathForLog(String scriptPathForLog) {
        this.scriptPathForLog = scriptPathForLog;
    }

    public String getScriptPathForLog() {
        return this.scriptPathForLog;
    }

    private Map<String, Object> getPropertiesMap(ConfigurationItem configurationItem, String propertyName) {
        Configuration ciProperty = (Configuration)configurationItem.getProperty(propertyName);
        HashMap<String, Object> ciProperties = null;
        if (null != ciProperty) {
            ciProperties = new HashMap<String, Object>();
            Descriptor descriptor = ciProperty.getType().getDescriptor();
            for (PropertyDescriptor ciPropertyDescriptor : descriptor.getPropertyDescriptors()) {
                ciProperties.put(ciPropertyDescriptor.getName(), ciProperty.getProperty(ciPropertyDescriptor.getName()));
            }
        }
        return ciProperties;
    }

    private boolean ciIsSubTypeOfConfiguration(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getKind() == PropertyKind.CI && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(Configuration.class));
    }

    private void addBindingToSugarify(String bindingName, ScriptContext scriptContext, String sugarifyType) {
        ArrayList<String> sugarifiedNames = (ArrayList<String>)scriptContext.getAttribute(sugarifyType);
        if (sugarifiedNames == null) {
            sugarifiedNames = new ArrayList<String>();
            scriptContext.setAttribute(sugarifyType, sugarifiedNames, 100);
        }
        sugarifiedNames.add(bindingName);
    }
}

