/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand$;
import com.xebialabs.xlrelease.repository.ReleaseMoveCommand;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams$;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.ReleasesDeleteUnderFolderCommand;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u0001\u0003\u0001-\u0011QBR8mI\u0016\u00148+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012!B:mMRR'\"A\f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0007\u000b\u0003\u000f1{wmZ5oO\"A1\u0004\u0001B\u0001B\u0003%A$A\u0004g_2$WM]:\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011E\b\u0002\u0011\r>dG-\u001a:SKB|7/\u001b;pefD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0006i\u0016\fWn\u001d\t\u0003;\u0015J!A\n\u0010\u0003\u000bQ+\u0017-\\:\t\u0011!\u0002!\u0011!Q\u0001\n%\n\u0001B]3mK\u0006\u001cXm\u001d\t\u0003;)J!a\u000b\u0010\u0003\u0011I+G.Z1tKND\u0001\"\f\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0006i\u0006\u001c8n\u001d\t\u0003;=J!\u0001\r\u0010\u0003\u000bQ\u000b7o[:\t\u0011I\u0002!\u0011!Q\u0001\nM\n1bY5JIN+'O^5dKB\u0011A'N\u0007\u0002\u0005%\u0011aG\u0001\u0002\f\u0007&LEmU3sm&\u001cW\r\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u00035AHN\u001d*fa>\u001c\u0018\u000e^8ssB\u0011QDO\u0005\u0003wy\u0011Q\u0002\u00177s%\u0016\u0004xn]5u_JL\b\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002\u0015ad'/U;fe&,7\u000f\u0005\u0002\u001e\u007f%\u0011\u0001I\b\u0002\u000b12\u0014\u0018+^3sS\u0016\u001c\b\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\u0002)I,G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f!\t!D)\u0003\u0002F\u0005\t!\"+\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016D\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001S\u0001\fa\u0016\u0014X.[:tS>t7\u000f\u0005\u0002J\u00196\t!J\u0003\u0002L\t\u0005A1/Z2ve&$\u00180\u0003\u0002N\u0015\n\t\u0002+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\t\u0011=\u0003!\u0011!Q\u0001\nA\u000b\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u0012\ta!\u001a<f]R\u001c\u0018BA+S\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo\u001d\u0005\u0006/\u0002!\t\u0001W\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0017eS6\fX/_?\u0002\f'm\u0019\t\u0003i\u0001AQa\u0007,A\u0002qAQa\t,A\u0002\u0011BQ\u0001\u000b,A\u0002%BQ!\f,A\u00029BQA\r,A\u0002MBQ\u0001\u000f,A\u0002eBQ!\u0010,A\u0002yBQA\u0011,A\u0002\rCQa\u0012,A\u0002!CQa\u0014,A\u0002ACQ!\u001a\u0001\u0005\u0002\u0019\f\u0011c\u00195fG.4u\u000e\u001c3fe\u0016C\u0018n\u001d;t)\t9'\u000e\u0005\u0002\u000eQ&\u0011\u0011N\u0004\u0002\u0005+:LG\u000fC\u0003lI\u0002\u0007A.\u0001\u0005g_2$WM]%e!\tiGO\u0004\u0002oeB\u0011qND\u0007\u0002a*\u0011\u0011OC\u0001\u0007yI|w\u000e\u001e \n\u0005Mt\u0011A\u0002)sK\u0012,g-\u0003\u0002vm\n11\u000b\u001e:j]\u001eT!a\u001d\b\t\u000ba\u0004A\u0011A=\u0002\r\u0015D\u0018n\u001d;t)\tQX\u0010\u0005\u0002\u000ew&\u0011AP\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015Yw\u000f1\u0001m\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u0005Aq-\u001a;USRdW\rF\u0002m\u0003\u0007AQa\u001b@A\u00021Dq!a\u0002\u0001\t\u0003\tI!\u0001\u0005gS:$')_%e)\u0019\tY!a\u0007\u0002\u001eA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011A\u00024pY\u0012,'OC\u0002\u0002\u0016\u0011\ta\u0001Z8nC&t\u0017\u0002BA\r\u0003\u001f\u0011aAR8mI\u0016\u0014\bBB6\u0002\u0006\u0001\u0007A\u000e\u0003\u0006\u0002 \u0005\u0015\u0001\u0013!a\u0001\u0003C\tQ\u0001Z3qi\"\u0004B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0003mC:<'BAA\u0016\u0003\u0011Q\u0017M^1\n\t\u0005=\u0012Q\u0005\u0002\b\u0013:$XmZ3s\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003k\t!BZ5oI\nK\b+\u0019;i)\u0019\tY!a\u000e\u0002<!9\u0011\u0011HA\u0019\u0001\u0004a\u0017\u0001\u00029bi\"D!\"a\b\u00022A\u0005\t\u0019AA\u001f!\ri\u0011qH\u0005\u0004\u0003\u0003r!aA%oi\"9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0013a\u00057jgR4\u0016.Z<bE2,gi\u001c7eKJ\u001cH\u0003CA%\u0003+\nI&a\u0019\u0011\r\u0005-\u0013\u0011KA\u0006\u001b\t\tiE\u0003\u0003\u0002P\u0005%\u0012\u0001B;uS2LA!a\u0015\u0002N\t!A*[:u\u0011\u001d\t9&a\u0011A\u00021\f\u0001\u0002]1sK:$\u0018\n\u001a\u0005\t\u00037\n\u0019\u00051\u0001\u0002^\u0005!\u0001/Y4f!\ri\u0012qL\u0005\u0004\u0003Cr\"\u0001\u0002)bO\u0016D\u0011\"!\u001a\u0002DA\u0005\t\u0019\u0001>\u0002/\u0011,7m\u001c:bi\u0016<\u0016\u000e\u001e5QKJl\u0017n]:j_:\u001c\bbBA5\u0001\u0011\u0005\u00111N\u0001\u0005[>4X\r\u0006\u0004\u0002\f\u00055\u0014q\u000e\u0005\u0007W\u0006\u001d\u0004\u0019\u00017\t\u000f\u0005E\u0014q\ra\u0001Y\u0006Ya.Z<QCJ,g\u000e^%e\u0011\u001d\t)\b\u0001C\u0001\u0003o\naA]3oC6,GCBA\u0006\u0003s\nY\b\u0003\u0004l\u0003g\u0002\r\u0001\u001c\u0005\b\u0003{\n\u0019\b1\u0001m\u0003\u001dqWm\u001e(b[\u0016Dq!!!\u0001\t\u0003\t\u0019)A\btK\u0006\u00148\r\u001b+f[Bd\u0017\r^3t)\u0019\t))a$\u0002\u0012B1\u00111JA)\u0003\u000f\u0003B!!#\u0002\f6\u0011\u00111C\u0005\u0005\u0003\u001b\u000b\u0019BA\u0004SK2,\u0017m]3\t\r-\fy\b1\u0001m\u0011!\tY&a A\u0002\u0005u\u0003bBAK\u0001\u0011\u0005\u0011qS\u0001\u000fg\u0016\f'o\u00195SK2,\u0017m]3t)!\tI*!*\u0002(\u0006]\u0006\u0003BAN\u0003Ck!!!(\u000b\u0007\u0005}E!\u0001\u0004tK\u0006\u00148\r[\u0005\u0005\u0003G\u000biJA\nSK2,\u0017m]3TK\u0006\u00148\r\u001b*fgVdG\u000f\u0003\u0004l\u0003'\u0003\r\u0001\u001c\u0005\t\u0003S\u000b\u0019\n1\u0001\u0002,\u00069a-\u001b7uKJ\u001c\b\u0003BAW\u0003gk!!a,\u000b\u0007\u0005EF!A\u0003wS\u0016<8/\u0003\u0003\u00026\u0006=&a\u0004*fY\u0016\f7/Z:GS2$XM]:\t\u0015\u0005m\u00131\u0013I\u0001\u0002\u0004\ti\u0006C\u0004\u0002<\u0002!\t!!0\u0002\u00195|g/\u001a+f[Bd\u0017\r^3\u0015\u000f1\fy,!1\u0002F\"11.!/A\u00021Dq!a1\u0002:\u0002\u0007A.\u0001\u0006uK6\u0004H.\u0019;f\u0013\u0012D\u0011\"a2\u0002:B\u0005\t\u0019\u0001>\u0002!MDw.\u001e7e\u001b\u0016\u0014x-\u001a+fC6\u001c\bbBAf\u0001\u0011\u0005\u0011QZ\u0001\u0007GJ,\u0017\r^3\u0015\r\u0005-\u0011qZAi\u0011\u001d\t9&!3A\u00021D\u0001\"!\u0005\u0002J\u0002\u0007\u00111\u0002\u0005\b\u0003\u0017\u0004A\u0011AAk)!\tY!a6\u0002Z\u0006m\u0007bBA,\u0003'\u0004\r\u0001\u001c\u0005\t\u0003#\t\u0019\u000e1\u0001\u0002\f!9\u0011Q\\Aj\u0001\u0004Q\u0018AE2sK\u0006$X\rR3gCVdG\u000fV3b[NDq!!9\u0001\t\u0003\t\u0019/\u0001\u0004eK2,G/\u001a\u000b\u0004O\u0006\u0015\bBB6\u0002`\u0002\u0007A\u000eC\u0004\u0002j\u0002!I!a;\u0002\u00155,'oZ3UK\u0006l7\u000fF\u0004h\u0003[\fy/!=\t\r-\f9\u000f1\u0001m\u0011\u001d\t\u0019-a:A\u00021D\u0001\"a=\u0002h\u0002\u0007\u0011Q_\u0001\u000ei\u0016l\u0007\u000f\\1uKR+\u0017-\\:\u0011\r\u0005](\u0011\u0001B\u0004\u001d\u0011\tI0!@\u000f\u0007=\fY0C\u0001\u0010\u0013\r\tyPD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019A!\u0002\u0003\u0007M+\u0017OC\u0002\u0002\u0000:\u0001B!!#\u0003\n%!!1BA\n\u0005\u0011!V-Y7\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012\u0005a!/\u001a9mC\u000e,G+Z1ngR)qMa\u0005\u0003\u0016!11N!\u0004A\u00021Dq!a1\u0003\u000e\u0001\u0007A\u000eC\u0004\u0003\u001a\u0001!IAa\u0007\u000275,'oZ3UK6\u0004H.\u0019;f\u0003:$gi\u001c7eKJ$V-Y7t)\u0019\t)P!\b\u0003\"!A!q\u0004B\f\u0001\u0004\t)0A\u0006g_2$WM\u001d+fC6\u001c\b\u0002CAz\u0005/\u0001\r!!>\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(\u0005i!/Z:fiR\u000b7o\u001b+fC6$2a\u001aB\u0015\u0011\u001d\t\u0019Ma\tA\u00021DqA!\f\u0001\t\u0013\u0011y#\u0001\u0010de\u0016\fG/\u001a#fM\u0006,H\u000e\u001e+fC6\u001chi\u001c:UQ\u00164u\u000e\u001c3feR)qM!\r\u00034!A\u0011\u0011\u0003B\u0016\u0001\u0004\tY\u0001C\u0004\u0002X\t-\u0002\u0019\u00017\t\u000f\t]\u0002\u0001\"\u0003\u0003:\u0005)2\r[3dW\u001a{G\u000eZ3s\u0007\u0006t')Z'pm\u0016$G#B4\u0003<\tu\u0002BB6\u00036\u0001\u0007A\u000eC\u0004\u0003@\tU\u0002\u0019\u00017\u0002\u0013=\u0004XM]1uS>t\u0007b\u0002B\"\u0001\u0011%!QI\u0001\u0018G\",7m\u001b+f[Bd\u0017\r^3DC:\u0014U-T8wK\u0012$2a\u001aB$\u0011\u001d\t\u0019M!\u0011A\u00021DqAa\u0013\u0001\t\u0013\u0011i%\u0001\nhKR\u0014VO\u001c8j]\u001e\u0014V\r\\3bg\u0016\u001cH\u0003\u0002B(\u0005#\u0002b!a>\u0003\u0002\u0005\u001d\u0005BB6\u0003J\u0001\u0007A\u000eC\u0004\u0003V\u0001!IAa\u0016\u0002%\u001d,G/\u00128bE2,G\r\u0016:jO\u001e,'o\u001d\u000b\u0005\u00053\u0012\t\u0007\u0005\u0004\u0002x\n\u0005!1\f\t\u0005\u0003\u0013\u0013i&\u0003\u0003\u0003`\u0005M!A\u0004*fY\u0016\f7/\u001a+sS\u001e<WM\u001d\u0005\b\u0005G\u0012\u0019\u00061\u0001m\u0003)\tgnY3ti>\u0014\u0018\n\u001a\u0005\b\u0005O\u0002A\u0011\u0002B5\u0003m9W\r^!vi>\u001cF/\u0019:u!\u0016tG-\u001b8h%\u0016dW-Y:fgR!!q\nB6\u0011\u0019Y'Q\ra\u0001Y\"I!q\u000e\u0001\u0012\u0002\u0013\u0005!\u0011O\u0001\u0017[>4X\rV3na2\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u000f\u0016\u0004u\nU4F\u0001B<!\u0011\u0011IHa!\u000e\u0005\tm$\u0002\u0002B?\u0005\u007f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0005e\"\u0001\u0006b]:|G/\u0019;j_:LAA!\"\u0003|\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t%\u0005!%A\u0005\u0002\t-\u0015A\u00054j]\u0012\u0014\u00150\u00133%I\u00164\u0017-\u001e7uII*\"A!$+\t\u0005\u0005\"Q\u000f\u0005\n\u0005#\u0003\u0011\u0013!C\u0001\u0005'\u000bACZ5oI\nK\b+\u0019;iI\u0011,g-Y;mi\u0012\u0012TC\u0001BKU\u0011\tiD!\u001e\t\u0013\te\u0005!%A\u0005\u0002\tE\u0014!\b7jgR4\u0016.Z<bE2,gi\u001c7eKJ\u001cH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\tu\u0005!%A\u0005\u0002\t}\u0015\u0001G:fCJ\u001c\u0007NU3mK\u0006\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0015\u0016\u0005\u0003;\u0012)\b")
public class FolderService
implements Logging {
    private final FolderRepository folders;
    private final Teams teams;
    private final Releases releases;
    private final Tasks tasks;
    private final CiIdService ciIdService;
    private final XlrRepository xlrRepository;
    private final XlrQueries xlrQueries;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Folder ", " cannot be found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.ROOT_FOLDER_ID})), new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find Folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})), new Object[0]);
        });
    }

    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find Folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})), new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public Folder findByPath(String path, int depth) {
        void var3_3;
        Folder found = this.folders.findByPath(path, depth);
        this.permissions.check(XLReleasePermissions.VIEW_FOLDER, found.getId());
        return var3_3;
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    public List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        this.permissions.checkViewFolder(parentId);
        return this.folders.listViewableFolders(parentId, page, decorateWithPermissions);
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkFolderCanBeMoved(folderId, "move");
        return this.folders.move(folderId, newParentId);
    }

    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        return this.folders.rename(folderId, newName);
    }

    public List<Release> searchTemplates(String folderId, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), page.depth()).getReleases();
    }

    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage(), page.depth());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String string;
        String newTemplateId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId, Ids.getName((String)templateId)}));
        this.checkTemplateCanBeMoved(templateId);
        String string2 = Ids.getParentId((String)templateId);
        String string3 = folderId;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to move template ", " to same folder ", ". Will be ignored."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{templateId, folderId})));
            string = templateId;
        } else {
            Buffer templateTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teams.getStoredTeams(templateId)).asScala();
            this.xlrRepository.handle(new ReleaseMoveCommand(templateId, newTemplateId));
            this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
            if (shouldMergeTeams) {
                this.mergeTeams(folderId, newTemplateId, (Seq<Team>)templateTeams);
            } else {
                this.replaceTeams(folderId, newTemplateId);
            }
            string = newTemplateId;
        }
        return string;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    public Folder create(String parentId, Folder folder) {
        return this.create(parentId, folder, true);
    }

    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        Folder saved;
        block3: {
            this.checkFolderExists(parentId);
            this.folders.checkNameIsUnique(parentId, folder.getTitle());
            if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
                folder.setId(this.ciIdService.getGloballyUniqueId(Type.valueOf(Folder.class), parentId));
            } else {
                folder.setId(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentId, Ids.getName((String)folder.getId())})));
            }
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating folder ", " with id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folder.getTitle(), folder.getId()})));
            saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
            if (!createDefaultTeams) break block3;
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.createDefaultTeamsForTheFolder(saved, parentId);
            }
        }
        return saved;
    }

    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, "delete");
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})));
        this.xlrRepository.handle(new ReleasesDeleteUnderFolderCommand(folderId));
        this.folders.delete(folderId);
    }

    private void mergeTeams(String folderId, String templateId, Seq<Team> templateTeams) {
        block0: {
            if (!templateTeams.nonEmpty()) break block0;
            Buffer folderTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teams.getEffectiveTeams(folderId)).asScala();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable & scala.Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> folderId);
            Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teams.saveTeamsToPlatform(folderTeamsContainerId, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(mergedTeams).asJava());
            this.teams.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teams.deleteTeamsFromPlatform(templateId);
    }

    private Seq<Team> mergeTemplateAndFolderTeams(Seq<Team> folderTeams, Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((TraversableOnce)folderTeams.map((Function1 & Serializable & scala.Serializable)team -> new Tuple2((Object)team.getTeamName(), team), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).toSeq());
        templateTeams.foreach((Function1 & Serializable & scala.Serializable)templateTeam -> {
            MapLike mapLike;
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                mapLike = folderTeamsMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                Set memberSet = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getMembers()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getMembers()).asScala()).toSet());
                Set roleSet = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getRoles()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getRoles()).asScala()).toSet());
                Set permissionSet = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getPermissions()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getPermissions()).asScala()).toSet());
                folderTeam.setMembers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(memberSet.toSeq()).asJava());
                folderTeam.setRoles((List)JavaConverters$.MODULE$.seqAsJavaListConverter(roleSet.toSeq()).asJava());
                folderTeam.setPermissions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(permissionSet.toSeq()).asJava());
                mapLike = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return mapLike;
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releases.findById(templateId);
        template.getAllTasks().forEach(task -> $this.tasks.reassignToTeam((Task)task, null));
    }

    private void createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions(XLReleasePermissions.getFolderPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.setPermissions(XLReleasePermissions.getReleasePermissions());
        releaseAdmin.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        this.teams.saveTeamsToPlatform(folder.getId(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{folderOwner, templateOwner, releaseAdmin}))).asJava());
    }

    private void checkFolderCanBeMoved(String folderId, String operation) {
        Seq<Release> activeReleases = this.getRunningReleases(folderId);
        Seq<ReleaseTrigger> enabledTriggers = this.getEnabledTriggers(folderId);
        Seq<Release> autoStartPendingReleases = this.getAutoStartPendingReleases(folderId);
        if (activeReleases.nonEmpty() || enabledTriggers.nonEmpty() || autoStartPendingReleases.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to ", " folder ", ", which has active releases ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation, folderId, ((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or enabled triggers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or pending releases with auto start option enabled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
            String details = "";
            if (activeReleases.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Active releases: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            if (enabledTriggers.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Enabled triggers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)t -> t.getTemplate().getTitle() + "/" + t.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            if (autoStartPendingReleases.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Pending releases with auto start: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You cannot ", " this folder. The folder or its subfolders contain active releases or templates ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation, details})), new Object[0]);
        }
    }

    private void checkTemplateCanBeMoved(String templateId) {
        Release template = this.xlrRepository.handle(new ReleaseGetCommand(templateId, Predef$.MODULE$.int2Integer(2), true, ReleaseGetCommand$.MODULE$.apply$default$4()));
        Buffer enabledTriggers = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(template.getReleaseTriggers()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isEnabled()));
        if (enabledTriggers.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to move template ", " with enabled triggers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{templateId, ((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getId(), Buffer$.MODULE$.canBuildFrom())).mkString(", ")})));
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You can't move this template because it has one or more enabled triggers: "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getTitle(), Buffer$.MODULE$.canBuildFrom())).mkString(", ")})), new Object[0]);
        }
    }

    private Seq<Release> getRunningReleases(String folderId) {
        Page x$11 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$12 = ReleaseStatus.ACTIVE_STATUSES;
        String x$13 = folderId;
        String x$14 = ReleaseSearchByParams$.MODULE$.apply$default$2();
        String x$15 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$16 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$17 = ReleaseSearchByParams$.MODULE$.apply$default$7();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.xlrQueries.query(new ReleaseSearchByParams(x$11, x$14, x$12, x$15, x$16, x$13, x$17))).asScala();
    }

    private Seq<ReleaseTrigger> getEnabledTriggers(String ancestorId) {
        Page x$18 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(2));
        ReleaseStatus[] x$19 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE});
        String x$20 = ancestorId;
        String x$21 = ReleaseSearchByParams$.MODULE$.apply$default$2();
        String x$22 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$23 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$24 = ReleaseSearchByParams$.MODULE$.apply$default$7();
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.xlrQueries.query(new ReleaseSearchByParams(x$18, x$21, x$19, x$22, x$23, x$20, x$24))).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$9.getReleaseTriggers()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isEnabled()));
    }

    private Seq<Release> getAutoStartPendingReleases(String folderId) {
        Page x$25 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$26 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED});
        String x$27 = folderId;
        boolean x$28 = true;
        String x$29 = ReleaseSearchByParams$.MODULE$.apply$default$2();
        String x$30 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$31 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.xlrQueries.query(new ReleaseSearchByParams(x$25, x$29, x$26, x$30, x$31, x$27, x$28))).asScala();
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public FolderService(FolderRepository folders, Teams teams, Releases releases, Tasks tasks, CiIdService ciIdService, XlrRepository xlrRepository, XlrQueries xlrQueries, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus) {
        this.folders = folders;
        this.teams = teams;
        this.releases = releases;
        this.tasks = tasks;
        this.ciIdService = ciIdService;
        this.xlrRepository = xlrRepository;
        this.xlrQueries = xlrQueries;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

