/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.PermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TeamUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TriggerCreatedNewReleaseEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.planner.Planner;
import com.xebialabs.xlrelease.planner.PlannerReleaseItem;
import com.xebialabs.xlrelease.planner.PlannerReleaseTree;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRestart;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.repository.Phases;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableDuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseEditor {
    public static final Duration MIN_RELEASE_DURATION = Duration.standardHours((long)8L);
    private Teams teams;
    private Phases phases;
    private Releases releases;
    private PermissionChecker permissions;
    private CiIdService ciIdService;
    private XLReleaseEventBus eventBus;
    private PhaseRestart phaseRestart;

    @Autowired
    public ReleaseEditor(Teams teams, Phases phases, Releases releases, PermissionChecker permissions, CiIdService ciIdService, XLReleaseEventBus eventBus, PhaseRestart phaseRestart) {
        this.teams = teams;
        this.phases = phases;
        this.releases = releases;
        this.permissions = permissions;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        this.phaseRestart = phaseRestart;
    }

    public Team addTeam(Release release, Team team) {
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't add team to release '%s' because it is %s", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Preconditions.checkArgument((!Ids.isInFolder((String)release.getId()) ? 1 : 0) != 0, (String)"Can't add team to release '%s' because it is inside a folder", (Object[])new Object[]{release.getTitle()});
        Team addedTeam = this.teams.create(release.getId(), team);
        release.addTeam(addedTeam);
        this.eventBus.publish((XLReleaseEvent)new TeamCreatedEvent(release, addedTeam));
        return addedTeam;
    }

    public Team updateTeam(String teamId, Team newTeam) {
        String releaseId = Ids.releaseIdFrom((String)teamId);
        Release release = this.releases.findById(releaseId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't update team on release '%s' because it is %s", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Preconditions.checkArgument((!Ids.isInFolder((String)releaseId) ? 1 : 0) != 0, (String)"Can't update team on release '%s' because it is inside a folder", (Object[])new Object[]{release.getTitle()});
        Team team = release.getTeamWithId(teamId);
        if (team.isSystemTeam()) {
            Preconditions.checkArgument((boolean)newTeam.getTeamName().equals(team.getTeamName()), (Object)"Cannot rename a system release");
        }
        release.updateTeam(newTeam);
        this.teams.saveTeamsToPlatform(release);
        this.eventBus.publish((XLReleaseEvent)new TeamUpdatedEvent(release, team, newTeam));
        return team;
    }

    public List<Team> updateTeams(String releaseId, List<Team> updatedTeams) {
        Release release = this.releases.findById(releaseId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't update teams on release '%s' because it is %s", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Preconditions.checkArgument((!Ids.isInFolder((String)releaseId) ? 1 : 0) != 0, (String)"Can't update teams on release '%s' because it is inside a folder", (Object[])new Object[]{release.getTitle()});
        List currentTeams = release.getTeams();
        Map<String, Set<String>> currentPermissions = this.getTeamsPermissions(currentTeams);
        Set<Team> toDelete = currentTeams.stream().filter(team -> !updatedTeams.contains(team)).collect(Collectors.toSet());
        Set<Team> toUpdate = updatedTeams.stream().filter(currentTeams::contains).collect(Collectors.toSet());
        Set<Team> toCreate = updatedTeams.stream().filter(team -> !currentTeams.contains(team)).collect(Collectors.toSet());
        ArrayList<PermissionsUpdatedEvent> teamEvents = new ArrayList<PermissionsUpdatedEvent>();
        toDelete.forEach(team -> {
            release.deleteTeam(team.getId());
            teamEvents.add((PermissionsUpdatedEvent)new TeamDeletedEvent(release, team));
        });
        toUpdate.forEach(team -> {
            Team currentTeam = release.getTeamWithId(team.getId());
            Team original = CiCloneHelper.cloneCi(currentTeam);
            release.updateTeam(team);
            if (!this.teamsAreEqual(original, (Team)team)) {
                teamEvents.add((PermissionsUpdatedEvent)new TeamUpdatedEvent(release, original, team));
            }
        });
        toCreate.forEach(team -> {
            release.addTeam(team);
            teamEvents.add((PermissionsUpdatedEvent)new TeamCreatedEvent(release, team));
        });
        Map<String, Set<String>> newPermissions = this.getTeamsPermissions(release.getTeams());
        if (!newPermissions.equals(currentPermissions)) {
            teamEvents.add(new PermissionsUpdatedEvent(release.getTeams()));
        }
        this.teams.saveTeamsToPlatform(release);
        teamEvents.forEach(this.eventBus::publish);
        return release.getTeams();
    }

    public void deleteTeam(Release release, String teamId) {
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't delete team from release '%s' because it is %s", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Preconditions.checkArgument((!Ids.isInFolder((String)release.getId()) ? 1 : 0) != 0, (String)"Can't delete team from release '%s' because it is inside a folder", (Object[])new Object[]{release.getTitle()});
        Team team = release.getTeamWithId(teamId);
        release.deleteTeam(teamId);
        this.teams.saveTeamsToPlatform(release);
        this.eventBus.publish((XLReleaseEvent)new TeamDeletedEvent(release, team));
    }

    public Release createTemplate(Release templateData) {
        return this.createTemplate(templateData, null);
    }

    public Release createTemplate(Release templateData, String parentId) {
        templateData.checkDatesValidityForTemplate();
        Release template = this.releases.createTemplate(templateData, parentId);
        this.addFirstBlankPhase(template);
        if (parentId == null) {
            ArrayList adminTeamPermissions = Lists.newArrayList((Object[])new String[]{XLReleasePermissions.VIEW_TEMPLATE.getPermissionName()});
            adminTeamPermissions.addAll(XLReleasePermissions.getReleasePermissions());
            this.addDefaultTeam(template, "Release Admin", adminTeamPermissions, false, false);
            this.addDefaultTeam(template, "Template Owner", XLReleasePermissions.getTemplateOnlyPermissions(), true, false);
        }
        return this.releases.findById(template.getId(), false);
    }

    private void addFirstBlankPhase(Release release) {
        this.phases.create(release.getId(), null, null);
    }

    @VisibleForTesting
    void addDefaultTeam(Release release, String teamName, List<String> permissions, boolean includeCurrentUser, boolean includeOwner) {
        boolean isCreation;
        Team team = null;
        if (teamName.equals("Release Admin")) {
            team = release.getAdminTeam();
        }
        boolean bl = isCreation = team == null;
        if (isCreation) {
            team = (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
            team.setTeamName(teamName);
        }
        team.setPermissions(permissions);
        if (includeCurrentUser) {
            team.addMember(Permissions.getAuthenticatedUserName());
        }
        if (includeOwner) {
            team.addMember(release.getOwner());
        }
        if (isCreation) {
            this.addTeam(release, team);
        } else {
            this.updateTeam(team.getId(), team);
        }
        this.eventBus.publish((XLReleaseEvent)new PermissionsUpdatedEvent(release.getTeams()));
    }

    public Duration getDurationOf(Release release) {
        Duration duration;
        if (release.getPlannedDuration() != null) {
            duration = Duration.standardSeconds((long)release.getPlannedDuration().longValue());
        } else if (release.getDueDate() != null) {
            duration = Duration.millis((long)(release.getDueDate().getTime() - release.getScheduledStartDate().getTime()));
        } else {
            Release templateRelease = CiCloneHelper.cloneCi(release);
            PlannerReleaseTree releaseTree = PlannerReleaseTree.apply((PlannerReleaseItem)PlannerReleaseItem.transform((PlanItem)templateRelease));
            Planner.makePlan((PlannerReleaseTree)releaseTree, (DateTime)new DateTime((Object)release.getScheduledStartDate()));
            duration = releaseTree.root().getDuration();
        }
        if (!duration.isLongerThan((ReadableDuration)Duration.ZERO)) {
            duration = MIN_RELEASE_DURATION;
        }
        return duration;
    }

    public void setDatesFromTemplate(Release release, Release template) {
        this.setDatesFromTemplate(release, template, LocalDateTime.now());
    }

    public void setDatesFromTemplate(Release release, Release template, LocalDateTime now) {
        release.setScheduledStartDate(now.toDate());
        release.setDueDate(now.plusMinutes(this.getDurationOf(template).toStandardMinutes().getMinutes()).toDate());
    }

    public Release createWithoutTemplate(Release releaseData) {
        releaseData.checkDatesValidityForRelease();
        Release release = this.releases.createWithoutTemplate(releaseData);
        if (Ids.isInRootFolder((String)releaseData.getId())) {
            this.addDefaultTeam(release, "Release Admin", XLReleasePermissions.getReleasePermissions(), false, true);
        }
        this.addFirstBlankPhase(release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(release, null));
        return this.releases.findById(release.getId(), false);
    }

    public Release createFromTemplate(String templateId, Release releaseMetadata) {
        return this.createFromTemplate(templateId, releaseMetadata, false);
    }

    private Release createFromTemplate(String templateId, Release releaseMetadata, boolean createdFromTrigger) {
        releaseMetadata.checkDatesValidityForRelease();
        return this.releases.createFromTemplate(templateId, releaseMetadata, createdFromTrigger);
    }

    public Release copyTemplate(String templateId, Release template) {
        boolean userHasPermissionToEditTemplate = this.permissions.hasPermission(XLReleasePermissions.EDIT_TEMPLATE, templateId);
        return this.releases.copyTemplate(templateId, template, userHasPermissionToEditTemplate);
    }

    public Release updateRelease(String releaseId, Release toUpdate) {
        return this.releases.updateRelease(releaseId, toUpdate);
    }

    public Release updateTemplate(String templateId, Release toUpdate) {
        return this.releases.updateTemplate(templateId, toUpdate);
    }

    public Release updateVariables(String releaseId, List<Variable> variables) {
        return this.releases.updateReleaseVariables(releaseId, variables);
    }

    public Release restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion) {
        return this.phaseRestart.restartPhases(releaseId, phaseId, taskId, phaseVersion);
    }

    public Release createFromReleaseTrigger(ReleaseTrigger releaseTrigger) {
        Release template = releaseTrigger.getTemplate();
        Release releaseParams = this.getReleaseParams(releaseTrigger, template);
        Release release = this.createFromTemplate(template.getId(), releaseParams, true);
        this.eventBus.publish((XLReleaseEvent)new TriggerCreatedNewReleaseEvent(releaseTrigger, template, release));
        return release;
    }

    public void incrementRunningTriggeredReleasesCount(Release template) {
        Release original = CiCloneHelper.cloneCi(template);
        template.incrementRunningTriggeredReleasesCount();
        this.releases.updateReleaseProperties(original, template);
    }

    private Release getReleaseParams(ReleaseTrigger releaseTrigger, Release template) {
        String title = VariableHelper.replaceAll((String)releaseTrigger.getReleaseTitle(), (Map)releaseTrigger.getStringScriptVariableValues());
        LinkedHashSet<String> releaseTags = new LinkedHashSet<String>();
        releaseTags.add(releaseTrigger.getName());
        releaseTags.add(template.getName());
        releaseTags.addAll(template.getTags());
        releaseTags.addAll(releaseTrigger.getTags().stream().map(tag -> VariableHelper.replaceAll((String)tag, (Map)releaseTrigger.getStringScriptVariableValues())).filter(tag -> !VariableHelper.containsVariables((String)tag)).collect(Collectors.toList()));
        Release release = ReleaseBuilder.newRelease().withTags(new ArrayList(releaseTags)).withVariables(template.getVariables()).withOriginTemplateId(template.getId()).withTitle(title).build();
        this.setDatesFromTemplate(release, template);
        Map templateVariables = (Map)releaseTrigger.getTemplateVariableValues(v -> !v.isPassword()).entrySet().stream().collect(com.xebialabs.xlrelease.utils.Collectors.toMap(Map.Entry::getKey, e -> VariableHelper.replaceAll(e.getValue(), (Map)releaseTrigger.getStringScriptVariableValues(), (Set)Sets.newHashSet(), (boolean)false)));
        Map passwordTemplateVariables = releaseTrigger.getTemplateVariableValues(Variable::isPassword);
        release.setVariableValues(templateVariables);
        release.setPasswordVariableValues(passwordTemplateVariables);
        release.setScriptUsername(template.getScriptUsername());
        release.setScriptUserPassword(template.getScriptUserPassword());
        VariablePersistenceHelper.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        return release;
    }

    private boolean teamsAreEqual(Team original, Team updated) {
        return new HashSet(original.getMembers()).equals(new HashSet(updated.getMembers())) && new HashSet(original.getRoles()).equals(new HashSet(updated.getRoles()));
    }

    private Map<String, Set<String>> getTeamsPermissions(Collection<Team> teams) {
        return teams.stream().collect(Collectors.toMap(Team::getTeamName, team -> new HashSet(team.getPermissions())));
    }
}

