/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseTitleResolver {
    private Releases releases;
    private static final Logger logger = LoggerFactory.getLogger(ReleaseTitleResolver.class);

    @Autowired
    public ReleaseTitleResolver(Releases releases) {
        this.releases = releases;
    }

    public String getReleaseTitleFromChild(String childId) {
        if (childId == null) {
            return null;
        }
        return this.getReleaseTitle(Ids.releaseIdFrom((String)childId));
    }

    public String getReleaseTitle(String id) {
        if (id == null) {
            return null;
        }
        String title = null;
        try {
            title = this.releases.getTitle(id);
        }
        catch (NotFoundException e) {
            logger.warn("Could not find release with ID {} to resolve its title", (Object)id);
        }
        return title;
    }
}

