/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.views.TaskAccessView;
import com.xebialabs.xlrelease.configuration.TaskAccess;
import com.xebialabs.xlrelease.customscripts.ScriptTypes;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskDefinition;
import com.xebialabs.xlrelease.domain.TaskTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskAccessService {
    private ScriptTypes scriptTypes;
    private RepositoryService repositoryService;
    private RoleService roleService;
    private PermissionEnforcer permissionEnforcer;

    @Autowired
    public TaskAccessService(ScriptTypes scriptTypes, RepositoryService repositoryService, RoleService roleService, PermissionEnforcer permissionEnforcer) {
        this.scriptTypes = scriptTypes;
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.permissionEnforcer = permissionEnforcer;
    }

    public List<TaskAccessView> getTaskAccesses() {
        List<TaskAccessView> taskAccessViews = this.getAllTaskAccessViews();
        List<TaskAccess> taskAccesses = this.readTaskAccesses();
        return this.mergeWithTaskAccesses(taskAccessViews, taskAccesses);
    }

    private List<TaskAccessView> getAllTaskAccessViews() {
        return Stream.concat(TaskTypes.getDefaultTaskTypes().stream(), this.scriptTypes.getPythonScriptTypes().stream()).map(this::taskToAccessView).collect(Collectors.toList());
    }

    private TaskAccessView taskToAccessView(Type defaultType) {
        return new TaskAccessView(TaskDefinition.getDisplayGroup((Type)defaultType), defaultType.toString(), TaskDefinition.getDisplayName((Type)defaultType), true, new ArrayList<String>());
    }

    private List<TaskAccess> readTaskAccesses() {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setType(Type.valueOf(TaskAccess.class));
        return this.repositoryService.listEntities(searchParameters);
    }

    private List<TaskAccessView> mergeWithTaskAccesses(List<TaskAccessView> taskAccessViews, List<TaskAccess> taskAccesses) {
        ImmutableMap accessesByTaskType = Maps.uniqueIndex(taskAccessViews, TaskAccessView::getTaskType);
        for (TaskAccess taskAccess : taskAccesses) {
            String taskType = taskAccess.getName();
            if (!accessesByTaskType.containsKey(taskType)) continue;
            TaskAccessView taskAccessView = (TaskAccessView)accessesByTaskType.get(taskType);
            taskAccessView.setAllowedToAll(taskAccess.isAllowedToAll());
            taskAccessView.getRoles().addAll(taskAccess.getRoles());
        }
        return taskAccessViews;
    }

    public List<Type> getAllowedTaskTypesForAuthenticatedUser() {
        List roles = this.roleService.getRolesFor(Permissions.getAuthentication());
        boolean isAdmin = this.permissionEnforcer.isCurrentUserAdmin();
        HashSet<String> roleNamesForAuthenticatedUser = new HashSet<String>(this.transform(roles, Role::getName));
        return this.getTaskAccesses().stream().filter(taskAccess -> isAdmin || taskAccess.isGrantedForRoles(roleNamesForAuthenticatedUser)).map(TaskAccessView::toType).collect(Collectors.toList());
    }

    private <T, R> List<R> transform(List<T> collection, Function<T, R> transform) {
        return collection.stream().map(transform).collect(Collectors.toList());
    }

    public List<TaskDefinition> getTaskDefinitions() {
        List<Type> allowedTaskTypesForAuthenticatedUser = this.getAllowedTaskTypesForAuthenticatedUser();
        return this.transform(this.getAllTaskAccessViews(), taskAccessView -> {
            Type type = taskAccessView.toType();
            boolean isAllowed = allowedTaskTypesForAuthenticatedUser.stream().anyMatch(allowedType -> allowedType.equals((Object)type));
            if (type.getDescriptor().isAssignableTo(PythonScript.class)) {
                return new PythonScriptDefinition(type, isAllowed);
            }
            return new TaskDefinition(type, isAllowed);
        });
    }

    public void checkIfAuthenticatedUserCanUseTask(Task task) {
        this.checkIfAuthenticatedUserCanUseTasks(Collections.singletonList(task));
    }

    public void checkIfAuthenticatedUserCanUseTasks(List<Task> tasks) {
        if (null == Permissions.getAuthenticatedUserName()) {
            return;
        }
        HashSet<Type> rejectedTaskTypes = new HashSet<Type>(this.transform(tasks, Task::getTaskType));
        rejectedTaskTypes.removeAll(this.getAllowedTaskTypesForAuthenticatedUser());
        if (!rejectedTaskTypes.isEmpty()) {
            throw PermissionDeniedException.withMessage((String)String.format("Task use is not granted to you for types : '%s'", ((Object)rejectedTaskTypes).toString()));
        }
    }

    public void updateTaskAccesses(List<TaskAccessView> taskAccessesView) {
        for (TaskAccessView taskAccessView : taskAccessesView) {
            TaskAccess taskAccess = new TaskAccess(taskAccessView.getTaskType(), taskAccessView.isAllowedToAll(), taskAccessView.getRoles());
            this.repositoryService.createOrUpdate((ConfigurationItem[])new TaskAccess[]{taskAccess});
        }
    }
}

