/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.service.UserProfilesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserInfoResolver {
    private UserProfilesService userProfilesService;

    @Autowired
    public UserInfoResolver(UserProfilesService userProfilesService) {
        this.userProfilesService = userProfilesService;
    }

    public String getNotificationEmailOf(String username) {
        if (this.isUndefined(username)) {
            return null;
        }
        UserProfile profile = this.userProfilesService.discover(username);
        return profile == null ? null : profile.getEmail();
    }

    public String getFullNameOf(String username) {
        if (this.isUndefined(username)) {
            return null;
        }
        UserProfile profile = this.userProfilesService.discover(username);
        return profile == null ? null : profile.getFullName();
    }

    public String getFullNameOrUsernameOf(String username) {
        String fullName = this.getFullNameOf(username);
        return this.isUndefined(fullName) ? username : fullName;
    }

    private boolean isUndefined(String username) {
        return Strings.isEmpty((String)com.google.common.base.Strings.nullToEmpty((String)username).trim());
    }
}

