/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.configuration;

import com.xebialabs.xlrelease.config.XlrConfig;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class XlrWebApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        XlrConfig bootConfig = XlrConfig.getInstance();
        if (bootConfig.isSqlRepositoryEnabled() || this.propertyEnabled("xl.repository.sql")) {
            environment.addActiveProfile("sql");
        }
        if (bootConfig.isClusterEnabled()) {
            environment.addActiveProfile("cluster");
            environment.addActiveProfile(bootConfig.clusterMode().configOption());
            if (bootConfig.isJackrabbitCluster()) {
                environment.addActiveProfile("jackrabbit");
            }
        } else {
            environment.addActiveProfile("default");
            environment.addActiveProfile("jackrabbit");
        }
    }

    private boolean propertyEnabled(String propertyName) {
        return Boolean.valueOf(System.getProperty(propertyName));
    }
}

