/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.common;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.upgrade.Components;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XLRelease402DisabledTutorialSampleTemplate
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease402DisabledTutorialSampleTemplate.class);
    private static final String VERSION = "4.0.2";
    private static final String SAMPLE_ID = "Applications/ReleaseTemplate_sample";
    private static final String SAMPLE_WITH_DEPLOY_IT_ID = "Applications/ReleaseTemplate_sample_with_Deployit";
    private RepositoryService repositoryService;

    @Autowired
    public XLRelease402DisabledTutorialSampleTemplate(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean doUpgrade() throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Remove tutorial property on the sample templates ***", (Object)"XL Release", (Object)VERSION);
        ArrayList samples = Lists.newArrayList((Object[])new Release[]{(Release)this.repositoryService.read(SAMPLE_ID), (Release)this.repositoryService.read(SAMPLE_WITH_DEPLOY_IT_ID)});
        for (Release sample : samples) {
            sample.setTutorial(false);
            this.repositoryService.update((ConfigurationItem[])new Release[]{sample});
        }
        logger.info("*** Done {} {} upgrade -- Remove tutorial property on the sample templates ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)VERSION);
    }
}

