/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.id.IdType;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.views.BaseConfigurationView;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;

abstract class BaseConfigurationViewConverter {
    protected final RepositoryService repositoryService;

    @Autowired
    public BaseConfigurationViewConverter(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    void fillItem(ConfigurationItem item, BaseConfigurationView view) {
        this.getPropertyDescriptors(item.getType()).forEach(pd -> {
            Object propertyValue = view.getProperty(pd.getName());
            if (propertyValue != null) {
                if (pd.getKind() == PropertyKind.CI) {
                    propertyValue = this.repositoryService.read(IdType.CONFIGURATION.convertToJcrId((String)propertyValue));
                    Type referencedType = ((Configuration)propertyValue).getType();
                    Preconditions.checkArgument((boolean)referencedType.getDescriptor().isAssignableTo(pd.getReferencedType()), (Object)("Type of CI must be " + pd.getReferencedType().getName() + " got " + referencedType.getName()));
                } else if (pd.getKind() == PropertyKind.SET_OF_STRING) {
                    propertyValue = Sets.newHashSet((Iterable)((Collection)propertyValue));
                } else if (pd.getKind() == PropertyKind.STRING && pd.isPassword()) {
                    propertyValue = PasswordEncrypter.getInstance().ensureDecrypted(propertyValue.toString());
                }
            }
            item.setProperty(pd.getName(), propertyValue);
        });
        item.setId(view.getId());
    }

    void fillView(BaseConfigurationView view, ConfigurationItem instance) {
        view.setId(instance.getId());
        view.setType(instance.getType().toString());
        view.setTitle((String)instance.getProperty("title"));
        PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
        Map<String, Object> properties = view.getProperties();
        this.getPropertyDescriptors(instance.getType()).forEach(pd -> {
            String propertyName = pd.getName();
            if (pd.getKind() == PropertyKind.CI) {
                Configuration configuration = (Configuration)instance.getProperty(propertyName);
                properties.put(propertyName, configuration != null ? IdType.CONFIGURATION.convertToViewId(configuration.getId()) : null);
            } else if (pd.isPassword() && instance.getProperty(propertyName) != null) {
                properties.put(propertyName, passwordEncrypter.ensureEncrypted((String)instance.getProperty(propertyName)));
            } else {
                properties.put(propertyName, instance.getProperty(propertyName));
            }
        });
    }

    <T extends ConfigurationItem> T newInstance(BaseConfigurationView view) {
        Descriptor descriptor = view.type().getDescriptor();
        return (T)descriptor.newInstance(view.getId());
    }

    Stream<PropertyDescriptor> getPropertyDescriptors(Type type) {
        return type.getDescriptor().getPropertyDescriptors().stream().filter(pd -> !pd.isHidden());
    }
}

