/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableReplacedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariablesUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.VariableRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.TaskBackup;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u0001\u0003\u0001-\u0011qBV1sS\u0006\u0014G.Z*feZL7-\u001a\u0006\u0003\u0007\u0011\tqa]3sm&\u001cWM\u0003\u0002\u0006\r\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u000f!\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0006g24GG\u001b\u0006\u0002/\u0005AqM]5{u2,G-\u0003\u0002\u001a)\t9Aj\\4hS:<\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bCA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003)\u0011X\r]8tSR|'/_\u0005\u0003Cy\u0011qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\n\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\tiR%\u0003\u0002'=\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\t\u0011!\u0002!\u0011!Q\u0001\n%\n!C^1sS\u0006\u0014G.\u001a*fa>\u001c\u0018\u000e^8ssB\u0011QDK\u0005\u0003Wy\u0011!CV1sS\u0006\u0014G.\u001a*fa>\u001c\u0018\u000e^8ss\"AQ\u0006\u0001B\u0001B\u0003%a&\u0001\tbe\u000eD\u0017N^5oON+'O^5dKB\u0011q\u0006M\u0007\u0002\u0005%\u0011\u0011G\u0001\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016D\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\fG&LEmU3sm&\u001cW\r\u0005\u00020k%\u0011aG\u0001\u0002\f\u0007&LEmU3sm&\u001cW\r\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0003)!\u0018m]6CC\u000e\\W\u000f\u001d\t\u0003_iJ!a\u000f\u0002\u0003\u0015Q\u000b7o\u001b\"bG.,\b\u000f\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0003!)g/\u001a8u\u0005V\u001c\bCA C\u001b\u0005\u0001%BA!\u0005\u0003\u0019)g/\u001a8ug&\u00111\t\u0011\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\b\"B#\u0001\t\u00031\u0015A\u0002\u001fj]&$h\b\u0006\u0005H\u0011&S5\nT'O!\ty\u0003\u0001C\u0003\u001c\t\u0002\u0007A\u0004C\u0003$\t\u0002\u0007A\u0005C\u0003)\t\u0002\u0007\u0011\u0006C\u0003.\t\u0002\u0007a\u0006C\u00034\t\u0002\u0007A\u0007C\u00039\t\u0002\u0007\u0011\bC\u0003>\t\u0002\u0007a\b\u000b\u0002E!B\u0011\u0011\u000bX\u0007\u0002%*\u00111\u000bV\u0001\u000bC:tw\u000e^1uS>t'BA+W\u0003\u001d1\u0017m\u0019;pefT!a\u0016-\u0002\u000b\t,\u0017M\\:\u000b\u0005eS\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003m\u000b1a\u001c:h\u0013\ti&KA\u0005BkR|w/\u001b:fI\")q\f\u0001C\u0001A\u0006Ib-\u001b8e\u0005fLE-\u00138dYV$\u0017N\\4Be\u000eD\u0017N^3e)\t\t\u0017\u000e\u0005\u0002cO6\t1M\u0003\u0002eK\u0006Ia/\u0019:jC\ndWm\u001d\u0006\u0003M\u0012\ta\u0001Z8nC&t\u0017B\u00015d\u0005!1\u0016M]5bE2,\u0007\"\u00026_\u0001\u0004Y\u0017A\u0003<be&\f'\r\\3JIB\u0011An\u001d\b\u0003[F\u0004\"A\u001c\b\u000e\u0003=T!\u0001\u001d\u0006\u0002\rq\u0012xn\u001c;?\u0013\t\u0011h\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:\u000fQ\tqv\u000f\u0005\u0002y}6\t\u0011P\u0003\u0002Tu*\u00111\u0010`\u0001\b[\u0016$(/[2t\u0015\ti\b\"\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\ty\u0018PA\u0003US6,G\rC\u0004\u0002\u0004\u0001!\t!!\u0002\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$2!YA\u0004\u0011\u0019Q\u0017\u0011\u0001a\u0001W\"\u001a\u0011\u0011A<\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010\u00059b-\u001b8e%\u0016dW-Y:f-\u0006\u0014\u0018.\u00192mK\nK\u0018\n\u001a\u000b\u0004C\u0006E\u0001B\u00026\u0002\f\u0001\u00071\u000eC\u0004\u0002\u0016\u0001!I!a\u0006\u0002-\u0019Lg\u000eZ$m_\n\fGNV1sS\u0006\u0014G.\u001a\"z\u0013\u0012$2!YA\r\u0011\u0019Q\u00171\u0003a\u0001W\"9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0011!\u00034j]\u0012\u0014\u0015pS3z)\u0015\t\u0017\u0011EA\u0013\u0011\u001d\t\u0019#a\u0007A\u0002-\fAB^1sS\u0006\u0014G.\u001a(b[\u0016Dq!a\n\u0002\u001c\u0001\u00071.A\u0005sK2,\u0017m]3JI\"\u001a\u00111D<\t\u000f\u00055\u0002\u0001\"\u0001\u00020\u0005Y\u0011\r\u001a3WCJL\u0017M\u00197f)\u0015\t\u0017\u0011GA\u001f\u0011!\t\u0019$a\u000bA\u0002\u0005U\u0012a\u0002:fY\u0016\f7/\u001a\t\u0005\u0003o\tI$D\u0001f\u0013\r\tY$\u001a\u0002\b%\u0016dW-Y:f\u0011\u001d\ty$a\u000bA\u0002\u0005\f\u0001B^1sS\u0006\u0014G.\u001a\u0015\u0004\u0003W9\bbBA#\u0001\u0011\u0005\u0011qI\u0001\u0017kB$\u0017\r^3SK2,\u0017m]3WCJL\u0017M\u00197fgR1\u0011QGA%\u0003\u0017B\u0001\"a\r\u0002D\u0001\u0007\u0011Q\u0007\u0005\bI\u0006\r\u0003\u0019AA'!\u0015\ty%!\u0017b\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001B;uS2T!!a\u0016\u0002\t)\fg/Y\u0005\u0005\u00037\n\tF\u0001\u0003MSN$\bfAA\"o\"9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0014AD;qI\u0006$XMV1sS\u0006\u0014G.\u001a\u000b\u0006C\u0006\u0015\u0014q\r\u0005\t\u0003g\ty\u00061\u0001\u00026!9\u0011\u0011NA0\u0001\u0004\t\u0017aB;qI\u0006$X\r\u001a\u0015\u0004\u0003?:\bbBA8\u0001\u0011\u0005\u0011\u0011O\u0001\u001bM&tGm\u00127pE\u0006dg+\u0019:jC\ndWm](s\u000b6\u0004H/\u001f\u000b\u0003\u0003g\u00022AYA;\u0013\r\t9h\u0019\u0002\u0010\u000f2|'-\u00197WCJL\u0017M\u00197fg\"\u001a\u0011QN<\t\u000f\u0005u\u0004\u0001\"\u0003\u0002r\u0005\u0019b-\u001b8e\u000f2|'-\u00197WCJL\u0017M\u00197fg\"9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0015!E1eI\u001ecwNY1m-\u0006\u0014\u0018.\u00192mKR\u0019\u0011-!\"\t\u000f\u0005\u001d\u0015q\u0010a\u0001C\u0006\ta\u000fK\u0002\u0002\u0000]Dq!!$\u0001\t\u0003\ty)\u0001\u000bva\u0012\fG/Z$m_\n\fGNV1sS\u0006\u0014G.\u001a\u000b\u0004C\u0006E\u0005bBA5\u0003\u0017\u0003\r!\u0019\u0015\u0004\u0003\u0017;\bbBAL\u0001\u0011\u0005\u0011\u0011T\u0001\u0015I\u0016dW\r^3HY>\u0014\u0017\r\u001c,be&\f'\r\\3\u0015\t\u0005m\u0015\u0011\u0015\t\u0004\u001b\u0005u\u0015bAAP\u001d\t!QK\\5u\u0011\u0019Q\u0017Q\u0013a\u0001W\"\u001a\u0011QS<\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u0006qA-\u001a7fi\u00164\u0016M]5bE2,GCBAN\u0003W\u000bi\u000b\u0003\u0005\u00024\u0005\u0015\u0006\u0019AA\u001b\u0011\u0019Q\u0017Q\u0015a\u0001W\"\u001a\u0011QU<\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\u0006y!/\u001a9mC\u000e,g+\u0019:jC\ndW\r\u0006\u0005\u0002\u001c\u0006]\u0016\u0011XA^\u0011!\t\u0019$!-A\u0002\u0005U\u0002bBA \u0003c\u0003\r!\u0019\u0005\t\u0003{\u000b\t\f1\u0001\u0002@\u0006Y!/\u001a9mC\u000e,W.\u001a8u!\u0011\t\t-a4\u000e\u0005\u0005\r'\u0002BAc\u0003\u000f\fQAZ8s[NTA!!3\u0002L\u0006\u0011a/\r\u0006\u0004\u0003\u001b$\u0011aA1qS&!\u0011\u0011[Ab\u0005=1\u0016M]5bE2,wJ\u001d,bYV,\u0007fAAYo\"9\u0011q\u001b\u0001\u0005\n\u0005e\u0017aE2iK\u000e\\'+\u001a8b[\u00164\u0016\r\\5eSRLH\u0003CAN\u00037\fy/a=\t\u000f\u0011\f)\u000e1\u0001\u0002^B)\u0011q\\AuC:!\u0011\u0011]As\u001d\rq\u00171]\u0005\u0002\u001f%\u0019\u0011q\u001d\b\u0002\u000fA\f7m[1hK&!\u00111^Aw\u0005\r\u0019V-\u001d\u0006\u0004\u0003Ot\u0001bBAy\u0003+\u0004\r!Y\u0001\bGV\u0014(/\u001a8u\u0011\u001d\tI'!6A\u0002\u0005Dq!a>\u0001\t\u0013\tI0A\u0007dQ\u0016\u001c7nU1nKRK\b/\u001a\u000b\u0007\u00037\u000bY0!@\t\u000f\u0005E\u0018Q\u001fa\u0001C\"9\u0011\u0011NA{\u0001\u0004\t\u0007b\u0002B\u0001\u0001\u0011%!1A\u0001\u001akB$\u0017\r^3WCJL\u0017M\u00197f\u0003:$\u0007K]8wS\u0012,'\u000fF\u0005b\u0005\u000b\u0011IAa\u0003\u0003\u000e!9!qAA\u0000\u0001\u0004Y\u0017\u0001\u00039be\u0016tG/\u00133\t\u000f\u0005E\u0018q a\u0001C\"9\u0011\u0011NA\u0000\u0001\u0004\t\u0007\u0002CA\u001a\u0003\u007f\u0004\r!!\u000e\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014\u0005\u0001R\u000f\u001d3bi\u0016,6/Y4f!>Lg\u000e\u001e\u000b\t\u0005+\u0011\tD!\u0011\u0003DA)ANa\u0006\u0003\u001c%\u0019!\u0011D;\u0003\u0007M+G\u000f\u0005\u0003\u0003\u001e\t5RB\u0001B\u0010\u0015\u0011\u0011\tCa\t\u0002\u0007U$WN\u0003\u0003\u0002N\n\u0015\"\u0002\u0002B\u0014\u0005S\ta\u0001\u001d7vO&t'b\u0001B\u0016\r\u0005AA-\u001a9m_fLG/\u0003\u0003\u00030\t}!!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\"A!1\u0007B\b\u0001\u0004\u0011)$\u0001\u0002vaB!!q\u0007B\u001f\u001b\t\u0011IDC\u0002\u0003<\r\f\u0011B]3gKJ,gnY3\n\t\t}\"\u0011\b\u0002\u000b+N\fw-\u001a)pS:$\bbBA \u0005\u001f\u0001\r!\u0019\u0005\t\u0003{\u0013y\u00011\u0001\u0002@\"\u001a\u0001Aa\u0012\u0011\t\t%#qJ\u0007\u0003\u0005\u0017R1A!\u0014Y\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005#\u0012YEA\u0004TKJ4\u0018nY3")
public class VariableService
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final ReleaseRepository releaseRepository;
    private final VariableRepository variableRepository;
    private final ArchivingService archivingService;
    private final CiIdService ciIdService;
    private final TaskBackup taskBackup;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        VariableService variableService = this;
        synchronized (variableService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Variable findByIdIncludingArchived(String variableId) {
        Variable variable;
        if (VariableHelper$.MODULE$.isGlobalVariableId(variableId)) {
            variable = this.findGlobalVariableById(variableId);
        } else if (this.variableRepository.exists(variableId)) {
            variable = this.findById(variableId);
        } else if (this.archivingService.exists(variableId)) {
            variable = this.archivingService.getVariable(variableId);
        } else {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Variable [", "] does not exist in the repository or archive"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variableId})), new Object[0]);
        }
        return variable;
    }

    @Timed
    public Variable findById(String variableId) {
        return VariableHelper$.MODULE$.isGlobalVariableId(variableId) ? this.findGlobalVariableById(variableId) : this.findReleaseVariableById(variableId);
    }

    private Variable findReleaseVariableById(String variableId) {
        return this.variableRepository.findById(variableId);
    }

    private Variable findGlobalVariableById(String variableId) {
        return (Variable)this.configurationRepository.read(variableId);
    }

    @Timed
    public Variable findByKey(String variableName, String releaseId) {
        String string = variableName;
        Variable variable = Strings.isNotBlank((String)string) ? this.variableRepository.findByKey(string, releaseId) : null;
        return variable;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Variable addVariable(Release release, Variable variable) {
        void var3_3;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding new variable with key [", "] to release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variable.getKey(), release.getId()})));
        release.addVariable(variable);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        Object object = !release.getVariableById(variable.getId()).isPresent() ? release.addVariable(variable) : BoxedUnit.UNIT;
        Variable created = this.variableRepository.create(variable, release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableCreatedEvent(variable));
        return var3_3;
    }

    @Timed
    public Release updateReleaseVariables(Release release, List<Variable> variables) {
        List originalVariables = release.getVariables();
        release.setVariables(variables);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        this.variableRepository.update((Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(originalVariables).asScala()), (Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(variables).asScala()), release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariablesUpdatedEvent(originalVariables, variables));
        return release;
    }

    @Timed
    public Variable updateVariable(Release release, Variable updated) {
        Variable updatedVariable;
        block3: {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating variable [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{updated.getId()})));
            updated.checkValidity();
            Variable current = this.findById(updated.getId());
            this.checkSameType(current, updated);
            String string = current.getKey();
            String string2 = updated.getKey();
            if (string == null ? string2 != null : !string.equals(string2)) {
                ReleaseStatus releaseStatus = release.getStatus();
                ReleaseStatus releaseStatus2 = ReleaseStatus.TEMPLATE;
                if (releaseStatus == null ? releaseStatus2 != null : !releaseStatus.equals(releaseStatus2)) {
                    ReleaseStatus releaseStatus3 = release.getStatus();
                    ReleaseStatus releaseStatus4 = ReleaseStatus.PLANNED;
                    if (releaseStatus3 == null ? releaseStatus4 != null : !releaseStatus3.equals(releaseStatus4)) {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot rename variable ", " of an already started release"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{updated.getId()})));
                    }
                }
                this.checkRenameValidity((Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()), current, updated);
            }
            updatedVariable = this.updateVariableAndProvider(release.getId(), current, updated, release);
            this.eventBus.publish((XLReleaseEvent)new ReleaseVariableUpdatedEvent(current, updated));
            String string3 = current.getKey();
            String string4 = updated.getKey();
            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block3;
            this.replaceVariableUsages$1(current, updatedVariable, release, updated);
        }
        return updatedVariable;
    }

    @Timed
    public GlobalVariables findGlobalVariablesOrEmpty() {
        return this.findGlobalVariables();
    }

    /*
     * WARNING - void declaration
     */
    private GlobalVariables findGlobalVariables() {
        void var1_1;
        GlobalVariables globalVariables = new GlobalVariables();
        globalVariables.setVariables(this.configurationRepository.findAllByType(Type.valueOf(Variable.class)));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Variable addGlobalVariable(Variable v) {
        void var3_3;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding new global variable with key [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v.getKey()})));
        GlobalVariables globalVars = this.findGlobalVariables();
        Variable newVariable = globalVars.addVariable(v);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(globalVars.getId(), globalVars.getVariables(), this.ciIdService);
        this.configurationRepository.create(newVariable);
        return var3_3;
    }

    @Timed
    public Variable updateGlobalVariable(Variable updated) {
        GlobalVariables globalVars;
        Variable current;
        block0: {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating global variable [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{updated.getId()})));
            updated.checkGlobalVariableValidity();
            current = this.findGlobalVariableById(updated.getId());
            this.checkSameType(current, updated);
            globalVars = this.findGlobalVariables();
            String string = current.getKey();
            String string2 = updated.getKey();
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.checkRenameValidity((Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(globalVars.getVariables()).asScala()), current, updated);
        }
        return this.updateVariableAndProvider(globalVars.getId(), current, updated, null);
    }

    @Timed
    public void deleteGlobalVariable(String variableId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting global variable [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variableId})));
        this.configurationRepository.delete(variableId);
    }

    @Timed
    public void deleteVariable(Release release, String variableId) {
        Variable variable = (Variable)release.getVariableById(variableId).orElseThrow(() -> new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Repository entity [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variableId})), new Object[0]));
        release.removeVariable(variableId);
        release.getAllUserInputTasks().forEach(task -> $this.taskBackup.removeVariable((UserInputTask)task, variableId));
        release.getReleaseTriggers().forEach(trigger -> {
            Buffer triggerVariables = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(trigger.getVariables()).asScala()).filter((Function1 & Serializable & scala.Serializable)tVar -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$deleteVariable$4(variable, tVar)));
            trigger.setVariables((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(triggerVariables).asJava());
        });
        this.variableRepository.delete(variableId, release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableDeletedEvent(variable));
    }

    @Timed
    public void replaceVariable(Release release, Variable variable, VariableOrValue replacement) {
        if (replacement.getVariable() == null && replacement.getValue() == null) {
            replacement.setValue(variable.getEmptyValue());
        }
        if (replacement.getVariable() != null) {
            replacement.setVariable(VariableHelper$.MODULE$.formatVariableIfNeeded(replacement.getVariable()));
        }
        Set cis = (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(release.collectVariableReferences()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)varRef -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$replaceVariable$1(variable, varRef))).flatMap((Function1 & Serializable & scala.Serializable)varRef -> (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(varRef.getUsagePoints()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)up -> (scala.collection.immutable.Set)this.updateUsagePoint((UsagePoint)up, variable, replacement).map((Function1 & Serializable & scala.Serializable)u -> u, Set$.MODULE$.canBuildFrom()), scala.collection.mutable.Set$.MODULE$.canBuildFrom()), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        JavaConverters$.MODULE$.asScalaBufferConverter(VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService)).asScala();
        this.variableRepository.replace(release, (Seq<ConfigurationItem>)cis.toSeq());
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableReplacedEvent(variable, replacement));
    }

    private void checkRenameValidity(Seq<Variable> variables, Variable current, Variable updated) {
        if (((SeqLike)variables.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKey(), Seq$.MODULE$.canBuildFrom())).contains((Object)updated.getKey())) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot rename variable ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{updated.getId(), current.getKey()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" to ", " because ", " already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{updated.getKey(), updated.getKey()})));
        }
    }

    private void checkSameType(Variable current, Variable updated) {
        if (!current.getType().equals((Object)updated.getType())) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot change type of variable ", " from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{updated.getId(), current.getType(), updated.getType()})));
        }
    }

    private Variable updateVariableAndProvider(String parentId, Variable current, Variable updated, Release release) {
        PropertyDescriptor currentValueType = current.getType().getDescriptor().getPropertyDescriptor("value");
        PropertyDescriptor updatedValueType = updated.getType().getDescriptor().getPropertyDescriptor("value");
        if (!currentValueType.getKind().equals((Object)updatedValueType.getKind())) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot change type of variable from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{current.getType(), updated.getType()})));
        }
        if (updated.getValueProvider() != null) {
            updated.getValueProvider().setVariable(updated);
        }
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(parentId, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Variable[]{updated}))).asJava(), this.ciIdService);
        if (Ids.isReleaseId((String)parentId)) {
            release.replaceVariable(current, updated);
            this.variableRepository.update(current, updated, release);
        } else {
            this.configurationRepository.update(updated);
        }
        return updated;
    }

    private scala.collection.immutable.Set<ConfigurationItem> updateUsagePoint(UsagePoint up, Variable variable, VariableOrValue replacement) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(up.replaceVariable(variable, replacement)).asScala()).toSet();
    }

    private final void replaceVariableUsages$1(Variable oldVariable, Variable updatedVariable, Release release$2, Variable updated$1) {
        VariableOrValue replacement = new VariableOrValue();
        replacement.setVariable(updated$1.getKey());
        Release updatedRelease = this.releaseRepository.findById(release$2.getId(), null);
        this.replaceVariable(updatedRelease, oldVariable, replacement);
    }

    public static final /* synthetic */ boolean $anonfun$deleteVariable$4(Variable variable$3, Variable tVar) {
        return !tVar.getKey().equals(variable$3.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$replaceVariable$1(Variable variable$2, VariableReference varRef) {
        String string = VariableHelper$.MODULE$.withoutVariableSyntax(varRef.getKey());
        String string2 = VariableHelper$.MODULE$.withoutVariableSyntax(variable$2.getKey());
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public VariableService(ConfigurationRepository configurationRepository, ReleaseRepository releaseRepository, VariableRepository variableRepository, ArchivingService archivingService, CiIdService ciIdService, TaskBackup taskBackup, XLReleaseEventBus eventBus) {
        this.configurationRepository = configurationRepository;
        this.releaseRepository = releaseRepository;
        this.variableRepository = variableRepository;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.taskBackup = taskBackup;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

