/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.actors.cluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import com.xebialabs.xlplatform.hotstandby.ClusterConfig;
import com.xebialabs.xlplatform.hotstandby.ClusterDiscoveryActor;
import com.xebialabs.xlplatform.hotstandby.ClusterDiscoveryActor$;
import com.xebialabs.xlplatform.hotstandby.ClusterMode;
import com.xebialabs.xlplatform.hotstandby.DataSourceConfig;
import com.xebialabs.xlplatform.hotstandby.HotStandbyDetector$;
import com.xebialabs.xlplatform.hotstandby.membership.ClusterMembershipManagement;
import com.xebialabs.xlplatform.hotstandby.membership.ClusterMembershipMySQLDialect;
import com.xebialabs.xlplatform.hotstandby.membership.ClusterMembershipOracleDialect;
import com.xebialabs.xlplatform.hotstandby.membership.ClusterMembershipPostgreSQLDialect;
import com.xebialabs.xlplatform.hotstandby.membership.ClusterMembershipSQLManagement;
import com.xebialabs.xlrelease.actors.cluster.XlrFullClusterNodeStateManager$;
import com.xebialabs.xlrelease.actors.cluster.membership.ClusterMembershipDB2Dialect;
import com.xebialabs.xlrelease.actors.cluster.membership.ClusterMembershipDerbyDialect;
import com.xebialabs.xlrelease.actors.cluster.membership.ClusterMembershipH2Dialect;
import com.xebialabs.xlrelease.actors.cluster.membership.ClusterMembershipMSSQLDialect;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u00015\u0011!\u0003\u00177s\u00072,8\u000f^3s!J|g/\u001b3fe*\u00111\u0001B\u0001\bG2,8\u000f^3s\u0015\t)a!\u0001\u0004bGR|'o\u001d\u0006\u0003\u000f!\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\u000e\u000e\u0003YQ!a\u0006\r\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003e\tA!Y6lC&\u00111D\u0006\u0002\n\u000bb$XM\\:j_:D\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u000fKb$XM\u001c3fINK8\u000f^3n!\t)r$\u0003\u0002!-\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\"A!\u0005\u0001B\u0001B\u0003%1%\u0001\u0004d_:4\u0017n\u001a\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\n!\u0002[8ugR\fg\u000e\u001a2z\u0015\tA\u0003\"\u0001\u0006yYBd\u0017\r\u001e4pe6L!AK\u0013\u0003\u001b\rcWo\u001d;fe\u000e{gNZ5h\u0011\u0015a\u0003\u0001\"\u0001.\u0003\u0019a\u0014N\\5u}Q\u0019a\u0006M\u0019\u0011\u0005=\u0002Q\"\u0001\u0002\t\u000buY\u0003\u0019\u0001\u0010\t\u000b\tZ\u0003\u0019A\u0012\t\u000fM\u0002!\u0019!C\u0006i\u000511/_:uK6,\u0012A\b\u0005\u0007m\u0001\u0001\u000b\u0011\u0002\u0010\u0002\u000fML8\u000f^3nA!9\u0001\b\u0001b\u0001\n\u0017I\u0014\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\u0005Q\u0004CA\u001e?\u001b\u0005a$BA\u001f\u0011\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u007fq\u0012\u0001$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s\u0011\u0019\t\u0005\u0001)A\u0005u\u0005\tR\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0011\t\u000f\r\u0001!\u0019!C\u0005\u0007V\tA\t\u0005\u0002F\u000f6\taI\u0003\u0002\u00041%\u0011\u0001J\u0012\u0002\b\u00072,8\u000f^3s\u0011\u0019Q\u0005\u0001)A\u0005\t\u0006A1\r\\;ti\u0016\u0014\b\u0005C\u0004M\u0001\t\u0007I\u0011A'\u0002\r=\u0013\u0018m\u00197f+\u0005q\u0005CA(U\u001b\u0005\u0001&BA)S\u0003!i\u0017\r^2iS:<'BA*\u0011\u0003\u0011)H/\u001b7\n\u0005U\u0003&!\u0002*fO\u0016D\bBB,\u0001A\u0003%a*A\u0004Pe\u0006\u001cG.\u001a\u0011\t\u000fe\u0003!\u0019!C\u0001\u001b\u0006)Q*_*R\u0019\"11\f\u0001Q\u0001\n9\u000ba!T=T#2\u0003\u0003bB/\u0001\u0005\u0004%\t!T\u0001\u000b!>\u001cHo\u001a:f'Fc\u0005BB0\u0001A\u0003%a*A\u0006Q_N$xM]3T#2\u0003\u0003bB1\u0001\u0005\u0004%\t!T\u0001\u0004\t\n\u0013\u0004BB2\u0001A\u0003%a*\u0001\u0003E\u0005J\u0002\u0003bB3\u0001\u0005\u0004%\t!T\u0001\u0006\u001bN\u001b\u0016\u000b\u0014\u0005\u0007O\u0002\u0001\u000b\u0011\u0002(\u0002\r5\u001b6+\u0015'!\u0011\u001dI\u0007A1A\u0005\u00025\u000b!\u0001\u0013\u001a\t\r-\u0004\u0001\u0015!\u0003O\u0003\rA%\u0007\t\u0005\b[\u0002\u0011\r\u0011\"\u0001N\u0003\u0015!UM\u001d2z\u0011\u0019y\u0007\u0001)A\u0005\u001d\u00061A)\u001a:cs\u0002Bq!\u001d\u0001C\u0002\u0013\u0005!/\u0001\u000bnK6\u0014WM]:iSBl\u0015M\\1hK6,g\u000e^\u000b\u0002gB\u0011Ao^\u0007\u0002k*\u0011a/J\u0001\u000b[\u0016l'-\u001a:tQ&\u0004\u0018B\u0001=v\u0005m\u0019E.^:uKJlU-\u001c2feND\u0017\u000e]'b]\u0006<W-\\3oi\"1!\u0010\u0001Q\u0001\nM\fQ#\\3nE\u0016\u00148\u000f[5q\u001b\u0006t\u0017mZ3nK:$\b\u0005C\u0003}\u0001\u0011\u0005Q0A\u0003ti\u0006\u0014H\u000fF\u0002\u007f\u0003\u0007\u0001\"aD@\n\u0007\u0005\u0005\u0001C\u0001\u0003V]&$\bbBA\u0003w\u0002\u0007\u0011qA\u0001\u000bS:LG/[1mSj,\u0007\u0003B\b\u0002\nyL1!a\u0003\u0011\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u0002\u0010\u0001!I!!\u0005\u0002\u001bM,G.Z2u\t&\fG.Z2u)!\t\u0019\"!\u0007\u0002$\u0005M\u0002c\u0001;\u0002\u0016%\u0019\u0011qC;\u0003=\rcWo\u001d;fe6+WNY3sg\"L\u0007oU)M\u001b\u0006t\u0017mZ3nK:$\b\u0002CA\u000e\u0003\u001b\u0001\r!!\b\u0002\u0011\u0011\u001c8i\u001c8gS\u001e\u00042\u0001JA\u0010\u0013\r\t\t#\n\u0002\u0011\t\u0006$\u0018mU8ve\u000e,7i\u001c8gS\u001eD\u0001\"!\n\u0002\u000e\u0001\u0007\u0011qE\u0001\u0004iRd\u0007\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055B(\u0001\u0005ekJ\fG/[8o\u0013\u0011\t\t$a\u000b\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"Q\u0011QGA\u0007!\u0003\u0005\r!a\u000e\u0002\u0011\u0019\f\u0017\u000e\u001c$bgR\u00042aDA\u001d\u0013\r\tY\u0004\u0005\u0002\b\u0005>|G.Z1o\u0011%\ty\u0004AI\u0001\n\u0013\t\t%A\ftK2,7\r\u001e#jC2,7\r\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\t\u0016\u0005\u0003o\t)e\u000b\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013!C;oG\",7m[3e\u0015\r\t\t\u0006E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA+\u0003\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class XlrClusterProvider
implements Extension {
    private final ClusterConfig config;
    private final ExtendedActorSystem system;
    private final ExecutionContextExecutor executionContext;
    private final Cluster cluster;
    private final Regex Oracle;
    private final Regex MySQL;
    private final Regex PostgreSQL;
    private final Regex DB2;
    private final Regex MSSQL;
    private final Regex H2;
    private final Regex Derby;
    private final ClusterMembershipManagement membershipManagement;

    private ExtendedActorSystem system() {
        return this.system;
    }

    private ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    private Cluster cluster() {
        return this.cluster;
    }

    public Regex Oracle() {
        return this.Oracle;
    }

    public Regex MySQL() {
        return this.MySQL;
    }

    public Regex PostgreSQL() {
        return this.PostgreSQL;
    }

    public Regex DB2() {
        return this.DB2;
    }

    public Regex MSSQL() {
        return this.MSSQL;
    }

    public Regex H2() {
        return this.H2;
    }

    public Regex Derby() {
        return this.Derby;
    }

    public ClusterMembershipManagement membershipManagement() {
        return this.membershipManagement;
    }

    public void start(Function0<BoxedUnit> initialize) {
        ActorRef actorRef;
        ClusterMode clusterMode = this.config.mode();
        if (ClusterMode.Full$.MODULE$.equals(clusterMode)) {
            actorRef = this.system().actorOf(XlrFullClusterNodeStateManager$.MODULE$.clusterNodeStateManager(initialize));
        } else if (ClusterMode.HotStandby$.MODULE$.equals(clusterMode)) {
            actorRef = this.system().actorOf(HotStandbyDetector$.MODULE$.hotStandbyDetector(initialize));
        } else {
            throw new IllegalArgumentException("This extension is only valid with cluster usage.");
        }
        ActorRef clusterStateManagerActor = actorRef;
        ActorRef discoveryActor = this.system().actorOf(ClusterDiscoveryActor$.MODULE$.props(this.cluster(), this.membershipManagement(), this.config.membership().heartbeatInterval()));
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(discoveryActor);
        ClusterDiscoveryActor.Start x$1 = new ClusterDiscoveryActor.Start(clusterStateManagerActor);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    private ClusterMembershipSQLManagement selectDialect(DataSourceConfig dsConfig, FiniteDuration ttl, boolean failFast) {
        Object object;
        String url = dsConfig.url();
        String string = url.toLowerCase();
        Option option = this.Oracle().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
            object = new ClusterMembershipOracleDialect(dsConfig, ttl, failFast);
        } else {
            Option option2 = this.MySQL().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0) {
                object = new ClusterMembershipMySQLDialect(dsConfig, ttl, failFast);
            } else {
                Option option3 = this.PostgreSQL().unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(0) == 0) {
                    object = new ClusterMembershipPostgreSQLDialect(dsConfig, ttl, failFast);
                } else {
                    Option option4 = this.DB2().unapplySeq((CharSequence)string);
                    if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(0) == 0) {
                        object = new ClusterMembershipDB2Dialect(dsConfig, ttl, failFast);
                    } else {
                        Option option5 = this.MSSQL().unapplySeq((CharSequence)string);
                        if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(0) == 0) {
                            object = new ClusterMembershipMSSQLDialect(dsConfig, ttl, failFast);
                        } else {
                            Option option6 = this.H2().unapplySeq((CharSequence)string);
                            if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(0) == 0) {
                                object = new ClusterMembershipH2Dialect(dsConfig, ttl, failFast);
                            } else {
                                Option option7 = this.Derby().unapplySeq((CharSequence)string);
                                if (!option7.isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(0) == 0) {
                                    object = new ClusterMembershipDerbyDialect(dsConfig, ttl, failFast);
                                } else {
                                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not determine the correct dialect for JDBC url: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
                                }
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    private boolean selectDialect$default$3() {
        return true;
    }

    public XlrClusterProvider(ExtendedActorSystem extendedSystem, ClusterConfig config) {
        this.config = config;
        this.system = extendedSystem;
        this.executionContext = extendedSystem.dispatcher();
        this.cluster = (Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system());
        this.Oracle = new StringOps(Predef$.MODULE$.augmentString("jdbc:oracle.*")).r();
        this.MySQL = new StringOps(Predef$.MODULE$.augmentString("jdbc:mysql.*")).r();
        this.PostgreSQL = new StringOps(Predef$.MODULE$.augmentString("jdbc:postgresql.*")).r();
        this.DB2 = new StringOps(Predef$.MODULE$.augmentString("jdbc:db2.*")).r();
        this.MSSQL = new StringOps(Predef$.MODULE$.augmentString("jdbc:sqlserver.*")).r();
        this.H2 = new StringOps(Predef$.MODULE$.augmentString("jdbc:h2.*")).r();
        this.Derby = new StringOps(Predef$.MODULE$.augmentString("jdbc:derby.*")).r();
        this.membershipManagement = this.selectDialect(config.membership().datasource(), config.membership().ttl(), this.selectDialect$default$3());
    }
}

