/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.export.ImportTemplateConfigurationItemReaderWriter;
import com.xebialabs.deployit.plumbing.export.UnresolvedReferencesConfigurationItemConverter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.export.TemplateImportProcessor;
import com.xebialabs.xlrelease.export.TemplateImportUpgrader;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.views.ImportResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.MediaType;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateImporter {
    public static final Pattern FILE_NAME_PATTERN = Pattern.compile("attachments/[A-Za-z0-9]*-(.*)");
    public static final String XLR_3_0_0_VERSION = "3.0.0";
    private ReleaseService releaseService;
    private ImportTemplateConfigurationItemReaderWriter importTemplateConfigurationItemReaderWriter;
    private TemplateImportUpgrader templateImportUpgrader;
    private TaskAccessService taskAccessService;
    private List<TemplateImportProcessor> templateProcessors = new ArrayList<TemplateImportProcessor>();

    @Autowired
    public TemplateImporter(ReleaseService releaseService, ImportTemplateConfigurationItemReaderWriter importTemplateConfigurationItemReaderWriter, TemplateImportUpgrader templateImportUpgrader, TaskAccessService taskAccessService) {
        this.releaseService = releaseService;
        this.importTemplateConfigurationItemReaderWriter = importTemplateConfigurationItemReaderWriter;
        this.templateImportUpgrader = templateImportUpgrader;
        this.taskAccessService = taskAccessService;
    }

    @Autowired(required=false)
    public void setTemplateProcessors(List<TemplateImportProcessor> templateProcessors) {
        this.templateProcessors = templateProcessors;
    }

    public List<ImportResult> importZippedTemplate(InputStream inputStream) {
        return this.importZippedTemplate(inputStream, null);
    }

    public List<ImportResult> importZippedTemplate(InputStream inputStream, String destinationFolderId) {
        try {
            TemplateContent templateContent = this.readContentFromZippedStream(inputStream);
            List<String> upgradeWarnings = this.upgradeJSONFile(templateContent);
            return this.importTemplate(templateContent, upgradeWarnings, destinationFolderId);
        }
        catch (IOException | JSONException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImportResult> importReleaseStream(InputStream inputStream, boolean isJson, String destinationFolderId) {
        WorkDirContext.initWorkdir((String)"import");
        try {
            if (isJson) {
                List<ImportResult> list = this.importJsonTemplate(inputStream, destinationFolderId);
                return list;
            }
            List<ImportResult> list = this.importZippedTemplate(inputStream, destinationFolderId);
            return list;
        }
        finally {
            WorkDirContext.get().delete();
            WorkDirContext.clear();
        }
    }

    public List<ImportResult> importReleaseStream(InputStream inputStream, boolean isJson) {
        return this.importReleaseStream(inputStream, isJson, null);
    }

    public List<ImportResult> importJsonTemplate(InputStream inputStream) {
        return this.importJsonTemplate(inputStream, null);
    }

    public List<ImportResult> importJsonTemplate(InputStream inputStream, String destinationFolderId) {
        try {
            TemplateContent templateContent = this.readContentFromJsonStream(inputStream);
            List<String> upgradeWarnings = this.upgradeJSONFile(templateContent);
            return this.importTemplate(templateContent, upgradeWarnings, destinationFolderId);
        }
        catch (IOException | JSONException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public List<ImportResult> importDefaultTemplate(InputStream inputStream) {
        try {
            TemplateContent templateContent = this.readContentFromJsonStream(inputStream);
            return this.importTemplate(templateContent, Lists.newArrayList(), null);
        }
        catch (IOException | JSONException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private List<String> upgradeJSONFile(TemplateContent templateContent) {
        return this.templateImportUpgrader.upgrade(templateContent.template, templateContent.version);
    }

    private TemplateContent readContentFromJsonStream(InputStream inputStream) throws IOException, JSONException {
        String jsonString = this.readJson(inputStream);
        JSONArray jsonArray = new JSONArray(jsonString);
        Preconditions.checkArgument((jsonArray.length() >= 1 ? 1 : 0) != 0, (Object)"Template file is empty");
        Preconditions.checkArgument((boolean)(jsonArray.get(0) instanceof JSONObject), (Object)"Invalid json file");
        HashMap localFiles = Maps.newHashMap();
        return new TemplateContent((JSONObject)jsonArray.get(0), XLR_3_0_0_VERSION, localFiles);
    }

    private TemplateContent readContentFromZippedStream(InputStream inputStream) throws IOException, JSONException {
        WorkDir workDir = WorkDirContext.get();
        HashMap localFiles = Maps.newHashMap();
        JSONObject releaseJson = null;
        String version = null;
        try (ZipInputStream stream = new ZipInputStream(inputStream);){
            ZipEntry entry = stream.getNextEntry();
            while (entry != null) {
                String entryName = entry.getName();
                if (entryName.equals("release-template.json")) {
                    releaseJson = new JSONObject(this.readJson(stream));
                } else if (entryName.startsWith("attachments")) {
                    String fileName = this.extractFileName(entryName);
                    LocalFile localFile = workDir.newFile(fileName);
                    OutputStream outputStream = localFile.getOutputStream();
                    ByteStreams.copy((InputStream)stream, (OutputStream)outputStream);
                    outputStream.close();
                    localFiles.put(entryName, localFile);
                } else if (entryName.equals("manifest.json")) {
                    JSONObject manifestJson = new JSONObject(this.readJson(stream));
                    version = manifestJson.has("xlr-data-model-version") ? manifestJson.getString("xlr-data-model-version") : manifestJson.getString("xlr-version");
                }
                stream.closeEntry();
                entry = stream.getNextEntry();
            }
        }
        Preconditions.checkArgument((releaseJson != null ? 1 : 0) != 0, (Object)"Missing file in template export : release-template.json");
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"Missing file in template export : manifest.json");
        return new TemplateContent(releaseJson, version, localFiles);
    }

    private Release getReleaseFromJSON(JSONObject jsonObject) throws IOException {
        ByteArrayInputStream singleReleaseStream = new ByteArrayInputStream(jsonObject.toString().getBytes());
        ConfigurationItem configurationItem = this.importTemplateConfigurationItemReaderWriter.readFrom(null, null, null, MediaType.APPLICATION_JSON_TYPE, null, (InputStream)singleReleaseStream);
        Preconditions.checkArgument((boolean)(configurationItem instanceof Release), (Object)"Template file doesn't contain a Release");
        return (Release)configurationItem;
    }

    private List<ImportResult> importTemplate(TemplateContent templateContent, List<String> warnings, String destinationFolderId) throws IOException {
        Release template = this.getReleaseFromJSON(templateContent.template);
        Preconditions.checkArgument((boolean)template.isTemplate(), (Object)"Only templates can be imported");
        this.taskAccessService.checkIfAuthenticatedUserCanUseTasks(template.getAllTasks());
        for (Attachment attachment : template.getAttachments()) {
            attachment.setFile((OverthereFile)templateContent.localFiles.get(attachment.getExportFilename()));
        }
        this.templateProcessors.forEach(processor -> warnings.addAll(processor.process(template, destinationFolderId == null ? Ids.ROOT_FOLDER_ID : destinationFolderId)));
        this.removeMissingGateDependencies(template, warnings);
        this.resetUndecryptedPasswords(template, warnings);
        this.resetTemplate(template);
        while (this.templateExistsWithTitle(template.getTitle())) {
            template.setTitle(RetryTitleGenerator.getNextTitle(template.getTitle()));
        }
        if (!template.hasScheduledStartDate()) {
            template.setScheduledStartDate(template.findFirstSetDate());
        }
        this.releaseService.importTemplate(template, destinationFolderId);
        return Lists.newArrayList((Object[])new ImportResult[]{new ImportResult(template.getId(), template.getTitle(), warnings)});
    }

    private String readJson(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
        return new String(outputStream.toByteArray());
    }

    private String extractFileName(String entryName) {
        Matcher matcher = FILE_NAME_PATTERN.matcher(entryName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new RuntimeException("File name not found in : '" + entryName + "'");
    }

    private boolean templateExistsWithTitle(String title) {
        return this.releaseService.templateExistsWithTitle(title);
    }

    private void removeMissingGateDependencies(Release template, Collection<String> warnings) {
        block0: for (GateTask gateTask : template.getAllGates()) {
            Iterator i = gateTask.getDependencies().iterator();
            while (i.hasNext()) {
                Dependency dependency = (Dependency)i.next();
                if (dependency.hasVariableTarget() || dependency.hasResolvedTarget() || dependency.isArchived()) continue;
                warnings.add(String.format("Gate Task '%s' has a dependency on an unknown Release/Phase/Task", gateTask.getTitle()));
                i.remove();
                continue block0;
            }
        }
    }

    private void resetUndecryptedPasswords(Release template, Collection<String> warnings) {
        boolean issueWarning = false;
        List configurationItems = CiHelper.getNestedCis((ConfigurationItem)template);
        for (ConfigurationItem configurationItem : configurationItems) {
            Collection propertyDescriptors = configurationItem.getType().getDescriptor().getPropertyDescriptors();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                boolean decryptionFailed = this.resetUndecryptedPassword(configurationItem, propertyDescriptor);
                if (!decryptionFailed) continue;
                issueWarning = true;
            }
        }
        if (issueWarning) {
            warnings.add("Passwords could not be decrypted and have been reset.");
        }
    }

    private boolean resetUndecryptedPassword(ConfigurationItem ci, PropertyDescriptor propertyDescriptor) {
        String passwordValue;
        if (propertyDescriptor.getKind() == PropertyKind.STRING && propertyDescriptor.isPassword() && Objects.equal((Object)(passwordValue = (String)propertyDescriptor.get(ci)), (Object)UnresolvedReferencesConfigurationItemConverter.DECRYPTION_FAILED_VALUE)) {
            propertyDescriptor.set(ci, (Object)"");
            return true;
        }
        return false;
    }

    private void resetTemplate(Release release) {
        release.setRunningTriggeredReleasesCount(0);
        for (ReleaseTrigger releaseTrigger : release.getReleaseTriggers()) {
            releaseTrigger.setEnabled(false);
            releaseTrigger.resetExecutionId();
        }
    }

    static class TemplateContent {
        JSONObject template;
        String version;
        Map<String, LocalFile> localFiles;

        TemplateContent(JSONObject template, String version, Map<String, LocalFile> localFiles) {
            this.template = template;
            this.version = version;
            this.localFiles = localFiles;
        }
    }
}

