/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t]c\u0001B\u0001\u0003\u0001-\u0011\u0011\u0003R3qK:$WM\\2z'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001aE\u0003\u0001\u0019I1\u0012\u0004\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011!CU3mK\u0006\u001cX\r\u0016:fK\n+\u0018\u000e\u001c3feB\u00111cF\u0005\u00031\t\u0011A\u0004R3qK:$WM\\2z\u0007\u0006tG-\u001b3bi\u0016\u001cu\u000e\u001c7fGR|'\u000f\u0005\u0002\u001b?5\t1D\u0003\u0002\u001d;\u0005)1\u000f\u001c45U*\ta$\u0001\u0005he&T(\u0010\\3e\u0013\t\u00013DA\u0004M_\u001e<\u0017N\\4\t\u0011\t\u0002!Q1A\u0005\u0002\r\n\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z+\u0005!\u0003CA\u0013)\u001b\u00051#BA\u0014\u0005\u0003)\u0011X\r]8tSR|'/_\u0005\u0003S\u0019\u0012\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011!Y\u0003A!A!\u0002\u0013!\u0013A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002B\u0001\"\f\u0001\u0003\u0006\u0004%\tAL\u0001\u0013a2\fg.\u0013;f[J+\u0007o\\:ji>\u0014\u00180F\u00010!\t)\u0003'\u0003\u00022M\t\u0011\u0002\u000b\\1o\u0013R,WNU3q_NLGo\u001c:z\u0011!\u0019\u0004A!A!\u0002\u0013y\u0013a\u00059mC:LE/Z7SKB|7/\u001b;pef\u0004\u0003\u0002C\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\u0002)\u0011,\u0007/\u001a8eK:\u001c\u0017PU3q_NLGo\u001c:z+\u00059\u0004CA\u00139\u0013\tIdE\u0001\u000bEKB,g\u000eZ3oGf\u0014V\r]8tSR|'/\u001f\u0005\tw\u0001\u0011\t\u0011)A\u0005o\u0005)B-\u001a9f]\u0012,gnY=SKB|7/\u001b;pef\u0004\u0003\u0002C\u001f\u0001\u0005\u000b\u0007I\u0011\u0001 \u0002\u0011\u00154XM\u001c;CkN,\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u0012\ta!\u001a<f]R\u001c\u0018B\u0001#B\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo\u001d\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u007f\u0005IQM^3oi\n+8\u000f\t\u0005\t\u0011\u0002\u0011)\u0019!C\u0001\u0013\u0006qA/Y:l%\u0016\u0004xn]5u_JLX#\u0001&\u0011\u0005\u0015Z\u0015B\u0001''\u00059!\u0016m]6SKB|7/\u001b;pefD\u0001B\u0014\u0001\u0003\u0002\u0003\u0006IAS\u0001\u0010i\u0006\u001c8NU3q_NLGo\u001c:zA!A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011+A\u0006dS&#7+\u001a:wS\u000e,W#\u0001*\u0011\u0005M\u0019\u0016B\u0001+\u0003\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\t\u0011Y\u0003!\u0011!Q\u0001\nI\u000bAbY5JIN+'O^5dK\u0002B\u0001\u0002\u0017\u0001\u0003\u0006\u0004%\t!W\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016,\u0012A\u0017\t\u0003'mK!\u0001\u0018\u0002\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0007\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\u0002#\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007\u0005C\u0003a\u0001\u0011\u0005\u0011-\u0001\u0004=S:LGO\u0010\u000b\tE\u000e$WMZ4iSB\u00111\u0003\u0001\u0005\u0006E}\u0003\r\u0001\n\u0005\u0006[}\u0003\ra\f\u0005\u0006k}\u0003\ra\u000e\u0005\u0006{}\u0003\ra\u0010\u0005\u0006\u0011~\u0003\rA\u0013\u0005\u0006!~\u0003\rA\u0015\u0005\u00061~\u0003\rA\u0017\u0015\u0003?.\u0004\"\u0001\\<\u000e\u00035T!A\\8\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002qc\u00069a-Y2u_JL(B\u0001:t\u0003\u0015\u0011W-\u00198t\u0015\t!X/A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u00051\u0018aA8sO&\u0011\u00010\u001c\u0002\n\u0003V$xn^5sK\u0012DqA\u001f\u0001C\u0002\u0013\u000510\u0001\rbGRLg/\u001a#fa\u0016tG-\u001a8dsN#\u0018\r^;tKN,\u0012\u0001 \t\u0006{\u0006-\u0011\u0011\u0003\b\u0004}\u0006\u001dabA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007Q\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\r\tIAD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti!a\u0004\u0003\u0007M+\u0017OC\u0002\u0002\n9\u0001B!a\u0005\u0002\u001c9!\u0011QCA\f!\tyh\"C\u0002\u0002\u001a9\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u000f\u0003?\u0011aa\u0015;sS:<'bAA\r\u001d!9\u00111\u0005\u0001!\u0002\u0013a\u0018!G1di&4X\rR3qK:$WM\\2z'R\fG/^:fg\u0002Bq!a\n\u0001\t\u0003\tI#\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003W\t9$!\u0011\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r\u0005\u0003\u0019!w.\\1j]&!\u0011QGA\u0018\u0005)!U\r]3oI\u0016t7-\u001f\u0005\t\u0003s\t)\u00031\u0001\u0002<\u0005!q-\u0019;f!\u0011\ti#!\u0010\n\t\u0005}\u0012q\u0006\u0002\t\u000f\u0006$X\rV1tW\"A\u00111IA\u0013\u0001\u0004\t\t\"\u0001\nuCJ<W\r^%e\u001fJ4\u0016M]5bE2,\u0007\u0006BA\u0013\u0003\u000f\u0002B!!\u0013\u0002V5\u0011\u00111\n\u0006\u0004]\u00065#\u0002BA(\u0003#\nq!\\3ue&\u001c7OC\u0002\u0002T!\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0003/\nYEA\u0003US6,G\rC\u0004\u0002\\\u0001!\t!!\u0018\u0002\u0019U\u0004H-\u0019;f)\u0006\u0014x-\u001a;\u0015\r\u0005-\u0012qLA2\u0011!\t\t'!\u0017A\u0002\u0005E\u0011\u0001\u00043fa\u0016tG-\u001a8ds&#\u0007\u0002CA\"\u00033\u0002\r!!\u0005)\t\u0005e\u0013q\t\u0005\b\u0003S\u0002A\u0011AA6\u0003\u0019!W\r\\3uKR!\u0011QNA:!\ri\u0011qN\u0005\u0004\u0003cr!\u0001B+oSRD\u0001\"!\u001e\u0002h\u0001\u0007\u0011\u0011C\u0001\u0003S\u0012DC!a\u001a\u0002H!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014!F4fi\u000e{W\u000e\u001d7fi\u0006\u0014G.Z$bi\u0016LEm\u001d\u000b\u0005\u0003\u007f\ny\t\u0005\u0004\u0002\u0002\u0006-\u0015\u0011C\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006!Q\u000f^5m\u0015\t\tI)\u0001\u0003kCZ\f\u0017\u0002BAG\u0003\u0007\u0013!bQ8mY\u0016\u001cG/[8o\u0011!\t\t*!\u001fA\u0002\u0005M\u0015a\u0002;be\u001e,Go\u001d\t\u0007\u0003\u0003\u000bY)!&\u0011\t\u00055\u0012qS\u0005\u0005\u00033\u000byC\u0001\u0005QY\u0006t\u0017\n^3nQ\u0011\tI(a\u0012\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\u0006Ib-\u001b8e\u0003\u000e$\u0018N^3J]\u000e|W.\u001b8h\u000f\u0006$X-\u00133t)\u0011\t\u0019+!+\u0011\r\u0005\u0005\u0015QUA\t\u0013\u0011\t9+a!\u0003\t1K7\u000f\u001e\u0005\t\u0003W\u000bi\n1\u0001\u0002\u0012\u0005A\u0001/\u0019:f]RLE\r\u000b\u0003\u0002\u001e\u0006\u001d\u0003bBAY\u0001\u0011\u0005\u00111W\u0001\u0013O\u0016$h)Y5mC\ndWmR1uK&#7\u000f\u0006\u0003\u0002\u0000\u0005U\u0006\u0002CA\\\u0003_\u0003\r!a%\u0002\u001d\u0005\u0014wN\u001d;fIR\u000b'oZ3ug\"\"\u0011qVA$\u0011\u001d\ti\f\u0001C\u0005\u0003\u007f\u000bADZ5oI\u0006cG.\u00138d_6Lgn\u001a#fa\u0016tG-\u001a8ds&#7\u000fF\u0004}\u0003\u0003\f)-!3\t\u000f\u0005\r\u00171\u0018a\u0001y\u0006IA/\u0019:hKRLEm\u001d\u0005\n\u0003\u000f\fY\f%AA\u0002q\f\u0001b\u001d;biV\u001cXm\u001d\u0005\u000b\u0003\u0017\fY\f%AA\u0002\u00055\u0017a\u0005:fM\u0016\u0014XM\\2j]\u001e\u001c\u0005.\u001b7ee\u0016t\u0007cA\u0007\u0002P&\u0019\u0011\u0011\u001b\b\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0017a\u00074j]\u0012\f5\r^5wK>+HoZ8j]\u001e$\u0016M]4fi&#7\u000f\u0006\u0003\u0002$\u0006e\u0007\u0002CAn\u0003'\u0004\r!!\u0005\u0002\u0013I,G.Z1tK&#\u0007\u0006BAj\u0003\u000fBq!!9\u0001\t\u0003\t\u0019/\u0001\bhKR\u0014V\r\\3bg\u0016$&/Z3\u0015\t\u0005\u0015\u0018\u0011\u001f\t\u0005\u0003O\fi/\u0004\u0002\u0002j*\u0019\u00111\u001e\u0003\u0002\u000bYLWm^:\n\t\u0005=\u0018\u0011\u001e\u0002\f%\u0016dW-Y:f)J,W\r\u0003\u0005\u0002\\\u0006}\u0007\u0019AA\tQ\u0011\ty.a\u0012\t\u000f\u0005]\b\u0001\"\u0001\u0002z\u0006YR\u000f\u001d3bi\u0016<\u0015\r^3SK\u001a,'/\u001a8dS:<\u0007\u000b[1tKN$b!!\u001c\u0002|\u0006}\b\u0002CA\u007f\u0003k\u0004\r!!\u0005\u0002\r\u001d\fG/Z%e\u0011!\u0011\t!!>A\u0002\t\r\u0011\u0001E8sS\u001eLg\u000eV8SKN$xN]3e!!\t\tI!\u0002\u0002\u0016\u0006U\u0015\u0002\u0002B\u0004\u0003\u0007\u00131!T1qQ\u0011\t)0a\u0012\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010\u0005\u0019\u0012M]2iSZ,G)\u001a9f]\u0012,gnY5fgR1\u0011Q\u000eB\t\u0005'A\u0001\"a7\u0003\f\u0001\u0007\u0011\u0011\u0003\u0005\b\u0005+\u0011Y\u00011\u0001}\u00035!W\r]3oI\u0016t7-_%eg\"\"!1BA$\u0011\u001d\u0011Y\u0002\u0001C\t\u0005;\tQDZ5oI&s\u0007K]8he\u0016\u001c8/\u00138d_6LgnZ$bi\u0016LEm\u001d\u000b\u0004y\n}\u0001bBAb\u00053\u0001\r\u0001 \u0005\b\u0005G\u0001A\u0011\u0003B\u0013\u0003)I7\u000fV3na2\fG/\u001a\u000b\u0005\u0003\u001b\u00149\u0003\u0003\u0005\u0002b\t\u0005\u0002\u0019AA\t\u0011%\u0011Y\u0003AI\u0001\n\u0013\u0011i#\u0001\u0014gS:$\u0017\t\u001c7J]\u000e|W.\u001b8h\t\u0016\u0004XM\u001c3f]\u000eL\u0018\nZ:%I\u00164\u0017-\u001e7uII*\"Aa\f+\u0007q\u0014\td\u000b\u0002\u00034A!!Q\u0007B\u001f\u001b\t\u00119D\u0003\u0003\u0003:\tm\u0012!C;oG\",7m[3e\u0015\tqg\"\u0003\u0003\u0003@\t]\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!1\t\u0001\u0012\u0002\u0013%!QI\u0001'M&tG-\u00117m\u0013:\u001cw.\\5oO\u0012+\u0007/\u001a8eK:\u001c\u00170\u00133tI\u0011,g-Y;mi\u0012\u001aTC\u0001B$U\u0011\tiM!\r)\u0007\u0001\u0011Y\u0005\u0005\u0003\u0003N\tMSB\u0001B(\u0015\r\u0011\tf]\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B+\u0005\u001f\u0012qaU3sm&\u001cW\r")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final XLReleaseEventBus eventBus;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final Seq<String> activeDependencyStatuses;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    @Timed
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        void var3_3;
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return var3_3;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(String id) {
        Dependency dependency = this.dependencyRepository().findById(id);
        GateTask gate = dependency.getGateTask();
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public Collection<String> getCompletableGateIds(Collection<PlanItem> targets) {
        Seq doneTargetIds = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(targets).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone()))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.findInProgressIncomingGateIds((Seq<String>)doneTargetIds).map((Function1 & Serializable & scala.Serializable)id -> (GateTask)this.taskRepository().findById((String)id), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isCompletable()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    public List<String> findActiveIncomingGateIds(String parentId) {
        Seq seq;
        if (this.planItemRepository().exists(parentId)) {
            seq = (Seq)((SeqLike)((TraversableLike)this.findAllIncomingDependencyIds((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable & scala.Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Plan item ", " not found. It is either archived, or does not exist. Returning no dependencies"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentId})));
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava();
    }

    @Timed
    public Collection<String> getFailableGateIds(Collection<PlanItem> abortedTargets) {
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.findInProgressIncomingGateIds((Seq<String>)((Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(abortedTargets).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getId(), Seq$.MODULE$.canBuildFrom())))).asJava();
    }

    private Seq<String> findAllIncomingDependencyIds(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren) {
        return (Seq)this.dependencyRepository().findAllIncomingDependencies(targetIds, statuses, referencingChildren).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getId(), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> findAllIncomingDependencyIds$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private boolean findAllIncomingDependencyIds$default$3() {
        return false;
    }

    @Timed
    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.dependencyRepository().findAndResolveByReleaseId(releaseId)).asScala()).filter((Function1 & Serializable & scala.Serializable)dep -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$findActiveOutgoingTargetIds$1(dep)))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getTargetId(), Buffer$.MODULE$.canBuildFrom())).distinct()).asJava();
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.archivingService().exists(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = Map$.MODULE$.empty();
            Release release = this.releaseRepository().findById(releaseId);
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    @Timed
    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                Dependency updatedDependency = this.dependencyRepository().update(release, (Dependency)dependency);
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, updatedDependency));
            }
        });
    }

    @Timed
    public void archiveDependencies(String releaseId, Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(referencingRelease.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$9.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (Seq<Dependency>)dependenciesToArchive);
    }

    public Seq<String> findInProgressIncomingGateIds(Seq<String> targetIds) {
        return (Seq)((SeqLike)this.findAllIncomingDependencyIds(targetIds, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$findActiveOutgoingTargetIds$1(Dependency dep) {
        return dep.hasResolvedTarget() && !dep.isDone();
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, XLReleaseEventBus eventBus, TaskRepository taskRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (Seq)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).toSeq().$colon$plus((Object)TaskStatus.PLANNED, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom());
    }
}

