/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.forms;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.configuration.UserProfile;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class UserAccount {
    private String username;
    private boolean external;
    private String profileId;
    private String email;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String password;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String previousPassword;
    private String fullName;
    private boolean loginAllowed;
    private String dateFormat;
    private String timeFormat;
    private Integer firstDayOfWeek;

    @PublicApiMember
    public UserAccount() {
    }

    public UserAccount(String username, UserProfile profile, boolean isInternal) {
        this.username = username;
        boolean bl = this.external = !isInternal;
        if (profile != null) {
            this.profileId = profile.getId();
            this.email = profile.getEmail();
            this.fullName = profile.getFullName();
            this.loginAllowed = profile.isLoginAllowed();
            this.dateFormat = profile.getDateFormat();
            this.timeFormat = profile.getTimeFormat();
            this.firstDayOfWeek = profile.getFirstDayOfWeek();
        }
    }

    public UserProfile toUserProfile() {
        UserProfile profile = new UserProfile(this.username, this.email, this.fullName, this.loginAllowed);
        profile.setDateFormat(this.dateFormat);
        profile.setTimeFormat(this.timeFormat);
        profile.setFirstDayOfWeek(this.firstDayOfWeek);
        return profile;
    }

    @PublicApiMember
    public String getUsername() {
        return this.username;
    }

    @PublicApiMember
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isExternal() {
        return this.external;
    }

    public String getProfileId() {
        return this.profileId;
    }

    @PublicApiMember
    public String getEmail() {
        return this.email;
    }

    @PublicApiMember
    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    @PublicApiMember
    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasPassword() {
        return this.password != null && !this.password.isEmpty();
    }

    public String getPreviousPassword() {
        return this.previousPassword;
    }

    public void setPreviousPassword(String previousPassword) {
        this.previousPassword = previousPassword;
    }

    @PublicApiMember
    public String getFullName() {
        return this.fullName;
    }

    @PublicApiMember
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @PublicApiMember
    public boolean isLoginAllowed() {
        return this.loginAllowed;
    }

    @PublicApiMember
    public void setLoginAllowed(boolean loginAllowed) {
        this.loginAllowed = loginAllowed;
    }

    @PublicApiMember
    public String getDateFormat() {
        return this.dateFormat;
    }

    @PublicApiMember
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @PublicApiMember
    public Integer getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @PublicApiMember
    public void setFirstDayOfWeek(Integer firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    @PublicApiMember
    public String getTimeFormat() {
        return this.timeFormat;
    }

    @PublicApiMember
    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }
}

