/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service.blackout;

import akka.actor.Actor;
import akka.actor.ActorRef;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.blackout.BlackoutPeriod;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.EventBus;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.blackout.BlackoutReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.AllowConcurrentEvents;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001B\u0001\u0003\u00015\u0011\u0001D\u00117bG.|W\u000f\u001e+bg.,e/\u001a8u\u0011\u0006tG\r\\3s\u0015\t\u0019A!\u0001\u0005cY\u0006\u001c7n\\;u\u0015\t)a!A\u0004tKJ4\u0018nY3\u000b\u0005\u001dA\u0011!\u0003=me\u0016dW-Y:f\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u001dQa\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005IQ\r\u001f;f]NLwN\u001c\u0006\u00033\u0019\ta!Y2u_J\u001c\u0018BA\u000e\u0017\u0005q\t5\r^8s\u000bb$XM\\:j_:D\u0015M\u001c3mKJ4\u0015m\u0019;pef\u0004\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\u000bMdg\r\u000e6\u000b\u0003\u0005\n\u0001b\u001a:jujdW\rZ\u0005\u0003Gy\u0011q\u0001T8hO&tw\r\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u0003!)g/\u001a8u\u0005V\u001cX#A\u0014\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013AB3wK:$8O\u0003\u0002-\r\u00051Am\\7bS:L!AL\u0015\u0003\u0011\u00153XM\u001c;CkND\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IaJ\u0001\nKZ,g\u000e\u001e\"vg\u0002B\u0001B\r\u0001\u0003\u0006\u0004%\taM\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u000b\u0002iA\u0011QGN\u0007\u00021%\u0011q\u0007\u0007\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\u0005\ts\u0001\u0011\t\u0011)A\u0005i\u0005!\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0002B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001P\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z+\u0005i\u0004C\u0001 B\u001b\u0005y$B\u0001!\u0007\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u0005~\u0012a\u0002V1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003>\u0003=!\u0018m]6SKB|7/\u001b;pef\u0004\u0003\"\u0002$\u0001\t\u00039\u0015A\u0002\u001fj]&$h\b\u0006\u0003I\u0015.c\u0005CA%\u0001\u001b\u0005\u0011\u0001\"B\u0013F\u0001\u00049\u0003\"\u0002\u001aF\u0001\u0004!\u0004\"B\u001eF\u0001\u0004i\u0004FA#O!\ty%,D\u0001Q\u0015\t\t&+\u0001\u0006b]:|G/\u0019;j_:T!a\u0015+\u0002\u000f\u0019\f7\r^8ss*\u0011QKV\u0001\u0006E\u0016\fgn\u001d\u0006\u0003/b\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u00023\u0006\u0019qN]4\n\u0005m\u0003&!C!vi><\u0018N]3e\u0011\u0015i\u0006\u0001\"\u0001_\u0003!\u0011XmZ5ti\u0016\u0014H#A0\u0011\u0005=\u0001\u0017BA1\u0011\u0005\u0011)f.\u001b;)\u0005q\u001b\u0007C\u00013i\u001b\u0005)'BA)g\u0015\u00059\u0017!\u00026bm\u0006D\u0018BA5f\u00055\u0001vn\u001d;D_:\u001cHO];di\")1\u000e\u0001C\u0001=\u0006QQO\u001c:fO&\u001cH/\u001a:)\u0005)l\u0007C\u00013o\u0013\tyWM\u0001\u0006Qe\u0016$Um\u001d;s_fDQ!\u001d\u0001\u0005\u0002I\f\u0011c\u001c8CY\u0006\u001c7n\\;u+B$\u0017\r^3e)\ty6\u000fC\u0003ua\u0002\u0007Q/A\u0003fm\u0016tG\u000f\u0005\u0002)m&\u0011q/\u000b\u0002\u0015\u00052\f7m[8viV\u0003H-\u0019;fI\u00163XM\u001c;)\u0005AL\bc\u0001>\u0002\u00025\t1P\u0003\u0002Ry*\u0011QP`\u0001\b[\u0016$(/[2t\u0015\ty(\"\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\r\t\u0019a\u001f\u0002\u0006)&lW\r\u001a\u0015\u0004a\u0006\u001d\u0001\u0003BA\u0005\u0003/i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0006iJ\u0012Wo\u001d\u0006\u0005\u0003#\t\u0019\"\u0001\u0005kCZ\fG-\u001e3f\u0015\t\t)\"\u0001\u0002oY&!\u0011\u0011DA\u0006\u0005U\tE\u000e\\8x\u0007>t7-\u001e:sK:$XI^3oiND3\u0001]A\u000f!\u0011\tI!a\b\n\t\u0005\u0005\u00121\u0002\u0002\n'V\u00147o\u0019:jE\u0016Dq!!\n\u0001\t\u0003\t9#A\tp]\nc\u0017mY6pkR$U\r\\3uK\u0012$2aXA\u0015\u0011\u001d!\u00181\u0005a\u0001\u0003W\u00012\u0001KA\u0017\u0013\r\ty#\u000b\u0002\u0015\u00052\f7m[8vi\u0012+G.\u001a;fI\u00163XM\u001c;)\u0007\u0005\r\u0012\u0010\u000b\u0003\u0002$\u0005\u001d\u0001\u0006BA\u0012\u0003;Aq!!\u000f\u0001\t\u0013\tY$\u0001\tjg\u00063g-Z2uS:<G+Y:lgR1\u0011QHA\"\u0003\u000b\u00022aDA \u0013\r\t\t\u0005\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019!\u0018q\u0007a\u0001k\"A\u0011qIA\u001c\u0001\u0004\tI%A\u0002o_^\u0004B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&\u0001\u0003vi&d'BAA*\u0003\u0011Q\u0017M^1\n\t\u0005]\u0013Q\n\u0002\u0005\t\u0006$X\rC\u0004\u0002\\\u0001!I!!\u0018\u0002%M\u001c\u0007.\u001a3vY\u0016$\u0016m]6Va\u0012\fG/\u001a\u000b\u0006?\u0006}\u0013\u0011\u0010\u0005\t\u0003C\nI\u00061\u0001\u0002d\u00051A/Y:l\u0013\u0012\u0004B!!\u001a\u0002t9!\u0011qMA8!\r\tI\u0007E\u0007\u0003\u0003WR1!!\u001c\r\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u000f\t\u0002\rA\u0013X\rZ3g\u0013\u0011\t)(a\u001e\u0003\rM#(/\u001b8h\u0015\r\t\t\b\u0005\u0005\t\u0003w\nI\u00061\u0001\u0002~\u000591m\\7nC:$\u0007\u0003BA@\u0003+sA!!!\u0002\u0012:!\u00111QAH\u001d\u0011\t))!$\u000f\t\u0005\u001d\u00151\u0012\b\u0005\u0003S\nI)C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011\u0011DB\u0005\u0004\u0003'C\u0012!\b*fY\u0016\f7/Z#yK\u000e,H/[8o\u0003\u000e$xN]'fgN\fw-Z:\n\t\u0005]\u0015\u0011\u0014\u0002\u0011\u000bb$XM\\:j_:\u001cu.\\7b]\u0012T1!a%\u0019\u0011\u001d\ti\n\u0001C!\u0003?\u000b!bZ3u\u0011\u0006tG\r\\3s)!\t\t+a0\u0002L\u0006U\u0007\u0003BAR\u0003ssA!!*\u00024:!\u0011qUAW\u001d\u0011\tI'!+\n\u0005\u0005-\u0016\u0001B1lW\u0006LA!a,\u00022\u0006)\u0011m\u0019;pe*\u0011\u00111V\u0005\u0005\u0003k\u000b9,A\u0003BGR|'O\u0003\u0003\u00020\u0006E\u0016\u0002BA^\u0003{\u0013qAU3dK&4XM\u0003\u0003\u00026\u0006]\u0006\u0002CAa\u00037\u0003\r!a1\u0002\tM,GN\u001a\t\u0005\u0003\u000b\f9-\u0004\u0002\u00028&!\u0011\u0011ZA\\\u0005!\t5\r^8s%\u00164\u0007\u0002CAg\u00037\u0003\r!a4\u0002\rM,g\u000eZ3s!\u0015y\u0011\u0011[Ab\u0013\r\t\u0019\u000e\u0005\u0002\n\rVt7\r^5p]BB\u0001\"a6\u0002\u001c\u0002\u0007\u00111M\u0001\ne\u0016dW-Y:f\u0013\u0012Dq!a7\u0001\t\u0013\ti.\u0001\bva\u0012\fG/\u001a+bg.<\u0016\u000e\u001e5\u0015\t\u0005}\u00171\u001f\u000b\u0004?\u0006\u0005\b\u0002CAr\u00033\u0004\r!!:\u0002\u000fU\u0004H-\u0019;feB1q\"a:\u0002l~K1!!;\u0011\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002n\u0006=X\"A\u0016\n\u0007\u0005E8F\u0001\u0003UCN\\\u0007\u0002CA1\u00033\u0004\r!a\u0019\t\u000f\u0005]\b\u0001\"\u0003\u0002z\u0006AR\u000f\u001d3bi\u0016\u001c6\r[3ek2,Gm\u0015;beR$\u0015\r^3\u0015\u000b}\u000bY0a@\t\u0011\u0005u\u0018Q\u001fa\u0001\u0003W\fA\u0001^1tW\"A!\u0011AA{\u0001\u0004\tI%A\u000boK^\u001c6\r[3ek2,Gm\u0015;beR$\u0015\r^3\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b\u00059\"/Z:fiN\u001b\u0007.\u001a3vY\u0016$7\u000b^1si\u0012\u000bG/\u001a\u000b\u0004?\n%\u0001\u0002CA\u007f\u0005\u0007\u0001\r!a;\t\u000f\t5\u0001\u0001\"\u0011\u0003\u0010\u0005A1/\u001e9q_J$8\u000f\u0006\u0003\u0002>\tE\u0001\u0002\u0003B\n\u0005\u0017\u0001\rA!\u0006\u0002\u000b\rd\u0017M\u001f>1\t\t]!\u0011\u0005\t\u0007\u0003K\u0012IB!\b\n\t\tm\u0011q\u000f\u0002\u0006\u00072\f7o\u001d\t\u0005\u0005?\u0011\t\u0003\u0004\u0001\u0005\u0019\t\r\"\u0011CA\u0001\u0002\u0003\u0015\tA!\n\u0003\u0007}#\u0013'\u0005\u0003\u0003(\t5\u0002cA\b\u0003*%\u0019!1\u0006\t\u0003\u000f9{G\u000f[5oOB!\u0011Q\u0019B\u0018\u0013\u0011\u0011\t$a.\u0003\u000b\u0005\u001bGo\u001c:)\u0007\u0001\u0011)\u0004\u0005\u0003\u00038\tuRB\u0001B\u001d\u0015\r\u0011YDV\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B \u0005s\u0011qaU3sm&\u001cW\r")
public class BlackoutTaskEventHandler
implements ActorExtensionHandlerFactory,
Logging {
    private final EventBus eventBus;
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public <T> void replyOrFail(Function0<ActorRef> sender, Function0<T> call) {
        ActorExtensionHandlerFactory.replyOrFail$(this, sender, call);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BlackoutTaskEventHandler blackoutTaskEventHandler = this;
        synchronized (blackoutTaskEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    @PostConstruct
    public void register() {
        this.eventBus().register((Object)this);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Blackout task event handler registered in event bus.");
    }

    @PreDestroy
    public void unregister() {
        this.eventBus().deregister((Object)this);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Blackout task event handler de-registered from event bus.");
    }

    @Subscribe
    @AllowConcurrentEvents
    @Timed
    public void onBlackoutUpdated(BlackoutUpdatedEvent event) {
        block0: {
            Date now = new Date();
            if (!this.isAffectingTasks(event, now)) break block0;
            Buffer taskIds = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.taskRepository().findAffectedByBlackout(event.original())).asScala();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " taskIds to be updated after blackout ", " update."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)taskIds.length()), event.original().getLabel()})));
            BlackoutMetadata metadata = BlackoutMetadata$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlackoutPeriod[]{new BlackoutPeriod(event.updated().getStartDate(), event.updated().getEndDate())})));
            boolean isInBlackout = metadata.isInBlackout(now);
            Date newScheduledStartDate = metadata.getEndOfBlackout(now);
            taskIds.foreach((Function1 & Serializable & scala.Serializable)taskId -> {
                this.scheduleTaskUpdate(taskId, isInBlackout ? new BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate(taskId, newScheduledStartDate) : new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
                return BoxedUnit.UNIT;
            });
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    @Timed
    public void onBlackoutDeleted(BlackoutDeletedEvent event) {
        Buffer taskIds = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.taskRepository().findAffectedByBlackout(event.blackout())).asScala();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " taskIds to be started after blackout ", " removal."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)taskIds.length()), event.blackout().getLabel()})));
        taskIds.foreach((Function1 & Serializable & scala.Serializable)taskId -> {
            this.scheduleTaskUpdate(taskId, new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
            return BoxedUnit.UNIT;
        });
    }

    private boolean isAffectingTasks(BlackoutUpdatedEvent event, Date now) {
        Date date = event.original().getEndDate();
        Date date2 = event.updated().getEndDate();
        boolean endDateChanged = date == null ? date2 != null : !((Object)date).equals(date2);
        boolean startDateMovedIntoFuture = now.after(event.original().getStartDate()) && now.before(event.updated().getStartDate());
        return endDateChanged || startDateMovedIntoFuture;
    }

    private void scheduleTaskUpdate(String taskId, ReleaseExecutionActorMessages.ExtensionCommand command) {
        this.releaseActorService().executeCommandAsync(taskId, command);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> getHandler(ActorRef self, Function0<ActorRef> sender, String releaseId) {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlackoutTaskEventHandler $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate updateScheduledStartDate = (BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate)A1;
                    String taskId = updateScheduledStartDate.taskId();
                    Date newScheduledStartDate = updateScheduledStartDate.newScheduledStartDate();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$1(this, newScheduledStartDate, x$1);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate resetScheduledStartDate = (BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate)A1;
                    String taskId = resetScheduledStartDate.taskId();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable & scala.Serializable)task -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$2(this, task);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate ? true : object instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate;
                return bl;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$getHandler$1 $this, Date newScheduledStartDate$2, Task x$1) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(x$1, newScheduledStartDate$2);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2($anonfun$getHandler$1 $this, Task task) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(task);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 java.util.Date com.xebialabs.xlrelease.domain.Task ), $anonfun$applyOrElse$2$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 com.xebialabs.xlrelease.domain.Task )}, serializedLambda);
            }
        };
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(String taskId, Function1<Task, BoxedUnit> updater) {
        Object task = this.taskRepository().findById(taskId);
        Task original = (Task)CiCloneHelper.cloneCi(task);
        updater.apply(task);
        this.taskRepository().update((Task)task);
        this.eventBus().publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(Task task, Date newScheduledStartDate) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating task '", "' scheduled start date due to new blackout end date '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task.getId(), newScheduledStartDate})));
        Date originalScheduledStartDate = task.getOriginalScheduledStartDate();
        task.setScheduledStartDate(newScheduledStartDate);
        task.setPostponedDueToBlackout(true);
        task.setOriginalScheduledStartDate(originalScheduledStartDate);
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(Task task) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resetting task '", "' scheduled start date due to blackout not being applicable anymore."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task.getId()})));
        task.setScheduledStartDate(task.getOriginalScheduledStartDate());
        task.setPostponedDueToBlackout(false);
    }

    @Override
    public boolean supports(Class<? extends Actor> clazz) {
        return ReleaseExecutionActor.class.isAssignableFrom(clazz);
    }

    @Autowired
    public BlackoutTaskEventHandler(EventBus eventBus, ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.eventBus = eventBus;
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        ActorExtensionHandlerFactory.$init$(this);
        Logging.$init$((Logging)this);
    }
}

