/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SharedConfigurationService {
    private CiIdService ciIdService;
    private ConfigurationRepository configurationRepository;

    @Autowired
    public SharedConfigurationService(CiIdService ciIdService, ConfigurationRepository configurationRepository) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
    }

    @Timed
    public boolean exists(String configurationInstanceId) {
        return this.configurationRepository.exists(configurationInstanceId);
    }

    @Timed
    public Configuration findById(String configurationInstanceId) {
        return (Configuration)this.configurationRepository.read(configurationInstanceId);
    }

    @Timed
    public List<Configuration> findAll() {
        return this.configurationRepository.findAllByTypeAndTitle(Type.valueOf(Configuration.class), null);
    }

    @Timed
    public List<Configuration> searchByTypeAndTitle(Type configurationType, String title) {
        this.checkIsConfigurationType(configurationType);
        return this.configurationRepository.findAllByTypeAndTitle(configurationType, title);
    }

    @Timed
    public List<Descriptor> findAllConfigurationDescriptors() {
        Type configurationType = Type.valueOf(Configuration.class);
        Collection allTypes = DescriptorRegistry.getSubtypes((Type)configurationType);
        return allTypes.stream().filter(type -> !type.getDescriptor().isVirtual()).map(Type::getDescriptor).collect(Collectors.toList());
    }

    @Timed
    public Configuration update(String configurationInstanceId, Configuration configuration) {
        configuration.setId(configurationInstanceId);
        this.configurationRepository.update(configuration);
        return configuration;
    }

    @Timed
    public Configuration create(Configuration configuration) {
        String id = this.getUniqueId(Ids.CUSTOM_CONFIGURATION_ROOT);
        configuration.setId(id);
        this.configurationRepository.create(configuration);
        return configuration;
    }

    @Timed
    public void delete(String configurationInstanceId) {
        this.configurationRepository.delete(configurationInstanceId);
    }

    private String getUniqueId(String parentId) {
        return this.ciIdService.getUniqueId(Type.valueOf(Configuration.class), parentId);
    }

    protected void checkIsConfigurationType(Type configurationType) {
        boolean typeIsConfiguration = configurationType.isSubTypeOf(Type.valueOf(Configuration.class));
        if (!typeIsConfiguration) {
            throw new IllegalArgumentException(String.format("Type '%s' is not Configuration sub-type", configurationType));
        }
    }
}

