/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.xebialabs.xlrelease.configuration.UserProfile;

public class UserProfileBuilder {
    private String id;
    private String fullName;
    private String email;
    private boolean loginAllowed;
    private String dateFormat;
    private String timeFormat;
    private Integer firstDayOfWeek;

    private UserProfileBuilder() {
    }

    public static UserProfileBuilder newUserProfile() {
        return new UserProfileBuilder();
    }

    public UserProfileBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public UserProfileBuilder withFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public UserProfileBuilder withEmail(String email) {
        this.email = email;
        return this;
    }

    public UserProfileBuilder withLoginAllowed(boolean loginAllowed) {
        this.loginAllowed = loginAllowed;
        return this;
    }

    public UserProfileBuilder withDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public UserProfileBuilder withTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        return this;
    }

    public UserProfileBuilder withFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    public UserProfile build() {
        UserProfile profile = new UserProfile(this.id, this.email, this.fullName, this.loginAllowed);
        profile.setTimeFormat(this.timeFormat);
        profile.setDateFormat(this.dateFormat);
        profile.setFirstDayOfWeek(this.firstDayOfWeek);
        return profile;
    }
}

