/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.CurrentVersion;
import com.xebialabs.deployit.plumbing.export.ImportTemplateConfigurationItemReaderWriter;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.upgrade.Components;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.core.Headers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateExporter {
    public static final String RELEASE_TEMPLATE_JSON_FILE = "release-template.json";
    public static final String MANIFEST_JSON_FILE = "manifest.json";
    public static final String XLR_VERSION_FIELD_NAME = "xlr-version";
    public static final String DATA_MODEL_VERSION_FIELD_NAME = "xlr-data-model-version";
    private ImportTemplateConfigurationItemReaderWriter configurationItemReaderWriter;
    private RepositoryVersionService repositoryVersionService;

    @Autowired
    public TemplateExporter(ImportTemplateConfigurationItemReaderWriter configurationItemReaderWriter, RepositoryVersionService repositoryVersionService) {
        this.configurationItemReaderWriter = configurationItemReaderWriter;
        this.repositoryVersionService = repositoryVersionService;
    }

    public void exportTemplate(Release template, OutputStream outputStream) {
        CiHelper.getNestedCis((Collection)Lists.newArrayList((Object[])new Release[]{template})).forEach(CiHelper::eraseTokens);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            this.addAttachments(template, zipOutputStream);
            this.addReleaseTemplate(template, zipOutputStream);
            this.addManifestFile(zipOutputStream);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void addAttachments(Release template, ZipOutputStream zipOutputStream) throws IOException {
        for (Attachment attachment : template.getAttachments()) {
            String exportFilename = attachment.buildExportFileName();
            zipOutputStream.putNextEntry(new ZipEntry(exportFilename));
            attachment.setExportFilename(exportFilename);
            try (InputStream inputStream = attachment.getFile().getInputStream();){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
            }
            zipOutputStream.closeEntry();
        }
    }

    private void addReleaseTemplate(Release template, ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(RELEASE_TEMPLATE_JSON_FILE));
        this.configurationItemReaderWriter.writeTo((ConfigurationItem)template, (Class<?>)Release.class, (Type)((Object)Release.class), new Annotation[0], MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap<String, Object>)new Headers(), (OutputStream)zipOutputStream);
        zipOutputStream.closeEntry();
    }

    private void addManifestFile(ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(MANIFEST_JSON_FILE));
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        writer.object();
        writer.key(DATA_MODEL_VERSION_FIELD_NAME).value((Object)this.repositoryVersionService.readVersionOfComponent(Components.XL_RELEASE_COMPONENT).getVersion());
        writer.key(XLR_VERSION_FIELD_NAME).value((Object)CurrentVersion.get());
        writer.endObject();
        String formattedJson = stringWriter.toString();
        zipOutputStream.write(formattedJson.getBytes(StandardCharsets.UTF_8));
        zipOutputStream.closeEntry();
    }
}

