/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.views.ReleaseTriggerView;
import com.xebialabs.xlrelease.views.converters.BaseConfigurationItemViewConverter;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReleaseTriggerViewConverter
extends BaseConfigurationItemViewConverter {
    @Autowired
    public ReleaseTriggerViewConverter(ConfigurationRepository configurationRepository) {
        super(configurationRepository);
    }

    public ReleaseTrigger fromView(ReleaseTriggerView triggerView) {
        ReleaseTrigger trigger = (ReleaseTrigger)this.newInstance(triggerView);
        this.fillItem((ConfigurationItem)trigger, triggerView);
        trigger.setVariables(this.eraseTokens(triggerView.getVariables()));
        trigger.setTags(triggerView.getTags());
        return trigger;
    }

    public ReleaseTriggerView toView(ReleaseTrigger trigger) {
        ReleaseTriggerView triggerView = new ReleaseTriggerView();
        this.fillView(triggerView, (ConfigurationItem)trigger);
        triggerView.setName(trigger.getName());
        triggerView.setVariables(this.getUpdatableVariables(trigger));
        triggerView.setTags(trigger.getTags());
        return triggerView;
    }

    @Override
    Stream<PropertyDescriptor> getPropertyDescriptors(Type type) {
        return super.getPropertyDescriptors(type).filter(pd -> !"hidden".equals(pd.getCategory()) && !"variables".equals(pd.getCategory()));
    }

    private List<Variable> eraseTokens(List<Variable> vars) {
        for (Variable v : vars) {
            CiHelper.eraseTokens((ConfigurationItem)v);
        }
        return vars;
    }

    private List<Variable> getUpdatableVariables(ReleaseTrigger releaseTrigger) {
        Map values = releaseTrigger.getTemplateVariableValues(v -> !v.isPassword());
        Map passwordValues = releaseTrigger.getTemplateVariableValues(Variable::isPassword);
        List variables = releaseTrigger.getTemplate().getVariables();
        Release dummy = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate().getId()).withVariables(variables).build();
        dummy.setVariableValues(values);
        dummy.setPasswordVariableValues(passwordValues);
        variables = dummy.getVariables();
        return variables;
    }
}

