/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.PhaseService;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/phases")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class PhaseApi
implements ApiService {
    private static final Logger logger = LoggerFactory.getLogger(PhaseApi.class);
    public static final String SERVICE_NAME = "phaseApi";
    private PermissionChecker permissions;
    private PhaseService phaseService;
    private ReleaseService releaseService;
    private ReleaseActorService releaseActorService;

    @Autowired
    public PhaseApi(PermissionChecker permissions, PhaseService phaseService, ReleaseService releaseService, ReleaseActorService releaseActorService) {
        this.permissions = permissions;
        this.phaseService = phaseService;
        this.releaseService = releaseService;
        this.releaseActorService = releaseActorService;
    }

    public String serviceName() {
        return SERVICE_NAME;
    }

    @GET
    @Path(value="/{phaseId:.*/Phase[^/]*}")
    @PublicApiMember
    @Timed
    public Phase getPhase(@PathParam(value="phaseId") String phaseId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)phaseId));
        return this.phaseService.findById(phaseId);
    }

    @PUT
    @Path(value="/{phaseId:.*/Phase[^/]*}")
    @Timed
    public Phase updatePhase(@PathParam(value="phaseId") String phaseId, Phase phase) {
        this.permissions.checkEdit(Ids.releaseIdFrom((String)phaseId));
        return this.releaseActorService.updatePhase(phaseId, phase);
    }

    @PublicApiMember
    @Timed
    public Phase updatePhase(Phase phase) {
        return this.updatePhase(phase.getId(), phase);
    }

    @POST
    @Path(value="/{containerId:.*/Phase.*?}/tasks")
    @PublicApiMember
    @Timed
    public Task addTask(@PathParam(value="containerId") String containerId, Task task, @QueryParam(value="position") Integer position) {
        String releaseId = Ids.releaseIdFrom((String)containerId);
        this.permissions.checkView(releaseId);
        this.permissions.checkEdit(releaseId);
        this.permissions.checkEditTask(releaseId);
        try {
            return this.releaseActorService.createTask(containerId, task, position);
        }
        catch (IllegalArgumentException e) {
            logger.error("Could not add a task to a phase", (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @GET
    @Path(value="/byTitle")
    @PublicApiMember
    @Timed
    public List<Phase> searchPhasesByTitle(@QueryParam(value="phaseTitle") String phaseTitle, @QueryParam(value="releaseId") String releaseId) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)phaseTitle) ? 1 : 0) != 0, (String)"Query parameter phaseTitle must be provided", (Object[])new Object[0]);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)releaseId) ? 1 : 0) != 0, (String)"Query parameter releaseId must be provided", (Object[])new Object[0]);
        Release release = this.releaseService.findById(releaseId);
        this.permissions.checkView(release);
        return release.getPhasesByTitle(phaseTitle);
    }

    @GET
    @Path(value="/search")
    @PublicApiMember
    @Timed
    public List<Phase> searchPhases(@QueryParam(value="phaseTitle") String phaseTitle, @QueryParam(value="releaseId") String releaseId, @QueryParam(value="phaseVersion") PhaseVersion phaseVersion) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)releaseId) ? 1 : 0) != 0, (String)"Query parameter releaseId must be provided", (Object[])new Object[0]);
        Release release = this.releaseService.findById(releaseId);
        this.permissions.checkView(release);
        List<Phase> filteredPhases = release.getPhasesContainingInTitle(phaseTitle);
        filteredPhases = this.filterPhasesForPhaseVersion(filteredPhases, phaseVersion);
        Collections.reverse(filteredPhases);
        return filteredPhases;
    }

    public List<Phase> filterPhasesForPhaseVersion(List<Phase> phases, PhaseVersion phaseVersion) {
        if (phaseVersion == null || phaseVersion == PhaseVersion.ALL) {
            return phases;
        }
        return phases.stream().filter(phase -> PhaseVersion.isPhaseVersion(phase, phaseVersion)).collect(Collectors.toList());
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/phase")
    @PublicApiMember
    @Timed
    public Phase addPhase(@PathParam(value="releaseId") String releaseId, Phase phase, @QueryParam(value="position") Integer position) {
        this.permissions.checkView(releaseId);
        this.permissions.checkEdit(releaseId);
        try {
            return this.releaseActorService.addPhase(releaseId, phase, position);
        }
        catch (IllegalArgumentException e) {
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @POST
    @Path(value="/{phaseId:.*/Phase[^/]*}/copy")
    @PublicApiMember
    @Timed
    public Phase copyPhase(@PathParam(value="phaseId") String phaseIdToCopy, @QueryParam(value="targetPosition") int targetPosition) {
        String releaseId = Ids.releaseIdFrom((String)phaseIdToCopy);
        this.permissions.copyPhase(releaseId);
        try {
            return this.releaseActorService.copyPhase(releaseId, phaseIdToCopy, targetPosition);
        }
        catch (IllegalArgumentException e) {
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @PublicApiMember
    @Timed
    public Phase addPhase(String releaseId, Phase phase) {
        return this.addPhase(releaseId, phase, null);
    }

    @PublicApiMember
    @Timed
    public Phase newPhase() {
        return this.newPhase("New Phase");
    }

    @PublicApiMember
    @Timed
    public Phase newPhase(String title) {
        Phase phase = new Phase();
        phase.setTitle(title);
        return phase;
    }

    @DELETE
    @Path(value="/{phaseId:.*/Phase[^/]*}")
    @PublicApiMember
    @Timed
    public void deletePhase(@PathParam(value="phaseId") String phaseId) {
        this.permissions.checkEdit(Ids.releaseIdFrom((String)phaseId));
        this.releaseActorService.deletePhase(phaseId);
    }
}

