/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.calendar.CalendarEntry;
import com.xebialabs.xlrelease.domain.calendar.SpecialDay;
import com.xebialabs.xlrelease.domain.events.BlackoutCreatedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001-\u0011qbQ1mK:$\u0017M]*feZL7-\u001a\u0006\u0003\u0007\u0011\tqa]3sm&\u001cWM\u0003\u0002\u0006\r\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u000f!\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0006g24GG\u001b\u0006\u0002/\u0005AqM]5{u2,G-\u0003\u0002\u001a)\t9Aj\\4hS:<\u0007\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002/\r\fG.\u001a8eCJ,e\u000e\u001e:z%\u0016\u0004xn]5u_JLX#A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001\"\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011!e\b\u0002\u0018\u0007\u0006dWM\u001c3be\u0016sGO]=SKB|7/\u001b;pefD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0019G\u0006dWM\u001c3be\u0016sGO]=SKB|7/\u001b;pef\u0004\u0003\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011A\u0014\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002QA\u0011\u0011FK\u0007\u0002\u0005%\u00111F\u0001\u0002\f\u0007&LEmU3sm&\u001cW\r\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003)\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0011!y\u0003A!b\u0001\n\u0003\u0001\u0014\u0001C3wK:$()^:\u0016\u0003E\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0003\u0002\r\u00154XM\u001c;t\u0013\t14GA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkND\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!M\u0001\nKZ,g\u000e\u001e\"vg\u0002BQA\u000f\u0001\u0005\u0002m\na\u0001P5oSRtD\u0003\u0002\u001f>}}\u0002\"!\u000b\u0001\t\u000bmI\u0004\u0019A\u000f\t\u000b\u0019J\u0004\u0019\u0001\u0015\t\u000b=J\u0004\u0019A\u0019)\u0005e\n\u0005C\u0001\"N\u001b\u0005\u0019%B\u0001#F\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\r\u001e\u000bqAZ1di>\u0014\u0018P\u0003\u0002I\u0013\u0006)!-Z1og*\u0011!jS\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA*A\u0002pe\u001eL!AT\"\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"\u0002)\u0001\t\u0003\t\u0016!D4fiN\u0003XmY5bY\u0012\u000b\u0017\u0010\u0006\u0002S5B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\tG\u0006dWM\u001c3be*\u0011q\u000bB\u0001\u0007I>l\u0017-\u001b8\n\u0005e#&AC*qK\u000eL\u0017\r\u001c#bs\")1l\u0014a\u00019\u0006a1\u000f]3dS\u0006dG)Y=JIB\u0011Q\f\u001a\b\u0003=\n\u0004\"a\u0018\b\u000e\u0003\u0001T!!\u0019\u0006\u0002\rq\u0012xn\u001c;?\u0013\t\u0019g\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2\u000fQ\ty\u0005\u000e\u0005\u0002j_6\t!N\u0003\u0002EW*\u0011A.\\\u0001\b[\u0016$(/[2t\u0015\tq\u0007\"\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\t\u0001(NA\u0003US6,G\rC\u0003s\u0001\u0011\u00051/A\u0007tKR\u001c\u0006/Z2jC2$\u0015-\u001f\u000b\u0004%R,\b\"B.r\u0001\u0004a\u0006\"\u0002<r\u0001\u0004\u0011\u0016AC:qK\u000eL\u0017\r\u001c#bs\"\u0012\u0011\u000f\u001b\u0005\u0006s\u0002!\tA_\u0001\u000fO\u0016$8\u000b]3dS\u0006dG)Y=t)\u0015Y\u0018qAA\t!\u0011a\u00181\u0001*\u000e\u0003uT!A`@\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0003\tAA[1wC&\u0019\u0011QA?\u0003\t1K7\u000f\u001e\u0005\b\u0003\u0013A\b\u0019AA\u0006\u0003\u00111'o\\7\u0011\u0007q\fi!C\u0002\u0002\u0010u\u0014A\u0001R1uK\"9\u00111\u0003=A\u0002\u0005-\u0011A\u0001;pQ\tA\b\u000eC\u0004\u0002\u001a\u0001!\t!a\u0007\u0002\u0017\u0005$GM\u00117bG.|W\u000f\u001e\u000b\u0005\u0003;\t\u0019\u0003E\u0002T\u0003?I1!!\tU\u0005!\u0011E.Y2l_V$\b\u0002CA\u0013\u0003/\u0001\r!!\b\u0002\u0011\td\u0017mY6pkRD3!a\u0006i\u0011\u001d\tI\u0002\u0001C\u0001\u0003W!b!!\b\u0002.\u0005E\u0002bBA\u0018\u0003S\u0001\r\u0001X\u0001\ta\u0006\u0014XM\u001c;JI\"A\u0011QEA\u0015\u0001\u0004\ti\u0002K\u0002\u0002*!Dq!a\u000e\u0001\t\u0003\tI$\u0001\bva\u0012\fG/\u001a\"mC\u000e\\w.\u001e;\u0015\t\u0005u\u00111\b\u0005\t\u0003{\t)\u00041\u0001\u0002\u001e\u00059Q\u000f\u001d3bi\u0016$\u0007fAA\u001bQ\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013A\u00043fY\u0016$XM\u00117bG.|W\u000f\u001e\u000b\u0005\u0003\u000f\ni\u0005E\u0002\u000e\u0003\u0013J1!a\u0013\u000f\u0005\u0011)f.\u001b;\t\u000f\u0005=\u0013\u0011\ta\u00019\u0006Q!\r\\1dW>,H/\u00133)\u0007\u0005\u0005\u0003\u000eC\u0004\u0002V\u0001!\t!a\u0016\u0002\u0017\u001d,GO\u00117bG.|W\u000f\u001e\u000b\u0005\u0003;\tI\u0006C\u0004\u0002P\u0005M\u0003\u0019\u0001/)\u0007\u0005M\u0003\u000eC\u0004\u0002`\u0001!\t!!\u0019\u0002\u0019%\u001c\u0018J\u001c\"mC\u000e\\w.\u001e;\u0015\t\u0005\r\u0014\u0011\u000e\t\u0004\u001b\u0005\u0015\u0014bAA4\u001d\t9!i\\8mK\u0006t\u0007\u0002CA6\u0003;\u0002\r!a\u0003\u0002\u00079|w\u000fK\u0002\u0002^!Dq!!\u001d\u0001\t\u0003\t\u0019(\u0001\u0007hKR\u0014E.Y2l_V$8\u000f\u0006\u0003\u0002v\u0005]\u0004#\u0002?\u0002\u0004\u0005u\u0001\u0002CA6\u0003_\u0002\r!a\u0003)\u0007\u0005=\u0004\u000eC\u0004\u0002r\u0001!\t!! \u0015\r\u0005U\u0014qPAA\u0011!\tI!a\u001fA\u0002\u0005-\u0001\u0002CA\n\u0003w\u0002\r!a\u0003)\u0007\u0005m\u0004\u000eC\u0004\u0002\b\u0002!I!!#\u0002\u0011M,G\u000fR1uKN$b!a\u0012\u0002\f\u0006=\u0005bBAG\u0003\u000b\u0003\r\u0001X\u0001\u0003S\u0012DaA^AC\u0001\u0004\u0011\u0006bBAJ\u0001\u0011%\u0011QS\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011qIAL\u0011!\t)#!%A\u0002\u0005u\u0001f\u0001\u0001\u0002\u001cB!\u0011QTAR\u001b\t\tyJC\u0002\u0002\"&\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t)+a(\u0003\u000fM+'O^5dK\u0002")
public class CalendarService
implements Logging {
    private final CalendarEntryRepository calendarEntryRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CalendarService calendarService = this;
        synchronized (calendarService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public CalendarEntryRepository calendarEntryRepository() {
        return this.calendarEntryRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public SpecialDay getSpecialDay(String specialDayId) {
        SpecialDay specialDay;
        if (!this.calendarEntryRepository().exists(specialDayId)) {
            void var2_2;
            SpecialDay result = new SpecialDay();
            result.setId(specialDayId);
            this.setDates(specialDayId, result);
            specialDay = var2_2;
        } else {
            specialDay = (SpecialDay)this.calendarEntryRepository().findById(specialDayId);
        }
        return specialDay;
    }

    @Timed
    public SpecialDay setSpecialDay(String specialDayId, SpecialDay specialDay) {
        if (specialDay.isBlank()) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing special day [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{specialDayId})));
            if (this.calendarEntryRepository().exists(specialDayId)) {
                this.calendarEntryRepository().delete(specialDayId);
            }
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Saving special day [", "] with label [", "] and color [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{specialDayId, specialDay.getLabel(), specialDay.getColor()})));
            specialDay.setId(specialDayId);
            this.setDates(specialDayId, specialDay);
            this.calendarEntryRepository().createOrUpdate((CalendarEntry)specialDay);
        }
        return specialDay;
    }

    @Timed
    public List<SpecialDay> getSpecialDays(Date from, Date to) {
        return this.calendarEntryRepository().findAllByTypeInRange(Type.valueOf(SpecialDay.class), from, to);
    }

    @Timed
    public Blackout addBlackout(Blackout blackout) {
        return this.addBlackout(Ids.CALENDAR_ROOT, blackout);
    }

    @Timed
    public Blackout addBlackout(String parentId, Blackout blackout) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding new blackout [", " for period [", "] - [", "] to parent [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blackout.getLabel(), blackout.getStartDate(), blackout.getEndDate(), parentId})));
        this.validate(blackout);
        blackout.setId(this.ciIdService().getUniqueId(Type.valueOf(Blackout.class), parentId));
        this.calendarEntryRepository().create((CalendarEntry)blackout);
        this.eventBus().publish((XLReleaseEvent)new BlackoutCreatedEvent(blackout));
        return blackout;
    }

    @Timed
    public Blackout updateBlackout(Blackout updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating blackout [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{updated.getId()})));
        this.validate(updated);
        Blackout original = (Blackout)this.calendarEntryRepository().findById(updated.getId());
        this.calendarEntryRepository().update((CalendarEntry)updated);
        this.eventBus().publish((XLReleaseEvent)new BlackoutUpdatedEvent(original, updated));
        return updated;
    }

    @Timed
    public void deleteBlackout(String blackoutId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting blackout [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blackoutId})));
        Blackout blackout = (Blackout)this.calendarEntryRepository().findById(blackoutId);
        this.calendarEntryRepository().delete(blackoutId);
        this.eventBus().publish((XLReleaseEvent)new BlackoutDeletedEvent(blackout));
    }

    @Timed
    public Blackout getBlackout(String blackoutId) {
        return (Blackout)this.calendarEntryRepository().findById(blackoutId);
    }

    @Timed
    public boolean isInBlackout(Date now) {
        return this.calendarEntryRepository().existsByTypeInRange(Type.valueOf(Blackout.class), now, now);
    }

    @Timed
    public List<Blackout> getBlackouts(Date now) {
        return this.getBlackouts(now, now);
    }

    @Timed
    public List<Blackout> getBlackouts(Date from, Date to) {
        return this.calendarEntryRepository().findAllByTypeInRange(Type.valueOf(Blackout.class), from, to);
    }

    private void setDates(String id, SpecialDay specialDay) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            dateFormat.setLenient(false);
            DateTime specialDayDate = new DateTime((Object)dateFormat.parse(Ids.getName((String)id)));
            specialDay.setStartDate(specialDayDate.withTimeAtStartOfDay().toDate());
            specialDay.setEndDate(specialDayDate.withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).toDate());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Special day ID [", "] does not have a valid format - Configuration/Calendar/", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id, "yyyyMMdd"})), e);
        }
    }

    private void validate(Blackout blackout) {
        Checks.checkNotNull((Object)blackout.getLabel(), (String)"Blackout label");
        Checks.checkNotNull((Object)blackout.getStartDate(), (String)"Blackout start date");
        Checks.checkNotNull((Object)blackout.getEndDate(), (String)"Blackout end date");
        Checks.checkArgument((boolean)blackout.getStartDate().before(blackout.getEndDate()), (String)"Blackout end date must be after start date.", (Object[])new Object[0]);
    }

    @Autowired
    public CalendarService(CalendarEntryRepository calendarEntryRepository, CiIdService ciIdService, XLReleaseEventBus eventBus) {
        this.calendarEntryRepository = calendarEntryRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

