/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.google.common.base.Joiner;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CalendarService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.TeamView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PermissionChecker {
    public static final String GLOBAL_SECURITY_ALIAS = "global";
    private PermissionEnforcer permissionEnforcer;
    private ReleaseRepository releaseRepository;
    private TaskRepository taskRepository;
    private RoleService roleService;
    private TeamService teamService;
    private CalendarService calendarService;
    private SecuredCis securedCis;
    private ArchivingService archivingService;
    private static final PermissionDeniedException folderAdminCannotAssignPermissionException = new PermissionDeniedException("You cannot assign this permission to a new or existing team.");
    private static final PermissionDeniedException folderAdminCannotEditTeamException = new PermissionDeniedException("You cannot edit a team with this assigned permission.");
    private static final PermissionDeniedException folderAdminCannotDeleteTeamException = new PermissionDeniedException("You cannot delete a team with this assigned permission.");
    private static final PermissionDeniedException userCannotManageTeamException = new PermissionDeniedException("You don't have the permissions required to manage this team.");

    @Autowired
    public PermissionChecker(PermissionEnforcer permissionEnforcer, ReleaseRepository releaseRepository, TaskRepository taskRepository, RoleService roleService, TeamService teamService, CalendarService calendarService, SecuredCis securedCis, ArchivingService archivingService) {
        this.permissionEnforcer = permissionEnforcer;
        this.releaseRepository = releaseRepository;
        this.taskRepository = taskRepository;
        this.roleService = roleService;
        this.teamService = teamService;
        this.calendarService = calendarService;
        this.securedCis = securedCis;
        this.archivingService = archivingService;
    }

    public void check(Permission permission) {
        if (!this.hasGlobalPermission(permission)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)null);
        }
    }

    public void check(Permission permission, String ciId) {
        if (!this.hasPermission(permission, ciId)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)ciId);
        }
    }

    public void check(Permission permission, Release release) {
        if (!this.hasPermission(permission, release)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)release.getId());
        }
    }

    public void checkAny(String ciId, Permission ... permissions) {
        for (Permission permission : permissions) {
            if (!this.hasPermission(permission, ciId)) continue;
            return;
        }
        throw this.exceptionForPermissions(ciId, permissions);
    }

    private PermissionDeniedException exceptionForPermissions(String releaseId, Permission[] permissions) {
        PermissionDeniedException exception = new PermissionDeniedException();
        exception.add("Permission %s on %s is not granted to you", new Object[]{Joiner.on((String)" or ").join((Object[])permissions), releaseId});
        return exception;
    }

    public void checkView(String releaseId) {
        this.check(this.getViewPermission(releaseId), releaseId);
    }

    public void checkView(Release release) {
        this.check(this.getViewPermission(release), release);
    }

    public void checkEditPlanItem(String planItemId) {
        if (Ids.isReleaseId((String)planItemId) || Ids.isPhaseId((String)planItemId)) {
            this.checkEdit(Ids.releaseIdFrom((String)planItemId));
        } else {
            this.checkEditTask(Ids.releaseIdFrom((String)planItemId));
        }
    }

    public void checkEdit(String releaseId) {
        Permission permissionToCheck = this.releaseRepository.isTemplate(releaseId) ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE;
        this.check(permissionToCheck, releaseId);
    }

    public void checkEditTask(String releaseId) {
        Permission permissionToCheck = this.releaseRepository.isTemplate(releaseId) ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK;
        this.check(permissionToCheck, releaseId);
    }

    public void checkEditVariable(Release release, Variable variable) {
        if (this.hasPermission(release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE, release)) {
            return;
        }
        for (Task task : release.getAllTasks()) {
            if (!this.hasPermissionToUpdateTask(task, release) || !task.getReferencedVariables().contains(variable)) continue;
            return;
        }
        throw PermissionDeniedException.withMessage((String)String.format("Permission edit variable is not granted to you on variable [%s]", variable.getId()));
    }

    public void checkDeleteTasks(List<String> ids) {
        String releaseId = this.checkTasksFromSingleRelease(ids);
        if (releaseId != null) {
            this.checkEdit(releaseId);
        }
    }

    public void checkReassignTaskPermission(Release release) {
        Permission permissionToCheck = release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.REASSIGN_RELEASE_TASK;
        this.check(permissionToCheck, release);
    }

    private String checkTasksFromSingleRelease(List<String> ids) {
        if (!ids.isEmpty()) {
            Iterator<String> iterator = ids.iterator();
            String releaseId = Ids.releaseIdFrom((String)iterator.next());
            while (iterator.hasNext()) {
                if (Ids.releaseIdFrom((String)iterator.next()).equals(releaseId)) continue;
                throw new IllegalArgumentException("You can not work with a set of tasks from different releases or templates");
            }
            return releaseId;
        }
        return null;
    }

    public void checkReassignTasks(List<String> ids, String newUser) {
        String releaseId = this.checkTasksFromSingleRelease(ids);
        if (releaseId != null) {
            Release release = this.releaseRepository.findById(releaseId);
            this.checkReassignTaskPermission(release);
            ids.forEach(id -> this.checkReassignTaskToUser((String)id, newUser));
        }
    }

    public void checkReassignTaskToUser(String taskId, String newUser) {
        Object task = this.taskRepository.findById(taskId);
        this.checkReassignTaskToUser((Task)task, newUser);
    }

    public void checkReassignTaskToUser(Task task, String newUser) {
        block2: {
            try {
                this.checkReassignTaskPermission(task.getRelease());
            }
            catch (PermissionDeniedException e) {
                if (this.areUsersInTheSameTaskTeam(task, newUser)) break block2;
                throw e;
            }
        }
    }

    public boolean areUsersInTheSameTaskTeam(Task task, String newUser) {
        Optional<Team> teamOptional;
        Authentication currentAuthentication = Permissions.getAuthentication();
        if (task.hasTeam() && (teamOptional = this.teamService.findTeamByName(task.getRelease().getId(), task.getTeam())).isPresent()) {
            Team team = teamOptional.get();
            return this.isUserInTeam(currentAuthentication, team) && (newUser == null || this.isUserInTeam(newUser, team));
        }
        return false;
    }

    public void checkEditBlackoutPermission(Release release) {
        this.check(release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_BLACKOUT, release);
    }

    private boolean isUserInTeam(Authentication authentication, Team team) {
        return this.isUserInTeam(authentication.getName(), team);
    }

    private boolean isUserInTeam(String user, Team team) {
        return team.hasMember(user) || team.hasAnyRole(this.roleService.getRolesFor(user));
    }

    public void checkEditOrReassignTask(String releaseId) {
        boolean isTemplate = this.releaseRepository.isTemplate(releaseId);
        Permission edit = isTemplate ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK;
        Permission reassign = isTemplate ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.REASSIGN_RELEASE_TASK;
        this.checkAny(releaseId, edit, reassign);
    }

    public void checkRetryTask(String taskId) {
        if (this.isCurrentUserAdmin()) {
            return;
        }
        String username = Permissions.getAuthenticatedUserName();
        Release release = this.releaseRepository.findById(Ids.releaseIdFrom((String)taskId));
        Task task = release.getTask(taskId);
        if (!release.hasOwner(username) && !task.hasOwner(username)) {
            throw PermissionDeniedException.withMessage((String)String.format("You cannot retry this task [%s]. You need to be either release owner or task owner", taskId));
        }
    }

    public List<String> filterRetryTasks(List<String> taskIds) {
        return this.filterTasksSilently(taskIds, this::checkRetryTask);
    }

    private void checkAbortTask(String taskId) {
        if (this.isCurrentUserAdmin()) {
            return;
        }
        String username = Permissions.getAuthenticatedUserName();
        Release release = this.releaseRepository.findById(Ids.releaseIdFrom((String)taskId));
        Task task = release.getTask(taskId);
        if (!release.hasOwner(username) && !task.hasOwner(username)) {
            throw PermissionDeniedException.withMessage((String)String.format("You cannot abort this task [%s]. You need to be either release owner or task owner", taskId));
        }
    }

    public List<String> filterAbortTasks(List<String> taskIds) {
        return this.filterTasksSilently(taskIds, this::checkAbortTask);
    }

    public void checkReopenTaskInRelease(String releaseId) {
        this.check(XLReleasePermissions.VIEW_RELEASE, releaseId);
        this.check(XLReleasePermissions.EDIT_RELEASE_TASK, releaseId);
    }

    public void checkReopenTasksInRelease(List<String> taskIds) {
        String releaseId = this.checkTasksFromSingleRelease(taskIds);
        this.checkReopenTaskInRelease(releaseId);
    }

    public void checkIsAllowedToCommentOnTask(String taskId) {
        try {
            this.checkHasPermissionsToUpdateTask((Task)this.taskRepository.findById(taskId));
        }
        catch (NotFoundException e) {
            if (this.archivingService.exists(taskId)) {
                throw PermissionDeniedException.withMessage((String)String.format("You cannot comment on archived task [%s]", taskId));
            }
            throw e;
        }
    }

    public void checkIsAllowedToUploadAttachmentsOnTask(String taskId) {
        try {
            this.checkHasPermissionsToUpdateTask((Task)this.taskRepository.findById(taskId));
        }
        catch (NotFoundException e) {
            if (this.taskRepository.exists(taskId)) {
                throw PermissionDeniedException.withMessage((String)String.format("You cannot upload attachments on archived task [%s]", taskId));
            }
            throw e;
        }
    }

    public List<String> filterAllowedToCommentOnTasks(List<String> taskIds) {
        return this.filterTasksSilently(taskIds, this::checkIsAllowedToCommentOnTask);
    }

    public void checkIsAllowedToStartTask(String taskId) {
        Object task = this.taskRepository.findById(taskId);
        this.checkTaskIsUpdatable((Task)task);
        if (task.isPostponedDueToBlackout()) {
            this.canOverrideBlackout((Task)task);
        } else {
            if (task.isDelayDuringBlackout() && this.calendarService.isInBlackout(new Date())) {
                this.canOverrideBlackout((Task)task);
            }
            this.checkHasPermissionsToUpdateTask((Task)task);
        }
    }

    private void canOverrideBlackout(Task task) {
        if (!this.hasCiPermission(XLReleasePermissions.EDIT_BLACKOUT, task.getRelease())) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)task.getId(), (String)"'Edit task blackout'");
        }
    }

    public void checkIsAllowedToWorkOnTask(String taskId) {
        Object task = this.taskRepository.findById(taskId);
        this.checkTaskIsUpdatable((Task)task);
        this.checkHasPermissionsToUpdateTask((Task)task);
    }

    public List<String> filterAllowedToWorkOnTasks(List<String> taskIds) {
        return this.filterTasksSilently(taskIds, this::checkIsAllowedToWorkOnTask);
    }

    public List<String> filterStartableReleases(List<String> releaseIds) {
        return this.filterSilently(releaseIds, id -> this.check(XLReleasePermissions.START_RELEASE, (String)id));
    }

    public List<String> filterAbortableReleases(List<String> releaseIds) {
        return this.filterSilently(releaseIds, id -> this.check(XLReleasePermissions.ABORT_RELEASE, (String)id));
    }

    private void checkTaskIsUpdatable(Task task) {
        if (!task.isUpdatable()) {
            throw new IllegalArgumentException("You can not work with a defunct or done in advance task");
        }
    }

    public List<Release> filter(List<Release> items, Permission permission) {
        Predicate<Release> isGranted = candidate -> this.hasPermission(permission, (Release)candidate);
        return items.stream().filter(isGranted).collect(Collectors.toList());
    }

    public List<ConfigurationItem> filterViewables(List<ConfigurationItem> configurationItems) {
        Predicate<ConfigurationItem> isGranted = configurationItem -> configurationItem instanceof Release && this.hasPermission(this.getViewPermission((Release)configurationItem), (Release)configurationItem);
        return configurationItems.stream().filter(isGranted).collect(Collectors.toList());
    }

    public void checkIsAllowedToCreateReleaseFromTemplate(String templateId) {
        boolean isAllowed;
        if (this.isCurrentUserAdmin()) {
            return;
        }
        boolean bl = isAllowed = this.hasCiPermission(XLReleasePermissions.VIEW_TEMPLATE, templateId) && (this.hasGlobalPermission(XLReleasePermissions.CREATE_RELEASE) || this.hasCiPermission(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, templateId));
        if (!isAllowed) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)templateId, (String)"'View template' and 'Create release' (global or on the template)");
        }
    }

    public void checkEditSecurity(String releaseId) {
        if (this.hasGlobalPermission(XLReleasePermissions.EDIT_SECURITY)) {
            return;
        }
        Permission permissionToCheck = this.releaseRepository.isTemplate(releaseId) ? XLReleasePermissions.EDIT_TEMPLATE_SECURITY : XLReleasePermissions.EDIT_RELEASE_SECURITY;
        this.check(permissionToCheck, releaseId);
    }

    private boolean hasCiPermission(Permission permission, Release release) {
        if (!this.isPermissionApplicableTo(permission, release.getId())) {
            return false;
        }
        if (release.isArchived()) {
            return this.hasArchivedReleasePermission(permission, () -> release);
        }
        return this.permissionEnforcer.hasLoggedInUserPermission(permission, this.securedCis.getEffectiveSecuredCi(release.getId()).getSecurityUid());
    }

    private boolean hasCiPermission(Permission permission, String containerId) {
        if (!this.isPermissionApplicableTo(permission, containerId)) {
            return false;
        }
        if (Ids.isReleaseId((String)containerId) && !this.releaseRepository.exists(containerId) && this.archivingService.exists(containerId)) {
            return this.hasArchivedReleasePermission(permission, () -> this.archivingService.getRelease(containerId));
        }
        return this.permissionEnforcer.hasLoggedInUserPermission(permission, this.securedCis.getEffectiveSecuredCi(containerId).getSecurityUid());
    }

    private boolean hasArchivedReleasePermission(Permission permission, Supplier<Release> release) {
        if (this.hasGlobalPermission(PlatformPermissions.ADMIN)) {
            return true;
        }
        Authentication auth = Permissions.getAuthentication();
        List userRoles = this.roleService.getRolesFor(auth);
        Collection userPrincipals = Permissions.authenticationToPrincipals((Authentication)auth);
        return release.get().getPermissions(userPrincipals, userRoles).contains(permission.getPermissionName());
    }

    public boolean hasGlobalPermission(Permission permission) {
        this.checkAuthenticated();
        return this.isPermissionApplicableTo(permission, GLOBAL_SECURITY_ALIAS) && this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{permission});
    }

    public boolean hasPermission(Permission permission, String ciId) {
        return this.hasGlobalPermission(permission) || this.hasCiPermission(permission, ciId);
    }

    public boolean hasPermission(Permission permission, Release release) {
        return this.hasGlobalPermission(permission) || this.hasCiPermission(permission, release);
    }

    public void checkHasPermissionsToUpdateTask(Task task) {
        if (!this.hasPermissionToUpdateTask(task, null)) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)task.getId(), (String)"'Task owner', 'Member of task team' or 'edit task'");
        }
    }

    private boolean hasPermissionToUpdateTask(Task task, Release release) {
        if (this.isCurrentUserAdmin() || this.owns(task)) {
            return true;
        }
        if (release == null) {
            release = this.releaseRepository.findById(Ids.releaseIdFrom((String)task.getId()));
        }
        if (this.hasCiPermission(XLReleasePermissions.EDIT_RELEASE_TASK, release)) {
            return true;
        }
        if (task.hasTeam()) {
            return this.isMemberOrRoleOf(Ids.releaseIdFrom((String)task.getId()), task.getTeam());
        }
        return false;
    }

    public void checkViewTask(Task task) {
        String username = Permissions.getAuthenticatedUserName();
        if (!this.hasViewTaskPermissions(task, username, null)) {
            throw new PermissionDeniedException(String.format("You are not allowed to view task [%s]", task.getId()));
        }
    }

    public void checkViewFolder(String containerId) {
        if (!containerId.equals(Ids.ROOT_FOLDER_ID)) {
            this.check(XLReleasePermissions.VIEW_FOLDER, containerId);
        }
    }

    public boolean hasViewTaskPermissions(Task task, String username, @Nullable List<Role> userRoles) {
        String releaseId = Ids.releaseIdFrom((String)task.getId());
        return this.hasPermission(this.getViewPermission(releaseId), releaseId) || task.hasOwner(username) || this.isMemberOrRoleOf(releaseId, task.getTeam(), userRoles);
    }

    private boolean isMemberOrRoleOf(String releaseId, String teamName) {
        return this.isMemberOrRoleOf(releaseId, teamName, null);
    }

    private boolean isMemberOrRoleOf(String releaseId, String teamName, List<Role> prefetchedUserRoles) {
        if (StringUtils.isEmpty((Object)teamName)) {
            return false;
        }
        List teamsToCheck = this.teamService.findTeamsByNames(releaseId, Arrays.asList(teamName, "Release Admin")).collect(Collectors.toList());
        String currentUser = Permissions.getAuthenticatedUserName();
        boolean isMember = teamsToCheck.stream().anyMatch(team -> team.hasMember(currentUser));
        if (isMember) {
            return true;
        }
        List roles = prefetchedUserRoles == null ? this.roleService.getRolesFor(Permissions.getAuthentication()) : prefetchedUserRoles;
        return teamsToCheck.stream().anyMatch(team -> team.hasAnyRole(roles));
    }

    private Permission getViewPermission(Release release) {
        return release.isTemplate() ? XLReleasePermissions.VIEW_TEMPLATE : XLReleasePermissions.VIEW_RELEASE;
    }

    private boolean owns(Task task) {
        return task.hasOwner(Permissions.getAuthenticatedUserName());
    }

    private Permission getViewPermission(String releaseId) {
        return this.releaseRepository.isTemplate(releaseId) ? XLReleasePermissions.VIEW_TEMPLATE : XLReleasePermissions.VIEW_RELEASE;
    }

    private void checkAuthenticated() {
        if (!this.isAuthenticated()) {
            throw new AuthenticationFailureException("Authentication is missing. Did you specify 'Run automated tasks as user' property of the release?");
        }
    }

    public boolean isAuthenticated() {
        return Permissions.getAuthentication() != null;
    }

    public boolean isCurrentUserAdmin() {
        return this.permissionEnforcer.isCurrentUserAdmin();
    }

    private boolean isPermissionApplicableTo(Permission permission, String containerId) {
        return permission != null && permission.isApplicableTo(containerId);
    }

    private List<String> filterTasksSilently(List<String> taskIds, Consumer<String> checker) {
        String releaseId = this.checkTasksFromSingleRelease(taskIds);
        if (releaseId != null) {
            return this.filterSilently(taskIds, checker);
        }
        return new ArrayList<String>();
    }

    private List<String> filterSilently(List<String> ids, Consumer<String> checker) {
        return ids.stream().filter(id -> {
            try {
                checker.accept((String)id);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    public void checkCopyTask(String releaseId) {
        this.checkView(releaseId);
        this.checkEdit(releaseId);
        this.checkEditTask(releaseId);
    }

    public void copyPhase(String releaseId) {
        this.checkView(releaseId);
        this.checkEdit(releaseId);
    }

    public void checkLockTaskPermission(String releaseId) {
        Permission permissionToCheck = this.releaseRepository.isTemplate(releaseId) ? XLReleasePermissions.LOCK_TEMPLATE_TASK : XLReleasePermissions.LOCK_RELEASE_TASK;
        this.check(permissionToCheck, releaseId);
    }

    public void checkViewTeams(String teamContainerId) {
        if (Ids.isReleaseId((String)teamContainerId)) {
            this.checkEdit(teamContainerId);
        } else if (Ids.isFolderId((String)teamContainerId)) {
            this.checkAny(teamContainerId, XLReleasePermissions.EDIT_FOLDER_SECURITY, XLReleasePermissions.EDIT_FOLDER_TEAMS);
        } else {
            throw new Checks.IncorrectArgumentException("[%s] is not a release or a folder", new Object[]{teamContainerId});
        }
    }

    public void checkEditTeams(String teamContainerId, List<TeamView> teams) {
        this.checkFolderTeams(teamContainerId, () -> this.checkFolderAdmin(teamContainerId, () -> {
            List<Team> toUpdate = this.withoutUnchangedTeams(teamContainerId, teams.stream().map(TeamView::toTeam).collect(Collectors.toList()));
            toUpdate.forEach(team -> this.canUpdateTeam(teamContainerId, (Team)team));
        }));
    }

    public void checkDeleteTeams(String teamContainerId, List<String> teamIds) {
        this.checkFolderTeams(teamContainerId, () -> this.checkFolderAdmin(teamContainerId, () -> teamIds.forEach(teamId -> this.canDeleteTeam(teamContainerId, (String)teamId))));
    }

    public List<Team> getUserFolderTeams(String folderId) {
        String username = User.AUTHENTICATED_USER.getName();
        List<Team> folderTeams = this.teamService.getEffectiveTeams(folderId);
        List userRoles = this.roleService.getRolesFor(username);
        return folderTeams.stream().filter(team -> team.hasMember(username) || team.hasAnyRole(userRoles)).collect(Collectors.toList());
    }

    public void checkDeleteOwnTeams(String teamContainerId) {
        this.checkFolderTeams(teamContainerId, () -> this.checkFolderAdmin(teamContainerId, () -> this.getUserFolderTeams(teamContainerId).forEach(this::canDeleteTeam)));
    }

    private void checkFolderTeams(String teamContainerId, Runnable checkFolder) {
        if (Ids.isReleaseId((String)teamContainerId)) {
            this.checkEdit(teamContainerId);
        } else if (Ids.isFolderId((String)teamContainerId)) {
            checkFolder.run();
        } else {
            throw new Checks.IncorrectArgumentException("[%s] is not a release or a folder", new Object[]{teamContainerId});
        }
    }

    private void checkFolderAdmin(String containerId, Runnable checkFolderAdmin) {
        boolean superUser = this.isCurrentUserAdmin();
        boolean owner = this.hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY, containerId);
        boolean admin = this.hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS, containerId);
        if (admin && !owner && !superUser) {
            checkFolderAdmin.run();
        } else if (!superUser && !owner) {
            throw userCannotManageTeamException;
        }
    }

    private void canDeleteTeam(String containerId, String teamId) {
        List<Team> folderTeams = this.teamService.getEffectiveTeams(containerId);
        Optional<Team> maybeTeamToDelete = folderTeams.stream().filter(team -> team.getId().equals(teamId)).findAny();
        maybeTeamToDelete.ifPresent(this::canDeleteTeam);
    }

    private void canDeleteTeam(Team team) {
        if (team.isFolderOwnerTeam() || team.isFolderAdminTeam()) {
            throw folderAdminCannotDeleteTeamException;
        }
    }

    private List<Team> withoutUnchangedTeams(String containerId, List<Team> teams) {
        List<Team> folderTeams = this.teamService.getEffectiveTeams(containerId);
        teams.removeIf(folderTeams::contains);
        return teams;
    }

    private void canUpdateTeam(String containerId, Team team) {
        Optional<Team> oldTeam = this.teamService.getEffectiveTeams(containerId).stream().filter(t -> t.getTeamName().equals(team.getTeamName())).findFirst();
        if (team.isFolderOwnerTeam() || team.isFolderAdminTeam()) {
            throw folderAdminCannotAssignPermissionException;
        }
        oldTeam.ifPresent(old -> {
            if (old.isFolderOwnerTeam() || old.isFolderAdminTeam()) {
                throw folderAdminCannotEditTeamException;
            }
        });
    }
}

