/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0001\u0003\u0001-\u0011\u0011\u0003R3qK:$WM\\2z'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001aE\u0003\u0001\u0019I1\u0012\u0004\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011!CU3mK\u0006\u001cX\r\u0016:fK\n+\u0018\u000e\u001c3feB\u00111cF\u0005\u00031\t\u0011A\u0004R3qK:$WM\\2z\u0007\u0006tG-\u001b3bi\u0016\u001cu\u000e\u001c7fGR|'\u000f\u0005\u0002\u001b?5\t1D\u0003\u0002\u001d;\u0005)1\u000f\u001c45U*\ta$\u0001\u0005he&T(\u0010\\3e\u0013\t\u00013DA\u0004M_\u001e<\u0017N\\4\t\u0011\t\u0002!Q1A\u0005\u0002\r\n\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z+\u0005!\u0003CA\u0013)\u001b\u00051#BA\u0014\u0005\u0003)\u0011X\r]8tSR|'/_\u0005\u0003S\u0019\u0012\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011!Y\u0003A!A!\u0002\u0013!\u0013A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002B\u0001\"\f\u0001\u0003\u0006\u0004%\tAL\u0001\u0015e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0016\u0003=\u0002\"a\u0005\u0019\n\u0005E\u0012!\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW\r\u0003\u00054\u0001\t\u0005\t\u0015!\u00030\u0003U\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\u0002B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAN\u0001\u0013a2\fg.\u0013;f[J+\u0007o\\:ji>\u0014\u00180F\u00018!\t)\u0003(\u0003\u0002:M\t\u0011\u0002\u000b\\1o\u0013R,WNU3q_NLGo\u001c:z\u0011!Y\u0004A!A!\u0002\u00139\u0014a\u00059mC:LE/Z7SKB|7/\u001b;pef\u0004\u0003\u0002C\u001f\u0001\u0005\u000b\u0007I\u0011\u0001 \u0002)\u0011,\u0007/\u001a8eK:\u001c\u0017PU3q_NLGo\u001c:z+\u0005y\u0004CA\u0013A\u0013\t\teE\u0001\u000bEKB,g\u000eZ3oGf\u0014V\r]8tSR|'/\u001f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\u007f\u0005)B-\u001a9f]\u0012,gnY=SKB|7/\u001b;pef\u0004\u0003\u0002C#\u0001\u0005\u000b\u0007I\u0011\u0001$\u0002\u0011\u00154XM\u001c;CkN,\u0012a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\u0012\ta!\u001a<f]R\u001c\u0018B\u0001'J\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo\u001d\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u000f\u0006IQM^3oi\n+8\u000f\t\u0005\t!\u0002\u0011)\u0019!C\u0001#\u0006qA/Y:l%\u0016\u0004xn]5u_JLX#\u0001*\u0011\u0005\u0015\u001a\u0016B\u0001+'\u00059!\u0016m]6SKB|7/\u001b;pefD\u0001B\u0016\u0001\u0003\u0002\u0003\u0006IAU\u0001\u0010i\u0006\u001c8NU3q_NLGo\u001c:zA!A\u0001\f\u0001BC\u0002\u0013\u0005\u0011,A\u0006dS&#7+\u001a:wS\u000e,W#\u0001.\u0011\u0005MY\u0016B\u0001/\u0003\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\t\u0011y\u0003!\u0011!Q\u0001\ni\u000bAbY5JIN+'O^5dK\u0002B\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t!Y\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016,\u0012A\u0019\t\u0003'\rL!\u0001\u001a\u0002\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0007\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011\u00022\u0002#\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007\u0005C\u0003i\u0001\u0011\u0005\u0011.\u0001\u0004=S:LGO\u0010\u000b\nU.dWN\\8qcJ\u0004\"a\u0005\u0001\t\u000b\t:\u0007\u0019\u0001\u0013\t\u000b5:\u0007\u0019A\u0018\t\u000bU:\u0007\u0019A\u001c\t\u000bu:\u0007\u0019A \t\u000b\u0015;\u0007\u0019A$\t\u000bA;\u0007\u0019\u0001*\t\u000ba;\u0007\u0019\u0001.\t\u000b\u0001<\u0007\u0019\u00012)\u0005\u001d$\bcA;\u0002\u00025\taO\u0003\u0002xq\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005eT\u0018a\u00024bGR|'/\u001f\u0006\u0003wr\fQAY3b]NT!! @\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011a`\u0001\u0004_J<\u0017bAA\u0002m\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\n\u0003\u000f\u0001!\u0019!C\u0001\u0003\u0013\t\u0001$Y2uSZ,G)\u001a9f]\u0012,gnY=Ti\u0006$Xo]3t+\t\tY\u0001\u0005\u0004\u0002\u000e\u0005u\u00111\u0005\b\u0005\u0003\u001f\tIB\u0004\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)BC\u0001\u0007yI|w\u000e\u001e \n\u0003=I1!a\u0007\u000f\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\b\u0002\"\t\u00191+Z9\u000b\u0007\u0005ma\u0002\u0005\u0003\u0002&\u00055b\u0002BA\u0014\u0003S\u00012!!\u0005\u000f\u0013\r\tYCD\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0012\u0011\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-b\u0002\u0003\u0005\u00026\u0001\u0001\u000b\u0011BA\u0006\u0003e\t7\r^5wK\u0012+\u0007/\u001a8eK:\u001c\u0017p\u0015;biV\u001cXm\u001d\u0011\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<\u000511M]3bi\u0016$b!!\u0010\u0002J\u0005M\u0003\u0003BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\rC!\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u000f\n\tE\u0001\u0006EKB,g\u000eZ3oGfD\u0001\"a\u0013\u00028\u0001\u0007\u0011QJ\u0001\u0005O\u0006$X\r\u0005\u0003\u0002@\u0005=\u0013\u0002BA)\u0003\u0003\u0012\u0001bR1uKR\u000b7o\u001b\u0005\t\u0003+\n9\u00041\u0001\u0002$\u0005\u0011B/\u0019:hKRLEm\u0014:WCJL\u0017M\u00197fQ\u0011\t9$!\u0017\u0011\t\u0005m\u0013qM\u0007\u0003\u0003;R1a^A0\u0015\u0011\t\t'a\u0019\u0002\u000f5,GO]5dg*\u0019\u0011Q\r\u0005\u0002\u0011\r|G-\u00195bY\u0016LA!!\u001b\u0002^\t)A+[7fI\"9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0014\u0001D;qI\u0006$X\rV1sO\u0016$HCBA\u001f\u0003c\n)\b\u0003\u0005\u0002t\u0005-\u0004\u0019AA\u0012\u00031!W\r]3oI\u0016t7-_%e\u0011!\t)&a\u001bA\u0002\u0005\r\u0002\u0006BA6\u00033Bq!a\u001f\u0001\t\u0003\ti(\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003\u007f\n)\tE\u0002\u000e\u0003\u0003K1!a!\u000f\u0005\u0011)f.\u001b;\t\u0011\u0005\u001d\u0015\u0011\u0010a\u0001\u0003G\t!!\u001b3)\t\u0005e\u0014\u0011\f\u0005\b\u0003\u001b\u0003A\u0011AAH\u0003U9W\r^\"p[BdW\r^1cY\u0016<\u0015\r^3JIN$B!!%\u0002\"B1\u00111SAO\u0003Gi!!!&\u000b\t\u0005]\u0015\u0011T\u0001\u0005kRLGN\u0003\u0002\u0002\u001c\u0006!!.\u0019<b\u0013\u0011\ty*!&\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0003\u0005\u0002$\u0006-\u0005\u0019AAS\u0003\u001d!\u0018M]4fiN\u0004b!a%\u0002\u001e\u0006\u001d\u0006\u0003BA \u0003SKA!a+\u0002B\tA\u0001\u000b\\1o\u0013R,W\u000e\u000b\u0003\u0002\f\u0006e\u0003bBAY\u0001\u0011\u0005\u00111W\u0001\u001aM&tG-Q2uSZ,\u0017J\\2p[&twmR1uK&#7\u000f\u0006\u0003\u00026\u0006m\u0006CBAJ\u0003o\u000b\u0019#\u0003\u0003\u0002:\u0006U%\u0001\u0002'jgRD\u0001\"!0\u00020\u0002\u0007\u00111E\u0001\ta\u0006\u0014XM\u001c;JI\"\"\u0011qVA-\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000b\f!cZ3u\r\u0006LG.\u00192mK\u001e\u000bG/Z%egR!\u0011\u0011SAd\u0011!\tI-!1A\u0002\u0005\u0015\u0016AD1c_J$X\r\u001a+be\u001e,Go\u001d\u0015\u0005\u0003\u0003\fI\u0006C\u0004\u0002P\u0002!I!!5\u00029\u0019Lg\u000eZ!mY&s7m\\7j]\u001e$U\r]3oI\u0016t7-_%egRA\u00111BAj\u0003/\fY\u000e\u0003\u0005\u0002V\u00065\u0007\u0019AA\u0006\u0003%!\u0018M]4fi&#7\u000f\u0003\u0006\u0002Z\u00065\u0007\u0013!a\u0001\u0003\u0017\t\u0001b\u001d;biV\u001cXm\u001d\u0005\u000b\u0003;\fi\r%AA\u0002\u0005}\u0017a\u0005:fM\u0016\u0014XM\\2j]\u001e\u001c\u0005.\u001b7ee\u0016t\u0007cA\u0007\u0002b&\u0019\u00111\u001d\b\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\u0018a\u00074j]\u0012\f5\r^5wK>+HoZ8j]\u001e$\u0016M]4fi&#7\u000f\u0006\u0003\u00026\u0006-\b\u0002CAw\u0003K\u0004\r!a\t\u0002\u0013I,G.Z1tK&#\u0007\u0006BAs\u00033Bq!a=\u0001\t\u0003\t)0\u0001\bhKR\u0014V\r\\3bg\u0016$&/Z3\u0015\t\u0005](1\u0001\t\u0005\u0003s\fy0\u0004\u0002\u0002|*\u0019\u0011Q \u0003\u0002\u000bYLWm^:\n\t\t\u0005\u00111 \u0002\f%\u0016dW-Y:f)J,W\r\u0003\u0005\u0002n\u0006E\b\u0019AA\u0012Q\u0011\t\t0!\u0017\t\u000f\t%\u0001\u0001\"\u0001\u0003\f\u0005YR\u000f\u001d3bi\u0016<\u0015\r^3SK\u001a,'/\u001a8dS:<\u0007\u000b[1tKN$b!a \u0003\u000e\tE\u0001\u0002\u0003B\b\u0005\u000f\u0001\r!a\t\u0002\r\u001d\fG/Z%e\u0011!\u0011\u0019Ba\u0002A\u0002\tU\u0011\u0001E8sS\u001eLg\u000eV8SKN$xN]3e!!\t\u0019Ja\u0006\u0002(\u0006\u001d\u0016\u0002\u0002B\r\u0003+\u00131!T1qQ\u0011\u00119!!\u0017\t\u000f\t}\u0001\u0001\"\u0001\u0003\"\u0005\u0019\u0012M]2iSZ,G)\u001a9f]\u0012,gnY5fgR1\u0011q\u0010B\u0012\u0005KA\u0001\"!<\u0003\u001e\u0001\u0007\u00111\u0005\u0005\t\u0005O\u0011i\u00021\u0001\u0002\f\u0005iA-\u001a9f]\u0012,gnY=JINDCA!\b\u0002Z!9!Q\u0006\u0001\u0005\u0012\t=\u0012!\b4j]\u0012Le\u000e\u0015:pOJ,7o]%oG>l\u0017N\\4HCR,\u0017\nZ:\u0015\t\u0005-!\u0011\u0007\u0005\t\u0003+\u0014Y\u00031\u0001\u0002\f!9!Q\u0007\u0001\u0005\u0012\t]\u0012AC5t)\u0016l\u0007\u000f\\1uKR!\u0011q\u001cB\u001d\u0011!\t\u0019Ha\rA\u0002\u0005\r\u0002\"\u0003B\u001f\u0001E\u0005I\u0011\u0002B \u0003\u00192\u0017N\u001c3BY2LenY8nS:<G)\u001a9f]\u0012,gnY=JIN$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0003RC!a\u0003\u0003D-\u0012!Q\t\t\u0005\u0005\u000f\u0012y%\u0004\u0002\u0003J)!!1\nB'\u0003%)hn\u00195fG.,GM\u0003\u0002x\u001d%!!\u0011\u000bB%\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005+\u0002\u0011\u0013!C\u0005\u0005/\naEZ5oI\u0006cG.\u00138d_6Lgn\u001a#fa\u0016tG-\u001a8ds&#7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011IF\u000b\u0003\u0002`\n\r\u0003f\u0001\u0001\u0003^A!!q\fB3\u001b\t\u0011\tGC\u0002\u0003dq\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u00119G!\u0019\u0003\u000fM+'O^5dK\u0002")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final XLReleaseEventBus eventBus;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final Seq<String> activeDependencyStatuses;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    @Timed
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        void var3_3;
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return var3_3;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(String id) {
        Dependency dependency = this.dependencyRepository().findById(id);
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public Collection<String> getCompletableGateIds(Collection<PlanItem> targets) {
        Seq doneTargetIds = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(targets).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone()))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.findInProgressIncomingGateIds((Seq<String>)doneTargetIds).map((Function1 & Serializable & scala.Serializable)id -> (GateTask)this.taskRepository().findById((String)id), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isCompletable()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    public List<String> findActiveIncomingGateIds(String parentId) {
        Seq seq;
        if (this.planItemRepository().exists(parentId)) {
            seq = (Seq)((SeqLike)((TraversableLike)this.findAllIncomingDependencyIds((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable & scala.Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Plan item ", " not found. It is either archived, or does not exist. Returning no dependencies"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentId})));
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava();
    }

    @Timed
    public Collection<String> getFailableGateIds(Collection<PlanItem> abortedTargets) {
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.findInProgressIncomingGateIds((Seq<String>)((Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(abortedTargets).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getId(), Seq$.MODULE$.canBuildFrom())))).asJava();
    }

    private Seq<String> findAllIncomingDependencyIds(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren) {
        return (Seq)this.dependencyRepository().findAllIncomingDependencies(targetIds, statuses, referencingChildren).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getId(), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> findAllIncomingDependencyIds$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private boolean findAllIncomingDependencyIds$default$3() {
        return false;
    }

    @Timed
    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.dependencyRepository().findByReleaseId(releaseId)).asScala()).filter((Function1 & Serializable & scala.Serializable)dep -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$findActiveOutgoingTargetIds$1(dep)))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getTargetId(), Buffer$.MODULE$.canBuildFrom())).distinct()).asJava();
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.archivingService().exists(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = Map$.MODULE$.empty();
            Release release = this.releaseRepository().findById(releaseId);
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    @Timed
    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                Dependency updatedDependency = this.dependencyRepository().update(release, (Dependency)dependency);
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, updatedDependency));
            }
        });
    }

    @Timed
    public void archiveDependencies(String releaseId, Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(referencingRelease.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$9.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (Seq<Dependency>)dependenciesToArchive);
    }

    public Seq<String> findInProgressIncomingGateIds(Seq<String> targetIds) {
        return (Seq)((SeqLike)this.findAllIncomingDependencyIds(targetIds, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$findActiveOutgoingTargetIds$1(Dependency dep) {
        return dep.hasResolvedTarget() && !dep.isDone();
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, XLReleaseEventBus eventBus, TaskRepository taskRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (Seq)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).toSeq().$colon$plus((Object)TaskStatus.PLANNED, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom());
    }
}

