/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.xltype.serialization.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.xebialabs.deployit.plumbing.xltype.serialization.json.CiJson2Writer;
import com.xebialabs.deployit.plumbing.xltype.serialization.json.JsonWithCachedProvider;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xltype.serialization.SerializationException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import javax.json.JsonObject;
import javax.json.JsonValue;

public class MetadataIncludingCiJsonWriter
extends CiJson2Writer {
    private ObjectMapper objectMapper;

    public MetadataIncludingCiJsonWriter(Writer writer, ObjectMapper objectMapper) {
        super(writer);
        this.objectMapper = objectMapper;
    }

    public void writeInternalMetadata(Map<String, InternalMetadata> metadata) {
        if (metadata != null && !metadata.isEmpty()) {
            String metadataAsString = null;
            try {
                ObjectWriter ow = this.objectMapper.writer().withDefaultPrettyPrinter();
                metadataAsString = ow.writeValueAsString(metadata);
                try (StringReader reader = new StringReader(metadataAsString);){
                    JsonObject metadataAsJsonObject = JsonWithCachedProvider.createReader(reader).readObject();
                    this.json.write("$metadata", (JsonValue)metadataAsJsonObject);
                }
            }
            catch (JsonProcessingException e) {
                throw new SerializationException("Could not serialize $metadata of a CI: " + metadata, (Throwable)e);
            }
            catch (Exception e) {
                throw new SerializationException("Could not serialize $metadata of a CI: " + metadataAsString, (Throwable)e);
            }
        }
    }
}

