/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseView {
    private static final Logger logger = LoggerFactory.getLogger(LicenseView.class);
    private int version;
    private String licensedTo;
    private String contact;
    private String expiresAfter;
    private String product;
    private String repositoryId;
    private String maxNumberOfUsers;
    private Integer usersLeftCount;

    public LicenseView(License license) {
        if (!license.isDummyLicense()) {
            this.version = license.getLicenseVersion();
            this.licensedTo = license.getStringValue(LicenseProperty.LICENSED_TO);
            try {
                InternetAddress address = new InternetAddress(license.getStringValue(LicenseProperty.CONTACT));
                this.contact = address.getAddress();
            }
            catch (AddressException e) {
                logger.warn("License email address invalid {}", (Object)license.getStringValue(LicenseProperty.CONTACT), (Object)e);
            }
            this.expiresAfter = license.getStringValue(LicenseProperty.EXPIRES_AFTER);
            this.product = license.getStringValue(LicenseProperty.PRODUCT);
            this.repositoryId = license.getStringValue(LicenseProperty.REPOSITORY_ID);
            this.maxNumberOfUsers = license.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getLicensedTo() {
        return this.licensedTo;
    }

    public void setLicensedTo(String licensedTo) {
        this.licensedTo = licensedTo;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getExpiresAfter() {
        return this.expiresAfter;
    }

    public void setExpiresAfter(String expiresAfter) {
        this.expiresAfter = expiresAfter;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getMaxNumberOfUsers() {
        return this.maxNumberOfUsers;
    }

    public void setMaxNumberOfUsers(String maxNumberOfUsers) {
        this.maxNumberOfUsers = maxNumberOfUsers;
    }

    public void setUsersLeftCount(Integer usersLeftCount) {
        this.usersLeftCount = usersLeftCount;
    }

    public Integer getUsersLeftCount() {
        return this.usersLeftCount;
    }
}

