/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.db;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.CreateProcedureChange;
import liquibase.change.core.CreateSequenceChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.CreateViewChange;
import liquibase.change.core.RenameTableChange;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.DropForeignKeyConstraintStatement;
import liquibase.statement.core.DropIndexStatement;
import liquibase.statement.core.DropProcedureStatement;
import liquibase.statement.core.DropSequenceStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.DropViewStatement;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001\u0002\t\u0012\u0001iA\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005W!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015i\u0005\u0001\"\u0001J\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015\u0019\u0006\u0001\"\u0001J\u0011\u0015!\u0006\u0001\"\u0003V\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u0015Y\b\u0001\"\u0003}\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!a\u0006\u0001\t\u0013\tIB\u0001\fY\u0019J+G.Z1tK\u0012\u0013\u0017J\\5uS\u0006d\u0017N_3s\u0015\t\u00112#\u0001\u0002eE*\u0011A#F\u0001\nq2\u0014X\r\\3bg\u0016T!AF\f\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nQa\u001d7gi)T\u0011AJ\u0001\tOJL'P\u001f7fI&\u0011\u0001f\t\u0002\b\u0019><w-\u001b8h\u0003!!'mQ8oM&<W#A\u0016\u0011\u00051\u001adBA\u00172!\tqS$D\u00010\u0015\t\u0001\u0014$\u0001\u0004=e>|GOP\u0005\u0003eu\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!'H\u0001\nI\n\u001cuN\u001c4jO\u0002\n!\u0002Z1uCN{WO]2f+\u0005I\u0004C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\r\u0019\u0018\u000f\u001c\u0006\u0002}\u0005)!.\u0019<bq&\u0011\u0001i\u000f\u0002\u000b\t\u0006$\u0018mU8ve\u000e,\u0017a\u00033bi\u0006\u001cv.\u001e:dK\u0002\na\u0001P5oSRtDc\u0001#G\u000fB\u0011Q\tA\u0007\u0002#!)\u0011&\u0002a\u0001W!)q'\u0002a\u0001s\u0005!\u0011N\\5u)\u0005Q\u0005C\u0001\u000fL\u0013\taUD\u0001\u0003V]&$\u0018a\u00023s_B\fE\u000e\\\u0001\u000eSNLe.\u001b;jC2L'0\u001a3\u0016\u0003A\u0003\"\u0001H)\n\u0005Ik\"a\u0002\"p_2,\u0017M\\\u0001\rIJ|\u0007/T=UC\ndWm]\u0001\u0011Y><GI]8q'R\fG/Z7f]R$\"A\u0013,\t\u000b]S\u0001\u0019\u0001-\u0002\u001b\u0011\u0014x\u000e]*uCR,W.\u001a8u!\tIf,D\u0001[\u0015\tYF,A\u0005ti\u0006$X-\\3oi*\tQ,A\u0005mSF,\u0018NY1tK&\u0011qL\u0017\u0002\r'Fd7\u000b^1uK6,g\u000e^\u0001\u0015GJ,\u0017\r^3Ee>\u00048\u000b^1uK6,g\u000e^:\u0015\u0005\t\\\u0007cA2i1:\u0011AM\u001a\b\u0003]\u0015L\u0011AH\u0005\u0003Ov\tq\u0001]1dW\u0006<W-\u0003\u0002jU\n\u00191+Z9\u000b\u0005\u001dl\u0002\"\u00027\f\u0001\u0004i\u0017!\u00053bi\u0006\u0014\u0017m]3DQ\u0006tw-\u001a'pOB\u0011a.]\u0007\u0002_*\u0011\u0001\u000fX\u0001\nG\"\fgnZ3m_\u001eL!A]8\u0003#\u0011\u000bG/\u00192bg\u0016\u001c\u0005.\u00198hK2{w-A\u0005ee>\u0004xJ\u001d3feV\tQ\u000f\u0005\u0003\u001dmbC\u0018BA<\u001e\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\u001ds&\u0011!0\b\u0002\u0004\u0013:$\u0018AE2iC:<Wm\u001d\u001ati\u0006$X-\\3oiN,\u0012! \t\u00059Yt(\rE\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rA,\u0001\u0004dQ\u0006tw-Z\u0005\u0005\u0003\u000f\t\tA\u0001\u0004DQ\u0006tw-Z\u0001\u001cI\u0016dW\r^3ECR\f'-Y:f\u0007\"\fgnZ3M_\u001e\u0014vn^:\u0015\u0007)\u000bi\u0001\u0003\u0004^\u001d\u0001\u0007\u0011q\u0002\t\u0005\u0003#\t\u0019\"D\u0001]\u0013\r\t)\u0002\u0018\u0002\n\u0019&\fX/\u001b2bg\u0016\fq\u0002Z8XSRDG*[9vS\n\f7/Z\u000b\u0005\u00037\t\t\u0003\u0006\u0003\u0002\u001e\u0005M\u0002\u0003BA\u0010\u0003Ca\u0001\u0001B\u0004\u0002$=\u0011\r!!\n\u0003\u0003Q\u000bB!a\n\u0002.A\u0019A$!\u000b\n\u0007\u0005-RDA\u0004O_RD\u0017N\\4\u0011\u0007q\ty#C\u0002\u00022u\u00111!\u00118z\u0011\u001d\t)d\u0004a\u0001\u0003o\t\u0001bY1mY\n\f7m\u001b\t\u00079Y\fy!!\b")
public class XLReleaseDbInitializer
implements Logging {
    private final String dbConfig;
    private final DataSource dataSource;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        XLReleaseDbInitializer xLReleaseDbInitializer = this;
        synchronized (xLReleaseDbInitializer) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String dbConfig() {
        return this.dbConfig;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public void init() {
        this.doWithLiquibase((Function1 & Serializable & scala.Serializable)liquibase -> {
            liquibase.update("");
            return BoxedUnit.UNIT;
        });
    }

    public void dropAll() {
        this.doWithLiquibase((Function1 & Serializable & scala.Serializable)liquibase -> {
            liquibase.dropAll();
            return BoxedUnit.UNIT;
        });
    }

    public boolean isInitialized() {
        return BoxesRunTime.unboxToBoolean(this.doWithLiquibase((Function1 & Serializable & scala.Serializable)liquibase -> BoxesRunTime.boxToBoolean((boolean)XLReleaseDbInitializer.$anonfun$isInitialized$1(liquibase))));
    }

    public void dropMyTables() {
        this.doWithLiquibase((Function1 & Serializable & scala.Serializable)liquibase -> {
            XLReleaseDbInitializer.$anonfun$dropMyTables$1(this, liquibase);
            return BoxedUnit.UNIT;
        });
    }

    private void logDropStatement(SqlStatement dropStatement) {
        String string;
        SqlStatement sqlStatement = dropStatement;
        if (sqlStatement instanceof DropTableStatement) {
            DropTableStatement dropTableStatement = (DropTableStatement)sqlStatement;
            string = dropTableStatement.getTableName();
        } else if (sqlStatement instanceof DropForeignKeyConstraintStatement) {
            DropForeignKeyConstraintStatement dropForeignKeyConstraintStatement = (DropForeignKeyConstraintStatement)sqlStatement;
            string = dropForeignKeyConstraintStatement.getConstraintName();
        } else if (sqlStatement instanceof DropViewStatement) {
            DropViewStatement dropViewStatement = (DropViewStatement)sqlStatement;
            string = dropViewStatement.getViewName();
        } else if (sqlStatement instanceof DropSequenceStatement) {
            DropSequenceStatement dropSequenceStatement = (DropSequenceStatement)sqlStatement;
            string = dropSequenceStatement.getSequenceName();
        } else if (sqlStatement instanceof DropProcedureStatement) {
            DropProcedureStatement dropProcedureStatement = (DropProcedureStatement)sqlStatement;
            string = dropProcedureStatement.getProcedureName();
        } else if (sqlStatement instanceof DropIndexStatement) {
            DropIndexStatement dropIndexStatement = (DropIndexStatement)sqlStatement;
            string = dropIndexStatement.getIndexName();
        } else {
            string = sqlStatement.toString();
        }
        String entityName = string;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Dropping ").append(entityName).toString());
    }

    private Seq<SqlStatement> createDropStatements(DatabaseChangeLog databaseChangeLog) {
        List changeSets = databaseChangeLog.getChangeSets();
        return (Seq)((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(changeSets).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getChanges()).asScala(), Buffer$.MODULE$.canBuildFrom())).flatMap(this.changes2statements(), Buffer$.MODULE$.canBuildFrom())).sortBy(this.dropOrder(), (Ordering)Ordering.Int$.MODULE$);
    }

    private Function1<SqlStatement, Object> dropOrder() {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)XLReleaseDbInitializer.$anonfun$dropOrder$1(x0$1));
    }

    private Function1<Change, Seq<SqlStatement>> changes2statements() {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            Change change = x0$1;
            if (change instanceof CreateTableChange) {
                CreateTableChange createTableChange = (CreateTableChange)change;
                Buffer dropStatements = (Buffer)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(createTableChange.getColumns()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)XLReleaseDbInitializer.$anonfun$changes2statements$2(x$2)))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)XLReleaseDbInitializer.$anonfun$changes2statements$3(x$3)))).map((Function1 & Serializable & scala.Serializable)col -> new DropForeignKeyConstraintStatement(createTableChange.getCatalogName(), createTableChange.getSchemaName(), createTableChange.getTableName(), col.getConstraints().getForeignKeyName()), Buffer$.MODULE$.canBuildFrom());
                seq = (Seq)dropStatements.$colon$plus((Object)new DropTableStatement(createTableChange.getCatalogName(), createTableChange.getSchemaName(), createTableChange.getTableName(), true), Buffer$.MODULE$.canBuildFrom());
            } else if (change instanceof RenameTableChange) {
                RenameTableChange renameTableChange = (RenameTableChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropTableStatement[]{new DropTableStatement(renameTableChange.getCatalogName(), renameTableChange.getSchemaName(), renameTableChange.getNewTableName(), true)}));
            } else if (change instanceof AddForeignKeyConstraintChange) {
                AddForeignKeyConstraintChange addForeignKeyConstraintChange = (AddForeignKeyConstraintChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropForeignKeyConstraintStatement[]{new DropForeignKeyConstraintStatement(addForeignKeyConstraintChange.getBaseTableCatalogName(), addForeignKeyConstraintChange.getBaseTableSchemaName(), addForeignKeyConstraintChange.getBaseTableName(), addForeignKeyConstraintChange.getConstraintName())}));
            } else if (change instanceof CreateViewChange) {
                CreateViewChange createViewChange = (CreateViewChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropViewStatement[]{new DropViewStatement(createViewChange.getCatalogName(), createViewChange.getSchemaName(), createViewChange.getViewName())}));
            } else if (change instanceof CreateSequenceChange) {
                CreateSequenceChange createSequenceChange = (CreateSequenceChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropSequenceStatement[]{new DropSequenceStatement(createSequenceChange.getCatalogName(), createSequenceChange.getSchemaName(), createSequenceChange.getSequenceName())}));
            } else if (change instanceof CreateProcedureChange) {
                CreateProcedureChange createProcedureChange = (CreateProcedureChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropProcedureStatement[]{new DropProcedureStatement(createProcedureChange.getCatalogName(), createProcedureChange.getSchemaName(), createProcedureChange.getProcedureName())}));
            } else if (change instanceof CreateIndexChange) {
                CreateIndexChange createIndexChange = (CreateIndexChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropIndexStatement[]{new DropIndexStatement(createIndexChange.getIndexName(), createIndexChange.getCatalogName(), createIndexChange.getSchemaName(), createIndexChange.getTableName(), createIndexChange.getAssociatedWith())}));
            } else {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
            return seq;
        };
    }

    private void deleteDatabaseChangeLogRows(Liquibase liquibase) {
        Database database = liquibase.getDatabase();
        liquibase.getDatabaseChangeLog().getChangeSets().forEach(changeSet -> {
            DeleteStatement deleteStatement = new DeleteStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName());
            deleteStatement.setWhere("FILENAME = ?");
            deleteStatement.addWhereParameter((Object)changeSet.getFilePath());
            try {
                try {
                    ExecutorService.getInstance().getExecutor(database).execute((SqlStatement)deleteStatement);
                }
                catch (DatabaseException e) {
                    this.logger().debug((Function0 & Serializable & scala.Serializable)() -> e.getMessage());
                }
            }
            finally {
                database.commit();
            }
        });
    }

    private <T> T doWithLiquibase(Function1<Liquibase, T> callback) {
        Object object;
        try (Connection connection = this.dataSource().getConnection();){
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            Liquibase liquibase = new Liquibase(this.dbConfig(), (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            object = callback.apply((Object)liquibase);
        }
        return (T)object;
    }

    public static final /* synthetic */ boolean $anonfun$isInitialized$1(Liquibase liquibase) {
        return SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogTable(liquibase.getDatabase());
    }

    public static final /* synthetic */ boolean $anonfun$dropMyTables$2(boolean doExecDropSequencesAndTriggers$1, SqlStatement x0$1) {
        SqlStatement sqlStatement = x0$1;
        boolean bl = sqlStatement instanceof DropSequenceStatement ? true : sqlStatement instanceof DropProcedureStatement;
        boolean bl2 = bl ? doExecDropSequencesAndTriggers$1 : true;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$dropMyTables$3(XLReleaseDbInitializer $this, Database database$1, SqlStatement dropStatement) {
        try {
            try {
                $this.logDropStatement(dropStatement);
                ExecutorService.getInstance().getExecutor(database$1).execute(dropStatement);
            }
            catch (DatabaseException e) {
                $this.logger().warn((Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            }
        }
        finally {
            database$1.commit();
        }
    }

    public static final /* synthetic */ void $anonfun$dropMyTables$1(XLReleaseDbInitializer $this, Liquibase liquibase) {
        block0: {
            Database database = liquibase.getDatabase();
            boolean doExecDropSequencesAndTriggers = database.getDatabaseProductName().toLowerCase().contains("oracle");
            Seq dropsStatements = (Seq)$this.createDropStatements(liquibase.getDatabaseChangeLog()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XLReleaseDbInitializer.$anonfun$dropMyTables$2(doExecDropSequencesAndTriggers, x0$1)));
            boolean enableForeignKeys = database.supportsForeignKeyDisable() && database.disableForeignKeyChecks();
            dropsStatements.foreach((Function1 & Serializable & scala.Serializable)dropStatement -> {
                XLReleaseDbInitializer.$anonfun$dropMyTables$3($this, database, dropStatement);
                return BoxedUnit.UNIT;
            });
            $this.deleteDatabaseChangeLogRows(liquibase);
            if (!enableForeignKeys) break block0;
            liquibase.getDatabase().enableForeignKeyChecks();
        }
    }

    public static final /* synthetic */ int $anonfun$dropOrder$1(SqlStatement x0$1) {
        SqlStatement sqlStatement = x0$1;
        int n = sqlStatement instanceof DropForeignKeyConstraintStatement ? 0 : (sqlStatement instanceof DropIndexStatement ? 1 : (sqlStatement instanceof DropViewStatement ? 2 : 3));
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$changes2statements$2(ColumnConfig x$2) {
        return x$2.getConstraints() != null;
    }

    public static final /* synthetic */ boolean $anonfun$changes2statements$3(ColumnConfig x$3) {
        return x$3.getConstraints().getForeignKeyName() != null;
    }

    public XLReleaseDbInitializer(String dbConfig, DataSource dataSource) {
        this.dbConfig = dbConfig;
        this.dataSource = dataSource;
        Logging.$init$((Logging)this);
    }
}

