/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.variables.StringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.variable.VariableFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScriptServiceHelper {
    private static final Logger logger = LoggerFactory.getLogger(ScriptServiceHelper.class);

    ScriptServiceHelper() {
    }

    public static Map<String, Object> extractReleaseVariables(ScriptContext context) {
        Object attribute = context.getAttribute("_releaseVariables");
        if (attribute != null) {
            return (Map)attribute;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> extractGlobalVariables(ScriptContext context) {
        Object attribute = context.getAttribute("_globalVariables");
        if (attribute != null) {
            return (Map)attribute;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> extractFolderVariables(ScriptContext context) {
        Object attribute = context.getAttribute("_folderVariables");
        if (attribute != null) {
            return (Map)attribute;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> extractTransitionalAndOutputPropertyValues(CustomScriptTask task, ScriptContext scriptContext) {
        Collection transitionalAndOutputProperties = task.getPythonScript().getTransitionalAndOutputProperties();
        HashMap<String, Object> propertyValues = new HashMap<String, Object>();
        for (PropertyDescriptor propertyDescriptor : transitionalAndOutputProperties) {
            String propertyName = propertyDescriptor.getName();
            Object attr = scriptContext.getAttribute(propertyName);
            if (attr == null) {
                logger.debug("Python script task {} did not return a value for property {}", (Object)task.getId(), (Object)propertyDescriptor.getName());
                continue;
            }
            attr = ScriptServiceHelper.convertOutputPropertyValue(propertyDescriptor, attr);
            propertyValues.put(propertyName, attr);
        }
        return propertyValues;
    }

    private static Object convertOutputPropertyValue(PropertyDescriptor propertyDescriptor, Object propertyValue) {
        Variable variable = (Variable)Optional.ofNullable(VariableFactory.createVariableByPropertyDescriptor((PropertyDescriptor)propertyDescriptor).orNull(null)).orElse(new StringVariable());
        try {
            variable.setUntypedValue(propertyValue);
            return variable.getValue();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Cannot store value '%s' of type %s into %s property '%s'", propertyValue, propertyValue.getClass().getSimpleName(), propertyDescriptor.getKind(), propertyDescriptor.getName()));
        }
    }
}

