/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.tasks.gate.TargetIdResolutionFailedException;
import com.xebialabs.xlrelease.repository.IdMatchers$PhaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$ReleaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$TaskId$;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u0017\tAB)\u001a9f]\u0012,gnY=UCJ<W\r\u001e*fg>dg/\u001a:\u000b\u0005\r!\u0011A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011QAB\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0002\u0005\u0002\u0013a,'-[1mC\n\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u0003I\u0001H.\u00198Ji\u0016l'+\u001a9pg&$xN]=\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!A\u0005)mC:LE/Z7SKB|7/\u001b;pefD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0003\u0002\u000fM,'O^5dK&\u0011q\u0004\b\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016DQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtDcA\u0012%KA\u0011Q\u0003\u0001\u0005\u0006'\u0001\u0002\r\u0001\u0006\u0005\u00063\u0001\u0002\rA\u0007\u0015\u0003A\u001d\u0002\"\u0001K\u001a\u000e\u0003%R!AK\u0016\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002-[\u00059a-Y2u_JL(B\u0001\u00180\u0003\u0015\u0011W-\u00198t\u0015\t\u0001\u0014'A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0011\u0014aA8sO&\u0011A'\u000b\u0002\n\u0003V$xn^5sK\u0012DQA\u000e\u0001\u0005\u0002]\nQB]3t_24X\rV1sO\u0016$HC\u0001\u001d<!\ti\u0011(\u0003\u0002;\u001d\t!QK\\5u\u0011\u0015aT\u00071\u0001>\u0003)!W\r]3oI\u0016t7-\u001f\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0012\ta\u0001Z8nC&t\u0017B\u0001\"@\u0005)!U\r]3oI\u0016t7-\u001f\u0015\u0003k\u0011\u0003\"!R&\u000e\u0003\u0019S!AK$\u000b\u0005!K\u0015aB7fiJL7m\u001d\u0006\u0003\u0015\"\t\u0001bY8eC\"\fG.Z\u0005\u0003\u0019\u001a\u0013Q\u0001V5nK\u0012DQA\u0014\u0001\u0005\n=\u000bQC]3t_24X-\u0011:dQ&4X\r\u001a+be\u001e,G\u000fF\u0002Q'\u0002\u0004\"AP)\n\u0005I{$\u0001\u0003)mC:LE/Z7\t\u000bQk\u0005\u0019A+\u0002\u0011Q\f'oZ3u\u0013\u0012\u0004\"AV/\u000f\u0005][\u0006C\u0001-\u000f\u001b\u0005I&B\u0001.\u000b\u0003\u0019a$o\\8u}%\u0011ALD\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]\u001d!)\u0011-\u0014a\u0001+\u0006aA-\u001a9f]\u0012,gnY=JI\"\u0012\u0001a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003M>\n!b\u001d;fe\u0016|G/\u001f9f\u0013\tAWMA\u0005D_6\u0004xN\\3oi\u0002")
public class DependencyTargetResolver {
    private final PlanItemRepository planItemRepository;
    private final ArchivingService archivingService;

    @Timed
    public void resolveTarget(Dependency dependency) {
        block2: {
            String targetId = dependency.getTargetId();
            if (!Strings.isNotEmpty((String)targetId) || VariableHelper$.MODULE$.containsVariables(targetId) || dependency.isArchived()) break block2;
            if (this.planItemRepository.exists(targetId)) {
                Object planItem = this.planItemRepository.findById(targetId);
                dependency.setTarget(planItem);
            } else {
                Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.resolveArchivedTarget(targetId, dependency.getId())).map((Function1 & Serializable & scala.Serializable)target -> {
                    DependencyTargetResolver.$anonfun$resolveTarget$2(dependency, target);
                    return BoxedUnit.UNIT;
                }).recoverWith((PartialFunction)new scala.Serializable(null, dependency, targetId){
                    public static final long serialVersionUID = 0L;
                    private final Dependency dependency$1;
                    private final String targetId$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Object object = A1 instanceof NotFoundException ? new Failure((Throwable)new TargetIdResolutionFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find target on dependency ", " by ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dependency$1.getId(), this.targetId$1})))) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof NotFoundException;
                        return bl;
                    }
                    {
                        this.dependency$1 = dependency$1;
                        this.targetId$1 = targetId$1;
                    }
                }).get();
            }
        }
    }

    private PlanItem resolveArchivedTarget(String targetId, String dependencyId) {
        Release release;
        String string = targetId;
        Option<String> option = IdMatchers$ReleaseId$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            release = this.archivingService.getRelease(targetId);
        } else {
            Option<String> option2 = IdMatchers$PhaseId$.MODULE$.unapply(string);
            if (!option2.isEmpty()) {
                release = this.archivingService.getPhase(targetId);
            } else {
                Option<String> option3 = IdMatchers$TaskId$.MODULE$.unapply(string);
                if (!option3.isEmpty()) {
                    release = this.archivingService.getTask(targetId);
                } else {
                    throw new TargetIdResolutionFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid archived target on dependency ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyId})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"it is not a plan item: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetId})));
                }
            }
        }
        return release;
    }

    public static final /* synthetic */ void $anonfun$resolveTarget$2(Dependency dependency$1, PlanItem target) {
        dependency$1.setTarget(target);
        dependency$1.archive();
    }

    @Autowired
    public DependencyTargetResolver(PlanItemRepository planItemRepository, ArchivingService archivingService) {
        this.planItemRepository = planItemRepository;
        this.archivingService = archivingService;
    }
}

