/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.FolderCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.FolderMovedEvent;
import com.xebialabs.xlrelease.domain.events.FolderMovingAction;
import com.xebialabs.xlrelease.domain.events.FolderRenamedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams$;
import com.xebialabs.xlrelease.repository.ReleaseTriggerRepository;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r\u0005c\u0001B\u0001\u0003\u0001-\u0011QBR8mI\u0016\u00148+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012!B:mMRR'\"A\f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0007\u000b\u0003\u000f1{wmZ5oO\"A1\u0004\u0001B\u0001B\u0003%A$A\u0004g_2$WM]:\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011E\b\u0002\u0011\r>dG-\u001a:SKB|7/\u001b;pefD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\fi\u0016\fWnU3sm&\u001cW\r\u0005\u0002&M5\t!!\u0003\u0002(\u0005\tYA+Z1n'\u0016\u0014h/[2f\u0011!I\u0003A!A!\u0002\u0013Q\u0013!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011QdK\u0005\u0003Yy\u0011\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011!q\u0003A!A!\u0002\u0013y\u0013a\u0003;bg.\u001cVM\u001d<jG\u0016\u0004\"!\n\u0019\n\u0005E\u0012!a\u0003+bg.\u001cVM\u001d<jG\u0016D\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\u0018G>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"!H\u001b\n\u0005Yr\"aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0011!A\u0004A!A!\u0002\u0013I\u0014aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"!\n\u001e\n\u0005m\u0012!aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016D\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\u0015e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0011\u0005\u0015z\u0014B\u0001!\u0003\u0005Q\u0011V\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\"A!\t\u0001B\u0001B\u0003%1)A\u0006qKJl\u0017n]:j_:\u001c\bC\u0001#H\u001b\u0005)%B\u0001$\u0005\u0003!\u0019XmY;sSRL\u0018B\u0001%F\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM\u001d\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\u0006AQM^3oi\n+8\u000f\u0005\u0002M\u001f6\tQJ\u0003\u0002O\t\u00051QM^3oiNL!\u0001U'\u0003#ac%+\u001a7fCN,WI^3oi\n+8\u000f\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0003e\u0011X\r\\3bg\u0016$&/[4hKJ\u001c(+\u001a9pg&$xN]=\u0011\u0005u!\u0016BA+\u001f\u0005a\u0011V\r\\3bg\u0016$&/[4hKJ\u0014V\r]8tSR|'/\u001f\u0005\t/\u0002\u0011\t\u0011)A\u00051\u0006\u0001\u0012M]2iSZLgnZ*feZL7-\u001a\t\u0003KeK!A\u0017\u0002\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0007\"\u0002/\u0001\t\u0003i\u0016A\u0002\u001fj]&$h\b\u0006\u0007_?\u0002\f'm\u00193fM\u001eD\u0017\u000e\u0005\u0002&\u0001!)1d\u0017a\u00019!)1e\u0017a\u0001I!)\u0011f\u0017a\u0001U!)af\u0017a\u0001_!)1g\u0017a\u0001i!)\u0001h\u0017a\u0001s!)Qh\u0017a\u0001}!)!i\u0017a\u0001\u0007\")!j\u0017a\u0001\u0017\")!k\u0017a\u0001'\")qk\u0017a\u00011\")1\u000e\u0001C\u0001Y\u0006\t2\r[3dW\u001a{G\u000eZ3s\u000bbL7\u000f^:\u0015\u00055\u0004\bCA\u0007o\u0013\tygB\u0001\u0003V]&$\b\"B9k\u0001\u0004\u0011\u0018\u0001\u00034pY\u0012,'/\u00133\u0011\u0005MThB\u0001;y!\t)h\"D\u0001w\u0015\t9(\"\u0001\u0004=e>|GOP\u0005\u0003s:\ta\u0001\u0015:fI\u00164\u0017BA>}\u0005\u0019\u0019FO]5oO*\u0011\u0011P\u0004\u0015\u0003Uz\u00042a`A\u0007\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011AC1o]>$\u0018\r^5p]*!\u0011qAA\u0005\u0003\u001diW\r\u001e:jGNT1!a\u0003\t\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\b\u0003\u0003\u0011Q\u0001V5nK\u0012Dq!a\u0005\u0001\t\u0003\t)\"\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u0003/\ti\u0002E\u0002\u000e\u00033I1!a\u0007\u000f\u0005\u001d\u0011un\u001c7fC:Da!]A\t\u0001\u0004\u0011\bfAA\t}\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012\u0001C4fiRKG\u000f\\3\u0015\u0007I\f9\u0003\u0003\u0004r\u0003C\u0001\rA\u001d\u0015\u0004\u0003Cq\bbBA\u0017\u0001\u0011\u0005\u0011qF\u0001\tM&tGMQ=JIR1\u0011\u0011GA!\u0003\u0007\u0002B!a\r\u0002>5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0004g_2$WM\u001d\u0006\u0004\u0003w!\u0011A\u00023p[\u0006Lg.\u0003\u0003\u0002@\u0005U\"A\u0002$pY\u0012,'\u000f\u0003\u0004r\u0003W\u0001\rA\u001d\u0005\u000b\u0003\u000b\nY\u0003%AA\u0002\u0005\u001d\u0013!\u00023faRD\u0007\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\u0005Y\u0006twM\u0003\u0002\u0002R\u0005!!.\u0019<b\u0013\u0011\t)&a\u0013\u0003\u000f%sG/Z4fe\"\u001a\u00111\u0006@\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^\u0005Qa-\u001b8e\u0005f\u0004\u0016\r\u001e5\u0015\r\u0005E\u0012qLA2\u0011\u001d\t\t'!\u0017A\u0002I\fA\u0001]1uQ\"Q\u0011QIA-!\u0003\u0005\r!!\u001a\u0011\u00075\t9'C\u0002\u0002j9\u00111!\u00138uQ\r\tIF \u0005\b\u0003_\u0002A\u0011AA9\u0003Ma\u0017n\u001d;WS\u0016<\u0018M\u00197f\r>dG-\u001a:t)!\t\u0019(a \u0002\u0004\u00065\u0005CBA;\u0003w\n\t$\u0004\u0002\u0002x)!\u0011\u0011PA(\u0003\u0011)H/\u001b7\n\t\u0005u\u0014q\u000f\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002\u0002\u00065\u0004\u0019\u0001:\u0002\u0011A\f'/\u001a8u\u0013\u0012D\u0001\"!\"\u0002n\u0001\u0007\u0011qQ\u0001\u0005a\u0006<W\rE\u0002\u001e\u0003\u0013K1!a#\u001f\u0005\u0011\u0001\u0016mZ3\t\u0015\u0005=\u0015Q\u000eI\u0001\u0002\u0004\t9\"A\feK\u000e|'/\u0019;f/&$\b\u000eU3s[&\u001c8/[8og\"\u001a\u0011Q\u000e@\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\u0006!Qn\u001c<f)\u0019\t\t$!'\u0002\u001c\"1\u0011/a%A\u0002IDq!!(\u0002\u0014\u0002\u0007!/A\u0006oK^\u0004\u0016M]3oi&#\u0007fAAJ}\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0016A\u0002:f]\u0006lW\r\u0006\u0004\u00022\u0005\u001d\u0016\u0011\u0016\u0005\u0007c\u0006\u0005\u0006\u0019\u0001:\t\u000f\u0005-\u0016\u0011\u0015a\u0001e\u00069a.Z<OC6,\u0007fAAQ}\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0016aD:fCJ\u001c\u0007\u000eV3na2\fG/Z:\u0015\r\u0005U\u0016qXAa!\u0019\t)(a\u001f\u00028B!\u0011\u0011XA^\u001b\t\tI$\u0003\u0003\u0002>\u0006e\"a\u0002*fY\u0016\f7/\u001a\u0005\u0007c\u0006=\u0006\u0019\u0001:\t\u0011\u0005\u0015\u0015q\u0016a\u0001\u0003\u000fC3!a,\u007f\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013\fab]3be\u000eD'+\u001a7fCN,7\u000f\u0006\u0005\u0002L\u0006]\u0017\u0011\\Ay!\u0011\ti-a5\u000e\u0005\u0005='bAAi\t\u000511/Z1sG\"LA!!6\u0002P\n\u0019\"+\u001a7fCN,7+Z1sG\"\u0014Vm];mi\"1\u0011/!2A\u0002ID\u0001\"a7\u0002F\u0002\u0007\u0011Q\\\u0001\bM&dG/\u001a:t!\u0011\ty.!<\u000e\u0005\u0005\u0005(\u0002BAr\u0003K\fQAZ8s[NTA!a:\u0002j\u0006\u0011a/\r\u0006\u0004\u0003W$\u0011aA1qS&!\u0011q^Aq\u0005=\u0011V\r\\3bg\u0016\u001ch)\u001b7uKJ\u001c\bBCAC\u0003\u000b\u0004\n\u00111\u0001\u0002\b\"\u001a\u0011Q\u0019@\t\u000f\u0005]\b\u0001\"\u0001\u0002z\u0006aQn\u001c<f)\u0016l\u0007\u000f\\1uKR9!/a?\u0002~\n\u0005\u0001BB9\u0002v\u0002\u0007!\u000fC\u0004\u0002\u0000\u0006U\b\u0019\u0001:\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\r\u0003\u0006\u0003\u0004\u0005U\b\u0013!a\u0001\u0003/\t\u0001c\u001d5pk2$W*\u001a:hKR+\u0017-\\:)\u0007\u0005Uh\u0010C\u0004\u0003\n\u0001!\tAa\u0003\u0002\r\r\u0014X-\u0019;f)\u0019\t\tD!\u0004\u0003\u0010!9\u0011\u0011\u0011B\u0004\u0001\u0004\u0011\b\u0002CA\u001c\u0005\u000f\u0001\r!!\r)\u0007\t\u001da\u0010C\u0004\u0003\n\u0001!\tA!\u0006\u0015\u0011\u0005E\"q\u0003B\r\u00057Aq!!!\u0003\u0014\u0001\u0007!\u000f\u0003\u0005\u00028\tM\u0001\u0019AA\u0019\u0011!\u0011iBa\u0005A\u0002\u0005]\u0011AE2sK\u0006$X\rR3gCVdG\u000fV3b[ND3Aa\u0005\u007f\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0005K\ta\u0001Z3mKR,GcA7\u0003(!1\u0011O!\tA\u0002ID3A!\t\u007f\u0011\u001d\u0011i\u0003\u0001C\u0005\u0005_\tq\"\u0019:dQ&4Xm\u0014:EK2,G/\u001a\u000b\u0006[\nE\"Q\u0007\u0005\t\u0005g\u0011Y\u00031\u0001\u0002f\u0005Iam\u001c7eKJ,\u0016\u000e\u001a\u0005\b\u0005o\u0011Y\u00031\u0001s\u0003%\u0011X\r\\3bg\u0016LE\rC\u0004\u0003<\u0001!IA!\u0010\u0002\u00155,'oZ3UK\u0006l7\u000fF\u0004n\u0005\u007f\u0011\tEa\u0011\t\rE\u0014I\u00041\u0001s\u0011\u001d\tyP!\u000fA\u0002ID\u0001B!\u0012\u0003:\u0001\u0007!qI\u0001\u000ei\u0016l\u0007\u000f\\1uKR+\u0017-\\:\u0011\r\t%#1\u000bB-\u001d\u0011\u0011YEa\u0014\u000f\u0007U\u0014i%C\u0001\u0010\u0013\r\u0011\tFD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Fa\u0016\u0003\u0007M+\u0017OC\u0002\u0003R9\u0001B!!/\u0003\\%!!QLA\u001d\u0005\u0011!V-Y7\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d\u0005a!/\u001a9mC\u000e,G+Z1ngR)QN!\u001a\u0003h!1\u0011Oa\u0018A\u0002IDq!a@\u0003`\u0001\u0007!\u000fC\u0004\u0003l\u0001!IA!\u001c\u000275,'oZ3UK6\u0004H.\u0019;f\u0003:$gi\u001c7eKJ$V-Y7t)\u0019\u00119Ea\u001c\u0003t!A!\u0011\u000fB5\u0001\u0004\u00119%A\u0006g_2$WM\u001d+fC6\u001c\b\u0002\u0003B#\u0005S\u0002\rAa\u0012\t\u000f\t]\u0004\u0001\"\u0003\u0003z\u0005i!/Z:fiR\u000b7o\u001b+fC6$2!\u001cB>\u0011\u001d\tyP!\u001eA\u0002IDqAa \u0001\t\u0013\u0011\t)\u0001\u0010de\u0016\fG/\u001a#fM\u0006,H\u000e\u001e+fC6\u001chi\u001c:UQ\u00164u\u000e\u001c3feR)QNa!\u0003\u0006\"A\u0011q\u0007B?\u0001\u0004\t\t\u0004C\u0004\u0002\u0002\nu\u0004\u0019\u0001:\t\u000f\t%\u0005\u0001\"\u0001\u0003\f\u0006yr-\u001a;O_:Le\u000e[3sSR,GMR8mI\u0016\u0014(+\u001a4fe\u0016t7-Z:\u0015\r\t5%1\u0015BS!\u0019\u0011yI!'\u0003\u001e6\u0011!\u0011\u0013\u0006\u0005\u0005'\u0013)*A\u0004nkR\f'\r\\3\u000b\u0007\t]e\"\u0001\u0006d_2dWm\u0019;j_:LAAa'\u0003\u0012\n\u00191+\u001a;\u0011\t\u0005e&qT\u0005\u0005\u0005C\u000bIDA\tCCN,7i\u001c8gS\u001e,(/\u0019;j_:Da!\u001dBD\u0001\u0004\u0011\bb\u0002BT\u0005\u000f\u0003\rA]\u0001\f]\u0016<hm\u001c7eKJLE\rC\u0004\u0003,\u0002!IA!,\u0002+\rDWmY6G_2$WM]\"b]\n+Wj\u001c<fIR9QNa,\u00032\nm\u0006BB9\u0003*\u0002\u0007!\u000f\u0003\u0005\u00034\n%\u0006\u0019\u0001B[\u0003EqWm\u001e4pY\u0012,'/\u00133PaRLwN\u001c\t\u0005\u001b\t]&/C\u0002\u0003::\u0011aa\u00149uS>t\u0007b\u0002B_\u0005S\u0003\rA]\u0001\n_B,'/\u0019;j_:DqA!1\u0001\t\u0013\u0011\u0019-A\u0007de\u0016\fG/\u001a#fi\u0006LGn\u001d\u000b\u000b\u0005\u000b\u0014IMa4\u0003\\\n}\u0007\u0003BA%\u0005\u000fL1a_A&\u0011!\u0011YMa0A\u0002\t5\u0017AD1di&4XMU3mK\u0006\u001cXm\u001d\t\u0007\u0005\u0013\u0012\u0019&a.\t\u0011\tE'q\u0018a\u0001\u0005'\fq\"\u001a8bE2,G\r\u0016:jO\u001e,'o\u001d\t\u0007\u0005\u0013\u0012\u0019F!6\u0011\t\u0005e&q[\u0005\u0005\u00053\fID\u0001\bSK2,\u0017m]3Ue&<w-\u001a:\t\u0011\tu'q\u0018a\u0001\u0005\u001b\f\u0001$Y;u_N#\u0018M\u001d;QK:$\u0017N\\4SK2,\u0017m]3t\u0011!\u0011\tOa0A\u0002\t\r\u0018aC5om\u0006d\u0017\u000e\u001a*fMN\u0004bA!:\u0003h\nuUB\u0001BK\u0013\u0011\u0011YJ!&\t\u000f\t-\b\u0001\"\u0003\u0003n\u000692\r[3dWR+W\u000e\u001d7bi\u0016\u001c\u0015M\u001c\"f\u001b>4X\r\u001a\u000b\u0006[\n=(\u0011\u001f\u0005\b\u0003\u007f\u0014I\u000f1\u0001s\u0011\u0019\t(\u0011\u001ea\u0001e\"9!Q\u001f\u0001\u0005\n\t]\u0018AE4fiJ+hN\\5oOJ+G.Z1tKN$BA!4\u0003z\"1\u0011Oa=A\u0002IDqA!@\u0001\t\u0013\u0011y0\u0001\nhKR,e.\u00192mK\u0012$&/[4hKJ\u001cH\u0003\u0002Bj\u0007\u0003Aqaa\u0001\u0003|\u0002\u0007!/\u0001\u0006b]\u000e,7\u000f^8s\u0013\u0012Dqaa\u0002\u0001\t\u0013\u0019I!A\u000ehKR\fU\u000f^8Ti\u0006\u0014H\u000fU3oI&twMU3mK\u0006\u001cXm\u001d\u000b\u0005\u0005\u001b\u001cY\u0001\u0003\u0004r\u0007\u000b\u0001\rA\u001d\u0005\n\u0007\u001f\u0001\u0011\u0013!C\u0001\u0007#\ta#\\8wKR+W\u000e\u001d7bi\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0007'QC!a\u0006\u0004\u0016-\u00121q\u0003\t\u0005\u00073\u0019\t#\u0004\u0002\u0004\u001c)!1QDB\u0010\u0003%)hn\u00195fG.,GMC\u0002\u0002\u00049IAaa\t\u0004\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\r\u001d\u0002!%A\u0005\u0002\r%\u0012A\u00054j]\u0012\u0014\u00150\u00133%I\u00164\u0017-\u001e7uII*\"aa\u000b+\t\u0005\u001d3Q\u0003\u0005\n\u0007_\u0001\u0011\u0013!C\u0001\u0007c\tACZ5oI\nK\b+\u0019;iI\u0011,g-Y;mi\u0012\u0012TCAB\u001aU\u0011\t)g!\u0006\t\u0013\r]\u0002!%A\u0005\u0002\rE\u0011!\b7jgR4\u0016.Z<bE2,gi\u001c7eKJ\u001cH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\rm\u0002!%A\u0005\u0002\ru\u0012\u0001G:fCJ\u001c\u0007NU3mK\u0006\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u00111q\b\u0016\u0005\u0003\u000f\u001b)\u0002")
public class FolderService
implements Logging {
    private final FolderRepository folders;
    private final TeamService teamService;
    private final ReleaseRepository releaseRepository;
    private final TaskService taskService;
    private final ConfigurationRepository configurationRepository;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private final ReleaseTriggerRepository releaseTriggersRepository;
    private final ArchivingService archivingService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    @Timed
    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    @Timed
    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Folder ", " cannot be found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.ROOT_FOLDER_ID})), new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find Folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})), new Object[0]);
        });
    }

    @Timed
    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find Folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})), new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Folder findByPath(String path, int depth) {
        void var3_3;
        Folder found = this.folders.findByPath(path, depth);
        this.permissions.check(XLReleasePermissions.VIEW_FOLDER, found.getId());
        return var3_3;
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        this.permissions.checkViewFolder(parentId);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.folders.listViewableFolders(parentId, page, decorateWithPermissions)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)new Some((Object)newParentId), "move");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderMovingAction(folderId, Ids.getParentId((String)folderId), newParentId));
        Folder folder = this.folders.move(folderId, newParentId);
        this.eventBus.publish((XLReleaseEvent)new FolderMovedEvent(folder, Ids.getParentId((String)folderId), newParentId));
        return folder;
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        Checks.checkArgument((!newName.trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Folder folder = this.folders.rename(folderId, newName);
        this.eventBus.publish((XLReleaseEvent)new FolderRenamedEvent(folder, newName));
        return folder;
    }

    @Timed
    public List<Release> searchTemplates(String folderId, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), page.depth()).getReleases();
    }

    @Timed
    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage(), page.depth());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    @Timed
    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String string;
        String newTemplateId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId, Ids.getName((String)templateId)}));
        this.checkTemplateCanBeMoved(templateId, folderId);
        String string2 = Ids.getParentId((String)templateId);
        String string3 = folderId;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to move template ", " to same folder ", ". Will be ignored."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{templateId, folderId})));
            string = templateId;
        } else {
            Buffer templateTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getStoredTeams(templateId)).asScala();
            this.releaseRepository.move(templateId, newTemplateId);
            if (shouldMergeTeams) {
                this.mergeTeams(folderId, newTemplateId, (Seq<Team>)templateTeams);
            } else {
                this.replaceTeams(folderId, newTemplateId);
            }
            this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
            string = newTemplateId;
        }
        return string;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        return this.create(parentId, folder, true);
    }

    @Timed
    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        Folder saved;
        block3: {
            Checks.checkArgument((!folder.getTitle().trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
            this.checkFolderExists(parentId);
            this.folders.checkNameIsUnique(parentId, folder.getTitle());
            if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
                folder.setId(this.ciIdService.getUniqueId(Type.valueOf(Folder.class), parentId));
            } else {
                folder.setId(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentId, Ids.getName((String)folder.getId())})));
            }
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating folder ", " with id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folder.getTitle(), folder.getId()})));
            saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
            this.eventBus.publish((XLReleaseEvent)new FolderCreatedEvent(folder));
            if (!createDefaultTeams) break block3;
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.createDefaultTeamsForTheFolder(saved, parentId);
            }
        }
        return saved;
    }

    @Timed
    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)None$.MODULE$, "delete");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderDeletingAction(folderId));
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})));
        Folder folder = (Folder)this.folders.findById(folderId, this.folders.findById$default$2()).get();
        this.folders.delete(folderId, (Function2<Object, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(folderUid, releaseId) -> {
            this.archiveOrDelete(BoxesRunTime.unboxToInt((Object)folderUid), releaseId);
            return BoxedUnit.UNIT;
        });
        this.eventBus.publish((XLReleaseEvent)new FolderDeletedEvent(folder));
    }

    private void archiveOrDelete(int folderUid, String releaseId) {
        ReleaseStatus status = this.releaseRepository.getStatus(releaseId);
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"archiveOrDelete(", ", ", "): status=", " [inactive? ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)folderUid), releaseId, status, BoxesRunTime.boxToBoolean((boolean)status.isInactive())})));
        if (this.releaseRepository.getStatus(releaseId).isInactive()) {
            if (!this.archivingService.existsPreArchived(releaseId)) {
                Release release = this.releaseRepository.findById(releaseId);
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"release loaded: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release})));
                this.archivingService.preArchiveRelease(release);
            }
            this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"archiveRelease(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
            this.archivingService.archiveRelease(releaseId);
        } else {
            this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deleteRelease(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
            this.releaseRepository.delete(releaseId);
        }
    }

    private void mergeTeams(String folderId, String templateId, Seq<Team> templateTeams) {
        block0: {
            if (!templateTeams.nonEmpty()) break block0;
            Buffer folderTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(folderId)).asScala();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable & scala.Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> folderId);
            Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teamService.saveTeamsToPlatform(folderTeamsContainerId, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(mergedTeams).asJava());
            this.teamService.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teamService.deleteTeamsFromPlatform(templateId);
    }

    private Seq<Team> mergeTemplateAndFolderTeams(Seq<Team> folderTeams, Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((TraversableOnce)folderTeams.map((Function1 & Serializable & scala.Serializable)team -> new Tuple2((Object)team.getTeamName(), team), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).toSeq());
        templateTeams.foreach((Function1 & Serializable & scala.Serializable)templateTeam -> {
            MapLike mapLike;
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                mapLike = folderTeamsMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                scala.collection.immutable.Set memberSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getMembers()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getMembers()).asScala()).toSet());
                scala.collection.immutable.Set roleSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getRoles()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getRoles()).asScala()).toSet());
                scala.collection.immutable.Set permissionSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getPermissions()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getPermissions()).asScala()).toSet());
                folderTeam.setMembers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(memberSet.toSeq()).asJava());
                folderTeam.setRoles((List)JavaConverters$.MODULE$.seqAsJavaListConverter(roleSet.toSeq()).asJava());
                folderTeam.setPermissions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(permissionSet.toSeq()).asJava());
                mapLike = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return mapLike;
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releaseRepository.findById(templateId, null);
        template.getAllTasks().forEach(task -> $this.taskService.applyNewTeam(null, (Task)task, false));
    }

    private void createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(XLReleasePermissions.getFolderPermissions()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$createDefaultTeamsForTheFolder$1(x$1)))).asJava());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getReleaseGroupPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDashboardPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.setPermissions(XLReleasePermissions.getReleasePermissions());
        releaseAdmin.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        this.teamService.saveTeamsToPlatform(folder.getId(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{folderOwner, templateOwner, releaseAdmin}))).asJava());
    }

    public scala.collection.mutable.Set<BaseConfiguration> getNonInheritedFolderReferences(String folderId, String newfolderId) {
        Page x$10 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0));
        ReleaseStatus[] x$11 = (ReleaseStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ReleaseStatus.class));
        Right<String, String> x$12 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$13 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$14 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$15 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        scala.collection.mutable.Seq releases = (scala.collection.mutable.Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$10, (Either<String, String>)x$12, x$11, x$13, x$14, x$15))).asScala();
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        releases.foreach((Function1 & Serializable & scala.Serializable)release -> {
            FolderService.$anonfun$getNonInheritedFolderReferences$1(this, folderId, newfolderId, res, release);
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private void checkFolderCanBeMoved(String folderId, Option<String> newfolderIdOption, String operation) {
        scala.collection.mutable.Set<BaseConfiguration> set;
        Seq<Release> activeReleases = this.getRunningReleases(folderId);
        Seq<ReleaseTrigger> enabledTriggers = this.getEnabledTriggers(folderId);
        Seq<Release> autoStartPendingReleases = this.getAutoStartPendingReleases(folderId);
        Option<String> option = newfolderIdOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            String newFolderId = (String)some.value();
            set = this.getNonInheritedFolderReferences(folderId, newFolderId);
        } else if (None$.MODULE$.equals(option)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.mutable.Set<BaseConfiguration> invalidRefs = set;
        if (activeReleases.nonEmpty() || enabledTriggers.nonEmpty() || autoStartPendingReleases.nonEmpty() || invalidRefs.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to ", " folder ", ", which has active releases ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation, folderId, ((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or enabled triggers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or pending releases with auto start option enabled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
            String details = this.createDetails(activeReleases, enabledTriggers, autoStartPendingReleases, (Set<BaseConfiguration>)invalidRefs);
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You cannot ", " this folder. The folder or its subfolders contain ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation, details})), new Object[0]);
        }
    }

    private String createDetails(Seq<Release> activeReleases, Seq<ReleaseTrigger> enabledTriggers, Seq<Release> autoStartPendingReleases, Set<BaseConfiguration> invalidRefs) {
        String details;
        block3: {
            details = "";
            if (activeReleases.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"active releases: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            if (enabledTriggers.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"releases or template with enabled triggers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)t -> t.getTemplate().getTitle() + "/" + t.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            if (autoStartPendingReleases.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pending releases with auto start: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            if (!invalidRefs.nonEmpty()) break block3;
            details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"configuration references not inherited by the destination folder: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)invalidRefs.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getTitle(), Set$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
        }
        return details;
    }

    private void checkTemplateCanBeMoved(String templateId, String folderId) {
        Buffer enabledTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseTriggersRepository.findEnabledReleaseTriggers(templateId)).asScala();
        if (enabledTriggers.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to move template ", " with enabled triggers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{templateId, enabledTriggers})));
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You can't move this template because it has one or more enabled triggers: "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{enabledTriggers.mkString(", ")})), new Object[0]);
        }
        Release template = this.releaseRepository.findById(templateId);
        scala.collection.mutable.Set refs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(CiHelper.getExternalReferences((ConfigurationItem)template)).asScala();
        if (!((IterableLike)((SetLike)refs.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$2(c)))).map((Function1 & Serializable & scala.Serializable)c -> $this.configurationRepository.read(c.getId()), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$4(folderId, c)))) {
            throw new ItemInUseException("You cannot move this template. It contains references to configurations that are not global or not inherited by the destination folder.", new Object[0]);
        }
    }

    private Seq<Release> getRunningReleases(String folderId) {
        Page x$16 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$17 = ReleaseStatus.ACTIVE_STATUSES;
        Right<String, String> x$18 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$19 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$20 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$21 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$16, (Either<String, String>)x$18, x$17, x$19, x$20, x$21))).asScala();
    }

    private Seq<ReleaseTrigger> getEnabledTriggers(String ancestorId) {
        Page x$22 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(2));
        ReleaseStatus[] x$23 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE});
        Right<String, String> x$24 = ReleaseSearchByParams$.MODULE$.byAncestor(ancestorId);
        String x$25 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$26 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$27 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$22, (Either<String, String>)x$24, x$23, x$25, x$26, x$27))).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$8.getReleaseTriggers()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isEnabled()));
    }

    private Seq<Release> getAutoStartPendingReleases(String folderId) {
        Page x$28 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$29 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED});
        Right<String, String> x$30 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        boolean x$31 = true;
        String x$32 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$33 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$28, (Either<String, String>)x$30, x$29, x$32, x$33, x$31))).asScala();
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public static final /* synthetic */ boolean $anonfun$createDefaultTeamsForTheFolder$1(String x$1) {
        String string = x$1;
        String string2 = XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getNonInheritedFolderReferences$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ void $anonfun$getNonInheritedFolderReferences$1(FolderService $this, String folderId$8, String newfolderId$1, scala.collection.mutable.Set res$1, Release release) {
        scala.collection.mutable.Set refs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(CiHelper.getExternalReferences((ConfigurationItem)release)).asScala();
        ((IterableLike)((SetLike)refs.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$getNonInheritedFolderReferences$2(c)))).map((Function1 & Serializable & scala.Serializable)c -> $this.configurationRepository.read(c.getId()), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)c -> c.getFolderId() != null && !newfolderId$1.startsWith(c.getFolderId()) && !c.getFolderId().equals(folderId$8) ? BoxesRunTime.boxToBoolean((boolean)res$1.add(c)) : BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$4(String folderId$5, BaseConfiguration c) {
        return c.getFolderId() == null || folderId$5.startsWith(c.getFolderId());
    }

    public FolderService(FolderRepository folders, TeamService teamService, ReleaseRepository releaseRepository, TaskService taskService, ConfigurationRepository configurationRepository, CiIdService ciIdService, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus, ReleaseTriggerRepository releaseTriggersRepository, ArchivingService archivingService) {
        this.folders = folders;
        this.teamService = teamService;
        this.releaseRepository = releaseRepository;
        this.taskService = taskService;
        this.configurationRepository = configurationRepository;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        this.releaseTriggersRepository = releaseTriggersRepository;
        this.archivingService = archivingService;
        Logging.$init$((Logging)this);
    }
}

