/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.AdaptiveReleaseId;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0001\u0011}r!\u0002\u001c8\u0011\u0003\u0001e!\u0002\"8\u0011\u0003\u0019\u0005\"\u0002*\u0002\t\u0003\u0019\u0006\"\u0002+\u0002\t\u0003)\u0006\"\u0002:\u0002\t\u0003\u0019h!\u0002\"8\u0001\u0005\u0005\u0001BCA\u0002\u000b\t\u0015\r\u0011\"\u0001\u0002\u0006!Q\u00111C\u0003\u0003\u0002\u0003\u0006I!a\u0002\t\u0015\u0005UQA!A!\u0002\u0013\t9\u0002\u0003\u0006\u0002\u001e\u0015\u0011\t\u0011)A\u0005\u0003?A\u0011\"!\n\u0006\u0005\u0003\u0005\u000b\u0011B6\t\u0015\u0005\u001dRA!A!\u0002\u0013\tI\u0003\u0003\u0006\u00020\u0015\u0011\t\u0011)A\u0005\u0003cA!\"a\u000f\u0006\u0005\u0003\u0005\u000b\u0011BA\u001f\u0011)\t\u0019%\u0002B\u0001B\u0003%\u0011Q\t\u0005\u000b\u0003#*!\u0011!Q\u0001\n\u0005M\u0003BCA-\u000b\t\u0005\t\u0015!\u0003\u0002\\!Q\u0011\u0011M\u0003\u0003\u0002\u0003\u0006I!a\u0019\t\u0015\u0005%TA!A!\u0002\u0013\tY\u0007\u0003\u0004S\u000b\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003O+A\u0011AAU\u0011\u001d\tI-\u0002C\u0005\u0003\u0017Dq!!5\u0006\t\u0013\t\u0019\u000eC\u0004\u0002X\u0016!\t!!7\t\u000f\u0005}W\u0001\"\u0001\u0002b\"9\u0011q\\\u0003\u0005\u0002\u0005\u0015\bbBA{\u000b\u0011\u0005\u0011q\u001f\u0005\b\u0003{,A\u0011AA\u0000\u0011\u001d\u0011i!\u0002C\u0001\u0005\u001fAqA!\b\u0006\t\u0003\u0011y\u0002C\u0004\u00034\u0015!\tA!\u000e\t\u000f\tuR\u0001\"\u0001\u0003@!9!QI\u0003\u0005\u0002\t\u001d\u0003b\u0002B(\u000b\u0011\u0005!\u0011\u000b\u0005\b\u0005/*A\u0011\u0001B-\u0011\u001d\u0011\t'\u0002C\u0001\u0005GBqAa\u001c\u0006\t\u0003\u0011\t\bC\u0004\u0003~\u0015!\tAa \t\u000f\tuT\u0001\"\u0001\u0003,\"9!qX\u0003\u0005\u0002\t\u0005\u0007\"CB\u000b\u000bE\u0005I\u0011AB\f\u0011%\u0019Y#BI\u0001\n\u0003\u00199\u0002C\u0004\u0004.\u0015!\taa\f\t\u000f\r5S\u0001\"\u0001\u0004P!91QK\u0003\u0005\u0002\r]\u0003bBB<\u000b\u0011\u00051\u0011\u0010\u0005\b\u0007\u007f*A\u0011ABA\u0011\u001d\u0011i(\u0002C\u0005\u0007\u001fCqaa&\u0006\t\u0003\u0019I\nC\u0004\u0004\"\u0016!Iaa)\t\u0013\r-V!%A\u0005\n\r5\u0006bBBY\u000b\u0011%11\u0017\u0005\b\u0007C,A\u0011BBr\u0011\u001d\u0019I/\u0002C\u0005\u0007W\f\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u000b\u0005aJ\u0014aB:feZL7-\u001a\u0006\u0003um\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005qj\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005q\u0014aA2p[\u000e\u0001\u0001CA!\u0002\u001b\u00059$\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f'\r\tAI\u0013\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015!B:mMRR'\"A(\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0015'\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001Q\u0001\u001bI\u0016\u001cXM]5bY&TX-\u0011:dQ&4X\r\u001a*fY\u0016\f7/\u001a\u000b\u0004-rK\u0007CA,[\u001b\u0005A&BA-:\u0003\u0019!w.\\1j]&\u00111\f\u0017\u0002\b%\u0016dW-Y:f\u0011\u0015i6\u00011\u0001_\u0003-\u0011X\r\\3bg\u0016T5o\u001c8\u0011\u0005}3gB\u00011e!\t\tg)D\u0001c\u0015\t\u0019w(\u0001\u0004=e>|GOP\u0005\u0003K\u001a\u000ba\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011QM\u0012\u0005\u0006U\u000e\u0001\ra[\u0001\u000be\u0016\u0004xn]5u_JL\bC\u00017q\u001b\u0005i'B\u00016o\u0015\ty7(\u0001\u0005eKBdw._5u\u0013\t\tXNA\tSKB|7/\u001b;pef\fE-\u00199uKJ\fAbZ3u\u001b>tG\u000f[-fCJ$\"A\u0018;\t\u000bU$\u0001\u0019\u0001<\u0002\u0013M$\u0018M\u001d;ECR,\u0007CA<\u007f\u001b\u0005A(BA={\u0003\u0011!\u0018.\\3\u000b\u0005md\u0018\u0001\u00026pI\u0006T\u0011!`\u0001\u0004_J<\u0017BA@y\u0005!!\u0015\r^3US6,7cA\u0003E\u0015\u0006\u0001\u0012M]2iSZ,GMU3mK\u0006\u001cXm]\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bI\u0014A\u00013c\u0013\u0011\t\t\"a\u0003\u0003!\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\u0018!E1sG\"Lg/\u001a3SK2,\u0017m]3tA\u00051\u0012M]2iSZ,GMU3mK\u0006\u001cXm]*fCJ\u001c\u0007\u000e\u0005\u0003\u0002\n\u0005e\u0011\u0002BA\u000e\u0003\u0017\u0011a#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:TK\u0006\u00148\r[\u0001\u001fCJ\u001c\u0007.\u001b<fI\u0006\u001bG/\u001b<jifdunZ:TKJL\u0017\r\\5{KJ\u00042!QA\u0011\u0013\r\t\u0019c\u000e\u0002\u001f\u0003J\u001c\u0007.\u001b<fI\u0006\u001bG/\u001b<jifdunZ:TKJL\u0017\r\\5{KJ\f\u0011C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003y\u0019w.\u001c9mKR,GMU3mK\u0006\u001cXm]#ya>\u0014HoU3sm&\u001cW\rE\u0002B\u0003WI1!!\f8\u0005u\u0019u.\u001c9mKR,GMU3mK\u0006\u001cX-\u0012=q_J$8+\u001a:wS\u000e,\u0017!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB!\u00111GA\u001c\u001b\t\t)D\u0003\u0002ks%!\u0011\u0011HA\u001b\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0015I\u0016\u0004XM\u001c3f]\u000eL(+\u001a9pg&$xN]=\u0011\t\u0005M\u0012qH\u0005\u0005\u0003\u0003\n)D\u0001\u000bEKB,g\u000eZ3oGf\u0014V\r]8tSR|'/_\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J\u001d\u0002\r\u0005\u001cGo\u001c:t\u0013\u0011\ty%!\u0013\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002\u001dQ,\u0017-\u001c*fa>\u001c\u0018\u000e^8ssB!\u00111GA+\u0013\u0011\t9&!\u000e\u0003\u001dQ+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\u0006Q1/Z2ve\u0016$7)[:\u0011\t\u0005M\u0012QL\u0005\u0005\u0003?\n)D\u0001\u0006TK\u000e,(/\u001a3DSN\f1D]3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\b\u0003BA\u001a\u0003KJA!a\u001a\u00026\tY\"+\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef\fabY8n[\u0016tGoU3sm&\u001cW\rE\u0002B\u0003[J1!a\u001c8\u00059\u0019u.\\7f]R\u001cVM\u001d<jG\u0016$\"$a\u001d\u0002v\u0005]\u0014\u0011PA>\u0003{\ny(!!\u0002\u0004\u0006\u0015\u0015qQAE\u0003\u0017\u0003\"!Q\u0003\t\u000f\u0005\r1\u00031\u0001\u0002\b!9\u0011QC\nA\u0002\u0005]\u0001bBA\u000f'\u0001\u0007\u0011q\u0004\u0005\u0007\u0003K\u0019\u0002\u0019A6\t\u000f\u0005\u001d2\u00031\u0001\u0002*!9\u0011qF\nA\u0002\u0005E\u0002bBA\u001e'\u0001\u0007\u0011Q\b\u0005\b\u0003\u0007\u001a\u0002\u0019AA#\u0011\u001d\t\tf\u0005a\u0001\u0003'Bq!!\u0017\u0014\u0001\u0004\tY\u0006C\u0004\u0002bM\u0001\r!a\u0019\t\u000f\u0005%4\u00031\u0001\u0002l!\u001a1#a$\u0011\t\u0005E\u00151U\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005e\u00151T\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\ti*a(\u0002\u000b\t,\u0017M\\:\u000b\u0007\u0005\u0005F0A\btaJLgn\u001a4sC6,wo\u001c:l\u0013\u0011\t)+a%\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AD1sG\"Lg/\u001a*fY\u0016\f7/\u001a\u000b\u0005\u0003W\u000b\t\fE\u0002F\u0003[K1!a,G\u0005\u0011)f.\u001b;\t\r\u0005MF\u00031\u0001_\u0003%\u0011X\r\\3bg\u0016LE\rK\u0002\u0015\u0003o\u0003B!!/\u0002F6\u0011\u00111\u0018\u0006\u0005\u0003+\u000biL\u0003\u0003\u0002@\u0006\u0005\u0017aB7fiJL7m\u001d\u0006\u0004\u0003\u0007l\u0014\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005\u001d\u00171\u0018\u0002\u0006)&lW\rZ\u0001\u0013CJ\u001c\u0007.\u001b<f\u0003R$\u0018m\u00195nK:$8\u000f\u0006\u0003\u0002,\u00065\u0007BBAh+\u0001\u0007a+A\u0004sK2,\u0017m]3\u0002'\u0005\u00148\r[5wK\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\u0005-\u0016Q\u001b\u0005\u0007\u0003\u001f4\u0002\u0019\u0001,\u0002#A\u0014X-\u0011:dQ&4XMU3mK\u0006\u001cX\r\u0006\u0003\u0002,\u0006m\u0007BBAh/\u0001\u0007a\u000bK\u0002\u0018\u0003o\u000b!bZ3u%\u0016dW-Y:f)\r1\u00161\u001d\u0005\u0007\u0003gC\u0002\u0019\u00010\u0015\u000bY\u000b9/!;\t\r\u0005M\u0016\u00041\u0001_\u0011\u001d\tY/\u0007a\u0001\u0003[\f!#\u001b8dYV$W\r\u0015:f\u0003J\u001c\u0007.\u001b<fIB\u0019Q)a<\n\u0007\u0005EhIA\u0004C_>dW-\u00198)\u0007e\t9,A\bhKR\u0014V\r\\3bg\u0016$\u0016\u000e\u001e7f)\rq\u0016\u0011 \u0005\u0007\u0003gS\u0002\u0019\u00010)\u0007i\t9,\u0001\u0005hKR\u0004\u0006.Y:f)\u0011\u0011\tAa\u0002\u0011\u0007]\u0013\u0019!C\u0002\u0003\u0006a\u0013Q\u0001\u00155bg\u0016DaA!\u0003\u001c\u0001\u0004q\u0016a\u00029iCN,\u0017\n\u001a\u0015\u00047\u0005]\u0016aB4fiR\u000b7o\u001b\u000b\u0005\u0005#\u00119\u0002E\u0002X\u0005'I1A!\u0006Y\u0005\u0011!\u0016m]6\t\r\teA\u00041\u0001_\u0003\u0019!\u0018m]6JI\"\u001aA$a.\u0002\u0017\u001d,GOV1sS\u0006\u0014G.\u001a\u000b\u0005\u0005C\u0011i\u0003\u0005\u0003\u0003$\t%RB\u0001B\u0013\u0015\r\u00119\u0003W\u0001\nm\u0006\u0014\u0018.\u00192mKNLAAa\u000b\u0003&\tAa+\u0019:jC\ndW\r\u0003\u0004\u00030u\u0001\rAX\u0001\u000bm\u0006\u0014\u0018.\u00192mK&#\u0007fA\u000f\u00028\u00061Q\r_5tiN$B!!<\u00038!1!\u0011\b\u0010A\u0002y\u000bAaY5JI\"\u001aa$a.\u0002#\u0015D\u0018n\u001d;t!J,\u0017I]2iSZ,G\r\u0006\u0003\u0002n\n\u0005\u0003B\u0002B\u001d?\u0001\u0007a\fK\u0002 \u0003o\u000bA\"\u001a=jgR\u001c()\u001f(b[\u0016$B!!<\u0003J!1!1\n\u0011A\u0002y\u000b1B]3mK\u0006\u001cXMT1nK\"\u001a\u0001%a.\u0002!\rDWmY6O_R\f%o\u00195jm\u0016$G\u0003BAV\u0005'BaA!\u000f\"\u0001\u0004q\u0006fA\u0011\u00028\u0006\u0001\u0012\r\u001e;bG\"lWM\u001c;Fq&\u001cHo\u001d\u000b\u0005\u0003[\u0014Y\u0006\u0003\u0004\u0003^\t\u0002\rAX\u0001\rCR$\u0018m\u00195nK:$\u0018\n\u001a\u0015\u0004E\u0005]\u0016!D4fi\u0006#H/Y2i[\u0016tG\u000f\u0006\u0003\u0003f\t-\u0004cA,\u0003h%\u0019!\u0011\u000e-\u0003\u0015\u0005#H/Y2i[\u0016tG\u000f\u0003\u0004\u0003^\r\u0002\rA\u0018\u0015\u0004G\u0005]\u0016aE4fi\u0006#H/Y2i[\u0016tGo\u00149uS>tG\u0003\u0002B:\u0005s\u0002R!\u0012B;\u0005KJ1Aa\u001eG\u0005\u0019y\u0005\u000f^5p]\"1!Q\f\u0013A\u0002yC3\u0001JA\\\u00039\u0019X-\u0019:dQJ+G.Z1tKN$BA!!\u0003\u0012B)!1\u0011BG-6\u0011!Q\u0011\u0006\u0005\u0005\u000f\u0013I)\u0001\u0003vi&d'B\u0001BF\u0003\u0011Q\u0017M^1\n\t\t=%Q\u0011\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0003\u0014\u0016\u0002\rA!&\u0002\u000f\u0019LG\u000e^3sgB!!q\u0013BS\u001b\t\u0011IJ\u0003\u0003\u0003\u001c\nu\u0015!\u00024pe6\u001c(\u0002\u0002BP\u0005C\u000b!A^\u0019\u000b\u0007\t\r\u0016(A\u0002ba&LAAa*\u0003\u001a\ny!+\u001a7fCN,7OR5mi\u0016\u00148\u000fK\u0002&\u0003o#\u0002B!!\u0003.\n=&\u0011\u0018\u0005\b\u0005'3\u0003\u0019\u0001BK\u0011\u001d\u0011\tL\na\u0001\u0005g\u000bQ\u0001\\5nSR\u00042!\u0012B[\u0013\r\u00119L\u0012\u0002\u0005\u0019>tw\rC\u0004\u0003<\u001a\u0002\rAa-\u0002\r=4gm]3uQ\r1\u0013qW\u00013M&tGm\u00155peR\u0014V\r\\3bg\u0016LEm],ji\"4u\u000e\u001c3fe:\u000bW.Z!oI>\u0013H-\u001a:De&$XM]5p]RQ!1\u0019Bv\u0007\u0003\u0019ia!\u0005\u0011\r\t\u0015'q\u001aBj\u001d\u0011\u00119Ma3\u000f\u0007\u0005\u0014I-C\u0001H\u0013\r\u0011iMR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yI!5\u000b\u0007\t5g\tE\u0004F\u0005+\u0014IN!:\n\u0007\t]gI\u0001\u0004UkBdWM\r\t\u0005\u00057\u0014\t/\u0004\u0002\u0003^*\u0019!q\u001c-\u0002\u000bU$\u0018\u000e\\:\n\t\t\r(Q\u001c\u0002\u0012\u0003\u0012\f\u0007\u000f^5wKJ+G.Z1tK&#\u0007cA#\u0003h&\u0019!\u0011\u001e$\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003\u0014\u001e\u0002\rA!<\u0011\r\t\u0015'q\u001eBz\u0013\u0011\u0011\tP!5\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003v\nuXB\u0001B|\u0015\u0011\u0011\u0019J!?\u000b\u0007\tm\u0018(A\u0004sKB|'\u000f^:\n\t\t}(q\u001f\u0002\r%\u0016\u0004xN\u001d;GS2$XM\u001d\u0005\b\u0007\u00079\u0003\u0019AB\u0003\u0003\u0015y'\u000fZ3s!\u0015)%QOB\u0004!\u0011\u00119j!\u0003\n\t\r-!\u0011\u0014\u0002\u0011%\u0016dW-Y:f\u001fJ$WM]'pI\u0016D\u0011B!-(!\u0003\u0005\raa\u0004\u0011\u000b\u0015\u0013)Ha-\t\u0013\tmv\u0005%AA\u0002\r=\u0001fA\u0014\u00028\u0006ad-\u001b8e'\"|'\u000f\u001e*fY\u0016\f7/Z%eg^KG\u000f\u001b$pY\u0012,'OT1nK\u0006sGm\u0014:eKJ\u001c%/\u001b;fe&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019IB\u000b\u0003\u0004\u0010\rm1FAB\u000f!\u0011\u0019yba\n\u000e\u0005\r\u0005\"\u0002BB\u0012\u0007K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Ue)\u0003\u0003\u0004*\r\u0005\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006ad-\u001b8e'\"|'\u000f\u001e*fY\u0016\f7/Z%eg^KG\u000f\u001b$pY\u0012,'OT1nK\u0006sGm\u0014:eKJ\u001c%/\u001b;fe&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0003U\u0019w.\u001e8u%\u0016dW-Y:fg\nK8\u000b^1ukN$Ba!\r\u0004JA9qla\r\u00048\r\r\u0013bAB\u001bQ\n\u0019Q*\u00199\u0011\t\re2qH\u0007\u0003\u0007wQ1a!\u0010Y\u0003\u0019\u0019H/\u0019;vg&!1\u0011IB\u001e\u00055\u0011V\r\\3bg\u0016\u001cF/\u0019;vgB\u0019Qi!\u0012\n\u0007\r\u001dcIA\u0002J]RDqAa%+\u0001\u0004\u0011)\nK\u0002+\u0003o\u000bQbY8v]R\u0014V\r\\3bg\u0016\u001cH\u0003BB\u0019\u0007#BqAa%,\u0001\u0004\u0011i\u000fK\u0002,\u0003o\u000b\u0001DZ5oI\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u0019Ifa\u0017\u0004fA)!Q\u0019Bx=\"91Q\f\u0017A\u0002\r}\u0013\u0001\u00023bi\u0016\u0004BAa!\u0004b%!11\rBC\u0005\u0011!\u0015\r^3\t\u000f\r\u001dD\u00061\u0001\u0004j\u0005A\u0001/Y4f'&TX\r\u0005\u0003\u0004l\rETBAB7\u0015\u0011\u0019yG!#\u0002\t1\fgnZ\u0005\u0005\u0007g\u001aiGA\u0004J]R,w-\u001a:)\u00071\n9,\u0001\u0010be\u000eD\u0017N^3BY2LenY8nS:<G)\u001a9f]\u0012,gnY5fgR!\u00111VB>\u0011\u0019\t\u0019,\fa\u0001=\"\u001aQ&a.\u0002\u0015\u001d,G/\u00117m)\u0006<7\u000f\u0006\u0003\u0004\u0004\u000e%\u0005#\u0002BB\u0007\u000bs\u0016\u0002BBD\u0005\u000b\u00131aU3u\u0011\u001d\u0019YI\fa\u0001\u0007\u0007\n1\u0002\\5nSRtU/\u001c2fe\"\u001aa&a.\u0015\u0011\t\u00055\u0011SBJ\u0007+CqAa%0\u0001\u0004\u0011)\nC\u0004\u00032>\u0002\raa\u0004\t\u000f\tmv\u00061\u0001\u0004\u0010\u0005Q2/Z1sG\"\u0014V\r\\3bg\u0016\u001c()\u001f*fY\u0016\f7/Z%egR!11TBO!\u0015\u0011)Ma<W\u0011\u001d\u0019y\n\ra\u0001\u00073\n!B]3mK\u0006\u001cX-\u00133t\u0003A9W\r\u001e*fY\u0016\f7/Z(qi&|g\u000e\u0006\u0004\u0004&\u000e\u001d6\u0011\u0016\t\u0005\u000b\nUd\u000b\u0003\u0004\u00024F\u0002\rA\u0018\u0005\n\u0003W\f\u0004\u0013!a\u0001\u0003[\f!dZ3u%\u0016dW-Y:f\u001fB$\u0018n\u001c8%I\u00164\u0017-\u001e7uII*\"aa,+\t\u0005581D\u0001\u000fO\u0016$(+\u001a7fCN,\u0017\n^3n+\u0011\u0019)la0\u0015\t\r]6Q\u001c\u000b\u0005\u0007s\u001b\t\u000eE\u0003F\u0005k\u001aY\f\u0005\u0003\u0004>\u000e}F\u0002\u0001\u0003\b\u0007\u0003\u001c$\u0019ABb\u0005\u0005!\u0016\u0003BBc\u0007\u0017\u00042!RBd\u0013\r\u0019IM\u0012\u0002\b\u001d>$\b.\u001b8h!\r96QZ\u0005\u0004\u0007\u001fD&\u0001\u0003)mC:LE/Z7\t\u000f\rM7\u00071\u0001\u0004V\u00069q-\u001a;Ji\u0016l\u0007CB#\u0004XZ\u001bY.C\u0002\u0004Z\u001a\u0013\u0011BR;oGRLwN\\\u0019\u0011\r\u0015\u001b9NXB^\u0011\u0019\u0019yn\ra\u0001=\u00061\u0011\u000e^3n\u0013\u0012\f\u0011cZ3u-\u0006\u0014\u0018.\u00192mK>\u0003H/[8o)\u0011\u0019)oa:\u0011\u000b\u0015\u0013)H!\t\t\r\t=B\u00071\u0001_\u0003y\t'o\u00195jm\u0016\fE\u000e\\(vi\u001e|\u0017N\\4EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0004n\u000eU\bC\u0002Bc\u0005_\u001cy\u000fE\u0002X\u0007cL1aa=Y\u0005)!U\r]3oI\u0016t7-\u001f\u0005\u0007\u0003\u001f,\u0004\u0019\u0001,)'\u0015\u0019I\u0010b\u0002\u0005\n\u00115Aq\u0002C\r\t7!)\u0003b\n\u0011\t\rmH1A\u0007\u0003\u0007{TA!!&\u0004\u0000*!A\u0011AAP\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0011\u00151Q \u0002\u000e)J\fgn]1di&|g.\u00197\u0002\u000bY\fG.^3\"\u0005\u0011-\u0011a\u0007:fa>\u0014H/\u001b8h)J\fgn]1di&|g.T1oC\u001e,'/A\u0006qe>\u0004\u0018mZ1uS>tGE\u0001C\t\u0013\u0011!\u0019\u0002\"\u0006\u0002\u0011I+\u0015+V%S\u000b\u0012SA\u0001b\u0006\u0004~\u0006Y\u0001K]8qC\u001e\fG/[8o\u0003%I7o\u001c7bi&|g\u000e\n\u0002\u0005\u001e%!Aq\u0004C\u0011\u00039\u0011V)\u0011#`\u0007>kU*\u0013+U\u000b\u0012SA\u0001b\t\u0004~\u0006I\u0011j]8mCRLwN\\\u0001\fe>dGNY1dW\u001a{'\u000f\f\u0002\u0005*\r\u0012A1\u0006\t\u0005\u0005\u000b$i#\u0003\u0003\u00050\tE'!\u0003+ie><\u0018M\u00197fQ\r)A1\u0007\t\u0005\tk!Y$\u0004\u0002\u00058)!A\u0011HAP\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\t{!9DA\u0004TKJ4\u0018nY3")
public class ArchivingService
implements Logging {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentService commentService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String getMonthYear(DateTime dateTime) {
        return ArchivingService$.MODULE$.getMonthYear(dateTime);
    }

    public static Release deserializeArchivedRelease(String string, RepositoryAdapter repositoryAdapter) {
        return ArchivingService$.MODULE$.deserializeArchivedRelease(string, repositoryAdapter);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Timed
    public void archiveRelease(String releaseId) {
        Release release = (Release)this.repositoryAdapter.read(releaseId);
        if (release == null) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Release '").append(releaseId).append("' cannot be read from active database, not archiving.").toString());
            if (!this.releaseRepository.exists(releaseId) && this.existsPreArchived(releaseId)) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Setting Release '").append(releaseId).append("' preArchived flag to false as it is no longer in the active database.").toString());
                this.archivedReleases().setPreArchived(releaseId, false);
            }
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES)).contains((Object)release.getStatus())) {
            if (this.existsPreArchived(releaseId)) {
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Archiving dependencies for '").append(releaseId).append("'").toString());
                this.releaseExtensionsRepository.decorate(release);
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
                    this.commentService.decorate(task);
                    return BoxedUnit.UNIT;
                });
                java.util.List<Team> updatedTeams = this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
                release.setTeams(updatedTeams);
                if (!release.isTutorial()) {
                    this.archiveAttachments(release);
                }
                this.archiveDependencies(release);
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Updating activity logs and releaseJson for '").append(releaseId).append("'").toString());
                String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
                String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
                if (!this.archivedReleases().update(releaseId, serializedRelease, activityLogsJson, false)) {
                    this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Could not update archived Release '").append(releaseId).append("'.").toString());
                } else {
                    this.archivedReleases().updateViewers(releaseId, (Seq<Team>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(updatedTeams).asScala()));
                }
                if (this.releaseRepository.exists(releaseId)) {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Deleting '").append(releaseId).append("' from active database").toString());
                    this.releaseRepository.delete(releaseId);
                }
            } else if (!release.isTutorial()) {
                throw new IllegalStateException("Only pre-archived releases can be archived");
            }
        } else {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Trying to pre-archive a release with invalid status ").append(release.getStatus()).toString());
            throw new IllegalStateException("Only inactive releases can be archived");
        }
    }

    private void archiveAttachments(Release release) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Archiving attachments for '").append(release.getId()).append("'").toString());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAttachments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)attachment -> {
            ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
            return BoxedUnit.UNIT;
        });
    }

    private void archiveDependencies(Release release) {
        Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append(release).append(" is already pre-archived, nothing to do").toString());
        } else {
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            if (!release.isTutorial()) {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("copying release ").append(release).append(" to archive database, marked as pre-archived").toString());
                this.archivedReleases().insert(release, serializedRelease, "", true);
                this.releaseRepository.setPreArchived(release.getId(), true);
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Running release ").append(release.getId()).append(" through export hooks").toString());
            } else {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Deleting tutorial release ").append(release).append(" instead of pre-archiving").toString());
                this.releaseRepository.delete(release.getId());
            }
            this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
        }
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable & scala.Serializable)x$12 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$12.getPhase(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)phaseId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable & scala.Serializable)x$2 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$2.getTask(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)taskId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)variableId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable & scala.Serializable)x$3 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$3.getPhase(x$1)).isDefined() : (Ids.isTaskId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable & scala.Serializable)x$4 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$4.getTask(x$1)).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().existsPreArchived(ciId) : false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases().exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringBuilder(56).append("You cannot perform this operation on archived release [").append(Ids.releaseIdFrom((String)ciId)).append("]").toString(), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(37).append("Could not find archived attachment [").append(attachmentId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable & scala.Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable & scala.Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public List<Tuple2<AdaptiveReleaseId, Object>> findShortReleaseIdsWithFolderNameAndOrderCriterion(Seq<ReportFilter> filters, Option<ReleaseOrderMode> order, Option<Object> limit, Option<Object> offset) {
        return this.archivedReleasesSearch.searchReleaseIdsAndOrderCriterion(filters, order, limit, offset);
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$4() {
        return None$.MODULE$;
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleases(Seq<ReportFilter> filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (Seq<String>)((Seq)Seq$.MODULE$.empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable & scala.Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter), List$.MODULE$.canBuildFrom())).asJava();
    }

    public Seq<Release> searchReleasesByReleaseIds(Seq<String> releaseIds) {
        Seq<String> releaseJsons = this.archivedReleasesSearch.searchReleasesByIds(releaseIds);
        return (Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter), Seq$.MODULE$.canBuildFrom());
    }

    private Option<Release> getReleaseOption(String releaseId, boolean includePreArchived) {
        return this.archivedReleases().getRelease(releaseId, includePreArchived).map((Function1 & Serializable & scala.Serializable)releaseJson -> {
            void var3_3;
            Release release = ArchivingService$.MODULE$.deserializeArchivedRelease((String)releaseJson, $this.repositoryAdapter);
            Map<String, String> attachmentsFileNames = this.archivedReleases().getAttachmentsFileNames(release.getId());
            release.getAttachments().forEach(attachment -> {
                Option option = attachmentsFileNames.get((Object)ArchivedReleases$.MODULE$.shortenId(attachment.getId()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String filename = (String)some.value();
                    attachment.setFile((OverthereFile)SourceArtifactFile.withNullableWorkDir((String)filename, (SourceArtifact)attachment, null));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Could not find attachment ").append(attachment.getId()).append(" of release ").append(releaseId).append(" in the attachments table").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            });
            return var3_3;
        });
    }

    private boolean getReleaseOption$default$2() {
        return false;
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)release -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$6))));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        void var2_2;
        Buffer dependencies = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$8)));
        dependencies.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.archive();
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$2, Attachment attachment$1, WorkDir workDir$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$2.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
            workDir$1.delete();
            WorkDirContext.clear();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$2, Attachment attachment) {
        WorkDirContext.initWorkdir();
        WorkDir workDir = WorkDirContext.get();
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable & scala.Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$2, attachment, workDir, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        Seq rawDependenciesToArchive = (Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (Seq<String>)((Seq)rawDependenciesToArchive.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Seq$.MODULE$.canBuildFrom())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$6) {
        String string = x$6.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$8) {
        return !x$8.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentService commentService) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentService = commentService;
        Logging.$init$((Logging)this);
    }
}

