/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\r\u001a\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!AQ\b\u0001B\u0001B\u0003%a\bC\u0003E\u0001\u0011\u0005Q\t\u0003\u0005K\u0001!\u0015\r\u0011\"\u0003L\u0011\u001d1\u0006\u00011A\u0005\n]Cqa\u0017\u0001A\u0002\u0013%A\f\u0003\u0004c\u0001\u0001\u0006K\u0001\u0017\u0005\bG\u0002\u0001\r\u0011\"\u0003X\u0011\u001d!\u0007\u00011A\u0005\n\u0015Daa\u001a\u0001!B\u0013A\u0006\"\u00025\u0001\t\u00039\u0006\"B5\u0001\t\u0003Q\u0007\"B6\u0001\t\u0003a\u0007\"B?\u0001\t\u0003q\bbBA\u0005\u0001\u0011E\u00111\u0002\u0005\n\u0003g\u0001\u0011\u0013!C\t\u0003kAa!!\u0013\u0001\t#Q\u0007bBA&\u0001\u0011%\u0011Q\n\u0005\n\u0003G\u0002\u0011\u0013!C\u0005\u0003KBq!!\u001b\u0001\t\u0013\tY\u0007C\u0004\u0002\f\u0002!I!!$\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\n\t\u0002K]3Be\u000eD\u0017N^3TKJ4\u0018nY3\u000b\u0005iY\u0012aB:feZL7-\u001a\u0006\u00039u\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005yy\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\u0001\u0013aA2p[\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u000bMdg\r\u000e6\u000b\u00039\n\u0001b\u001a:jujdW\rZ\u0005\u0003a-\u0012q\u0001T8hO&tw-\u0001\tbe\u000eD\u0017N^5oON+'O^5dKB\u00111\u0007N\u0007\u00023%\u0011Q'\u0007\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\tA4(D\u0001:\u0015\tQ4$\u0001\u0006sKB|7/\u001b;pefL!\u0001P\u001d\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180A\bbe\u000eD\u0017N^5oO\u000e{gNZ5h!\ty$)D\u0001A\u0015\t\t5$\u0001\u0004d_:4\u0017nZ\u0005\u0003\u0007\u0002\u0013\u0001$\u0011:dQ&4\u0018N\\4TKR$\u0018N\\4t\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q!ai\u0012%J!\t\u0019\u0004\u0001C\u00032\t\u0001\u0007!\u0007C\u00037\t\u0001\u0007q\u0007C\u0003>\t\u0001\u0007a(\u0001\u0003q_>dW#\u0001'\u0011\u00055#V\"\u0001(\u000b\u0005=\u0003\u0016AC2p]\u000e,(O]3oi*\u0011\u0011KU\u0001\u0005kRLGNC\u0001T\u0003\u0011Q\u0017M^1\n\u0005Us%\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u00069QM\\1cY\u0016$W#\u0001-\u0011\u0005\u0011J\u0016B\u0001.&\u0005\u001d\u0011un\u001c7fC:\f1\"\u001a8bE2,Gm\u0018\u0013fcR\u0011Q\f\u0019\t\u0003IyK!aX\u0013\u0003\tUs\u0017\u000e\u001e\u0005\bC\u001e\t\t\u00111\u0001Y\u0003\rAH%M\u0001\tK:\f'\r\\3eA\u0005Q1-\u0019;dQ&tw-\u00169\u0002\u001d\r\fGo\u00195j]\u001e,\u0006o\u0018\u0013fcR\u0011QL\u001a\u0005\bC*\t\t\u00111\u0001Y\u0003-\u0019\u0017\r^2iS:<W\u000b\u001d\u0011\u0002\u0013%\u001cXI\\1cY\u0016$\u0017!B:uCJ$H#A/\u00025A\u0014X-\u0011:dQ&4XmQ8na2,G/\u001a3SK2,\u0017m]3\u0015\u0005uk\u0007\"\u00028\u000f\u0001\u0004y\u0017!B3wK:$\bC\u00019v\u001b\u0005\t(B\u0001:t\u0003\u0019)g/\u001a8ug*\u0011AoG\u0001\u0007I>l\u0017-\u001b8\n\u0005Y\f(!\u0006*fY\u0016\f7/Z\"p[BdW\r^3e\u000bZ,g\u000e\u001e\u0015\u0003\u001da\u0004\"!_>\u000e\u0003iT!A]\u000e\n\u0005qT(!C*vEN\u001c'/\u001b2f\u0003a\u0001(/Z!sG\"Lg/Z!c_J$X\r\u001a*fY\u0016\f7/\u001a\u000b\u0003;~DaA\\\bA\u0002\u0005\u0005\u0001c\u00019\u0002\u0004%\u0019\u0011QA9\u0003'I+G.Z1tK\u0006\u0013wN\u001d;fI\u00163XM\u001c;)\u0005=A\u0018A\u00039sK\u0006\u00138\r[5wKR)Q,!\u0004\u0002\u001a!9\u0011q\u0002\tA\u0002\u0005E\u0011a\u0002:fY\u0016\f7/\u001a\t\u0005\u0003'\t)\"D\u0001t\u0013\r\t9b\u001d\u0002\b%\u0016dW-Y:f\u0011!\tY\u0002\u0005I\u0001\u0002\u0004A\u0016\u0001D2iK\u000e\\WI\\1cY\u0016$\u0007f\u0001\t\u0002 A!\u0011\u0011EA\u0018\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012AC1o]>$\u0018\r^5p]*!\u0011\u0011FA\u0016\u0003\u001diW\r\u001e:jGNT1!!\f \u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\u0019\u0003G\u0011Q\u0001V5nK\u0012\fA\u0003\u001d:f\u0003J\u001c\u0007.\u001b<fI\u0011,g-Y;mi\u0012\u0012TCAA\u001cU\rA\u0016\u0011H\u0016\u0003\u0003w\u0001B!!\u0010\u0002F5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0005v]\u000eDWmY6fI*\u0019\u0011QE\u0013\n\t\u0005\u001d\u0013q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\n9sK\u0006\u00138\r[5wK&s\u0017m\u0019;jm\u0016\u0014V\r\\3bg\u0016\u001c\u0018J\u001c\"bG.<'o\\;oI\u0006Q\u0002O]3Be\u000eD\u0017N^3J]\u0006\u001cG/\u001b<f%\u0016dW-Y:fgR\u0019Q,a\u0014\t\u0013\u0005E3\u0003%AA\u0002\u0005M\u0013\u0001\u00029bO\u0016\u00042\u0001JA+\u0013\r\t9&\n\u0002\u0004\u0013:$\bfA\n\u0002\\A!\u0011QLA0\u001b\t\t\u0019%\u0003\u0003\u0002b\u0005\r#a\u0002;bS2\u0014XmY\u0001%aJ,\u0017I]2iSZ,\u0017J\\1di&4XMU3mK\u0006\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\r\u0016\u0005\u0003'\nI$A\btk\nl\u0017\u000e^,ji\"$U\r\\1z)\u0011\ti'!\u001f\u0015\u0007u\u000by\u0007C\u0004\u0002rU\u0001\r!a\u001d\u0002\u0007)|'\r\u0005\u0003%\u0003kj\u0016bAA<K\tIa)\u001e8di&|g\u000e\r\u0005\b\u0003w*\u0002\u0019AA?\u0003\u0015!W\r\\1z!\u0011\ty(a\"\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0003\u001f\u0016JA!!#\u0002\u0002\nqa)\u001b8ji\u0016$UO]1uS>t\u0017AB:vE6LG/\u0006\u0003\u0002\u0010\u0006eEcA/\u0002\u0012\"9\u0011\u0011\u000f\fA\u0002\u0005M\u0005#\u0002\u0013\u0002v\u0005U\u0005\u0003BAL\u00033c\u0001\u0001B\u0004\u0002\u001cZ\u0011\r!!(\u0003\u0003U\u000bB!a(\u0002&B\u0019A%!)\n\u0007\u0005\rVEA\u0004O_RD\u0017N\\4\u0011\u0007\u0011\n9+C\u0002\u0002*\u0016\u00121!\u00118z\u0003!\u0011XO\u001c8bE2,W\u0003BAX\u0003\u000b$B!!-\u0002>B!\u00111WA]\u001b\t\t)LC\u0002\u00028J\u000bA\u0001\\1oO&!\u00111XA[\u0005!\u0011VO\u001c8bE2,\u0007bBA`/\u0001\u0007\u0011\u0011Y\u0001\u0005E>$\u0017\u0010E\u0003%\u0003k\n\u0019\r\u0005\u0003\u0002\u0018\u0006\u0015GaBAN/\t\u0007\u0011Q\u0014\u0015\u0004\u0001\u0005%\u0007cA=\u0002L&\u0019\u0011Q\u001a>\u0003\u001b\u00153XM\u001c;MSN$XM\\3sQ\r\u0001\u0011\u0011\u001b\t\u0005\u0003'\f\t/\u0004\u0002\u0002V*!\u0011q[Am\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u00037\fi.A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\ty.A\u0002pe\u001eLA!a9\u0002V\n91+\u001a:wS\u000e,\u0007")
public class PreArchiveService
implements Logging {
    private ScheduledExecutorService pool;
    private final ArchivingService archivingService;
    private final ReleaseRepository releaseRepository;
    private final ArchivingSettingsManager archivingConfig;
    private boolean enabled;
    private boolean catchingUp;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private ScheduledExecutorService pool$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if (!this.bitmap$0) {
                this.pool = Executors.newScheduledThreadPool(4, new PrefixedThreadFactory("pre-archiving", Predef$.MODULE$.boolean2Boolean(true)));
                this.bitmap$0 = true;
            }
        }
        return this.pool;
    }

    private ScheduledExecutorService pool() {
        return !this.bitmap$0 ? this.pool$lzycompute() : this.pool;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private boolean catchingUp() {
        return this.catchingUp;
    }

    private void catchingUp_$eq(boolean x$1) {
        this.catchingUp = x$1;
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public void start() {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "PreArchiveService is starting...");
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "Setting preArchivingEnabled callback...");
        this.archivingConfig.subscribeToPreArchivingEnabledChanges(becomesEnabled -> {
            PreArchiveService preArchiveService = this;
            synchronized (preArchiveService) {
                if (Predef$.MODULE$.Boolean2boolean(becomesEnabled)) {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "disabled -> enabled");
                    this.enabled_$eq(true);
                    this.preArchiveInactiveReleasesInBackground();
                } else {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "enabled -> disabled");
                    this.enabled_$eq(false);
                }
            }
        });
        this.enabled_$eq(this.archivingConfig.getPreArchivingEnabled());
        if (this.enabled()) {
            this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
        }
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "PreArchiveService started.");
    }

    @Subscribe
    public void preArchiveCompletedRelease(ReleaseCompletedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2());
    }

    @Subscribe
    public void preArchiveAbortedRelease(ReleaseAbortedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2());
    }

    @Timed
    public void preArchive(Release release, boolean checkEnabled) {
        if (!checkEnabled || this.enabled() && !this.catchingUp()) {
            if (!release.isTutorial()) {
                this.submit((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    try {
                        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Pre-archiving ").append(release).toString());
                        $this.archivingService.preArchiveRelease(release);
                        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Pre-archived ").append(release).toString());
                    }
                    catch (Exception e) {
                        this.logger().warn((Function0 & Serializable & scala.Serializable)() -> e);
                    }
                });
            }
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Pre-archiving is disabled");
        }
    }

    public boolean preArchive$default$2() {
        return true;
    }

    public synchronized void preArchiveInactiveReleasesInBackground() {
        block0: {
            if (this.catchingUp()) break block0;
            this.catchingUp_$eq(true);
            this.submit((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
                this.catchingUp_$eq(false);
            });
        }
    }

    private void preArchiveInactiveReleases(int page) {
        while (true) {
            Integer pageSize = this.archivingConfig.getSearchPageSize();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Fetching page ").append(page).append(" (").append(pageSize).append(" releases) for pre-archiving...").toString());
            Seq<Release> found = this.releaseRepository.findPreArchivableReleases(page, Predef$.MODULE$.Integer2int(pageSize));
            found.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                this.preArchive(x$1, false);
                return BoxedUnit.UNIT;
            });
            if (!this.enabled() || !BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)found.size()), (Object)pageSize)) break;
            ++page;
        }
    }

    private int preArchiveInactiveReleases$default$1() {
        return 0;
    }

    private void submitWithDelay(FiniteDuration delay, Function0<BoxedUnit> job) {
        this.pool().schedule(this.runnable(job), delay.toSeconds(), TimeUnit.SECONDS);
    }

    private <U> void submit(Function0<U> job) {
        this.pool().submit(this.runnable(job));
    }

    private <U> Runnable runnable(Function0<U> body) {
        return () -> body.apply();
    }

    public PreArchiveService(ArchivingService archivingService, ReleaseRepository releaseRepository, ArchivingSettingsManager archivingConfig) {
        this.archivingService = archivingService;
        this.releaseRepository = releaseRepository;
        this.archivingConfig = archivingConfig;
        Logging.$init$((Logging)this);
        this.enabled = false;
        this.catchingUp = false;
    }
}

