/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.FacetPermissionChecker;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.FacetService;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/facets/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
public class FacetApi
implements ApiService {
    private final FacetService facetService;
    private final PermissionChecker permissions;
    private final FacetPermissionChecker facetPermissions;

    @Autowired
    public FacetApi(FacetService facetService, PermissionChecker permissions, FacetPermissionChecker facetPermissions) {
        this.facetService = facetService;
        this.permissions = permissions;
        this.facetPermissions = facetPermissions;
    }

    @GET
    @Path(value="{facetId:.*Facet[^/-]*}")
    @PublicApiMember
    @Timed
    public Facet getFacet(@PathParam(value="facetId") String facetId) {
        Facet facet = this.facetService.get(facetId);
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(Ids.releaseIdFrom((String)facet.getTargetId()), () -> this.permissions.checkView(Ids.releaseIdFrom((String)facet.getTargetId())));
        return facet;
    }

    @POST
    @PublicApiMember
    @Timed
    public Facet createFacet(Facet facet) {
        return this.createFacet(facet, true);
    }

    protected Facet createFacet(Facet facet, boolean hasToCheckFacetMutability) {
        String releaseId = Ids.releaseIdFrom((String)facet.getTargetId());
        if (hasToCheckFacetMutability) {
            this.checkFacetMutability(facet, "You can not create immutable facet");
        }
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(releaseId, () -> {
            this.permissions.checkView(releaseId);
            this.permissions.checkEdit(releaseId);
            this.permissions.checkEditTask(releaseId);
        });
        return this.facetService.create(facet);
    }

    @PublicApiMember
    public Facet newFacet(String type) {
        return (Facet)Type.valueOf((String)type).getDescriptor().newInstance("");
    }

    @PUT
    @Path(value="{facetId:.*Facet[^/]*}")
    @PublicApiMember
    @Timed
    public Facet updateFacet(@PathParam(value="facetId") String facetId, Facet facet) {
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(Ids.releaseIdFrom((String)facet.getTargetId()), () -> this.permissions.checkEditTask(Ids.releaseIdFrom((String)facet.getTargetId())));
        this.checkFacetMutability(facet, "You can not modify immutable facet");
        facet.setId(facetId);
        return this.facetService.update(facet);
    }

    @DELETE
    @Path(value="{facetId:.*Facet[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteFacet(@PathParam(value="facetId") String facetId) {
        Facet facet = this.facetService.get(facetId);
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(Ids.releaseIdFrom((String)facet.getTargetId()), () -> this.permissions.checkEdit(Ids.releaseIdFrom((String)facet.getTargetId())));
        this.checkFacetMutability(facet, "You can not remove immutable facet");
        this.facetService.delete(facetId);
    }

    @POST
    @Path(value="search")
    @PublicApiMember
    @Timed
    public List<Facet> searchFacets(FacetFilters facetFilters) {
        facetFilters.validate();
        String containerId = facetFilters.getParentId() != null ? facetFilters.getParentId() : facetFilters.getTargetId();
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(Ids.releaseIdFrom((String)containerId), () -> this.permissions.checkView(Ids.releaseIdFrom((String)containerId)));
        return this.facetService.search(facetFilters);
    }

    @GET
    @Path(value="types")
    @PublicApiMember
    @Timed
    public List<Descriptor> getFacetTypes(@QueryParam(value="baseType") String baseType) {
        return this.facetService.getFacetTypes(baseType);
    }

    public String serviceName() {
        return "facetApi";
    }

    private void checkFacetMutability(Facet facet, String exceptionMsg) {
        if (this.facetService.isImmutable(facet)) {
            throw new IllegalArgumentException(exceptionMsg);
        }
    }
}

