/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import com.xebialabs.xlrelease.views.RoleView;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/roles")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class RolePrincipalsResource {
    private static final Logger logger = LoggerFactory.getLogger(RolePrincipalsResource.class);
    private PermissionChecker permissionChecker;
    private RoleService roleService;
    private DtoWriter dtoWriter = new DtoWriter();
    private DtoReader dtoReader = new DtoReader();
    private UserViewConverter userViewConverter;

    @Autowired
    public RolePrincipalsResource(PermissionChecker permissionChecker, RoleService roleService, UserViewConverter userViewConverter) {
        this.permissionChecker = permissionChecker;
        this.roleService = roleService;
        this.userViewConverter = userViewConverter;
    }

    @GET
    @Timed
    @Path(value="names")
    public List<String> readRoleNames() {
        List<RolePrincipals> assignments = this.getRolePrincipalsList();
        return assignments.stream().map(assignment -> assignment.getRole().getName()).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="principals")
    public List<RolePrincipalsView> readRolePrincipals() {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        List<RolePrincipals> assignments = this.getRolePrincipalsList();
        return assignments.stream().map(this::getRolePrincipalsView).collect(Collectors.toList());
    }

    private RolePrincipalsView getRolePrincipalsView(RolePrincipals rolePrincipal) {
        RoleView roleview = new RoleView(rolePrincipal.getRole());
        List<UserView> rolePrincipalsView = this.userViewConverter.toUserView(rolePrincipal.getPrincipals());
        return new RolePrincipalsView(roleview, rolePrincipalsView);
    }

    @PUT
    @Timed
    @Path(value="principals")
    public void createOrUpdateGlobalRolePermission(RolePrincipalsView rolePrincipalsView) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        RolePrincipals rolePrincipals = rolePrincipalsView.toRolePrincipals();
        Role role = (Role)this.dtoReader.readRoleAssignments(Collections.singletonList(rolePrincipals)).get(0);
        if (!role.getId().equals("-1")) {
            this.roleService.deleteById(role.getId());
        }
        try {
            this.roleService.createOrUpdateRole(role);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(String.format("Something went wrong while creating or updating role %s.", role.getName()));
        }
    }

    @DELETE
    @Timed
    @Path(value="principals/{roleId:.*}")
    public void deleteGlobalRolePermission(@PathParam(value="roleId") String roleId) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        this.roleService.deleteById(roleId);
    }

    private List<RolePrincipals> getRolePrincipalsList() {
        List multimap = this.roleService.readRoleAssignments();
        return this.dtoWriter.writeRoleAssignments(multimap);
    }
}

