/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.events.TriggerCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TriggerDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TriggerUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.ReleaseTriggerRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseTriggerService {
    private ReleaseTriggerRepository releaseTriggerRepository;
    private ReleaseService releaseService;
    private ReleaseActorService releaseActorService;
    private XLReleaseEventBus eventBus;
    private CiIdService ciIdService;
    private static final Logger logger = LoggerFactory.getLogger(ReleaseTriggerService.class);

    @Autowired
    public ReleaseTriggerService(ReleaseTriggerRepository releaseTriggerRepository, ReleaseService releaseService, ReleaseActorService releaseActorService, XLReleaseEventBus eventBus, CiIdService ciIdService) {
        this.releaseTriggerRepository = releaseTriggerRepository;
        this.releaseService = releaseService;
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
        this.ciIdService = ciIdService;
    }

    public ReleaseTrigger findById(String triggerId) {
        return this.releaseTriggerRepository.find(triggerId);
    }

    public ReleaseTrigger addTrigger(String templateId, ReleaseTrigger releaseTrigger) {
        String releaseTriggerId = this.ciIdService.getUniqueId(releaseTrigger.getType(), templateId);
        releaseTrigger.setId(releaseTriggerId);
        this.updateVariables(releaseTrigger);
        ReleaseTrigger addedTrigger = this.releaseTriggerRepository.create(templateId, releaseTrigger);
        this.eventBus.publish((XLReleaseEvent)new TriggerCreatedEvent(addedTrigger));
        return addedTrigger;
    }

    public void update(ReleaseTrigger releaseTrigger) {
        this.update(releaseTrigger, true);
    }

    public void update(ReleaseTrigger releaseTrigger, boolean shouldFireEvent) {
        Consumer<ReleaseTrigger> updateTriggerFn = rt -> {
            this.updateVariables((ReleaseTrigger)rt);
            this.releaseTriggerRepository.update((ReleaseTrigger)rt);
        };
        if (!shouldFireEvent) {
            updateTriggerFn.accept(releaseTrigger);
        } else {
            ReleaseTrigger original = this.releaseTriggerRepository.find(releaseTrigger.getId());
            updateTriggerFn.accept(releaseTrigger);
            this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedEvent(original, releaseTrigger));
        }
    }

    public void deleteTrigger(String triggerId) {
        ReleaseTrigger releaseTrigger = this.releaseTriggerRepository.find(triggerId);
        this.releaseTriggerRepository.delete(triggerId);
        this.eventBus.publish((XLReleaseEvent)new TriggerDeletedEvent(releaseTrigger));
    }

    public void releaseExecuted(String originTemplateId) {
        Release template;
        try {
            template = this.releaseService.findById(originTemplateId);
        }
        catch (NotFoundException e) {
            logger.info("Can't find origin template: '{}' when completing triggered release : {}", (Object)originTemplateId, (Object)e.getMessage());
            return;
        }
        Release original = CiCloneHelper.cloneCi(template);
        template.decrementRunningTriggeredReleasesCount();
        this.releaseService.updateReleaseProperties(original, template);
        if (!template.isAllowConcurrentReleasesFromTrigger()) {
            this.releaseActorService.scheduleReleaseTriggers(template.getId());
        }
    }

    private void updateVariables(ReleaseTrigger releaseTrigger) {
        VariablePersistenceHelper.fixUpVariableIds(releaseTrigger.getId(), releaseTrigger.getVariables(), this.ciIdService);
    }
}

