/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.initialize;

import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.export.TemplateImporter;
import com.xebialabs.xlrelease.template.SamplesImporter;
import com.xebialabs.xlrelease.upgrade.Components;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SampleTemplatesInitialization
implements RepositoryInitialization,
SamplesImporter {
    private static final Logger logger = LoggerFactory.getLogger(SampleTemplatesInitialization.class);
    public static final String TEMPLATE_WELCOME_ID = "Applications/ReleaseTemplate_welcome";
    public static final String TEMPLATE_CONFIGURE_ID = "Applications/ReleaseTemplate_configure";
    public static final String TEMPLATE_TOUR_ID = "Applications/ReleaseTemplate_tour";
    public static final String TEMPLATE_SAMPLE_ID = "Applications/ReleaseTemplate_sample";
    public static final String TEMPLATE_SAMPLE_WITH_XLD_ID = "Applications/ReleaseTemplate_sample_with_Deployit";
    public static final String TEMPLATE_BLUE_GREEN_ID = "Applications/ReleaseTemplate_blue_green_deployment";
    public static final String TEMPLATE_CANARY_ID = "Applications/ReleaseTemplate_canary_deployment";
    public static final String FOLDER_TEMPLATE_WELCOME_ID = "Applications/FolderSamplesAndTutorials/ReleaseTemplate_welcome";
    public static final String FOLDER_TEMPLATE_CONFIGURE_ID = "Applications/FolderSamplesAndTutorials/ReleaseTemplate_configure";
    private TemplateImporter templateImporter;
    private XlrConfig xlrConfig;
    private WorkDirContext workDirContext;
    private Map<String, String> sampleTemplates = new LinkedHashMap<String, String>(){
        {
            this.put("templates/welcome.json", SampleTemplatesInitialization.TEMPLATE_WELCOME_ID);
            this.put("templates/configure.json", SampleTemplatesInitialization.TEMPLATE_CONFIGURE_ID);
            this.put("templates/tour.json", SampleTemplatesInitialization.TEMPLATE_TOUR_ID);
            this.put("templates/sample.json", SampleTemplatesInitialization.TEMPLATE_SAMPLE_ID);
            this.put("templates/blue-green.json", SampleTemplatesInitialization.TEMPLATE_BLUE_GREEN_ID);
            this.put("templates/sample-with-xl-deploy.json", SampleTemplatesInitialization.TEMPLATE_SAMPLE_WITH_XLD_ID);
            this.put("templates/canary.json", SampleTemplatesInitialization.TEMPLATE_CANARY_ID);
        }
    };

    @Autowired
    public SampleTemplatesInitialization(TemplateImporter templateImporter, XlrConfig xlrConfig, WorkDirContext workDirContext) {
        this.templateImporter = templateImporter;
        this.workDirContext = workDirContext;
        this.xlrConfig = xlrConfig;
    }

    @Override
    public WorkDirContext workDirContext() {
        return this.workDirContext;
    }

    @Override
    public TemplateImporter templateImporter() {
        return this.templateImporter;
    }

    public void doInitialize() {
        if (this.xlrConfig.initialization_createSampleTemplates()) {
            logger.info("Importing sample templates");
            this.importSampleTemplates(this.sampleTemplates);
        } else {
            logger.info("Skipping import of sample templates");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String getComponent() {
        return Components.XL_RELEASE_COMPONENT;
    }
}

