/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskGranularPermissions {
    private PermissionChecker permissionChecker;
    private final Map<Permission, TaskUpdateDirective> permissionToUpdateDirective = Stream.of({XLReleasePermissions.EDIT_RELEASE_TASK, TaskUpdateDirective.UPDATE_RELEASE_TASK}, {XLReleasePermissions.EDIT_TEMPLATE, TaskUpdateDirective.UPDATE_TEMPLATE_TASK}, {XLReleasePermissions.EDIT_RELEASE_TASK_CONFIGURATION, TaskUpdateDirective.UPDATE_TASK_CONFIGURATION}, {XLReleasePermissions.EDIT_TASK_TAGS, TaskUpdateDirective.UPDATE_TASK_TAGS}, {XLReleasePermissions.EDIT_RELEASE_TASK_SCRIPT, TaskUpdateDirective.UPDATE_TASK_SCRIPT}, {XLReleasePermissions.EDIT_TASK_DATES, TaskUpdateDirective.UPDATE_TASK_DATES}, {XLReleasePermissions.EDIT_TASK_FLAG, TaskUpdateDirective.UPDATE_TASK_FLAG}, {XLReleasePermissions.EDIT_TASK_DESCRIPTION, TaskUpdateDirective.UPDATE_TASK_DESCRIPTION_AND_TITLE}, {XLReleasePermissions.EDIT_RELEASE_FAILURE_HANDLER, TaskUpdateDirective.UPDATE_TASK_FAILURE_HANDLER}, {XLReleasePermissions.EDIT_RELEASE_PRECONDITION, TaskUpdateDirective.UPDATE_TASK_PRECONDITION}, {XLReleasePermissions.EDIT_TEMPLATE_FAILURE_HANDLER, TaskUpdateDirective.UPDATE_TEMPLATE_TASK_FAILURE_HANDLER}, {XLReleasePermissions.EDIT_TEMPLATE_PRECONDITION, TaskUpdateDirective.UPDATE_TEMPLATE_TASK_PRECONDITION}).collect(Collectors.toMap(data -> (Permission)data[0], data -> (TaskUpdateDirective)((Object)((Object)data[1]))));
    private final Set<Permission> allTaskGranularPermissions = this.permissionToUpdateDirective.keySet();

    @Autowired
    public TaskGranularPermissions(PermissionChecker permissionChecker) {
        this.permissionChecker = permissionChecker;
    }

    public boolean hasEditTaskConfigurationGranularPermission(Release release) {
        return this.getUpdateDirectives(release).contains((Object)TaskUpdateDirective.UPDATE_TASK_CONFIGURATION);
    }

    public Set<TaskUpdateDirective> getUpdateDirectives(Release release) {
        Set<TaskUpdateDirective> directives = this.allTaskGranularPermissions.stream().filter(permission -> this.permissionChecker.hasPermission((Permission)permission, release)).map(this.permissionToUpdateDirective::get).collect(Collectors.toSet());
        if (directives.isEmpty()) {
            throw PermissionDeniedException.withMessage((String)"You are not allowed to edit tasks of this release.");
        }
        return directives;
    }

    public boolean hasDirectiveToUpdateAllProperties(Release release) {
        return this.hasDirectiveToUpdateAllProperties(release, this.getUpdateDirectives(release));
    }

    public boolean hasDirectiveToUpdateAllProperties(Release release, Set<TaskUpdateDirective> directives) {
        boolean isDefinedAndNotEmpty = directives != null && !directives.isEmpty();
        return isDefinedAndNotEmpty && (release.isTemplate() && directives.contains((Object)TaskUpdateDirective.UPDATE_TEMPLATE_TASK) || !release.isTemplate() && directives.contains((Object)TaskUpdateDirective.UPDATE_RELEASE_TASK));
    }

    public void checkHasEditTaskOrEditTaskConfiguration(Release release) {
        Permission permission;
        Permission permission2 = permission = release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK;
        if (!this.permissionChecker.hasPermission(permission, release) && !this.hasEditTaskConfigurationGranularPermission(release)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)release.getId());
        }
    }
}

