/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.xebialabs.xlrelease.views.LogsFilters;
import java.util.Date;

public class LogsFiltersBuilder {
    private String filter;
    private Date from;
    private Date to;
    private boolean important = true;
    private boolean releaseEdit = true;
    private boolean taskEdit = true;
    private boolean deliveryEdit = true;
    private boolean lifecycle = true;
    private boolean reassign = true;
    private boolean security = true;
    private boolean dateAsc = true;
    private boolean other = true;
    private String targetId;

    private LogsFiltersBuilder() {
    }

    public static LogsFiltersBuilder newLogsFilters() {
        return new LogsFiltersBuilder();
    }

    public LogsFiltersBuilder withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public LogsFiltersBuilder from(Date from) {
        this.from = from;
        return this;
    }

    public LogsFiltersBuilder to(Date to) {
        this.to = to;
        return this;
    }

    public LogsFiltersBuilder withImportant(boolean important) {
        this.important = important;
        return this;
    }

    public LogsFiltersBuilder withReleaseEdit(boolean releaseEdit) {
        this.releaseEdit = releaseEdit;
        return this;
    }

    public LogsFiltersBuilder withTaskEdit(boolean taskEdit) {
        this.taskEdit = taskEdit;
        return this;
    }

    public LogsFiltersBuilder withDeliveryEdit(boolean deliveryEdit) {
        this.deliveryEdit = deliveryEdit;
        return this;
    }

    public LogsFiltersBuilder withLifecycle(boolean lifecycle) {
        this.lifecycle = lifecycle;
        return this;
    }

    public LogsFiltersBuilder withReassign(boolean reassign) {
        this.reassign = reassign;
        return this;
    }

    public LogsFiltersBuilder withSecurity(boolean security) {
        this.security = security;
        return this;
    }

    public LogsFiltersBuilder withDateAsc(boolean dateAsc) {
        this.dateAsc = dateAsc;
        return this;
    }

    public LogsFiltersBuilder withOther(boolean other) {
        this.other = other;
        return this;
    }

    public LogsFiltersBuilder withTargetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    public LogsFilters build() {
        LogsFilters filters = new LogsFilters();
        filters.setFilter(this.filter);
        filters.setFrom(this.from);
        filters.setTo(this.to);
        filters.setImportant(this.important);
        filters.setReleaseEdit(this.releaseEdit);
        filters.setTaskEdit(this.taskEdit);
        filters.setDeliveryEdit(this.deliveryEdit);
        filters.setLifecycle(this.lifecycle);
        filters.setReassign(this.reassign);
        filters.setSecurity(this.security);
        filters.setDateAsc(this.dateAsc);
        filters.setOther(this.other);
        filters.setTargetId(this.targetId);
        return filters;
    }
}

