/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.FolderCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.FolderMovedEvent;
import com.xebialabs.xlrelease.domain.events.FolderMovingAction;
import com.xebialabs.xlrelease.domain.events.FolderRenamedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams$;
import com.xebialabs.xlrelease.repository.ReleaseTriggerRepository;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r\u0005c\u0001B\u0017/\u0001]B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\t[\u0002\u0011\t\u0011)A\u0005]\"AA\u000f\u0001B\u0001B\u0003%Q\u000f\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003z\u0011\u0015a\b\u0001\"\u0001~\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!a\u0014\u0001\t\u0003\t\t\u0006C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!I\u0011\u0011\u0013\u0001\u0012\u0002\u0013\u0005\u00111\u0013\u0005\b\u0003O\u0003A\u0011AAU\u0011%\tI\fAI\u0001\n\u0003\tY\fC\u0004\u0002@\u0002!\t!!1\t\u0013\u0005\r\b!%A\u0005\u0002\u0005\u0015\bbBAu\u0001\u0011\u0005\u00111\u001e\u0005\b\u0003k\u0004A\u0011AA|\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007AqA!\u0006\u0001\t\u0003\u00119\u0002C\u0005\u0003D\u0001\t\n\u0011\"\u0001\u0003F!9!\u0011\n\u0001\u0005\u0002\t-\u0003\"\u0003B-\u0001E\u0005I\u0011AAs\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0005;BqAa\u0017\u0001\t\u0003\u0011)\u0007C\u0004\u0003r\u0001!\tAa\u001d\t\u000f\te\u0004\u0001\"\u0003\u0003|!9!Q\u0011\u0001\u0005\n\t\u001d\u0005b\u0002BU\u0001\u0011%!1\u0016\u0005\b\u0005c\u0003A\u0011\u0002BZ\u0011\u001d\u0011Y\f\u0001C\u0005\u0005{CqA!1\u0001\t\u0013\u0011\u0019\rC\u0004\u0003J\u0002!\tAa3\t\u000f\t%\b\u0001\"\u0003\u0003l\"9!Q \u0001\u0005\n\t}\bbBB\u0013\u0001\u0011%1q\u0005\u0005\b\u0007[\u0001A\u0011BB\u0018\u0011\u001d\u0019\u0019\u0004\u0001C\u0005\u0007kAqaa\u000f\u0001\t\u0013\u0019iDA\u0007G_2$WM]*feZL7-\u001a\u0006\u0003_A\nqa]3sm&\u001cWM\u0003\u00022e\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003gQ\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003U\n1aY8n\u0007\u0001\u00192\u0001\u0001\u001d?!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0019\te.\u001f*fMB\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0006g24GG\u001b\u0006\u0002\u0007\u0006AqM]5{u2,G-\u0003\u0002F\u0001\n9Aj\\4hS:<\u0017a\u00024pY\u0012,'o\u001d\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015B\n!B]3q_NLGo\u001c:z\u0013\ta\u0015J\u0001\tG_2$WM\u001d*fa>\u001c\u0018\u000e^8ss\u0006YA/Z1n'\u0016\u0014h/[2f!\ty\u0005+D\u0001/\u0013\t\tfFA\u0006UK\u0006l7+\u001a:wS\u000e,\u0017!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011\u0001\nV\u0005\u0003+&\u0013\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003-!\u0018m]6TKJ4\u0018nY3\u0011\u0005=C\u0016BA-/\u0005-!\u0016m]6TKJ4\u0018nY3\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bC\u0001%]\u0013\ti\u0016JA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006Y1-[%e'\u0016\u0014h/[2f!\ty\u0005-\u0003\u0002b]\tY1)[%e'\u0016\u0014h/[2f\u0003Q\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dKB\u0011q\nZ\u0005\u0003K:\u0012ACU3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,\u0017a\u00039fe6L7o]5p]N\u0004\"\u0001[6\u000e\u0003%T!A\u001b\u0019\u0002\u0011M,7-\u001e:jifL!\u0001\\5\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0005fm\u0016tGOQ;t!\ty'/D\u0001q\u0015\t\t\b'\u0001\u0004fm\u0016tGo]\u0005\u0003gB\u0014\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003e\u0011X\r\\3bg\u0016$&/[4hKJ\u001c(+\u001a9pg&$xN]=\u0011\u0005!3\u0018BA<J\u0005a\u0011V\r\\3bg\u0016$&/[4hKJ\u0014V\r]8tSR|'/_\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\"a\u0014>\n\u0005mt#\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q1bp`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\u0002\u0005\u0002P\u0001!)a\t\u0004a\u0001\u000f\")Q\n\u0004a\u0001\u001d\")!\u000b\u0004a\u0001'\")a\u000b\u0004a\u0001/\")!\f\u0004a\u00017\")a\f\u0004a\u0001?\")!\r\u0004a\u0001G\")a\r\u0004a\u0001O\")Q\u000e\u0004a\u0001]\")A\u000f\u0004a\u0001k\")\u0001\u0010\u0004a\u0001s\u0006\t2\r[3dW\u001a{G\u000eZ3s\u000bbL7\u000f^:\u0015\t\u0005e\u0011q\u0004\t\u0004s\u0005m\u0011bAA\u000fu\t!QK\\5u\u0011\u001d\t\t#\u0004a\u0001\u0003G\t\u0001BZ8mI\u0016\u0014\u0018\n\u001a\t\u0005\u0003K\t\u0019D\u0004\u0003\u0002(\u0005=\u0002cAA\u0015u5\u0011\u00111\u0006\u0006\u0004\u0003[1\u0014A\u0002\u001fs_>$h(C\u0002\u00022i\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001b\u0003o\u0011aa\u0015;sS:<'bAA\u0019u!\u001aQ\"a\u000f\u0011\t\u0005u\u00121J\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005\u0015\u0013qI\u0001\b[\u0016$(/[2t\u0015\r\tI\u0005N\u0001\tG>$\u0017\r[1mK&!\u0011QJA \u0005\u0015!\u0016.\\3e\u0003\u0019)\u00070[:ugR!\u00111KA-!\rI\u0014QK\u0005\u0004\u0003/R$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003Cq\u0001\u0019AA\u0012Q\rq\u00111H\u0001\tO\u0016$H+\u001b;mKR!\u00111EA1\u0011\u001d\t\tc\u0004a\u0001\u0003GA3aDA\u001e\u0003!1\u0017N\u001c3Cs&#GCBA5\u0003s\nY\b\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\r\u0019|G\u000eZ3s\u0015\r\t\u0019\bM\u0001\u0007I>l\u0017-\u001b8\n\t\u0005]\u0014Q\u000e\u0002\u0007\r>dG-\u001a:\t\u000f\u0005\u0005\u0002\u00031\u0001\u0002$!I\u0011Q\u0010\t\u0011\u0002\u0003\u0007\u0011qP\u0001\u0006I\u0016\u0004H\u000f\u001b\t\u0005\u0003\u0003\u000bY)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0015\u0001\u00026bm\u0006LA!!$\u0002\u0004\n9\u0011J\u001c;fO\u0016\u0014\bf\u0001\t\u0002<\u0005\u0011b-\u001b8e\u0005fLE\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t)J\u000b\u0003\u0002\u0000\u0005]5FAAM!\u0011\tY*a)\u000e\u0005\u0005u%\u0002BAP\u0003C\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005#(\u0003\u0003\u0002&\u0006u%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Qa-\u001b8e\u0005f\u0004\u0016\r\u001e5\u0015\r\u0005%\u00141VAX\u0011\u001d\tiK\u0005a\u0001\u0003G\tA\u0001]1uQ\"I\u0011Q\u0010\n\u0011\u0002\u0003\u0007\u0011\u0011\u0017\t\u0004s\u0005M\u0016bAA[u\t\u0019\u0011J\u001c;)\u0007I\tY$\u0001\u000bgS:$')\u001f)bi\"$C-\u001a4bk2$HEM\u000b\u0003\u0003{SC!!-\u0002\u0018\u0006\u0019B.[:u-&,w/\u00192mK\u001a{G\u000eZ3sgRA\u00111YAh\u0003'\fi\u000e\u0005\u0004\u0002F\u0006-\u0017\u0011N\u0007\u0003\u0003\u000fTA!!3\u0002\b\u0006!Q\u000f^5m\u0013\u0011\ti-a2\u0003\t1K7\u000f\u001e\u0005\b\u0003#$\u0002\u0019AA\u0012\u0003!\u0001\u0018M]3oi&#\u0007bBAk)\u0001\u0007\u0011q[\u0001\u0005a\u0006<W\rE\u0002I\u00033L1!a7J\u0005\u0011\u0001\u0016mZ3\t\u0013\u0005}G\u0003%AA\u0002\u0005M\u0013a\u00063fG>\u0014\u0018\r^3XSRD\u0007+\u001a:nSN\u001c\u0018n\u001c8tQ\r!\u00121H\u0001\u001eY&\u001cHOV5fo\u0006\u0014G.\u001a$pY\u0012,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u001d\u0016\u0005\u0003'\n9*\u0001\u0003n_Z,GCBA5\u0003[\fy\u000fC\u0004\u0002\"Y\u0001\r!a\t\t\u000f\u0005Eh\u00031\u0001\u0002$\u0005Ya.Z<QCJ,g\u000e^%eQ\r1\u00121H\u0001\u0007e\u0016t\u0017-\\3\u0015\r\u0005%\u0014\u0011`A~\u0011\u001d\t\tc\u0006a\u0001\u0003GAq!!@\u0018\u0001\u0004\t\u0019#A\u0004oK^t\u0015-\\3)\u0007]\tY$A\btK\u0006\u00148\r\u001b+f[Bd\u0017\r^3t)\u0019\u0011)Aa\u0004\u0003\u0012A1\u0011QYAf\u0005\u000f\u0001BA!\u0003\u0003\f5\u0011\u0011\u0011O\u0005\u0005\u0005\u001b\t\tHA\u0004SK2,\u0017m]3\t\u000f\u0005\u0005\u0002\u00041\u0001\u0002$!9\u0011Q\u001b\rA\u0002\u0005]\u0007f\u0001\r\u0002<\u0005q1/Z1sG\"\u0014V\r\\3bg\u0016\u001cH\u0003\u0003B\r\u0005K\u00119Ca\u0010\u0011\t\tm!\u0011E\u0007\u0003\u0005;Q1Aa\b1\u0003\u0019\u0019X-\u0019:dQ&!!1\u0005B\u000f\u0005M\u0011V\r\\3bg\u0016\u001cV-\u0019:dQJ+7/\u001e7u\u0011\u001d\t\t#\u0007a\u0001\u0003GAqA!\u000b\u001a\u0001\u0004\u0011Y#A\u0004gS2$XM]:\u0011\t\t5\"1H\u0007\u0003\u0005_QAA!\r\u00034\u0005)am\u001c:ng*!!Q\u0007B\u001c\u0003\t1\u0018GC\u0002\u0003:A\n1!\u00199j\u0013\u0011\u0011iDa\f\u0003\u001fI+G.Z1tKN4\u0015\u000e\u001c;feND\u0011\"!6\u001a!\u0003\u0005\r!a6)\u0007e\tY$\u0001\rtK\u0006\u00148\r\u001b*fY\u0016\f7/Z:%I\u00164\u0017-\u001e7uIM*\"Aa\u0012+\t\u0005]\u0017qS\u0001\r[>4X\rV3na2\fG/\u001a\u000b\t\u0003G\u0011iEa\u0014\u0003T!9\u0011\u0011E\u000eA\u0002\u0005\r\u0002b\u0002B)7\u0001\u0007\u00111E\u0001\u000bi\u0016l\u0007\u000f\\1uK&#\u0007\"\u0003B+7A\u0005\t\u0019AA*\u0003A\u0019\bn\\;mI6+'oZ3UK\u0006l7\u000fK\u0002\u001c\u0003w\ta#\\8wKR+W\u000e\u001d7bi\u0016$C-\u001a4bk2$HeM\u0001\u0007GJ,\u0017\r^3\u0015\r\u0005%$q\fB1\u0011\u001d\t\t.\ba\u0001\u0003GAq!a\u001c\u001e\u0001\u0004\tI\u0007K\u0002\u001e\u0003w!\u0002\"!\u001b\u0003h\t%$1\u000e\u0005\b\u0003#t\u0002\u0019AA\u0012\u0011\u001d\tyG\ba\u0001\u0003SBqA!\u001c\u001f\u0001\u0004\t\u0019&\u0001\nde\u0016\fG/\u001a#fM\u0006,H\u000e\u001e+fC6\u001c\bf\u0001\u0010\u0002<\u00051A-\u001a7fi\u0016$B!!\u0007\u0003v!9\u0011\u0011E\u0010A\u0002\u0005\r\u0002fA\u0010\u0002<\u0005y\u0011M]2iSZ,wJ\u001d#fY\u0016$X\r\u0006\u0004\u0002\u001a\tu$\u0011\u0011\u0005\b\u0005\u007f\u0002\u0003\u0019AAY\u0003%1w\u000e\u001c3feVKG\rC\u0004\u0003\u0004\u0002\u0002\r!a\t\u0002\u0013I,G.Z1tK&#\u0017AC7fe\u001e,G+Z1ngRA\u0011\u0011\u0004BE\u0005\u0017\u0013i\tC\u0004\u0002\"\u0005\u0002\r!a\t\t\u000f\tE\u0013\u00051\u0001\u0002$!9!qR\u0011A\u0002\tE\u0015!\u0004;f[Bd\u0017\r^3UK\u0006l7\u000f\u0005\u0004\u0003\u0014\nu%1\u0015\b\u0005\u0005+\u0013IJ\u0004\u0003\u0002*\t]\u0015\"A\u001e\n\u0007\tm%(A\u0004qC\u000e\\\u0017mZ3\n\t\t}%\u0011\u0015\u0002\u0004'\u0016\f(b\u0001BNuA!!\u0011\u0002BS\u0013\u0011\u00119+!\u001d\u0003\tQ+\u0017-\\\u0001\re\u0016\u0004H.Y2f)\u0016\fWn\u001d\u000b\u0007\u00033\u0011iKa,\t\u000f\u0005\u0005\"\u00051\u0001\u0002$!9!\u0011\u000b\u0012A\u0002\u0005\r\u0012aG7fe\u001e,G+Z7qY\u0006$X-\u00118e\r>dG-\u001a:UK\u0006l7\u000f\u0006\u0004\u0003\u0012\nU&\u0011\u0018\u0005\b\u0005o\u001b\u0003\u0019\u0001BI\u0003-1w\u000e\u001c3feR+\u0017-\\:\t\u000f\t=5\u00051\u0001\u0003\u0012\u0006i!/Z:fiR\u000b7o\u001b+fC6$B!!\u0007\u0003@\"9!\u0011\u000b\u0013A\u0002\u0005\r\u0012AH2sK\u0006$X\rR3gCVdG\u000fV3b[N4uN\u001d+iK\u001a{G\u000eZ3s)\u0019\tIB!2\u0003H\"9\u0011qN\u0013A\u0002\u0005%\u0004bBAiK\u0001\u0007\u00111E\u0001 O\u0016$hj\u001c8J]\",'/\u001b;fI\u001a{G\u000eZ3s%\u00164WM]3oG\u0016\u001cHC\u0002Bg\u0005G\u0014)\u000f\u0005\u0004\u0003P\ne'Q\\\u0007\u0003\u0005#TAAa5\u0003V\u00069Q.\u001e;bE2,'b\u0001Blu\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tm'\u0011\u001b\u0002\u0004'\u0016$\b\u0003\u0002B\u0005\u0005?LAA!9\u0002r\t\t\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005\u0005b\u00051\u0001\u0002$!9!q\u001d\u0014A\u0002\u0005\r\u0012a\u00038fo\u001a|G\u000eZ3s\u0013\u0012\fQc\u00195fG.4u\u000e\u001c3fe\u000e\u000bgNQ3N_Z,G\r\u0006\u0005\u0002\u001a\t5(q\u001eB}\u0011\u001d\t\tc\na\u0001\u0003GAqA!=(\u0001\u0004\u0011\u00190A\toK^4w\u000e\u001c3fe&#w\n\u001d;j_:\u0004R!\u000fB{\u0003GI1Aa>;\u0005\u0019y\u0005\u000f^5p]\"9!1`\u0014A\u0002\u0005\r\u0012!C8qKJ\fG/[8o\u00035\u0019'/Z1uK\u0012+G/Y5mgRQ1\u0011AB\u0003\u0007\u0017\u00199ba\u0007\u0011\t\u0005\u000551A\u0005\u0005\u0003k\t\u0019\tC\u0004\u0004\b!\u0002\ra!\u0003\u0002\u001d\u0005\u001cG/\u001b<f%\u0016dW-Y:fgB1!1\u0013BO\u0005\u000fAqa!\u0004)\u0001\u0004\u0019y!A\bf]\u0006\u0014G.\u001a3Ue&<w-\u001a:t!\u0019\u0011\u0019J!(\u0004\u0012A!!\u0011BB\n\u0013\u0011\u0019)\"!\u001d\u0003\u001dI+G.Z1tKR\u0013\u0018nZ4fe\"91\u0011\u0004\u0015A\u0002\r%\u0011\u0001G1vi>\u001cF/\u0019:u!\u0016tG-\u001b8h%\u0016dW-Y:fg\"91Q\u0004\u0015A\u0002\r}\u0011aC5om\u0006d\u0017\u000e\u001a*fMN\u0004ba!\t\u0004$\tuWB\u0001Bk\u0013\u0011\u0011YN!6\u0002/\rDWmY6UK6\u0004H.\u0019;f\u0007\u0006t')Z'pm\u0016$GCBA\r\u0007S\u0019Y\u0003C\u0004\u0003R%\u0002\r!a\t\t\u000f\u0005\u0005\u0012\u00061\u0001\u0002$\u0005\u0011r-\u001a;Sk:t\u0017N\\4SK2,\u0017m]3t)\u0011\u0019Ia!\r\t\u000f\u0005\u0005\"\u00061\u0001\u0002$\u0005\u0011r-\u001a;F]\u0006\u0014G.\u001a3Ue&<w-\u001a:t)\u0011\u0019yaa\u000e\t\u000f\re2\u00061\u0001\u0002$\u0005Q\u0011M\\2fgR|'/\u00133\u00027\u001d,G/Q;u_N#\u0018M\u001d;QK:$\u0017N\\4SK2,\u0017m]3t)\u0011\u0019Iaa\u0010\t\u000f\u0005\u0005B\u00061\u0001\u0002$\u0001")
public class FolderService
implements Logging {
    private final FolderRepository folders;
    private final TeamService teamService;
    private final ReleaseRepository releaseRepository;
    private final TaskService taskService;
    private final ConfigurationRepository configurationRepository;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private final ReleaseTriggerRepository releaseTriggersRepository;
    private final ArchivingService archivingService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    @Timed
    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    @Timed
    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException(new StringBuilder(23).append("Folder ").append(Ids.ROOT_FOLDER_ID).append(" cannot be found").toString(), new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    @Timed
    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Folder findByPath(String path, int depth) {
        void var3_3;
        Folder found = this.folders.findByPath(path, depth);
        this.permissions.check(XLReleasePermissions.VIEW_FOLDER, found.getId());
        return var3_3;
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        this.permissions.checkViewFolder(parentId);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.folders.listViewableFolders(parentId, page, decorateWithPermissions)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)new Some((Object)newParentId), "move");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderMovingAction(folderId, Ids.getParentId((String)folderId), newParentId));
        Folder folder = this.folders.move(folderId, newParentId);
        this.eventBus.publish((XLReleaseEvent)new FolderMovedEvent(folder, Ids.getParentId((String)folderId), newParentId));
        return folder;
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        Checks.checkArgument((!newName.trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Folder folder = this.folders.rename(folderId, newName);
        this.eventBus.publish((XLReleaseEvent)new FolderRenamedEvent(folder, newName));
        return folder;
    }

    @Timed
    public List<Release> searchTemplates(String folderId, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), page.depth()).getReleases();
    }

    @Timed
    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage(), page.depth());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    @Timed
    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String string;
        String newTemplateId = new StringBuilder(1).append(folderId).append("/").append(Ids.getName((String)templateId)).toString();
        this.checkTemplateCanBeMoved(templateId, folderId);
        String string2 = Ids.getParentId((String)templateId);
        String string3 = folderId;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Attempted to move template ").append(templateId).append(" to same folder ").append(folderId).append(". Will be ignored.").toString());
            string = templateId;
        } else {
            Buffer templateTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getStoredTeams(templateId)).asScala();
            this.releaseRepository.move(templateId, newTemplateId);
            if (shouldMergeTeams) {
                this.mergeTeams(folderId, newTemplateId, (Seq<Team>)templateTeams);
            } else {
                this.replaceTeams(folderId, newTemplateId);
            }
            this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
            string = newTemplateId;
        }
        return string;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        return this.create(parentId, folder, true);
    }

    @Timed
    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        Folder saved;
        block3: {
            Checks.checkArgument((!folder.getTitle().trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
            Checks.checkArgument((folder.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Folder name must be 255 characters or less", (Object[])new Object[0]);
            this.checkFolderExists(parentId);
            this.folders.checkNameIsUnique(parentId, folder.getTitle());
            if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
                folder.setId(this.ciIdService.getUniqueId(Type.valueOf(Folder.class), parentId));
            } else {
                folder.setId(new StringBuilder(1).append(parentId).append("/").append(Ids.getName((String)folder.getId())).toString());
            }
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Creating folder ").append(folder.getTitle()).append(" with id ").append(folder.getId()).toString());
            saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
            this.eventBus.publish((XLReleaseEvent)new FolderCreatedEvent(folder));
            if (!createDefaultTeams) break block3;
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.createDefaultTeamsForTheFolder(saved, parentId);
            }
        }
        return saved;
    }

    @Timed
    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)None$.MODULE$, "delete");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderDeletingAction(folderId));
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Deleting folder ").append(folderId).toString());
        Folder folder = (Folder)this.folders.findById(folderId, this.folders.findById$default$2()).get();
        this.folders.delete(folderId, (Function2<Object, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(folderUid, releaseId) -> {
            this.archiveOrDelete(BoxesRunTime.unboxToInt((Object)folderUid), releaseId);
            return BoxedUnit.UNIT;
        });
        this.eventBus.publish((XLReleaseEvent)new FolderDeletedEvent(folder));
    }

    private void archiveOrDelete(int folderUid, String releaseId) {
        ReleaseStatus status = this.releaseRepository.getStatus(releaseId);
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("archiveOrDelete(").append(folderUid).append(", ").append(releaseId).append("): status=").append(status).append(" [inactive? ").append(status.isInactive()).append("]").toString());
        if (this.releaseRepository.getStatus(releaseId).isInactive()) {
            if (!this.archivingService.existsPreArchived(releaseId)) {
                Release release = this.releaseRepository.findById(releaseId);
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("release loaded: ").append(release).toString());
                this.archivingService.preArchiveRelease(release);
            }
            this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("archiveRelease(").append(releaseId).append(")").toString());
            this.archivingService.archiveRelease(releaseId);
        } else {
            this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("deleteRelease(").append(releaseId).append(")").toString());
            this.releaseRepository.delete(releaseId);
        }
    }

    private void mergeTeams(String folderId, String templateId, Seq<Team> templateTeams) {
        block0: {
            if (!templateTeams.nonEmpty()) break block0;
            Buffer folderTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(folderId)).asScala();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable & scala.Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> folderId);
            Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teamService.saveTeamsToPlatform(folderTeamsContainerId, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(mergedTeams).asJava());
            this.teamService.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teamService.deleteTeamsFromPlatform(templateId);
    }

    private Seq<Team> mergeTemplateAndFolderTeams(Seq<Team> folderTeams, Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((TraversableOnce)folderTeams.map((Function1 & Serializable & scala.Serializable)team -> new Tuple2((Object)team.getTeamName(), team), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).toSeq());
        templateTeams.foreach((Function1 & Serializable & scala.Serializable)templateTeam -> {
            MapLike mapLike;
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                mapLike = folderTeamsMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                scala.collection.immutable.Set memberSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getMembers()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getMembers()).asScala()).toSet());
                scala.collection.immutable.Set roleSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getRoles()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getRoles()).asScala()).toSet());
                scala.collection.immutable.Set permissionSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getPermissions()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getPermissions()).asScala()).toSet());
                folderTeam.setMembers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(memberSet.toSeq()).asJava());
                folderTeam.setRoles((List)JavaConverters$.MODULE$.seqAsJavaListConverter(roleSet.toSeq()).asJava());
                folderTeam.setPermissions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(permissionSet.toSeq()).asJava());
                mapLike = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return mapLike;
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releaseRepository.findById(templateId);
        template.getAllTasks().forEach(task -> $this.taskService.applyNewTeam(null, (Task)task, false));
    }

    private void createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(XLReleasePermissions.getFolderPermissions()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$createDefaultTeamsForTheFolder$1(x$1)))).asJava());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getReleaseGroupPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDeliveryPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDashboardPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.setPermissions(XLReleasePermissions.getReleasePermissions());
        releaseAdmin.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        this.teamService.saveTeamsToPlatform(folder.getId(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{folderOwner, templateOwner, releaseAdmin}))).asJava());
    }

    public scala.collection.mutable.Set<BaseConfiguration> getNonInheritedFolderReferences(String folderId, String newfolderId) {
        Page x$1 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0));
        ReleaseStatus[] x$2 = (ReleaseStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ReleaseStatus.class));
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        scala.collection.mutable.Seq releases = (scala.collection.mutable.Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala();
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        releases.foreach((Function1 & Serializable & scala.Serializable)release -> {
            FolderService.$anonfun$getNonInheritedFolderReferences$1(this, newfolderId, folderId, res, release);
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private void checkFolderCanBeMoved(String folderId, Option<String> newfolderIdOption, String operation) {
        scala.collection.mutable.Set<BaseConfiguration> set;
        Seq<Release> activeReleases = this.getRunningReleases(folderId);
        Seq<ReleaseTrigger> enabledTriggers = this.getEnabledTriggers(folderId);
        Seq<Release> autoStartPendingReleases = this.getAutoStartPendingReleases(folderId);
        Option<String> option = newfolderIdOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            String newFolderId = (String)some.value();
            set = this.getNonInheritedFolderReferences(folderId, newFolderId);
        } else if (None$.MODULE$.equals(option)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.mutable.Set<BaseConfiguration> invalidRefs = set;
        if (activeReleases.nonEmpty() || enabledTriggers.nonEmpty() || autoStartPendingReleases.nonEmpty() || invalidRefs.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Tried to ").append(operation).append(" folder ").append(folderId).append(", which has active releases ").append(((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(new StringBuilder(22).append(" or enabled triggers: ").append(((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString()).append(new StringBuilder(53).append(" or pending releases with auto start option enabled: ").append(((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString()).toString());
            String details = this.createDetails(activeReleases, enabledTriggers, autoStartPendingReleases, (Set<BaseConfiguration>)invalidRefs);
            throw new ItemInUseException(new StringBuilder(62).append("You cannot ").append(operation).append(" this folder. The folder or its subfolders contain ").append(details).toString(), new Object[0]);
        }
    }

    private String createDetails(Seq<Release> activeReleases, Seq<ReleaseTrigger> enabledTriggers, Seq<Release> autoStartPendingReleases, Set<BaseConfiguration> invalidRefs) {
        String details;
        block3: {
            details = "";
            if (activeReleases.nonEmpty()) {
                details = new StringBuilder(0).append(details).append(new StringBuilder(17).append("active releases: ").append(((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")).toString()).toString();
            }
            if (enabledTriggers.nonEmpty()) {
                details = new StringBuilder(0).append(details).append(new StringBuilder(44).append("releases or template with enabled triggers: ").append(((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(1).append(t.getTemplate().getTitle()).append("/").append(t.getTitle()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")).toString()).toString();
            }
            if (autoStartPendingReleases.nonEmpty()) {
                details = new StringBuilder(0).append(details).append(new StringBuilder(34).append("pending releases with auto start: ").append(((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")).toString()).toString();
            }
            if (!invalidRefs.nonEmpty()) break block3;
            details = new StringBuilder(0).append(details).append(new StringBuilder(66).append("configuration references not inherited by the destination folder: ").append(((TraversableOnce)invalidRefs.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getTitle(), Set$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")).toString()).toString();
        }
        return details;
    }

    private void checkTemplateCanBeMoved(String templateId, String folderId) {
        Buffer enabledTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseTriggersRepository.findEnabledReleaseTriggers(templateId)).asScala();
        if (enabledTriggers.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Tried to move template ").append(templateId).append(" with enabled triggers ").append(enabledTriggers).toString());
            throw new ItemInUseException(new StringBuilder(74).append("You can't move this template because it has one or more enabled triggers: ").append(String.valueOf(enabledTriggers.mkString(", "))).toString(), new Object[0]);
        }
        Release template = this.releaseRepository.findById(templateId);
        scala.collection.mutable.Set refs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(CiHelper.getExternalReferences((ConfigurationItem)template)).asScala();
        if (!((IterableLike)((SetLike)refs.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$2(c)))).map((Function1 & Serializable & scala.Serializable)c -> $this.configurationRepository.read(c.getId()), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$4(folderId, c)))) {
            throw new ItemInUseException("You cannot move this template. It contains references to configurations that are not global or not inherited by the destination folder.", new Object[0]);
        }
    }

    private Seq<Release> getRunningReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$2 = ReleaseStatus.ACTIVE_STATUSES;
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala();
    }

    private Seq<ReleaseTrigger> getEnabledTriggers(String ancestorId) {
        Page x$1 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(2));
        ReleaseStatus[] x$2 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE});
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(ancestorId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$8.getReleaseTriggers()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isEnabled()));
    }

    private Seq<Release> getAutoStartPendingReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$2 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED});
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        boolean x$4 = true;
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$6 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$5, x$6, x$4))).asScala();
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public static final /* synthetic */ boolean $anonfun$createDefaultTeamsForTheFolder$1(String x$1) {
        String string = x$1;
        String string2 = XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getNonInheritedFolderReferences$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ void $anonfun$getNonInheritedFolderReferences$1(FolderService $this, String newfolderId$1, String folderId$6, scala.collection.mutable.Set res$1, Release release) {
        scala.collection.mutable.Set refs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(CiHelper.getExternalReferences((ConfigurationItem)release)).asScala();
        ((IterableLike)((SetLike)refs.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$getNonInheritedFolderReferences$2(c)))).map((Function1 & Serializable & scala.Serializable)c -> $this.configurationRepository.read(c.getId()), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)c -> c.getFolderId() != null && !newfolderId$1.startsWith(c.getFolderId()) && !c.getFolderId().equals(folderId$6) ? BoxesRunTime.boxToBoolean((boolean)res$1.add(c)) : BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$4(String folderId$8, BaseConfiguration c) {
        return c.getFolderId() == null || folderId$8.startsWith(c.getFolderId());
    }

    public FolderService(FolderRepository folders, TeamService teamService, ReleaseRepository releaseRepository, TaskService taskService, ConfigurationRepository configurationRepository, CiIdService ciIdService, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus, ReleaseTriggerRepository releaseTriggersRepository, ArchivingService archivingService) {
        this.folders = folders;
        this.teamService = teamService;
        this.releaseRepository = releaseRepository;
        this.taskService = taskService;
        this.configurationRepository = configurationRepository;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        this.releaseTriggersRepository = releaseTriggersRepository;
        this.archivingService = archivingService;
        Logging.$init$((Logging)this);
    }
}

