/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.gate.TargetIdResolutionFailedException;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers$PhaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$ReleaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$TaskId$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions$;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u0013'\u0001=B\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003Q\u0011!!\u0006A!b\u0001\n\u0003)\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011i\u0003!Q1A\u0005\u0002mC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tA\u0002\u0011)\u0019!C\u0001C\"A\u0001\u000e\u0001B\u0001B\u0003%!\r\u0003\u0005j\u0001\t\u0015\r\u0011\"\u0001k\u0011!q\u0007A!A!\u0002\u0013Y\u0007\u0002C8\u0001\u0005\u000b\u0007I\u0011\u00019\t\u0011Q\u0004!\u0011!Q\u0001\nED\u0001\"\u001e\u0001\u0003\u0006\u0004%\tA\u001e\u0005\tu\u0002\u0011\t\u0011)A\u0005o\")1\u0010\u0001C\u0001y\"I\u00111\u0006\u0001C\u0002\u0013\u0005\u0011Q\u0006\u0005\t\u0003/\u0002\u0001\u0015!\u0003\u00020!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!!3\u0001\t\u0003\tY\rC\u0004\u0002Z\u0002!\t!a7\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"I\u0011\u0011 \u0001\u0012\u0002\u0013%\u00111 \u0005\n\u0005\u001f\u0001\u0011\u0013!C\u0005\u0005#AqA!\u0006\u0001\t\u0003\u00119\u0002C\u0004\u0003 \u0001!\tA!\t\t\u000f\tM\u0002\u0001\"\u0001\u00036!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B*\u0001\u0011\u0005!Q\u000b\u0005\b\u0005_\u0002A\u0011\u0002B9\u0011\u001d\u0011\t\t\u0001C\t\u0005\u0007CqAa\"\u0001\t#\u0011IIA\tEKB,g\u000eZ3oGf\u001cVM\u001d<jG\u0016T!a\n\u0015\u0002\u000fM,'O^5dK*\u0011\u0011FK\u0001\nq2\u0014X\r\\3bg\u0016T!a\u000b\u0017\u0002\u0013a,'-[1mC\n\u001c(\"A\u0017\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001\u0001dGO\u001f\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g!\t9\u0004(D\u0001'\u0013\tIdE\u0001\nSK2,\u0017m]3Ue\u0016,')^5mI\u0016\u0014\bCA\u001c<\u0013\tadE\u0001\u000fEKB,g\u000eZ3oGf\u001c\u0015M\u001c3jI\u0006$XmQ8mY\u0016\u001cGo\u001c:\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015!B:mMRR'\"\u0001\"\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001R \u0003\u000f1{wmZ5oO\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0016\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S!A\u0013\u0015\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002M\u0013\n\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002%I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0015e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0016\u0003A\u0003\"aN)\n\u0005I3#\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-A\u000bsK2,\u0017m]3TK\u0006\u00148\r[*feZL7-\u001a\u0011\u0002%Ad\u0017M\\%uK6\u0014V\r]8tSR|'/_\u000b\u0002-B\u0011\u0001jV\u0005\u00031&\u0013!\u0003\u00157b]&#X-\u001c*fa>\u001c\u0018\u000e^8ss\u0006\u0019\u0002\u000f\\1o\u0013R,WNU3q_NLGo\u001c:zA\u0005!B-\u001a9f]\u0012,gnY=SKB|7/\u001b;pef,\u0012\u0001\u0018\t\u0003\u0011vK!AX%\u0003)\u0011+\u0007/\u001a8eK:\u001c\u0017PU3q_NLGo\u001c:z\u0003U!W\r]3oI\u0016t7-\u001f*fa>\u001c\u0018\u000e^8ss\u0002\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011Q\rK\u0001\u0007KZ,g\u000e^:\n\u0005\u001d$'!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z+\u0005Y\u0007C\u0001%m\u0013\ti\u0017J\u0001\bUCN\\'+\u001a9pg&$xN]=\u0002\u001fQ\f7o\u001b*fa>\u001c\u0018\u000e^8ss\u0002\n1bY5JIN+'O^5dKV\t\u0011\u000f\u0005\u00028e&\u00111O\n\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0007dS&#7+\u001a:wS\u000e,\u0007%\u0001\tbe\u000eD\u0017N^5oON+'O^5dKV\tq\u000f\u0005\u00028q&\u0011\u0011P\n\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\f\u0011#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3!\u0003\u0019a\u0014N\\5u}QyQP`@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY\u0001\u0005\u00028\u0001!)Q)\u0005a\u0001\u000f\")a*\u0005a\u0001!\")A+\u0005a\u0001-\")!,\u0005a\u00019\")\u0001-\u0005a\u0001E\")\u0011.\u0005a\u0001W\")q.\u0005a\u0001c\")Q/\u0005a\u0001o\"\u001a\u0011#a\u0004\u0011\t\u0005E\u0011qE\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005e\u00111D\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\ti\"a\b\u0002\u000b\t,\u0017M\\:\u000b\t\u0005\u0005\u00121E\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011QE\u0001\u0004_J<\u0017\u0002BA\u0015\u0003'\u0011\u0011\"Q;u_^L'/\u001a3\u00021\u0005\u001cG/\u001b<f\t\u0016\u0004XM\u001c3f]\u000eL8\u000b^1ukN,7/\u0006\u0002\u00020A1\u0011\u0011GA!\u0003\u000frA!a\r\u0002>9!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:9\na\u0001\u0010:p_Rt\u0014\"A\u001a\n\u0007\u0005}\"'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0013Q\t\u0002\u0004'\u0016\f(bAA eA!\u0011\u0011JA)\u001d\u0011\tY%!\u0014\u0011\u0007\u0005U\"'C\u0002\u0002PI\na\u0001\u0015:fI\u00164\u0017\u0002BA*\u0003+\u0012aa\u0015;sS:<'bAA(e\u0005I\u0012m\u0019;jm\u0016$U\r]3oI\u0016t7-_*uCR,8/Z:!\u0003\u0019\u0019'/Z1uKR1\u0011QLA5\u0003g\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003GB\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002h\u0005\u0005$A\u0003#fa\u0016tG-\u001a8ds\"9\u00111\u000e\u000bA\u0002\u00055\u0014\u0001B4bi\u0016\u0004B!a\u0018\u0002p%!\u0011\u0011OA1\u0005!9\u0015\r^3UCN\\\u0007bBA;)\u0001\u0007\u0011qI\u0001\u0013i\u0006\u0014x-\u001a;JI>\u0013h+\u0019:jC\ndW\rK\u0002\u0015\u0003s\u0002B!a\u001f\u0002\b6\u0011\u0011Q\u0010\u0006\u0005\u0003+\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015aB7fiJL7m\u001d\u0006\u0004\u0003\u000bc\u0013\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005%\u0015Q\u0010\u0002\u0006)&lW\rZ\u0001\rkB$\u0017\r^3UCJ<W\r\u001e\u000b\u0007\u0003;\ny)a%\t\u000f\u0005EU\u00031\u0001\u0002H\u0005aA-\u001a9f]\u0012,gnY=JI\"9\u0011QO\u000bA\u0002\u0005\u001d\u0003fA\u000b\u0002z\u00051A-\u001a7fi\u0016$B!a'\u0002\"B\u0019\u0011'!(\n\u0007\u0005}%G\u0001\u0003V]&$\bbBAR-\u0001\u0007\u0011qI\u0001\u0003S\u0012D3AFA=\u0003U9W\r^\"p[BdW\r^1cY\u0016<\u0015\r^3JIN$B!a+\u0002<B1\u0011QVA\\\u0003\u000fj!!a,\u000b\t\u0005E\u00161W\u0001\u0005kRLGN\u0003\u0002\u00026\u0006!!.\u0019<b\u0013\u0011\tI,a,\u0003\u0015\r{G\u000e\\3di&|g\u000eC\u0004\u0002>^\u0001\r!a0\u0002\u000fQ\f'oZ3ugB1\u0011QVA\\\u0003\u0003\u0004B!a\u0018\u0002D&!\u0011QYA1\u0005!\u0001F.\u00198Ji\u0016l\u0007fA\f\u0002z\u0005Ib-\u001b8e\u0003\u000e$\u0018N^3J]\u000e|W.\u001b8h\u000f\u0006$X-\u00133t)\u0011\ti-a5\u0011\r\u00055\u0016qZA$\u0013\u0011\t\t.a,\u0003\t1K7\u000f\u001e\u0005\b\u0003+D\u0002\u0019AA$\u0003!\u0001\u0018M]3oi&#\u0007f\u0001\r\u0002z\u0005\u0011r-\u001a;GC&d\u0017M\u00197f\u000f\u0006$X-\u00133t)\u0011\tY+!8\t\u000f\u0005}\u0017\u00041\u0001\u0002@\u0006q\u0011MY8si\u0016$G+\u0019:hKR\u001c\bfA\r\u0002z\u0005ab-\u001b8e\u00032d\u0017J\\2p[&tw\rR3qK:$WM\\2z\u0013\u0012\u001cH\u0003CA\u0018\u0003O\fY/a<\t\u000f\u0005%(\u00041\u0001\u00020\u0005IA/\u0019:hKRLEm\u001d\u0005\n\u0003[T\u0002\u0013!a\u0001\u0003_\t\u0001b\u001d;biV\u001cXm\u001d\u0005\n\u0003cT\u0002\u0013!a\u0001\u0003g\f1C]3gKJ,gnY5oO\u000eC\u0017\u000e\u001c3sK:\u00042!MA{\u0013\r\t9P\r\u0002\b\u0005>|G.Z1o\u0003\u00192\u0017N\u001c3BY2LenY8nS:<G)\u001a9f]\u0012,gnY=JIN$C-\u001a4bk2$HEM\u000b\u0003\u0003{TC!a\f\u0002\u0000.\u0012!\u0011\u0001\t\u0005\u0005\u0007\u0011Y!\u0004\u0002\u0003\u0006)!!q\u0001B\u0005\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0016IJAA!\u0004\u0003\u0006\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002M\u0019Lg\u000eZ!mY&s7m\\7j]\u001e$U\r]3oI\u0016t7-_%eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0014)\"\u00111_A\u0000\u0003m1\u0017N\u001c3BGRLg/Z(vi\u001e|\u0017N\\4UCJ<W\r^%egR!\u0011Q\u001aB\r\u0011\u001d\u0011Y\"\ba\u0001\u0003\u000f\n\u0011B]3mK\u0006\u001cX-\u00133)\u0007u\tI(\u0001\bhKR\u0014V\r\\3bg\u0016$&/Z3\u0015\t\t\r\"q\u0006\t\u0005\u0005K\u0011Y#\u0004\u0002\u0003()\u0019!\u0011\u0006\u0015\u0002\u000bYLWm^:\n\t\t5\"q\u0005\u0002\f%\u0016dW-Y:f)J,W\rC\u0004\u0003\u001cy\u0001\r!a\u0012)\u0007y\tI(A\u000eva\u0012\fG/Z$bi\u0016\u0014VMZ3sK:\u001c\u0017N\\4QQ\u0006\u001cXm\u001d\u000b\u0007\u00037\u00139Da\u000f\t\u000f\ter\u00041\u0001\u0002H\u00051q-\u0019;f\u0013\u0012DqA!\u0010 \u0001\u0004\u0011y$\u0001\tpe&<\u0017N\u001c+p%\u0016\u001cHo\u001c:fIBA\u0011Q\u0016B!\u0003\u0003\f\t-\u0003\u0003\u0003D\u0005=&aA'ba\"\u001aq$!\u001f\u0002'\u0005\u00148\r[5wK\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\r\u0005m%1\nB'\u0011\u001d\u0011Y\u0002\ta\u0001\u0003\u000fBqAa\u0014!\u0001\u0004\ty#A\u0007eKB,g\u000eZ3oGfLEm\u001d\u0015\u0004A\u0005e\u0014A\b4j]\u0012$U\r]3oI\u0016t7-\u001f+be\u001e,GOQ=UCJ<W\r^%e+\u0011\u00119F!\u0018\u0015\t\te#\u0011\u000e\t\u0005\u00057\u0012i\u0006\u0004\u0001\u0005\u000f\t}\u0013E1\u0001\u0003b\t\tA+\u0005\u0003\u0003d\u0005\u0005\u0007cA\u0019\u0003f%\u0019!q\r\u001a\u0003\u000f9{G\u000f[5oO\"9!1N\u0011A\u0002\u0005\u001d\u0013\u0001\u0003;be\u001e,G/\u00133)\u0007\u0005\nI(\u0001\tgS:$\u0007\u000b\\1o\u0013R,WNQ=JIV!!1\u000fB?)\u0011\u0011)Ha \u0011\u000bE\u00129Ha\u001f\n\u0007\te$G\u0001\u0004PaRLwN\u001c\t\u0005\u00057\u0012i\bB\u0004\u0003`\t\u0012\rA!\u0019\t\u000f\t-$\u00051\u0001\u0002H\u0005ib-\u001b8e\u0013:\u0004&o\\4sKN\u001c\u0018J\\2p[&twmR1uK&#7\u000f\u0006\u0003\u00020\t\u0015\u0005bBAuG\u0001\u0007\u0011qF\u0001\u000bSN$V-\u001c9mCR,G\u0003BAz\u0005\u0017Cq!!%%\u0001\u0004\t9\u0005K\u0002\u0001\u0005\u001f\u0003BA!%\u0003\u00186\u0011!1\u0013\u0006\u0005\u0005+\u000by\"\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!'\u0003\u0014\n91+\u001a:wS\u000e,\u0007")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final XLReleaseEventBus eventBus;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    @Timed
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        void var3_3;
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return var3_3;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(String id) {
        Dependency dependency = this.dependencyRepository().findById(id);
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public Collection<String> getCompletableGateIds(Collection<PlanItem> targets) {
        Seq doneTargetIds = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(targets).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone()))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.findInProgressIncomingGateIds((Seq<String>)doneTargetIds).map((Function1 & Serializable & scala.Serializable)id -> (GateTask)this.taskRepository().findById((String)id), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isCompletable()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    public List<String> findActiveIncomingGateIds(String parentId) {
        Seq seq;
        if (this.planItemRepository().exists(parentId)) {
            seq = (Seq)((SeqLike)((TraversableLike)this.findAllIncomingDependencyIds((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable & scala.Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Plan item ").append(parentId).append(" not found. It is either archived, or does not exist. Returning no dependencies").toString());
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava();
    }

    @Timed
    public Collection<String> getFailableGateIds(Collection<PlanItem> abortedTargets) {
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.findInProgressIncomingGateIds((Seq<String>)((Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(abortedTargets).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getId(), Seq$.MODULE$.canBuildFrom())))).asJava();
    }

    private Seq<String> findAllIncomingDependencyIds(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren) {
        return (Seq)this.dependencyRepository().findAllIncomingDependencies(targetIds, statuses, referencingChildren).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getId(), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> findAllIncomingDependencyIds$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private boolean findAllIncomingDependencyIds$default$3() {
        return false;
    }

    @Timed
    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.dependencyRepository().findByReleaseId(releaseId)).asScala()).filter((Function1 & Serializable & scala.Serializable)dep -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$findActiveOutgoingTargetIds$1(dep)))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getTargetId(), Buffer$.MODULE$.canBuildFrom())).distinct()).asJava();
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.archivingService().exists(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = Map$.MODULE$.empty();
            Release release = this.releaseRepository().findById(releaseId);
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    @Timed
    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                Dependency updatedDependency = this.dependencyRepository().update(release, (Dependency)dependency);
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, updatedDependency));
            }
        });
    }

    @Timed
    public void archiveDependencies(String releaseId, Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(referencingRelease.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$9.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (Seq<Dependency>)dependenciesToArchive);
    }

    @Timed
    public <T extends PlanItem> T findDependencyTargetByTargetId(String targetId) {
        PlanItem planItem;
        String string = targetId;
        Option<String> option = IdMatchers$ReleaseId$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.archivingService().getRelease(targetId));
        } else {
            Option<String> option2 = IdMatchers$PhaseId$.MODULE$.unapply(string);
            if (!option2.isEmpty()) {
                planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.archivingService().getPhase(targetId));
            } else {
                Option<String> option3 = IdMatchers$TaskId$.MODULE$.unapply(string);
                if (!option3.isEmpty()) {
                    planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.archivingService().getTask(targetId));
                } else {
                    throw new TargetIdResolutionFailedException(new StringBuilder(35).append("Target is not plan item, targetId= ").append(targetId).toString());
                }
            }
        }
        return (T)planItem;
    }

    private <T extends PlanItem> Option<T> findPlanItemById(String targetId) {
        Some some;
        try {
            some = new Some(this.planItemRepository().findById(targetId, ResolveOptions$.MODULE$.MINIMAL()));
        }
        catch (NotFoundException notFoundException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public Seq<String> findInProgressIncomingGateIds(Seq<String> targetIds) {
        return (Seq)((SeqLike)this.findAllIncomingDependencyIds(targetIds, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$findActiveOutgoingTargetIds$1(Dependency dep) {
        return dep.hasResolvedTarget() && !dep.isDone();
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, XLReleaseEventBus eventBus, TaskRepository taskRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (Seq)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).toSeq().$colon$plus((Object)TaskStatus.PLANNED, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom());
    }
}

