/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.calendar.CalendarEntry;
import com.xebialabs.xlrelease.domain.calendar.SpecialDay;
import com.xebialabs.xlrelease.domain.events.BlackoutCreatedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u000b\u0017\u0001}A\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tm\u0001\u0011\t\u0011)A\u0005a!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003:\u0011!q\u0004A!b\u0001\n\u0003y\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b\u001d\u0003A\u0011\u0001%\t\u000bq\u0003A\u0011A/\t\u000bu\u0004A\u0011\u0001@\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u0016\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011q\u000f\u0001\u0005\u0002\u0005\u0005\u0005bBAE\u0001\u0011%\u00111\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0005=\u0019\u0015\r\\3oI\u0006\u00148+\u001a:wS\u000e,'BA\f\u0019\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0007\u000e\u0002\u0013ad'/\u001a7fCN,'BA\u000e\u001d\u0003%AXMY5bY\u0006\u00147OC\u0001\u001e\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013!B:mMRR'\"A\u0016\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\f\u0015\u0003\u000f1{wmZ5oO\u000692-\u00197f]\u0012\f'/\u00128uef\u0014V\r]8tSR|'/_\u000b\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\u00111\u0007G\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001b3\u0005]\u0019\u0015\r\\3oI\u0006\u0014XI\u001c;ssJ+\u0007o\\:ji>\u0014\u00180\u0001\rdC2,g\u000eZ1s\u000b:$(/\u001f*fa>\u001c\u0018\u000e^8ss\u0002\n1bY5JIN+'O^5dKV\t\u0011\b\u0005\u0002;w5\ta#\u0003\u0002=-\tY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003!)g/\u001a8u\u0005V\u001cX#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rC\u0012AB3wK:$8/\u0003\u0002F\u0005\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003J\u0015.c\u0005C\u0001\u001e\u0001\u0011\u0015qs\u00011\u00011\u0011\u00159t\u00011\u0001:\u0011\u0015qt\u00011\u0001AQ\t9a\n\u0005\u0002P56\t\u0001K\u0003\u0002R%\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005M#\u0016a\u00024bGR|'/\u001f\u0006\u0003+Z\u000bQAY3b]NT!a\u0016-\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!W\u0001\u0004_J<\u0017BA.Q\u0005%\tU\u000f^8xSJ,G-A\u0007hKR\u001c\u0006/Z2jC2$\u0015-\u001f\u000b\u0003=\u001a\u0004\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\u0011\r\fG.\u001a8eCJT!a\u0019\r\u0002\r\u0011|W.Y5o\u0013\t)\u0007M\u0001\u0006Ta\u0016\u001c\u0017.\u00197ECfDQa\u001a\u0005A\u0002!\fAb\u001d9fG&\fG\u000eR1z\u0013\u0012\u0004\"!\u001b9\u000f\u0005)t\u0007CA6#\u001b\u0005a'BA7\u001f\u0003\u0019a$o\\8u}%\u0011qNI\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002pE!\u0012\u0001\u0002\u001e\t\u0003knl\u0011A\u001e\u0006\u0003#^T!\u0001_=\u0002\u000f5,GO]5dg*\u0011!\u0010H\u0001\tG>$\u0017\r[1mK&\u0011AP\u001e\u0002\u0006)&lW\rZ\u0001\u000eg\u0016$8\u000b]3dS\u0006dG)Y=\u0015\ty{\u0018\u0011\u0001\u0005\u0006O&\u0001\r\u0001\u001b\u0005\u0007\u0003\u0007I\u0001\u0019\u00010\u0002\u0015M\u0004XmY5bY\u0012\u000b\u0017\u0010\u000b\u0002\ni\u0006qq-\u001a;Ta\u0016\u001c\u0017.\u00197ECf\u001cHCBA\u0006\u00037\t)\u0003E\u0003\u0002\u000e\u0005]a,\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\u0011)H/\u001b7\u000b\u0005\u0005U\u0011\u0001\u00026bm\u0006LA!!\u0007\u0002\u0010\t!A*[:u\u0011\u001d\tiB\u0003a\u0001\u0003?\tAA\u001a:p[B!\u0011QBA\u0011\u0013\u0011\t\u0019#a\u0004\u0003\t\u0011\u000bG/\u001a\u0005\b\u0003OQ\u0001\u0019AA\u0010\u0003\t!x\u000e\u000b\u0002\u000bi\u0006Y\u0011\r\u001a3CY\u0006\u001c7n\\;u)\u0011\ty#!\u000e\u0011\u0007}\u000b\t$C\u0002\u00024\u0001\u0014\u0001B\u00117bG.|W\u000f\u001e\u0005\b\u0003oY\u0001\u0019AA\u0018\u0003!\u0011G.Y2l_V$\bFA\u0006u)\u0019\ty#!\u0010\u0002B!1\u0011q\b\u0007A\u0002!\f\u0001\u0002]1sK:$\u0018\n\u001a\u0005\b\u0003oa\u0001\u0019AA\u0018Q\taA/\u0001\bva\u0012\fG/\u001a\"mC\u000e\\w.\u001e;\u0015\t\u0005=\u0012\u0011\n\u0005\b\u0003\u0017j\u0001\u0019AA\u0018\u0003\u001d)\b\u000fZ1uK\u0012D#!\u0004;\u0002\u001d\u0011,G.\u001a;f\u00052\f7m[8viR!\u00111KA-!\r\t\u0013QK\u0005\u0004\u0003/\u0012#\u0001B+oSRDa!a\u0017\u000f\u0001\u0004A\u0017A\u00032mC\u000e\\w.\u001e;JI\"\u0012a\u0002^\u0001\fO\u0016$(\t\\1dW>,H\u000f\u0006\u0003\u00020\u0005\r\u0004BBA.\u001f\u0001\u0007\u0001\u000e\u000b\u0002\u0010i\u0006a\u0011n]%o\u00052\f7m[8viR!\u00111NA9!\r\t\u0013QN\u0005\u0004\u0003_\u0012#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003g\u0002\u0002\u0019AA\u0010\u0003\rqwn\u001e\u0015\u0003!Q\fAbZ3u\u00052\f7m[8viN$B!a\u001f\u0002~A1\u0011QBA\f\u0003_Aq!a\u001d\u0012\u0001\u0004\ty\u0002\u000b\u0002\u0012iR1\u00111PAB\u0003\u000bCq!!\b\u0013\u0001\u0004\ty\u0002C\u0004\u0002(I\u0001\r!a\b)\u0005I!\u0018\u0001C:fi\u0012\u000bG/Z:\u0015\r\u0005M\u0013QRAI\u0011\u0019\tyi\u0005a\u0001Q\u0006\u0011\u0011\u000e\u001a\u0005\u0007\u0003\u0007\u0019\u0002\u0019\u00010\u0002\u0011Y\fG.\u001b3bi\u0016$B!a\u0015\u0002\u0018\"9\u0011q\u0007\u000bA\u0002\u0005=\u0002f\u0001\u0001\u0002\u001cB!\u0011QTAR\u001b\t\tyJC\u0002\u0002\"Z\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t)+a(\u0003\u000fM+'O^5dK\u0002")
public class CalendarService
implements Logging {
    private final CalendarEntryRepository calendarEntryRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CalendarService calendarService = this;
        synchronized (calendarService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public CalendarEntryRepository calendarEntryRepository() {
        return this.calendarEntryRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public SpecialDay getSpecialDay(String specialDayId) {
        SpecialDay specialDay;
        if (!this.calendarEntryRepository().exists(specialDayId)) {
            void var2_2;
            SpecialDay result = new SpecialDay();
            result.setId(specialDayId);
            this.setDates(specialDayId, result);
            specialDay = var2_2;
        } else {
            specialDay = (SpecialDay)this.calendarEntryRepository().findById(specialDayId);
        }
        return specialDay;
    }

    @Timed
    public SpecialDay setSpecialDay(String specialDayId, SpecialDay specialDay) {
        if (specialDay.isBlank()) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Removing special day [").append(specialDayId).append("]").toString());
            if (this.calendarEntryRepository().exists(specialDayId)) {
                this.calendarEntryRepository().delete(specialDayId);
            }
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Saving special day [").append(specialDayId).append("] with label [").append(specialDay.getLabel()).append("] and color [").append(specialDay.getColor()).append("]").toString());
            specialDay.setId(specialDayId);
            this.setDates(specialDayId, specialDay);
            this.calendarEntryRepository().createOrUpdate((CalendarEntry)specialDay);
        }
        return specialDay;
    }

    @Timed
    public List<SpecialDay> getSpecialDays(Date from, Date to) {
        return this.calendarEntryRepository().findAllByTypeInRange(Type.valueOf(SpecialDay.class), from, to);
    }

    @Timed
    public Blackout addBlackout(Blackout blackout) {
        return this.addBlackout(Ids.CALENDAR_ROOT, blackout);
    }

    @Timed
    public Blackout addBlackout(String parentId, Blackout blackout) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Adding new blackout [").append(blackout.getLabel()).append(" for period [").append(blackout.getStartDate()).append("] - [").append(blackout.getEndDate()).append("] to parent [").append(parentId).append("]").toString());
        this.validate(blackout);
        blackout.setId(this.ciIdService().getUniqueId(Type.valueOf(Blackout.class), parentId));
        this.calendarEntryRepository().create((CalendarEntry)blackout);
        this.eventBus().publish((XLReleaseEvent)new BlackoutCreatedEvent(blackout));
        return blackout;
    }

    @Timed
    public Blackout updateBlackout(Blackout updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Updating blackout [").append(updated.getId()).append("]").toString());
        this.validate(updated);
        Blackout original = (Blackout)this.calendarEntryRepository().findById(updated.getId());
        this.calendarEntryRepository().update((CalendarEntry)updated);
        this.eventBus().publish((XLReleaseEvent)new BlackoutUpdatedEvent(original, updated));
        return updated;
    }

    @Timed
    public void deleteBlackout(String blackoutId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Deleting blackout [").append(blackoutId).append("]").toString());
        Blackout blackout = (Blackout)this.calendarEntryRepository().findById(blackoutId);
        this.calendarEntryRepository().delete(blackoutId);
        this.eventBus().publish((XLReleaseEvent)new BlackoutDeletedEvent(blackout));
    }

    @Timed
    public Blackout getBlackout(String blackoutId) {
        return (Blackout)this.calendarEntryRepository().findById(blackoutId);
    }

    @Timed
    public boolean isInBlackout(Date now) {
        return this.calendarEntryRepository().existsByTypeInRange(Type.valueOf(Blackout.class), now, now);
    }

    @Timed
    public List<Blackout> getBlackouts(Date now) {
        return this.getBlackouts(now, now);
    }

    @Timed
    public List<Blackout> getBlackouts(Date from, Date to) {
        return this.calendarEntryRepository().findAllByTypeInRange(Type.valueOf(Blackout.class), from, to);
    }

    private void setDates(String id, SpecialDay specialDay) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            dateFormat.setLenient(false);
            DateTime specialDayDate = new DateTime((Object)dateFormat.parse(Ids.getName((String)id)));
            specialDay.setStartDate(specialDayDate.withTimeAtStartOfDay().toDate());
            specialDay.setEndDate(specialDayDate.withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).toDate());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(81).append("Special day ID [").append(id).append("] does not have a valid format - Configuration/Calendar/").append("yyyyMMdd").append(".").toString(), e);
        }
    }

    private void validate(Blackout blackout) {
        Checks.checkNotNull((Object)blackout.getLabel(), (String)"Blackout label");
        Checks.checkNotNull((Object)blackout.getStartDate(), (String)"Blackout start date");
        Checks.checkNotNull((Object)blackout.getEndDate(), (String)"Blackout end date");
        Checks.checkArgument((boolean)blackout.getStartDate().before(blackout.getEndDate()), (String)"Blackout end date must be after start date.", (Object[])new Object[0]);
    }

    @Autowired
    public CalendarService(CalendarEntryRepository calendarEntryRepository, CiIdService ciIdService, XLReleaseEventBus eventBus) {
        this.calendarEntryRepository = calendarEntryRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

