/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RepositoryInitializer;
import com.xebialabs.deployit.upgrade.UpgradeRejectedException;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.xlplatform.spring.JythonBindingsHolder;
import com.xebialabs.xlplatform.upgrade.UpgraderHelper;
import com.xebialabs.xlrelease.actors.cluster.XlrActorSystem;
import com.xebialabs.xlrelease.actors.initializer.SubscriptionInitializer;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.XLReleaseServiceHolder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.db.XLReleaseDbInitializer;
import com.xebialabs.xlrelease.script.bindings.SecurityApiBinding;
import com.xebialabs.xlrelease.service.MissingTypesChecker;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeLiquibaseUpgrade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"permissionCheckerHolder"})
public class ServiceStarter {
    private final Upgrader upgrader;
    private final RepositoryInitializer repositoryInitializer;
    private final XlrActorSystem xlrActorSystem;
    private final XlrConfig xlrConfig;
    private final MissingTypesChecker missingTypesChecker;
    private XLReleaseDbInitializer xlrMigrationsDbInitializer;
    private XLReleaseDbInitializer xlrRepositoryDbInitializer;
    private XLReleaseDbInitializer reportingDbInitializer;
    private BeforeLiquibaseUpgrade beforeLiquibaseUpgrade;
    private List<? extends ApiService> apiServices;
    private List<? extends SubscriptionInitializer> subscriptionInitializers = new ArrayList<SubscriptionInitializer>();
    private static final Logger logger = LoggerFactory.getLogger(ServiceStarter.class);

    @Autowired
    public ServiceStarter(Upgrader upgrader, RepositoryInitializer repositoryInitializer, XlrActorSystem xlrActorSystem, XlrConfig xlrConfig, MissingTypesChecker missingTypesChecker, BeforeLiquibaseUpgrade beforeLiquibaseUpgrade, @Qualifier(value="xlrMigrationsDbInitializer") XLReleaseDbInitializer xlrMigrationsDbInitializer, @Qualifier(value="xlrRepositoryDbInitializer") XLReleaseDbInitializer xlrRepositoryDbInitializer, @Qualifier(value="reportingDbInitializer") XLReleaseDbInitializer reportingDbInitializer) {
        this.upgrader = upgrader;
        this.repositoryInitializer = repositoryInitializer;
        this.xlrActorSystem = xlrActorSystem;
        this.xlrConfig = xlrConfig;
        this.missingTypesChecker = missingTypesChecker;
        this.beforeLiquibaseUpgrade = beforeLiquibaseUpgrade;
        this.xlrMigrationsDbInitializer = xlrMigrationsDbInitializer;
        this.xlrRepositoryDbInitializer = xlrRepositoryDbInitializer;
        this.reportingDbInitializer = reportingDbInitializer;
    }

    @Autowired
    public void setApiServices(List<? extends ApiService> apiServices) {
        this.apiServices = apiServices;
    }

    @Autowired(required=false)
    public void setSubscriptionInitializers(List<? extends SubscriptionInitializer> subscriptionInitializers) {
        subscriptionInitializers.sort(Comparator.comparingInt(Ordered::getOrder));
        this.subscriptionInitializers = subscriptionInitializers;
    }

    @PostConstruct
    public void startServices() {
        Version xlrDataVersion;
        boolean shutdown = false;
        XLReleaseServiceHolder.init(this.apiServices);
        this.initEndpointsJythonBindings(this.apiServices);
        this.logScriptSecurityOptions();
        try {
            xlrDataVersion = this.upgrader.getComponentVersion("xl-release");
        }
        catch (RuntimeException e) {
            xlrDataVersion = null;
        }
        if (xlrDataVersion != null) {
            List allUpgrades = (List)this.upgrader.findUpgrades().get("xl-release");
            List upgrades = UpgraderHelper.filterApplicable((List)allUpgrades, (Version)xlrDataVersion);
            allUpgrades.clear();
            if (!upgrades.isEmpty()) {
                try {
                    this.upgrader.askForUpgrade();
                }
                catch (UpgradeRejectedException e) {
                    shutdown = true;
                }
            }
        }
        if (!shutdown) {
            this.beforeLiquibaseUpgrade.init();
            logger.info("Initializing databases.");
            this.xlrMigrationsDbInitializer.init();
            this.xlrRepositoryDbInitializer.init();
            this.reportingDbInitializer.init();
            this.repositoryInitializer.initializeComponents();
            this.upgrader.autoUpgrade();
            this.missingTypesChecker.cleanup();
            this.missingTypesChecker.disableMissingWebhookEventTypes();
            this.xlrActorSystem.boot();
            this.subscriptionInitializers.forEach(SubscriptionInitializer::initialize);
        }
    }

    private void initEndpointsJythonBindings(List<? extends ApiService> apiServices) {
        HashMap<String, SecurityApiBinding> bindings = new HashMap<String, SecurityApiBinding>();
        bindings.put(SecurityApiBinding.NAME, new SecurityApiBinding());
        apiServices.forEach(apiService -> bindings.put(apiService.serviceName(), (SecurityApiBinding)apiService));
        JythonBindingsHolder.setBindings(Collections.unmodifiableMap(bindings));
    }

    private void logScriptSecurityOptions() {
        boolean hasSecurityManager = System.getSecurityManager() != null;
        boolean hasScriptSandbox = hasSecurityManager && this.xlrConfig.isScriptSandboxEnabled();
        logger.info("Configuring scripting engine - Java security is {}, script sandbox is {}.", (Object)(hasSecurityManager ? "configured" : "not configured"), (Object)(hasScriptSandbox ? "enabled" : "disabled"));
    }
}

