/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import com.google.common.base.Strings;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationService {
    private AuthenticationManager authenticationManager;
    private UserLastActiveActorService userLastActiveActorService;
    private ThreadLocal<Authentication> authenticationThreadLocal = new ThreadLocal();
    private ThreadLocal<Task> currentScriptTask = new ThreadLocal();
    private ThreadLocal<Release> currentScriptRelease = new ThreadLocal();

    @Autowired
    public AuthenticationService(AuthenticationManager authenticationManager, UserLastActiveActorService userLastActiveActorService) {
        this.authenticationManager = authenticationManager;
        this.userLastActiveActorService = userLastActiveActorService;
    }

    public void loginScriptUser(Task task) {
        Release release = task.getRelease();
        this.currentScriptTask.set(task);
        this.loginScriptUser(release);
    }

    public void loginScriptUser(Release release) {
        this.currentScriptRelease.set(release);
        String scriptUser = release.getScriptUsername();
        String scriptUserPassword = PasswordEncrypter.getInstance().ensureDecrypted(release.getScriptUserPassword());
        this.authenticationThreadLocal.set(SecurityContextHolder.getContext().getAuthentication());
        if (!Strings.isNullOrEmpty((String)scriptUser)) {
            if (Strings.isNullOrEmpty((String)scriptUserPassword)) {
                throw new IllegalArgumentException(String.format("'Password' property has to be set to run automated tasks as '%s'", scriptUser));
            }
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)scriptUser, (Object)scriptUserPassword);
            Authentication authentication = this.authenticationManager.authenticate((Authentication)usernamePasswordAuthenticationToken);
            this.userLastActiveActorService.updateLastActive(scriptUser);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
    }

    public void logoutScriptUser() {
        SecurityContextHolder.getContext().setAuthentication(this.authenticationThreadLocal.get());
        this.authenticationThreadLocal.remove();
        this.currentScriptRelease.remove();
        this.currentScriptTask.remove();
    }

    public boolean isInScriptTask() {
        return this.currentScriptRelease.get() != null;
    }

    public boolean hasScriptTask() {
        return this.currentScriptTask.get() != null;
    }

    @NonNull
    public Task getCurrentScriptTask() {
        if (!this.isInScriptTask()) {
            throw new IllegalStateException("Current authentication context is not a script task");
        }
        if (this.currentScriptTask.get() == null) {
            throw new IllegalStateException("Script task not available in this context");
        }
        return this.currentScriptTask.get();
    }

    @NonNull
    public Release getCurrentScriptRelease() {
        if (!this.isInScriptTask()) {
            throw new IllegalStateException("Current authentication context is not a script task");
        }
        return this.currentScriptRelease.get();
    }
}

