/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.CommentView;
import com.xebialabs.xlrelease.views.converters.CommentViewConverter;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/comments")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class CommentResource {
    private ReleaseActorService releaseActorService;
    private PermissionChecker permissions;
    private CommentViewConverter commentViewConverter;

    @Autowired
    public CommentResource(ReleaseActorService releaseActorService, PermissionChecker permissions, CommentViewConverter commentViewConverter) {
        this.releaseActorService = releaseActorService;
        this.permissions = permissions;
        this.commentViewConverter = commentViewConverter;
    }

    @PUT
    @Timed
    @Path(value="{commentId}")
    public CommentView updateComment(@PathParam(value="commentId") @IdParam String commentId, CommentView commentView) {
        String taskId = Ids.getParentId((String)commentId);
        this.permissions.checkIsAllowedToCommentOnTask(taskId);
        String releaseId = Ids.releaseIdFrom((String)taskId);
        if (this.permissions.canEditTask(releaseId) || commentView.getAuthor().getUsername().equalsIgnoreCase(User.AUTHENTICATED_USER.getName())) {
            Comment comment = this.releaseActorService.updateComment(commentId, commentView.getText());
            return this.commentViewConverter.toFullView(comment);
        }
        throw PermissionDeniedException.withMessage((String)String.format("You cannot comment on task [%s]", taskId));
    }
}

