/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.validators;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.forms.PasswordValidationResult;
import com.xebialabs.xlrelease.api.v1.forms.UserAccount;
import com.xebialabs.xlrelease.domain.validators.Invalid;
import com.xebialabs.xlrelease.domain.validators.StringValidator;
import com.xebialabs.xlrelease.domain.validators.UserAccountValidator$;
import com.xebialabs.xlrelease.domain.validators.Valid;
import com.xebialabs.xlrelease.domain.validators.ValidationResult;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dq!\u0002\b\u0010\u0011\u0003Qb!\u0002\u000f\u0010\u0011\u0003i\u0002\"\u0002\u0013\u0002\t\u0003)\u0003\"\u0002\u0014\u0002\t\u00039c\u0001\u0002\u000f\u0010\u0001aB\u0001\"\u000f\u0003\u0003\u0006\u0004%\tA\u000f\u0005\t}\u0011\u0011\t\u0011)A\u0005w!)A\u0005\u0002C\u0001\u007f!)\u0011\u000b\u0002C\u0001%\")!\r\u0002C\u0001G\")Q\r\u0002C\u0001M\")Q\r\u0002C\u0001Q\")1\u000e\u0002C\u0001Y\")\u0011\u0010\u0002C\u0001u\u0006!Rk]3s\u0003\u000e\u001cw.\u001e8u-\u0006d\u0017\u000eZ1u_JT!\u0001E\t\u0002\u0015Y\fG.\u001b3bi>\u00148O\u0003\u0002\u0013'\u00051Am\\7bS:T!\u0001F\u000b\u0002\u0013ad'/\u001a7fCN,'B\u0001\f\u0018\u0003%AXMY5bY\u0006\u00147OC\u0001\u0019\u0003\r\u0019w.\\\u0002\u0001!\tY\u0012!D\u0001\u0010\u0005Q)6/\u001a:BG\u000e|WO\u001c;WC2LG-\u0019;peN\u0011\u0011A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0012aE5t-\u0006d\u0017\u000eZ#nC&d\u0017\t\u001a3sKN\u001cHC\u0001\u0015,!\ty\u0012&\u0003\u0002+A\t9!i\\8mK\u0006t\u0007\"\u0002\u0017\u0004\u0001\u0004i\u0013!B3nC&d\u0007C\u0001\u00186\u001d\ty3\u0007\u0005\u00021A5\t\u0011G\u0003\u000233\u00051AH]8pizJ!\u0001\u000e\u0011\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003i\u0001\u001a\"\u0001\u0002\u0010\u0002#A\f7o]<pe\u00124\u0016\r\\5eCR|'/F\u0001<!\tYB(\u0003\u0002>\u001f\ty1\u000b\u001e:j]\u001e4\u0016\r\\5eCR|'/\u0001\nqCN\u001cxo\u001c:e-\u0006d\u0017\u000eZ1u_J\u0004CC\u0001!B!\tYB\u0001C\u0003:\u000f\u0001\u00071\b\u000b\u0002\b\u0007B\u0011AiT\u0007\u0002\u000b*\u0011aiR\u0001\u000bC:tw\u000e^1uS>t'B\u0001%J\u0003\u001d1\u0017m\u0019;pefT!AS&\u0002\u000b\t,\u0017M\\:\u000b\u00051k\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u00039\u000b1a\u001c:h\u0013\t\u0001VIA\u0005BkR|w/\u001b:fI\u0006)1\r[3dWR\u00111K\u0016\t\u0003?QK!!\u0016\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006/\"\u0001\r\u0001W\u0001\fkN,'/Q2d_VtG\u000f\u0005\u0002ZA6\t!L\u0003\u0002\\9\u0006)am\u001c:ng*\u0011QLX\u0001\u0003mFR!aX\n\u0002\u0007\u0005\u0004\u0018.\u0003\u0002b5\nYQk]3s\u0003\u000e\u001cw.\u001e8u\u00035\u0019\u0007.Z2l+N,'O\\1nKR\u00111\u000b\u001a\u0005\u0006/&\u0001\r\u0001W\u0001\u000eG\",7m\u001b)bgN<xN\u001d3\u0015\u0005M;\u0007\"B,\u000b\u0001\u0004AFCA*j\u0011\u0015Q7\u00021\u0001.\u0003!\u0001\u0018m]:x_J$\u0017\u0001\u0005<bY&$\u0017\r^3QCN\u001cxo\u001c:e)\ti\u0007\u0010E\u0002ogVl\u0011a\u001c\u0006\u0003aF\fA!\u001e;jY*\t!/\u0001\u0003kCZ\f\u0017B\u0001;p\u0005\u0011a\u0015n\u001d;\u0011\u0005e3\u0018BA<[\u0005a\u0001\u0016m]:x_J$g+\u00197jI\u0006$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0006U2\u0001\r!L\u0001\u000bG\",7m[#nC&dGCA*|\u0011\u00159V\u00021\u0001YQ\t!Q\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003Y\u0015AC:uKJ,w\u000e^=qK&\u0019\u0011QA@\u0003\u0013\r{W\u000e]8oK:$\b")
public class UserAccountValidator {
    private final StringValidator passwordValidator;

    public static boolean isValidEmailAddress(String string) {
        return UserAccountValidator$.MODULE$.isValidEmailAddress(string);
    }

    public StringValidator passwordValidator() {
        return this.passwordValidator;
    }

    public void check(UserAccount userAccount) {
        Checks.checkNotNull((Object)userAccount, (String)"User Account can not be null.", (Object[])new Object[]{""});
        this.checkUsername(userAccount);
        this.checkPassword(userAccount);
        this.checkEmail(userAccount);
    }

    public void checkUsername(UserAccount userAccount) {
        block0: {
            Checks.checkArgument((!Strings.isBlank((String)userAccount.getUsername()) ? 1 : 0) != 0, (String)"User name cannot be empty.", (Object[])new Object[0]);
            if (userAccount.isExternal()) break block0;
            Pattern pattern = Pattern.compile("^(?![\\.\\-_])(?!.*[\\.\\-_]{2})[\\w\\.\\-_]*[^\\W_]$", 256);
            Matcher matcher = pattern.matcher(userAccount.getUsername());
            Checks.checkArgument((boolean)matcher.matches(), (String)"All the alphanumeric characters and the special characters dash (-), underscore (_), and dot (.) are allowed. The special characters cannot be repeated more than once in a row. The username must not start or end with a special character.", (Object[])new Object[0]);
        }
    }

    public void checkPassword(UserAccount userAccount) {
        block0: {
            Checks.checkArgument((!Strings.isBlank((String)userAccount.getPassword()) ? 1 : 0) != 0, (String)"Password is required when creating a user.", (Object[])new Object[0]);
            if (userAccount.isExternal()) break block0;
            this.checkPassword(userAccount.getPassword());
        }
    }

    public void checkPassword(String password) {
        List invalids = (List)this.passwordValidator().validate((Object)password).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UserAccountValidator.$anonfun$checkPassword$1(x$1)));
        if (invalids.nonEmpty()) {
            throw new Checks.IncorrectArgumentException(((TraversableOnce)new .colon.colon((Object)"Password needs to meet following requirements:", (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)invalids.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.message(), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).mkString(new StringBuilder(1).append(System.lineSeparator()).append("\t").toString()), new Object[0]);
        }
    }

    public java.util.List<PasswordValidationResult> validatePassword(String password) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((SeqLike)this.passwordValidator().validate((Object)password).map((Function1 & Serializable & scala.Serializable)vr -> new PasswordValidationResult(vr instanceof Valid, vr.message()), List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isValid()), Ordering.Boolean$.MODULE$.reverse())).asJava();
    }

    public void checkEmail(UserAccount userAccount) {
        block0: {
            String email = userAccount.getEmail();
            if (!Strings.isNotBlank((String)email)) break block0;
            Checks.checkArgument((boolean)UserAccountValidator$.MODULE$.isValidEmailAddress(email), (String)new StringBuilder(20).append("Email is malformed: ").append(email).toString(), (Object[])new Object[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkPassword$1(ValidationResult x$1) {
        return x$1 instanceof Invalid;
    }

    @Autowired
    public UserAccountValidator(StringValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }
}

