/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.FolderCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.FolderMovedEvent;
import com.xebialabs.xlrelease.domain.events.FolderMovingAction;
import com.xebialabs.xlrelease.domain.events.FolderRenamedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.TemplateMovingAction;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams$;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r}a\u0001B\u0016-\u0001UB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!A\u0006A!A!\u0002\u0013I\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\"A!\u000f\u0001B\u0001B\u0003%1\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!9\u0011q\n\u0001\u0005\u0002\u0005E\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\n\u0003\u0007\u0003\u0011\u0013!C\u0001\u0003\u000bCq!!'\u0001\t\u0003\tY\nC\u0005\u0002,\u0002\t\n\u0011\"\u0001\u0002.\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006\"CAk\u0001E\u0005I\u0011AAl\u0011\u001d\tY\u000e\u0001C\u0001\u0003;Dq!a:\u0001\t\u0003\tI\u000fC\u0004\u0002t\u0002!\t!!>\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n!I!Q\u0007\u0001\u0012\u0002\u0013\u0005!q\u0007\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0011%\u0011Y\u0005AI\u0001\n\u0003\t9\u000eC\u0004\u0003N\u0001!\tAa\u0014\t\u000f\t5\u0003\u0001\"\u0001\u0003X!9!1\r\u0001\u0005\u0002\t\u0015\u0004b\u0002B6\u0001\u0011%!Q\u000e\u0005\b\u0005o\u0002A\u0011\u0002B=\u0011\u001d\u0011Y\n\u0001C\u0005\u0005;CqAa)\u0001\t\u0013\u0011)\u000bC\u0004\u0003.\u0002!IAa,\t\u000f\tM\u0006\u0001\"\u0003\u00036\"9!1\u0018\u0001\u0005\u0002\tu\u0006b\u0002Bn\u0001\u0011%!Q\u001c\u0005\b\u0005_\u0004A\u0011\u0002By\u0011\u001d\u0019Y\u0001\u0001C\u0005\u0007\u001bAqaa\u0005\u0001\t\u0013\u0019)\u0002C\u0004\u0004\u001a\u0001!Iaa\u0007\u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u0015\tic&A\u0004tKJ4\u0018nY3\u000b\u0005=\u0002\u0014!\u0003=me\u0016dW-Y:f\u0015\t\t$'A\u0005yK\nL\u0017\r\\1cg*\t1'A\u0002d_6\u001c\u0001aE\u0002\u0001mq\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012a!\u00118z%\u00164\u0007CA\u001fC\u001b\u0005q$BA A\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\t\u0015\u0001C4sSjTH.\u001a3\n\u0005\rs$a\u0002'pO\u001eLgnZ\u0001\bM>dG-\u001a:t!\t1\u0015*D\u0001H\u0015\tAe&\u0001\u0006sKB|7/\u001b;pefL!AS$\u0003!\u0019{G\u000eZ3s%\u0016\u0004xn]5u_JL\u0018a\u0003;fC6\u001cVM\u001d<jG\u0016\u0004\"!\u0014(\u000e\u00031J!a\u0014\u0017\u0003\u0017Q+\u0017-\\*feZL7-Z\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bC\u0001$S\u0013\t\u0019vIA\tSK2,\u0017m]3SKB|7/\u001b;pef\f1\u0002^1tWN+'O^5dKB\u0011QJV\u0005\u0003/2\u00121\u0002V1tWN+'O^5dK\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003\rjK!aW$\u0003/\r{gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\u0018aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"!\u00140\n\u0005}c#aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\fAC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,\u0007CA'c\u0013\t\u0019GF\u0001\u000bSK2,\u0017m]3TK\u0006\u00148\r[*feZL7-Z\u0001\fa\u0016\u0014X.[:tS>t7\u000f\u0005\u0002gS6\tqM\u0003\u0002i]\u0005A1/Z2ve&$\u00180\u0003\u0002kO\n\t\u0002+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u0002\u0011\u00154XM\u001c;CkN\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0018\u0002\r\u00154XM\u001c;t\u0013\t\thNA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\f\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0011\u00055#\u0018BA;-\u0005A\t%o\u00195jm&twmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u000fqfT8\u0010`?\u007f\u007f\u0006\u0005\u00111AA\u0003!\ti\u0005\u0001C\u0003E\u0017\u0001\u0007Q\tC\u0003L\u0017\u0001\u0007A\nC\u0003Q\u0017\u0001\u0007\u0011\u000bC\u0003U\u0017\u0001\u0007Q\u000bC\u0003Y\u0017\u0001\u0007\u0011\fC\u0003]\u0017\u0001\u0007Q\fC\u0003a\u0017\u0001\u0007\u0011\rC\u0003e\u0017\u0001\u0007Q\rC\u0003l\u0017\u0001\u0007A\u000eC\u0003s\u0017\u0001\u00071/A\tdQ\u0016\u001c7NR8mI\u0016\u0014X\t_5tiN$B!a\u0003\u0002\u0012A\u0019q'!\u0004\n\u0007\u0005=\u0001H\u0001\u0003V]&$\bbBA\n\u0019\u0001\u0007\u0011QC\u0001\tM>dG-\u001a:JIB!\u0011qCA\u0013\u001d\u0011\tI\"!\t\u0011\u0007\u0005m\u0001(\u0004\u0002\u0002\u001e)\u0019\u0011q\u0004\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019\u0003O\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0012\u0011\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r\u0002\bK\u0002\r\u0003[\u0001B!a\f\u0002>5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0006b]:|G/\u0019;j_:TA!a\u000e\u0002:\u00059Q.\u001a;sS\u000e\u001c(bAA\u001ee\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002@\u0005E\"!\u0002+j[\u0016$\u0017AB3ySN$8\u000f\u0006\u0003\u0002F\u0005-\u0003cA\u001c\u0002H%\u0019\u0011\u0011\n\u001d\u0003\u000f\t{w\u000e\\3b]\"9\u00111C\u0007A\u0002\u0005U\u0001fA\u0007\u0002.\u0005Aq-\u001a;USRdW\r\u0006\u0003\u0002\u0016\u0005M\u0003bBA\n\u001d\u0001\u0007\u0011Q\u0003\u0015\u0004\u001d\u00055\u0012\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\r\u0005m\u00131NA7!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\naAZ8mI\u0016\u0014(bAA3]\u00051Am\\7bS:LA!!\u001b\u0002`\t1ai\u001c7eKJDq!a\u0005\u0010\u0001\u0004\t)\u0002C\u0005\u0002p=\u0001\n\u00111\u0001\u0002r\u0005)A-\u001a9uQB!\u00111OA?\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014\u0001\u00027b]\u001eT!!a\u001f\u0002\t)\fg/Y\u0005\u0005\u0003\u007f\n)HA\u0004J]R,w-\u001a:)\u0007=\ti#\u0001\ngS:$')_%eI\u0011,g-Y;mi\u0012\u0012TCAADU\u0011\t\t(!#,\u0005\u0005-\u0005\u0003BAG\u0003+k!!a$\u000b\t\u0005E\u00151S\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\r9\u0013\u0011\t9*a$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006gS:$')\u001f)bi\"$b!a\u0017\u0002\u001e\u0006\u0005\u0006bBAP#\u0001\u0007\u0011QC\u0001\u0005a\u0006$\b\u000eC\u0005\u0002pE\u0001\n\u00111\u0001\u0002$B\u0019q'!*\n\u0007\u0005\u001d\u0006HA\u0002J]RD3!EA\u0017\u0003Q1\u0017N\u001c3CsB\u000bG\u000f\u001b\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0016\u0016\u0005\u0003G\u000bI)A\nmSN$h+[3xC\ndWMR8mI\u0016\u00148\u000f\u0006\u0005\u00026\u0006\u0005\u0017QYAh!\u0019\t9,!0\u0002\\5\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000bI(\u0001\u0003vi&d\u0017\u0002BA`\u0003s\u0013A\u0001T5ti\"9\u00111Y\nA\u0002\u0005U\u0011\u0001\u00039be\u0016tG/\u00133\t\u000f\u0005\u001d7\u00031\u0001\u0002J\u0006!\u0001/Y4f!\r1\u00151Z\u0005\u0004\u0003\u001b<%\u0001\u0002)bO\u0016D\u0011\"!5\u0014!\u0003\u0005\r!!\u0012\u0002/\u0011,7m\u001c:bi\u0016<\u0016\u000e\u001e5QKJl\u0017n]:j_:\u001c\bfA\n\u0002.\u0005iB.[:u-&,w/\u00192mK\u001a{G\u000eZ3sg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002Z*\"\u0011QIAE\u0003\u0011iwN^3\u0015\r\u0005m\u0013q\\Aq\u0011\u001d\t\u0019\"\u0006a\u0001\u0003+Aq!a9\u0016\u0001\u0004\t)\"A\u0006oK^\u0004\u0016M]3oi&#\u0007fA\u000b\u0002.\u00051!/\u001a8b[\u0016$b!a\u0017\u0002l\u00065\bbBA\n-\u0001\u0007\u0011Q\u0003\u0005\b\u0003_4\u0002\u0019AA\u000b\u0003\u001dqWm\u001e(b[\u0016D3AFA\u0017\u0003=\u0019X-\u0019:dQR+W\u000e\u001d7bi\u0016\u001cHCBA|\u0005\u0003\u0011\u0019\u0001\u0005\u0004\u00028\u0006u\u0016\u0011 \t\u0005\u0003w\fi0\u0004\u0002\u0002d%!\u0011q`A2\u0005\u001d\u0011V\r\\3bg\u0016Dq!a\u0005\u0018\u0001\u0004\t)\u0002C\u0004\u0002H^\u0001\r!!3)\u0007]\ti#\u0001\btK\u0006\u00148\r\u001b*fY\u0016\f7/Z:\u0015\u0011\t-!q\u0003B\r\u0005c\u0001BA!\u0004\u0003\u00145\u0011!q\u0002\u0006\u0004\u0005#q\u0013AB:fCJ\u001c\u0007.\u0003\u0003\u0003\u0016\t=!a\u0005*fY\u0016\f7/Z*fCJ\u001c\u0007NU3tk2$\bbBA\n1\u0001\u0007\u0011Q\u0003\u0005\b\u00057A\u0002\u0019\u0001B\u000f\u0003\u001d1\u0017\u000e\u001c;feN\u0004BAa\b\u0003.5\u0011!\u0011\u0005\u0006\u0005\u0005G\u0011)#A\u0003g_Jl7O\u0003\u0003\u0003(\t%\u0012A\u0001<2\u0015\r\u0011YCL\u0001\u0004CBL\u0017\u0002\u0002B\u0018\u0005C\u0011qBU3mK\u0006\u001cXm\u001d$jYR,'o\u001d\u0005\n\u0003\u000fD\u0002\u0013!a\u0001\u0003\u0013D3\u0001GA\u0017\u0003a\u0019X-\u0019:dQJ+G.Z1tKN$C-\u001a4bk2$HeM\u000b\u0003\u0005sQC!!3\u0002\n\u0006aQn\u001c<f)\u0016l\u0007\u000f\\1uKRA\u0011Q\u0003B \u0005\u0003\u0012)\u0005C\u0004\u0002\u0014i\u0001\r!!\u0006\t\u000f\t\r#\u00041\u0001\u0002\u0016\u0005QA/Z7qY\u0006$X-\u00133\t\u0013\t\u001d#\u0004%AA\u0002\u0005\u0015\u0013\u0001E:i_VdG-T3sO\u0016$V-Y7tQ\rQ\u0012QF\u0001\u0017[>4X\rV3na2\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u000511M]3bi\u0016$b!a\u0017\u0003R\tM\u0003bBAb9\u0001\u0007\u0011Q\u0003\u0005\b\u0003Cb\u0002\u0019AA.Q\ra\u0012Q\u0006\u000b\t\u00037\u0012IFa\u0017\u0003^!9\u00111Y\u000fA\u0002\u0005U\u0001bBA1;\u0001\u0007\u00111\f\u0005\b\u0005?j\u0002\u0019AA#\u0003I\u0019'/Z1uK\u0012+g-Y;miR+\u0017-\\:)\u0007u\ti#\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003\u0017\u00119\u0007C\u0004\u0002\u0014y\u0001\r!!\u0006)\u0007y\ti#A\bbe\u000eD\u0017N^3Pe\u0012+G.\u001a;f)\u0019\tYAa\u001c\u0003t!9!\u0011O\u0010A\u0002\u0005\r\u0016!\u00034pY\u0012,'/V5e\u0011\u001d\u0011)h\ba\u0001\u0003+\t\u0011B]3mK\u0006\u001cX-\u00133\u0002\u00155,'oZ3UK\u0006l7\u000f\u0006\u0005\u0002\f\tm$Q\u0010B@\u0011\u001d\t\u0019\u0002\ta\u0001\u0003+AqAa\u0011!\u0001\u0004\t)\u0002C\u0004\u0003\u0002\u0002\u0002\rAa!\u0002\u001bQ,W\u000e\u001d7bi\u0016$V-Y7t!\u0019\u0011)Ia$\u0003\u0016:!!q\u0011BF\u001d\u0011\tYB!#\n\u0003eJ1A!$9\u0003\u001d\u0001\u0018mY6bO\u0016LAA!%\u0003\u0014\n\u00191+Z9\u000b\u0007\t5\u0005\b\u0005\u0003\u0002|\n]\u0015\u0002\u0002BM\u0003G\u0012A\u0001V3b[\u0006a!/\u001a9mC\u000e,G+Z1ngR1\u00111\u0002BP\u0005CCq!a\u0005\"\u0001\u0004\t)\u0002C\u0004\u0003D\u0005\u0002\r!!\u0006\u000275,'oZ3UK6\u0004H.\u0019;f\u0003:$gi\u001c7eKJ$V-Y7t)\u0019\u0011\u0019Ia*\u0003,\"9!\u0011\u0016\u0012A\u0002\t\r\u0015a\u00034pY\u0012,'\u000fV3b[NDqA!!#\u0001\u0004\u0011\u0019)A\u0007sKN,G\u000fV1tWR+\u0017-\u001c\u000b\u0005\u0003\u0017\u0011\t\fC\u0004\u0003D\r\u0002\r!!\u0006\u0002=\r\u0014X-\u0019;f\t\u00164\u0017-\u001e7u)\u0016\fWn\u001d$peRCWMR8mI\u0016\u0014HCBA\u0006\u0005o\u0013I\fC\u0004\u0002b\u0011\u0002\r!a\u0017\t\u000f\u0005\rG\u00051\u0001\u0002\u0016\u0005yr-\u001a;O_:Le\u000e[3sSR,GMR8mI\u0016\u0014(+\u001a4fe\u0016t7-Z:\u0015\r\t}&Q\u001bBl!\u0019\u0011\tMa3\u0003P6\u0011!1\u0019\u0006\u0005\u0005\u000b\u00149-A\u0004nkR\f'\r\\3\u000b\u0007\t%\u0007(\u0001\u0006d_2dWm\u0019;j_:LAA!4\u0003D\n\u00191+\u001a;\u0011\t\u0005m(\u0011[\u0005\u0005\u0005'\f\u0019GA\tCCN,7i\u001c8gS\u001e,(/\u0019;j_:Dq!a\u0005&\u0001\u0004\t)\u0002C\u0004\u0003Z\u0016\u0002\r!!\u0006\u0002\u00179,wOZ8mI\u0016\u0014\u0018\nZ\u0001\u0016G\",7m\u001b$pY\u0012,'oQ1o\u0005\u0016luN^3e)!\tYAa8\u0003b\n-\bbBA\nM\u0001\u0007\u0011Q\u0003\u0005\b\u0005G4\u0003\u0019\u0001Bs\u0003EqWm\u001e4pY\u0012,'/\u00133PaRLwN\u001c\t\u0006o\t\u001d\u0018QC\u0005\u0004\u0005SD$AB(qi&|g\u000eC\u0004\u0003n\u001a\u0002\r!!\u0006\u0002\u0013=\u0004XM]1uS>t\u0017!D2sK\u0006$X\rR3uC&d7\u000f\u0006\u0005\u0003t\n](Q`B\u0001!\u0011\t\u0019H!>\n\t\u0005\u001d\u0012Q\u000f\u0005\b\u0005s<\u0003\u0019\u0001B~\u00039\t7\r^5wKJ+G.Z1tKN\u0004bA!\"\u0003\u0010\u0006e\bb\u0002B\u0000O\u0001\u0007!1`\u0001\u0019CV$xn\u0015;beR\u0004VM\u001c3j]\u001e\u0014V\r\\3bg\u0016\u001c\bbBB\u0002O\u0001\u00071QA\u0001\fS:4\u0018\r\\5e%\u001647\u000f\u0005\u0004\u0004\b\r%!qZ\u0007\u0003\u0005\u000fLAA!4\u0003H\u000692\r[3dWR+W\u000e\u001d7bi\u0016\u001c\u0015M\u001c\"f\u001b>4X\r\u001a\u000b\u0007\u0003\u0017\u0019ya!\u0005\t\u000f\t\r\u0003\u00061\u0001\u0002\u0016!9\u00111\u0003\u0015A\u0002\u0005U\u0011AE4fiJ+hN\\5oOJ+G.Z1tKN$BAa?\u0004\u0018!9\u00111C\u0015A\u0002\u0005U\u0011aG4fi\u0006+Ho\\*uCJ$\b+\u001a8eS:<'+\u001a7fCN,7\u000f\u0006\u0003\u0003|\u000eu\u0001bBA\nU\u0001\u0007\u0011Q\u0003")
public class FolderService
implements Logging {
    private final FolderRepository folders;
    private final TeamService teamService;
    private final ReleaseRepository releaseRepository;
    private final TaskService taskService;
    private final ConfigurationRepository configurationRepository;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    @Timed
    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    @Timed
    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException(new StringBuilder(23).append("Folder ").append(Ids.ROOT_FOLDER_ID).append(" cannot be found").toString(), new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    @Timed
    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Folder findByPath(String path, int depth) {
        void var3_3;
        Folder found = this.folders.findByPath(path, depth);
        this.permissions.check(XLReleasePermissions.VIEW_FOLDER, found.getId());
        return var3_3;
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        this.permissions.checkViewFolder(parentId);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.folders.listViewableFolders(parentId, page, decorateWithPermissions)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)new Some((Object)newParentId), "move");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderMovingAction(folderId, Ids.getParentId((String)folderId), newParentId));
        Folder folder = this.folders.move(folderId, newParentId);
        this.eventBus.publish((XLReleaseEvent)new FolderMovedEvent(folder, Ids.getParentId((String)folderId), newParentId));
        return folder;
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        Checks.checkArgument((!newName.trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Folder folder = this.folders.rename(folderId, newName);
        this.eventBus.publish((XLReleaseEvent)new FolderRenamedEvent(folder, newName));
        return folder;
    }

    @Timed
    public List<Release> searchTemplates(String folderId, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), page.depth()).getReleases();
    }

    @Timed
    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage(), page.depth());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    @Timed
    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String string;
        String newTemplateId = new StringBuilder(1).append(folderId).append("/").append(Ids.getName((String)templateId)).toString();
        this.checkTemplateCanBeMoved(templateId, folderId);
        String string2 = Ids.getParentId((String)templateId);
        String string3 = folderId;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Attempted to move template ").append(templateId).append(" to same folder ").append(folderId).append(". Will be ignored.").toString());
            string = templateId;
        } else {
            Buffer templateTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getStoredTeams(templateId)).asScala();
            this.eventBus.publishAndFailOnError((XLReleaseEvent)new TemplateMovingAction(templateId, folderId));
            this.releaseRepository.move(templateId, newTemplateId);
            if (shouldMergeTeams) {
                this.mergeTeams(folderId, newTemplateId, (Seq<Team>)templateTeams);
            } else {
                this.replaceTeams(folderId, newTemplateId);
            }
            this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
            string = newTemplateId;
        }
        return string;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        return this.create(parentId, folder, true);
    }

    @Timed
    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        Folder saved;
        block3: {
            Checks.checkArgument((!folder.getTitle().trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
            Checks.checkArgument((folder.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Folder name must be 255 characters or less", (Object[])new Object[0]);
            this.checkFolderExists(parentId);
            this.folders.checkNameIsUnique(parentId, folder.getTitle());
            if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
                folder.setId(this.ciIdService.getUniqueId(Type.valueOf(Folder.class), parentId));
            } else {
                folder.setId(new StringBuilder(1).append(parentId).append("/").append(Ids.getName((String)folder.getId())).toString());
            }
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Creating folder ").append(folder.getTitle()).append(" with id ").append(folder.getId()).toString());
            saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
            this.eventBus.publish((XLReleaseEvent)new FolderCreatedEvent(folder));
            if (!createDefaultTeams) break block3;
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.createDefaultTeamsForTheFolder(saved, parentId);
            }
        }
        return saved;
    }

    @Timed
    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)None$.MODULE$, "delete");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderDeletingAction(folderId));
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Deleting folder ").append(folderId).toString());
        Folder folder = (Folder)this.folders.findById(folderId, this.folders.findById$default$2()).get();
        this.folders.delete(folderId, (Function2<Object, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(folderUid, releaseId) -> {
            this.archiveOrDelete(BoxesRunTime.unboxToInt((Object)folderUid), releaseId);
            return BoxedUnit.UNIT;
        });
        this.eventBus.publish((XLReleaseEvent)new FolderDeletedEvent(folder));
    }

    private void archiveOrDelete(int folderUid, String releaseId) {
        ReleaseStatus status = this.releaseRepository.getStatus(releaseId);
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("archiveOrDelete(").append(folderUid).append(", ").append(releaseId).append("): status=").append(status).append(" [inactive? ").append(status.isInactive()).append("]").toString());
        if (this.releaseRepository.getStatus(releaseId).isInactive()) {
            if (!this.archivingService.existsPreArchived(releaseId)) {
                Release release = this.releaseRepository.findById(releaseId);
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("release loaded: ").append(release).toString());
                this.archivingService.preArchiveRelease(release);
            }
            this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("archiveRelease(").append(releaseId).append(")").toString());
            this.archivingService.archiveRelease(releaseId);
        } else {
            this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("deleteRelease(").append(releaseId).append(")").toString());
            this.releaseRepository.delete(releaseId);
        }
    }

    private void mergeTeams(String folderId, String templateId, Seq<Team> templateTeams) {
        block0: {
            if (!templateTeams.nonEmpty()) break block0;
            Buffer folderTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(folderId)).asScala();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable & scala.Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> folderId);
            Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teamService.saveTeamsToPlatform(folderTeamsContainerId, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(mergedTeams).asJava());
            this.teamService.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teamService.deleteTeamsFromPlatform(templateId);
    }

    private Seq<Team> mergeTemplateAndFolderTeams(Seq<Team> folderTeams, Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((TraversableOnce)folderTeams.map((Function1 & Serializable & scala.Serializable)team -> new Tuple2((Object)team.getTeamName(), team), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).toSeq());
        templateTeams.foreach((Function1 & Serializable & scala.Serializable)templateTeam -> {
            MapLike mapLike;
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                mapLike = folderTeamsMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                scala.collection.immutable.Set memberSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getMembers()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getMembers()).asScala()).toSet());
                scala.collection.immutable.Set roleSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getRoles()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getRoles()).asScala()).toSet());
                scala.collection.immutable.Set permissionSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getPermissions()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getPermissions()).asScala()).toSet());
                folderTeam.setMembers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(memberSet.toSeq()).asJava());
                folderTeam.setRoles((List)JavaConverters$.MODULE$.seqAsJavaListConverter(roleSet.toSeq()).asJava());
                folderTeam.setPermissions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(permissionSet.toSeq()).asJava());
                mapLike = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return mapLike;
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releaseRepository.findById(templateId);
        template.getAllTasks().forEach(task -> $this.taskService.applyNewTeam(null, (Task)task, false));
    }

    private void createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(XLReleasePermissions.getFolderPermissions()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$createDefaultTeamsForTheFolder$1(x$1)))).asJava());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getReleaseGroupPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDeliveryPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDashboardPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_TRIGGER.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        Buffer releaseAdminPermissions = (Buffer)((SeqLike)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(XLReleasePermissions.getReleasePermissions()).asScala()).union((GenSeq)JavaConverters$.MODULE$.asScalaBufferConverter(XLReleasePermissions.getTriggerPermissions()).asScala(), Buffer$.MODULE$.canBuildFrom())).union((GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{XLReleasePermissions.VIEW_FOLDER.getPermissionName()})), Buffer$.MODULE$.canBuildFrom());
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.addPermissions((String[])releaseAdminPermissions.toArray(ClassTag$.MODULE$.apply(String.class)));
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        this.teamService.saveTeamsToPlatform(folder.getId(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{folderOwner, templateOwner, releaseAdmin}))).asJava());
    }

    public scala.collection.mutable.Set<BaseConfiguration> getNonInheritedFolderReferences(String folderId, String newfolderId) {
        Page x$1 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0));
        ReleaseStatus[] x$2 = (ReleaseStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ReleaseStatus.class));
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        scala.collection.mutable.Seq releases = (scala.collection.mutable.Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala();
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        releases.foreach((Function1 & Serializable & scala.Serializable)release -> {
            FolderService.$anonfun$getNonInheritedFolderReferences$1(this, newfolderId, folderId, res, release);
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private void checkFolderCanBeMoved(String folderId, Option<String> newfolderIdOption, String operation) {
        scala.collection.mutable.Set<BaseConfiguration> set;
        Seq<Release> activeReleases = this.getRunningReleases(folderId);
        Seq<Release> autoStartPendingReleases = this.getAutoStartPendingReleases(folderId);
        Option<String> option = newfolderIdOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            String newFolderId = (String)some.value();
            set = this.getNonInheritedFolderReferences(folderId, newFolderId);
        } else if (None$.MODULE$.equals(option)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.mutable.Set<BaseConfiguration> invalidRefs = set;
        if (activeReleases.nonEmpty() || autoStartPendingReleases.nonEmpty() || invalidRefs.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Tried to ").append(operation).append(" folder ").append(folderId).append(", which has active releases ").append(((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(new StringBuilder(53).append(" or pending releases with auto start option enabled: ").append(((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString()).toString());
            String details = this.createDetails(activeReleases, autoStartPendingReleases, (Set<BaseConfiguration>)invalidRefs);
            throw new ItemInUseException(new StringBuilder(62).append("You cannot ").append(operation).append(" this folder. The folder or its subfolders contain ").append(details).toString(), new Object[0]);
        }
    }

    private String createDetails(Seq<Release> activeReleases, Seq<Release> autoStartPendingReleases, Set<BaseConfiguration> invalidRefs) {
        String details;
        block2: {
            details = "";
            if (activeReleases.nonEmpty()) {
                details = new StringBuilder(0).append(details).append(new StringBuilder(17).append("active releases: ").append(((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")).toString()).toString();
            }
            if (autoStartPendingReleases.nonEmpty()) {
                details = new StringBuilder(0).append(details).append(new StringBuilder(34).append("pending releases with auto start: ").append(((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")).toString()).toString();
            }
            if (!invalidRefs.nonEmpty()) break block2;
            details = new StringBuilder(0).append(details).append(new StringBuilder(66).append("configuration references not inherited by the destination folder: ").append(((TraversableOnce)invalidRefs.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTitle(), Set$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")).toString()).toString();
        }
        return details;
    }

    private void checkTemplateCanBeMoved(String templateId, String folderId) {
        Release template = this.releaseRepository.findById(templateId);
        scala.collection.mutable.Set refs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(CiHelper.getExternalReferences((ConfigurationItem)template)).asScala();
        if (!((IterableLike)((SetLike)refs.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$1(c)))).map((Function1 & Serializable & scala.Serializable)c -> $this.configurationRepository.read(c.getId()), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$3(folderId, c)))) {
            throw new ItemInUseException("You cannot move this template. It contains references to configurations that are not global or not inherited by the destination folder.", new Object[0]);
        }
    }

    private Seq<Release> getRunningReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$2 = ReleaseStatus.ACTIVE_STATUSES;
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala();
    }

    private Seq<Release> getAutoStartPendingReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$2 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED});
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        boolean x$4 = true;
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$6 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$5, x$6, x$4))).asScala();
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public static final /* synthetic */ boolean $anonfun$createDefaultTeamsForTheFolder$1(String x$1) {
        String string = x$1;
        String string2 = XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getNonInheritedFolderReferences$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ void $anonfun$getNonInheritedFolderReferences$1(FolderService $this, String newfolderId$1, String folderId$6, scala.collection.mutable.Set res$1, Release release) {
        scala.collection.mutable.Set refs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(CiHelper.getExternalReferences((ConfigurationItem)release)).asScala();
        ((IterableLike)((SetLike)refs.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$getNonInheritedFolderReferences$2(c)))).map((Function1 & Serializable & scala.Serializable)c -> $this.configurationRepository.read(c.getId()), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)c -> c.getFolderId() != null && !newfolderId$1.startsWith(c.getFolderId()) && !c.getFolderId().equals(folderId$6) ? BoxesRunTime.boxToBoolean((boolean)res$1.add(c)) : BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$1(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$3(String folderId$8, BaseConfiguration c) {
        return c.getFolderId() == null || folderId$8.startsWith(c.getFolderId());
    }

    public FolderService(FolderRepository folders, TeamService teamService, ReleaseRepository releaseRepository, TaskService taskService, ConfigurationRepository configurationRepository, CiIdService ciIdService, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus, ArchivingService archivingService) {
        this.folders = folders;
        this.teamService = teamService;
        this.releaseRepository = releaseRepository;
        this.taskService = taskService;
        this.configurationRepository = configurationRepository;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        Logging.$init$((Logging)this);
    }
}

