/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.FacetPermissionChecker;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.FacetService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class TaskReportingApi
implements ApiService {
    private final FacetService facetService;
    private final PermissionChecker permissions;
    private final FacetPermissionChecker facetPermissions;

    @Autowired
    public TaskReportingApi(FacetService facetService, PermissionChecker permissions, FacetPermissionChecker facetPermissions) {
        Checks.checkNotNull((Object)facetService, (String)"FacetService must be provided. If you're testing think twice as this object will have impact on other tests!");
        Checks.checkNotNull((Object)permissions, (String)"PermissionChecker must be provided");
        Checks.checkNotNull((Object)facetPermissions, (String)"FacetPermissionChecker must be provided");
        this.facetService = facetService;
        this.permissions = permissions;
        this.facetPermissions = facetPermissions;
    }

    @Timed
    public List<TaskReportingRecord> addRecord(TaskReportingRecord record, boolean applyTaskAttributes) {
        record.setCreatedViaApi(true);
        this.performChecksAndSetRetryCounter(record);
        if (applyTaskAttributes) {
            return this.facetService.createApplyingConfiguration(record, true);
        }
        return Collections.singletonList((TaskReportingRecord)this.facetService.create((Facet)record));
    }

    public TaskReportingRecord newItsmRecord() {
        return (TaskReportingRecord)this.newReportingRecord("udm.ItsmRecord");
    }

    public TaskReportingRecord newPlanRecord() {
        return (TaskReportingRecord)this.newReportingRecord("udm.PlanRecord");
    }

    public TaskReportingRecord newBuildRecord() {
        return (TaskReportingRecord)this.newReportingRecord("udm.BuildRecord");
    }

    public TaskReportingRecord newDeploymentRecord() {
        return (TaskReportingRecord)this.newReportingRecord("udm.DeploymentRecord");
    }

    public TaskReportingRecord newCodeComplianceRecord() {
        return (TaskReportingRecord)this.newReportingRecord("udm.CodeComplianceRecord");
    }

    public String serviceName() {
        return "taskReportingApi";
    }

    private <F extends Facet> F newReportingRecord(String type) {
        return (F)((Facet)Type.valueOf((String)type).getDescriptor().newInstance(""));
    }

    private void performChecksAndSetRetryCounter(TaskReportingRecord record) {
        if (record.getTargetId() == null || record.getTargetId().trim().isEmpty()) {
            if (this.facetPermissions.hasScriptTask()) {
                record.setTargetId(this.facetPermissions.getScriptTask().getId());
            } else {
                throw new IllegalStateException("reporting record should have targetId populated unless it is called from within script task context");
            }
        }
        String releaseId = Ids.releaseIdFrom((String)record.getTargetId());
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(releaseId, () -> {
            this.permissions.checkView(releaseId);
            this.permissions.checkEdit(releaseId);
            this.permissions.checkEditTask(releaseId);
        });
        if (this.facetPermissions.hasScriptTask()) {
            record.setRetryAttemptNumber(this.facetPermissions.getScriptTask().getFailuresCount());
        }
    }
}

