/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.AdaptiveReleaseId;
import com.xebialabs.xlrelease.domain.utils.FullReleaseId$;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicDataExt;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0001\u0011\u0005t!\u0002\u001d:\u0011\u0003\u0011e!\u0002#:\u0011\u0003)\u0005\"\u0002+\u0002\t\u0003)\u0006\"\u0002,\u0002\t\u00039\u0006\"\u0002;\u0002\t\u0003)h!\u0002#:\u0001\u0005\u0015\u0001BCA\u0004\u000b\t\u0015\r\u0011\"\u0001\u0002\n!Q\u0011qC\u0003\u0003\u0002\u0003\u0006I!a\u0003\t\u0015\u0005eQA!A!\u0002\u0013\tY\u0002\u0003\u0006\u0002\"\u0015\u0011\t\u0011)A\u0005\u0003GA\u0011\"!\u000b\u0006\u0005\u0003\u0005\u000b\u0011B7\t\u0015\u0005-RA!A!\u0002\u0013\ti\u0003\u0003\u0006\u00024\u0015\u0011\t\u0011)A\u0005\u0003kA!\"a\u0010\u0006\u0005\u0003\u0005\u000b\u0011BA!\u0011)\t9%\u0002B\u0001B\u0003%\u0011\u0011\n\u0005\u000b\u0003+*!\u0011!Q\u0001\n\u0005]\u0003BCA/\u000b\t\u0005\t\u0015!\u0003\u0002`!Q\u0011QM\u0003\u0003\u0002\u0003\u0006I!a\u001a\t\u0015\u00055TA!A!\u0002\u0013\ty\u0007\u0003\u0006\u0002v\u0015\u0011\t\u0011)A\u0005\u0003oBa\u0001V\u0003\u0005\u0002\u0005u\u0004bBA[\u000b\u0011\u0005\u0011q\u0017\u0005\b\u0003/,A\u0011BAm\u0011\u001d\ty.\u0002C\u0005\u0003CDq!!:\u0006\t\u0003\t9\u000fC\u0004\u0002n\u0016!\t!a<\t\u000f\u00055X\u0001\"\u0001\u0002t\"9!1A\u0003\u0005\u0002\t\u0015\u0001b\u0002B\u0006\u000b\u0011\u0005!Q\u0002\u0005\b\u00057)A\u0011\u0001B\u000f\u0011\u001d\u0011Y#\u0002C\u0001\u0005[AqA!\u0011\u0006\t\u0003\u0011\u0019\u0005C\u0004\u0003L\u0015!\tA!\u0014\t\u000f\tMS\u0001\"\u0001\u0003V!9!QL\u0003\u0005\u0002\t}\u0003b\u0002B3\u000b\u0011\u0005!q\r\u0005\b\u0005_*A\u0011\u0001B9\u0011\u001d\u0011i(\u0002C\u0001\u0005\u007fBqAa#\u0006\t\u0003\u0011i\tC\u0004\u0003\f\u0016!\tA!/\t\u000f\t5W\u0001\"\u0001\u0003P\"I11E\u0003\u0012\u0002\u0013\u00051Q\u0005\u0005\n\u0007s)\u0011\u0013!C\u0001\u0007KAqaa\u000f\u0006\t\u0003\u0019i\u0004C\u0004\u0004\\\u0015!\ta!\u0018\t\u000f\r\rT\u0001\"\u0001\u0004f!91QQ\u0003\u0005\u0002\r\u001d\u0005bBBG\u000b\u0011\u00051q\u0012\u0005\b\u0005\u0017+A\u0011BBO\u0011\u001d\u0019)+\u0002C\u0001\u0007OCqaa,\u0006\t\u0003\u0019\t\fC\u0004\u0004D\u0016!Ia!2\t\u0013\r5W!%A\u0005\n\r=\u0007bBBj\u000b\u0011%1Q\u001b\u0005\b\t\u0007)A\u0011\u0002C\u0003\u0011\u001d!Y!\u0002C\u0005\t\u001b\t\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u000b\u0005iZ\u0014aB:feZL7-\u001a\u0006\u0003yu\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005yz\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005\u0001\u0015aA2p[\u000e\u0001\u0001CA\"\u0002\u001b\u0005I$\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f'\r\ta\t\u0014\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016!B:mMRR'\"A)\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u0015(\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012AQ\u0001\u001bI\u0016\u001cXM]5bY&TX-\u0011:dQ&4X\r\u001a*fY\u0016\f7/\u001a\u000b\u00041z[\u0007CA-]\u001b\u0005Q&BA.<\u0003\u0019!w.\\1j]&\u0011QL\u0017\u0002\b%\u0016dW-Y:f\u0011\u0015y6\u00011\u0001a\u0003-\u0011X\r\\3bg\u0016T5o\u001c8\u0011\u0005\u0005DgB\u00012g!\t\u0019\u0007*D\u0001e\u0015\t)\u0017)\u0001\u0004=e>|GOP\u0005\u0003O\"\u000ba\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011q\r\u0013\u0005\u0006Y\u000e\u0001\r!\\\u0001\u000be\u0016\u0004xn]5u_JL\bC\u00018s\u001b\u0005y'B\u00017q\u0015\t\tX(\u0001\u0005eKBdw._5u\u0013\t\u0019xNA\tSKB|7/\u001b;pef\fE-\u00199uKJ\fAbZ3u\u001b>tG\u000f[-fCJ$\"\u0001\u0019<\t\u000b]$\u0001\u0019\u0001=\u0002\u0013M$\u0018M\u001d;ECR,\u0007cA=\u0002\u00025\t!P\u0003\u0002|y\u0006!A/[7f\u0015\tih0\u0001\u0003k_\u0012\f'\"A@\u0002\u0007=\u0014x-C\u0002\u0002\u0004i\u0014\u0001\u0002R1uKRKW.Z\n\u0004\u000b\u0019c\u0015\u0001E1sG\"Lg/\u001a3SK2,\u0017m]3t+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tbO\u0001\u0003I\nLA!!\u0006\u0002\u0010\t\u0001\u0012I]2iSZ,GMU3mK\u0006\u001cXm]\u0001\u0012CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN\u0004\u0013AF1sG\"Lg/\u001a3SK2,\u0017m]3t'\u0016\f'o\u00195\u0011\t\u00055\u0011QD\u0005\u0005\u0003?\tyA\u0001\fBe\u000eD\u0017N^3e%\u0016dW-Y:fgN+\u0017M]2i\u0003y\t'o\u00195jm\u0016$\u0017i\u0019;jm&$\u0018\u0010T8hgN+'/[1mSj,'\u000fE\u0002D\u0003KI1!a\n:\u0005y\t%o\u00195jm\u0016$\u0017i\u0019;jm&$\u0018\u0010T8hgN+'/[1mSj,'/A\tsKB|7/\u001b;pef\fE-\u00199uKJ\fadY8na2,G/\u001a3SK2,\u0017m]3t\u000bb\u0004xN\u001d;TKJ4\u0018nY3\u0011\u0007\r\u000by#C\u0002\u00022e\u0012QdQ8na2,G/\u001a3SK2,\u0017m]3FqB|'\u000f^*feZL7-Z\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\b\u0003BA\u001c\u0003wi!!!\u000f\u000b\u00051\\\u0014\u0002BA\u001f\u0003s\u0011\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003Q!W\r]3oI\u0016t7-\u001f*fa>\u001c\u0018\u000e^8ssB!\u0011qGA\"\u0013\u0011\t)%!\u000f\u0003)\u0011+\u0007/\u001a8eK:\u001c\u0017PU3q_NLGo\u001c:z\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(w\u00051\u0011m\u0019;peNLA!a\u0015\u0002N\t\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0006qA/Z1n%\u0016\u0004xn]5u_JL\b\u0003BA\u001c\u00033JA!a\u0017\u0002:\tqA+Z1n%\u0016\u0004xn]5u_JL\u0018AC:fGV\u0014X\rZ\"jgB!\u0011qGA1\u0013\u0011\t\u0019'!\u000f\u0003\u0015M+7-\u001e:fI\u000eK7/A\u000esK2,\u0017m]3FqR,gn]5p]N\u0014V\r]8tSR|'/\u001f\t\u0005\u0003o\tI'\u0003\u0003\u0002l\u0005e\"a\u0007*fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u00180\u0001\bd_6lWM\u001c;TKJ4\u0018nY3\u0011\u0007\r\u000b\t(C\u0002\u0002te\u0012abQ8n[\u0016tGoU3sm&\u001cW-A\rgC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014\b\u0003BA\u001c\u0003sJA!a\u001f\u0002:\tIb)Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s)q\ty(!!\u0002\u0004\u0006\u0015\u0015qQAE\u0003\u0017\u000bi)a$\u0002\u0012\u0006M\u0015QSAL\u00033\u0003\"aQ\u0003\t\u000f\u0005\u001dA\u00031\u0001\u0002\f!9\u0011\u0011\u0004\u000bA\u0002\u0005m\u0001bBA\u0011)\u0001\u0007\u00111\u0005\u0005\u0007\u0003S!\u0002\u0019A7\t\u000f\u0005-B\u00031\u0001\u0002.!9\u00111\u0007\u000bA\u0002\u0005U\u0002bBA )\u0001\u0007\u0011\u0011\t\u0005\b\u0003\u000f\"\u0002\u0019AA%\u0011\u001d\t)\u0006\u0006a\u0001\u0003/Bq!!\u0018\u0015\u0001\u0004\ty\u0006C\u0004\u0002fQ\u0001\r!a\u001a\t\u000f\u00055D\u00031\u0001\u0002p!9\u0011Q\u000f\u000bA\u0002\u0005]\u0004f\u0001\u000b\u0002\u001eB!\u0011qTAY\u001b\t\t\tK\u0003\u0003\u0002$\u0006\u0015\u0016AC1o]>$\u0018\r^5p]*!\u0011qUAU\u0003\u001d1\u0017m\u0019;pefTA!a+\u0002.\u0006)!-Z1og*\u0019\u0011q\u0016@\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.LA!a-\u0002\"\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u000fCJ\u001c\u0007.\u001b<f%\u0016dW-Y:f)\u0011\tI,a0\u0011\u0007\u001d\u000bY,C\u0002\u0002>\"\u0013A!\u00168ji\"1\u0011\u0011Y\u000bA\u0002\u0001\f\u0011B]3mK\u0006\u001cX-\u00133)\u0007U\t)\r\u0005\u0003\u0002H\u0006MWBAAe\u0015\u0011\t\u0019+a3\u000b\t\u00055\u0017qZ\u0001\b[\u0016$(/[2t\u0015\r\t\tnP\u0001\tG>$\u0017\r[1mK&!\u0011Q[Ae\u0005\u0015!\u0016.\\3e\u0003I\t'o\u00195jm\u0016\fE\u000f^1dQ6,g\u000e^:\u0015\t\u0005e\u00161\u001c\u0005\u0007\u0003;4\u0002\u0019\u0001-\u0002\u000fI,G.Z1tK\u0006\u0019\u0012M]2iSZ,G)\u001a9f]\u0012,gnY5fgR!\u0011\u0011XAr\u0011\u0019\tin\u0006a\u00011\u0006\t\u0002O]3Be\u000eD\u0017N^3SK2,\u0017m]3\u0015\t\u0005e\u0016\u0011\u001e\u0005\u0007\u0003;D\u0002\u0019\u0001-)\u0007a\t)-\u0001\u0006hKR\u0014V\r\\3bg\u0016$2\u0001WAy\u0011\u0019\t\t-\u0007a\u0001AR)\u0001,!>\u0002x\"1\u0011\u0011\u0019\u000eA\u0002\u0001Dq!!?\u001b\u0001\u0004\tY0\u0001\nj]\u000edW\u000fZ3Qe\u0016\f%o\u00195jm\u0016$\u0007cA$\u0002~&\u0019\u0011q %\u0003\u000f\t{w\u000e\\3b]\"\u001a!$!2\u0002\u001f\u001d,GOU3mK\u0006\u001cX\rV5uY\u0016$2\u0001\u0019B\u0004\u0011\u0019\t\tm\u0007a\u0001A\"\u001a1$!2\u0002\u0011\u001d,G\u000f\u00155bg\u0016$BAa\u0004\u0003\u0016A\u0019\u0011L!\u0005\n\u0007\tM!LA\u0003QQ\u0006\u001cX\r\u0003\u0004\u0003\u0018q\u0001\r\u0001Y\u0001\ba\"\f7/Z%eQ\ra\u0012QY\u0001\bO\u0016$H+Y:l)\u0011\u0011yB!\n\u0011\u0007e\u0013\t#C\u0002\u0003$i\u0013A\u0001V1tW\"1!qE\u000fA\u0002\u0001\fa\u0001^1tW&#\u0007fA\u000f\u0002F\u0006Yq-\u001a;WCJL\u0017M\u00197f)\u0011\u0011yCa\u000f\u0011\t\tE\"qG\u0007\u0003\u0005gQ1A!\u000e[\u0003%1\u0018M]5bE2,7/\u0003\u0003\u0003:\tM\"\u0001\u0003,be&\f'\r\\3\t\r\tub\u00041\u0001a\u0003)1\u0018M]5bE2,\u0017\n\u001a\u0015\u0004=\u0005\u0015\u0017AB3ySN$8\u000f\u0006\u0003\u0002|\n\u0015\u0003B\u0002B$?\u0001\u0007\u0001-\u0001\u0003dS&#\u0007fA\u0010\u0002F\u0006\tR\r_5tiN\u0004&/Z!sG\"Lg/\u001a3\u0015\t\u0005m(q\n\u0005\u0007\u0005\u000f\u0002\u0003\u0019\u00011)\u0007\u0001\n)-\u0001\u0007fq&\u001cHo\u001d\"z\u001d\u0006lW\r\u0006\u0003\u0002|\n]\u0003B\u0002B-C\u0001\u0007\u0001-A\u0006sK2,\u0017m]3OC6,\u0007fA\u0011\u0002F\u0006\u00012\r[3dW:{G/\u0011:dQ&4X\r\u001a\u000b\u0005\u0003s\u0013\t\u0007\u0003\u0004\u0003H\t\u0002\r\u0001\u0019\u0015\u0004E\u0005\u0015\u0017\u0001E1ui\u0006\u001c\u0007.\\3oi\u0016C\u0018n\u001d;t)\u0011\tYP!\u001b\t\r\t-4\u00051\u0001a\u00031\tG\u000f^1dQ6,g\u000e^%eQ\r\u0019\u0013QY\u0001\u000eO\u0016$\u0018\t\u001e;bG\"lWM\u001c;\u0015\t\tM$\u0011\u0010\t\u00043\nU\u0014b\u0001B<5\nQ\u0011\t\u001e;bG\"lWM\u001c;\t\r\t-D\u00051\u0001aQ\r!\u0013QY\u0001\u0014O\u0016$\u0018\t\u001e;bG\"lWM\u001c;PaRLwN\u001c\u000b\u0005\u0005\u0003\u00139\tE\u0003H\u0005\u0007\u0013\u0019(C\u0002\u0003\u0006\"\u0013aa\u00149uS>t\u0007B\u0002B6K\u0001\u0007\u0001\rK\u0002&\u0003\u000b\fab]3be\u000eD'+\u001a7fCN,7\u000f\u0006\u0003\u0003\u0010\n}\u0005#\u0002BI\u00057CVB\u0001BJ\u0015\u0011\u0011)Ja&\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u00053\u000bAA[1wC&!!Q\u0014BJ\u0005\u0011a\u0015n\u001d;\t\u000f\t\u0005f\u00051\u0001\u0003$\u00069a-\u001b7uKJ\u001c\b\u0003\u0002BS\u0005gk!Aa*\u000b\t\t%&1V\u0001\u0006M>\u0014Xn\u001d\u0006\u0005\u0005[\u0013y+\u0001\u0002wc)\u0019!\u0011W\u001e\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u00036\n\u001d&a\u0004*fY\u0016\f7/Z:GS2$XM]:)\u0007\u0019\n)\r\u0006\u0005\u0003\u0010\nm&Q\u0018Bd\u0011\u001d\u0011\tk\na\u0001\u0005GCqAa0(\u0001\u0004\u0011\t-A\u0003mS6LG\u000fE\u0002H\u0005\u0007L1A!2I\u0005\u0011auN\\4\t\u000f\t%w\u00051\u0001\u0003B\u00061qN\u001a4tKRD3aJAc\u0003I2\u0017N\u001c3TQ>\u0014HOU3mK\u0006\u001cX-\u00133t/&$\bNR8mI\u0016\u0014h*Y7f\u0003:$wJ\u001d3fe\u000e\u0013\u0018\u000e^3sS>tGC\u0003Bi\u0005s\u001cyaa\u0007\u0004 A1!1\u001bBo\u0005CtAA!6\u0003Z:\u00191Ma6\n\u0003%K1Aa7I\u0003\u001d\u0001\u0018mY6bO\u0016LAA!(\u0003`*\u0019!1\u001c%\u0011\u000f\u001d\u0013\u0019Oa:\u0003t&\u0019!Q\u001d%\u0003\rQ+\b\u000f\\33!\u0011\u0011IOa<\u000e\u0005\t-(b\u0001Bw5\u0006)Q\u000f^5mg&!!\u0011\u001fBv\u0005E\tE-\u00199uSZ,'+\u001a7fCN,\u0017\n\u001a\t\u0004\u000f\nU\u0018b\u0001B|\u0011\n\u0019\u0011I\\=\t\u000f\t\u0005\u0006\u00061\u0001\u0003|B1!1\u001bB\u007f\u0007\u0003IAAa@\u0003`\n\u00191+Z9\u0011\t\r\r11B\u0007\u0003\u0007\u000bQAA!)\u0004\b)\u00191\u0011B\u001e\u0002\u000fI,\u0007o\u001c:ug&!1QBB\u0003\u00051\u0011V\r]8si\u001aKG\u000e^3s\u0011\u001d\u0019\t\u0002\u000ba\u0001\u0007'\tQa\u001c:eKJ\u0004Ra\u0012BB\u0007+\u0001BA!*\u0004\u0018%!1\u0011\u0004BT\u0005A\u0011V\r\\3bg\u0016|%\u000fZ3s\u001b>$W\rC\u0005\u0003@\"\u0002\n\u00111\u0001\u0004\u001eA)qIa!\u0003B\"I!\u0011\u001a\u0015\u0011\u0002\u0003\u00071Q\u0004\u0015\u0004Q\u0005\u0015\u0017\u0001\u00104j]\u0012\u001c\u0006n\u001c:u%\u0016dW-Y:f\u0013\u0012\u001cx+\u001b;i\r>dG-\u001a:OC6,\u0017I\u001c3Pe\u0012,'o\u0011:ji\u0016\u0014\u0018n\u001c8%I\u00164\u0017-\u001e7uIM*\"aa\n+\t\ru1\u0011F\u0016\u0003\u0007W\u0001Ba!\f\u000465\u00111q\u0006\u0006\u0005\u0007c\u0019\u0019$A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0015%\n\t\r]2q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u00104j]\u0012\u001c\u0006n\u001c:u%\u0016dW-Y:f\u0013\u0012\u001cx+\u001b;i\r>dG-\u001a:OC6,\u0017I\u001c3Pe\u0012,'o\u0011:ji\u0016\u0014\u0018n\u001c8%I\u00164\u0017-\u001e7uIQ\nQcY8v]R\u0014V\r\\3bg\u0016\u001c()_*uCR,8\u000f\u0006\u0003\u0004@\r]\u0003cB1\u0004B\r\u00153\u0011K\u0005\u0004\u0007\u0007R'aA'baB!1qIB'\u001b\t\u0019IEC\u0002\u0004Li\u000baa\u001d;biV\u001c\u0018\u0002BB(\u0007\u0013\u0012QBU3mK\u0006\u001cXm\u0015;biV\u001c\bcA$\u0004T%\u00191Q\u000b%\u0003\u0007%sG\u000fC\u0004\u0003\".\u0002\rAa))\u0007-\n)-A\u0007d_VtGOU3mK\u0006\u001cXm\u001d\u000b\u0005\u0007\u007f\u0019y\u0006C\u0004\u0003\"2\u0002\rAa?)\u00071\n)-\u0001\rgS:$\u0017I]2iSZ\f'\r\\3SK2,\u0017m]3JIN$baa\u001a\u0004j\rM\u0004#\u0002Bj\u0005{\u0004\u0007bBB6[\u0001\u00071QN\u0001\u0005I\u0006$X\r\u0005\u0003\u0003\u0012\u000e=\u0014\u0002BB9\u0005'\u0013A\u0001R1uK\"91QO\u0017A\u0002\r]\u0014\u0001\u00039bO\u0016\u001c\u0016N_3\u0011\t\re4qP\u0007\u0003\u0007wRAa! \u0003\u0018\u0006!A.\u00198h\u0013\u0011\u0019\tia\u001f\u0003\u000f%sG/Z4fe\"\u001aQ&!2\u0002=\u0005\u00148\r[5wK\u0006cG.\u00138d_6Lgn\u001a#fa\u0016tG-\u001a8dS\u0016\u001cH\u0003BA]\u0007\u0013Ca!!1/\u0001\u0004\u0001\u0007f\u0001\u0018\u0002F\u0006Qq-\u001a;BY2$\u0016mZ:\u0015\t\rE5q\u0013\t\u0006\u0005#\u001b\u0019\nY\u0005\u0005\u0007+\u0013\u0019JA\u0002TKRDqa!'0\u0001\u0004\u0019\t&A\u0006mS6LGOT;nE\u0016\u0014\bfA\u0018\u0002FRA!qRBP\u0007C\u001b\u0019\u000bC\u0004\u0003\"B\u0002\rAa)\t\u000f\t}\u0006\u00071\u0001\u0004\u001e!9!\u0011\u001a\u0019A\u0002\ru\u0011AG:fCJ\u001c\u0007NU3mK\u0006\u001cXm\u001d\"z%\u0016dW-Y:f\u0013\u0012\u001cH\u0003BBU\u0007W\u0003RAa5\u0003~bCqa!,2\u0001\u0004\u00199'\u0001\u0006sK2,\u0017m]3JIN\f!e]3be\u000eD'+\u001a7fCN,7OQ1tS\u000e,\u0005\u0010\u001e\"z%\u0016dW-Y:f\u0013\u0012\u001cH\u0003BBZ\u0007\u0003\u0004bAa5\u0003~\u000eU\u0006\u0003BB\\\u0007{k!a!/\u000b\t\rm\u0016\u0011H\u0001\u0006cV,'/_\u0005\u0005\u0007\u007f\u001bILA\nSK2,\u0017m]3CCNL7\rR1uC\u0016CH\u000fC\u0004\u0004.J\u0002\raa\u001a\u0002!\u001d,GOU3mK\u0006\u001cXm\u00149uS>tGCBBd\u0007\u0013\u001cY\r\u0005\u0003H\u0005\u0007C\u0006BBAag\u0001\u0007\u0001\rC\u0005\u0002zN\u0002\n\u00111\u0001\u0002|\u0006Qr-\u001a;SK2,\u0017m]3PaRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u00111\u0011\u001b\u0016\u0005\u0003w\u001cI#\u0001\bhKR\u0014V\r\\3bg\u0016LE/Z7\u0016\t\r]7\u0011\u001d\u000b\u0005\u00073\u001cy\u0010\u0006\u0003\u0004\\\u000eM\b#B$\u0003\u0004\u000eu\u0007\u0003BBp\u0007Cd\u0001\u0001B\u0004\u0004dV\u0012\ra!:\u0003\u0003Q\u000bBaa:\u0004nB\u0019qi!;\n\u0007\r-\bJA\u0004O_RD\u0017N\\4\u0011\u0007e\u001by/C\u0002\u0004rj\u0013\u0001\u0002\u00157b]&#X-\u001c\u0005\b\u0007k,\u0004\u0019AB|\u0003\u001d9W\r^%uK6\u0004baRB}1\u000eu\u0018bAB~\u0011\nIa)\u001e8di&|g.\r\t\u0007\u000f\u000ee\bm!8\t\r\u0011\u0005Q\u00071\u0001a\u0003\u0019IG/Z7JI\u0006\tr-\u001a;WCJL\u0017M\u00197f\u001fB$\u0018n\u001c8\u0015\t\u0011\u001dA\u0011\u0002\t\u0006\u000f\n\r%q\u0006\u0005\u0007\u0005{1\u0004\u0019\u00011\u0002=\u0005\u00148\r[5wK\u0006cGnT;uO>Lgn\u001a#fa\u0016tG-\u001a8dS\u0016\u001cH\u0003\u0002C\b\t/\u0001bAa5\u0003~\u0012E\u0001cA-\u0005\u0014%\u0019AQ\u0003.\u0003\u0015\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010\u0003\u0004\u0002^^\u0002\r\u0001\u0017\u0015\u0014\u000b\u0011mA\u0011\u0006C\u0016\t_!\t\u0004b\u000f\u0005>\u0011\u001dC\u0011\n\t\u0005\t;!)#\u0004\u0002\u0005 )!\u00111\u0015C\u0011\u0015\u0011!\u0019#!,\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\tO!yBA\u0007Ue\u0006t7/Y2uS>t\u0017\r\\\u0001\u0006m\u0006dW/Z\u0011\u0003\t[\t1D]3q_J$\u0018N\\4Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\u0018a\u00039s_B\fw-\u0019;j_:$#\u0001b\r\n\t\u0011UBqG\u0001\t%\u0016\u000bV+\u0013*F\t*!A\u0011\bC\u0010\u0003-\u0001&o\u001c9bO\u0006$\u0018n\u001c8\u0002\u0013%\u001cx\u000e\\1uS>tGE\u0001C \u0013\u0011!\t\u0005b\u0011\u0002\u001dI+\u0015\tR0D\u001f6k\u0015\n\u0016+F\t*!AQ\tC\u0010\u0003%I5o\u001c7bi&|g.A\u0006s_2d'-Y2l\r>\u0014HF\u0001C&G\t!i\u0005\u0005\u0003\u0003T\u0012=\u0013\u0002\u0002C)\u0005?\u0014\u0011\u0002\u00165s_^\f'\r\\3)\u0007\u0015!)\u0006\u0005\u0003\u0005X\u0011uSB\u0001C-\u0015\u0011!Y&!,\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0005`\u0011e#aB*feZL7-\u001a")
public class ArchivingService
implements Logging {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentService commentService;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String getMonthYear(DateTime dateTime) {
        return ArchivingService$.MODULE$.getMonthYear(dateTime);
    }

    public static Release deserializeArchivedRelease(String string, RepositoryAdapter repositoryAdapter) {
        return ArchivingService$.MODULE$.deserializeArchivedRelease(string, repositoryAdapter);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Timed
    public void archiveRelease(String releaseId) {
        Release release = (Release)this.repositoryAdapter.read(releaseId);
        if (release == null) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Release '").append(releaseId).append("' cannot be read from active database, not archiving.").toString());
            if (!this.releaseRepository.exists(releaseId) && this.existsPreArchived(releaseId)) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Setting Release '").append(releaseId).append("' preArchived flag to false as it is no longer in the active database.").toString());
                this.archivedReleases().setPreArchived(releaseId, false);
            }
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES)).contains((Object)release.getStatus())) {
            if (this.existsPreArchived(releaseId)) {
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Archiving dependencies for '").append(releaseId).append("'").toString());
                this.releaseExtensionsRepository.decorate(release);
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
                    this.commentService.decorate(task);
                    return BoxedUnit.UNIT;
                });
                java.util.List<Team> updatedTeams = this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
                release.setTeams(updatedTeams);
                Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
                    task.setFacets(new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)facets.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveRelease$6(task, x$1)))).asJava()));
                    return BoxedUnit.UNIT;
                });
                if (!release.isTutorial()) {
                    this.archiveAttachments(release);
                }
                this.archiveDependencies(release);
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Updating activity logs and releaseJson for '").append(releaseId).append("'").toString());
                String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
                String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
                if (!this.archivedReleases().update(releaseId, serializedRelease, activityLogsJson, false)) {
                    this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Could not update archived Release '").append(releaseId).append("'.").toString());
                } else {
                    this.archivedReleases().updateViewers(releaseId, (Seq<Team>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(updatedTeams).asScala()));
                }
                if (this.releaseRepository.exists(releaseId)) {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Deleting '").append(releaseId).append("' from active database").toString());
                    this.releaseRepository.delete(releaseId);
                    ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).foreach((Function1 & Serializable & scala.Serializable)facet -> {
                        ArchivingService.$anonfun$archiveRelease$10(this, facet);
                        return BoxedUnit.UNIT;
                    });
                }
            } else if (!release.isTutorial()) {
                throw new IllegalStateException("Only pre-archived releases can be archived");
            }
        } else {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Trying to pre-archive a release with invalid status ").append(release.getStatus()).toString());
            throw new IllegalStateException("Only inactive releases can be archived");
        }
    }

    private void archiveAttachments(Release release) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Archiving attachments for '").append(release.getId()).append("'").toString());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAttachments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)attachment -> {
            ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
            return BoxedUnit.UNIT;
        });
    }

    private void archiveDependencies(Release release) {
        Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append(release).append(" is already pre-archived, nothing to do").toString());
        } else {
            Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
                task.setFacets(new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)facets.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$3(task, x$2)))).asJava()));
                return BoxedUnit.UNIT;
            });
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            if (!release.isTutorial()) {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("copying release ").append(release).append(" to archive database, marked as pre-archived").toString());
                this.archivedReleases().insert(release, serializedRelease, "", true);
                scala.collection.immutable.Set<Type> specialTypes = this.facetRepositoryDispatcher.supportedTypes();
                ((IterableLike)((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).filter((Function1 & Serializable & scala.Serializable)facet -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$5(specialTypes, facet)))).foreach((Function1 & Serializable & scala.Serializable)liveFacet -> $this.facetRepositoryDispatcher.archiveRepository().create((Facet)liveFacet));
                this.releaseRepository.setPreArchived(release.getId(), true);
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Running release ").append(release.getId()).append(" through export hooks").toString());
            } else {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Deleting tutorial release ").append(release).append(" instead of pre-archiving").toString());
                this.releaseRepository.delete(release.getId());
            }
            this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
        }
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable & scala.Serializable)x$3 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$3.getPhase(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)phaseId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable & scala.Serializable)x$4 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$4.getTask(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)taskId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)variableId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable & scala.Serializable)x$5 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$5.getPhase(x$1)).isDefined() : (Ids.isTaskId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable & scala.Serializable)x$6 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$6.getTask(x$1)).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().existsPreArchived(ciId) : false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases().exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringBuilder(56).append("You cannot perform this operation on archived release [").append(Ids.releaseIdFrom((String)ciId)).append("]").toString(), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(37).append("Could not find archived attachment [").append(attachmentId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable & scala.Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable & scala.Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public List<Tuple2<AdaptiveReleaseId, Object>> findShortReleaseIdsWithFolderNameAndOrderCriterion(Seq<ReportFilter> filters, Option<ReleaseOrderMode> order, Option<Object> limit, Option<Object> offset) {
        return this.archivedReleasesSearch.searchReleaseIdsAndOrderCriterion(filters, order, limit, offset);
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$4() {
        return None$.MODULE$;
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleases(Seq<ReportFilter> filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((Seq<String>)((Seq)new .colon.colon((Object)releaseId, (List)Nil$.MODULE$)), (Seq<String>)((Seq)Nil$.MODULE$), true);
        incomingDependencies.groupBy((Function1 & Serializable & scala.Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter), List$.MODULE$.canBuildFrom())).asJava();
    }

    public Seq<Release> searchReleasesByReleaseIds(Seq<String> releaseIds) {
        Seq<String> releaseJsons = this.archivedReleasesSearch.searchReleasesByIds(releaseIds);
        return (Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<ReleaseBasicDataExt> searchReleasesBasicExtByReleaseIds(Seq<String> releaseIds) {
        return this.archivedReleasesSearch.searchReleasesBasicInfoByIds((Seq<String>)((Seq)releaseIds.map((Function1 & Serializable & scala.Serializable)x$8 -> FullReleaseId$.MODULE$.apply((String)x$8).withOnlyOneParentOrApplicationsForArchiveDb(), Seq$.MODULE$.canBuildFrom())));
    }

    private Option<Release> getReleaseOption(String releaseId, boolean includePreArchived) {
        return this.archivedReleases().getRelease(releaseId, includePreArchived).map((Function1 & Serializable & scala.Serializable)releaseJson -> {
            void var3_3;
            Release release = ArchivingService$.MODULE$.deserializeArchivedRelease((String)releaseJson, $this.repositoryAdapter);
            Map<String, String> attachmentsFileNames = this.archivedReleases().getAttachmentsFileNames(release.getId());
            release.getAttachments().forEach(attachment -> {
                Option option = attachmentsFileNames.get((Object)ArchivedReleases$.MODULE$.shortenId(attachment.getId()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String filename = (String)some.value();
                    attachment.setFile((OverthereFile)SourceArtifactFile.withNullableWorkDir((String)filename, (SourceArtifact)attachment, null));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Could not find attachment ").append(attachment.getId()).append(" of release ").append(releaseId).append(" in the attachments table").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            });
            return var3_3;
        });
    }

    private boolean getReleaseOption$default$2() {
        return false;
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)release -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()).find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$9))));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        void var2_2;
        Buffer dependencies = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$10.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$11)));
        dependencies.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.archive();
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$archiveRelease$6(Task task$1, Facet x$1) {
        String string = x$1.getTargetId();
        String string2 = task$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archiveRelease$10(ArchivingService $this, Facet facet) {
        ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete(facet.getId(), ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete$default$2());
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$2, Attachment attachment$1, WorkDir workDir$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$2.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
            workDir$1.delete();
            WorkDirContext.clear();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$2, Attachment attachment) {
        WorkDirContext.initWorkdir();
        WorkDir workDir = WorkDirContext.get();
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable & scala.Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$2, attachment, workDir, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$3(Task task$2, Facet x$2) {
        String string = x$2.getTargetId();
        String string2 = task$2.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$5(scala.collection.immutable.Set specialTypes$1, Facet facet) {
        Type type = facet.getType();
        return specialTypes$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)type.instanceOf(x$1)));
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        Seq rawDependenciesToArchive = (Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (Seq<String>)((Seq)rawDependenciesToArchive.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getId(), Seq$.MODULE$.canBuildFrom())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$9) {
        String string = x$9.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$11) {
        return !x$11.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentService commentService, FacetRepositoryDispatcher facetRepositoryDispatcher) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentService = commentService;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        Logging.$init$((Logging)this);
        facetRepositoryDispatcher.setupGenericFacetArchiveRepository(this);
    }
}

