/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalAndFolderVariablesDecorator;
import com.xebialabs.xlrelease.api.internal.ReleaseServerUrlDecorator;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperations;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.ExecuteRecoverAction;
import com.xebialabs.xlrelease.script.ExecuteRecoverCallback;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.service.ChangeExecutionService;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.ExecutionServiceVisitor;
import com.xebialabs.xlrelease.service.PostActionVisitor;
import com.xebialabs.xlrelease.service.ScriptResultsService;
import com.xebialabs.xlrelease.service.TaskBackup;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.Option;

@Service
public class ExecutionService
implements ExecutionServiceVisitor,
ExecuteRecoverCallback {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionService.class);
    private ReleaseRepository releaseRepository;
    private TaskRepository taskRepository;
    private DependencyService dependencyService;
    private ScriptLifeCycle scriptLifeCycle;
    private TaskBackup taskBackup;
    private ReleaseActorService releaseActorService;
    private XLReleaseEventBus eventBus;
    private TeamService teamService;
    private ChangeExecutionService changeExecutionService;
    private ScriptResultsService scriptResultsService;
    private Map<String, ScriptService> scriptServices = new HashMap<String, ScriptService>();
    private Map<Class<? extends Task>, TaskExecutor<? extends Task>> taskExecutorsPerType = new HashMap<Class<? extends Task>, TaskExecutor<? extends Task>>();
    private InternalMetadataDecoratorService decoratorService;
    private ServerConfiguration serverConfiguration;

    @Autowired
    public ExecutionService(ReleaseRepository releaseRepository, TaskRepository taskRepository, DependencyService dependencyService, ScriptLifeCycle scriptLifeCycle, TaskBackup taskBackup, ReleaseActorService releaseActorService, XLReleaseEventBus eventBus, List<? extends TaskExecutor<? extends Task>> taskExecutors, Collection<? extends ScriptService> scriptServices, InternalMetadataDecoratorService decoratorService, TeamService teamService, ChangeExecutionService changeExecutionService, ServerConfiguration serverConfiguration, ScriptResultsService scriptResultsService) {
        this.releaseRepository = releaseRepository;
        this.taskRepository = taskRepository;
        this.dependencyService = dependencyService;
        this.scriptLifeCycle = scriptLifeCycle;
        this.taskBackup = taskBackup;
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
        this.decoratorService = decoratorService;
        this.teamService = teamService;
        this.changeExecutionService = changeExecutionService;
        this.serverConfiguration = serverConfiguration;
        this.scriptResultsService = scriptResultsService;
        this.setTaskExecutors(taskExecutors);
        scriptServices.forEach(scriptService -> this.scriptServices.put(scriptService.engine(), (ScriptService)scriptService));
    }

    private void setTaskExecutors(List<? extends TaskExecutor<? extends Task>> taskExecutors) {
        taskExecutors.forEach(executor -> {
            Class taskType = executor.getTaskClass();
            if (this.taskExecutorsPerType.containsKey(taskType)) {
                throw new IllegalStateException(String.format("Two executors are registered for the same task type %s: %s and %s", taskType, this.taskExecutorsPerType.get(taskType), executor));
            }
            this.taskExecutorsPerType.put(taskType, (TaskExecutor<? extends Task>)executor);
        });
    }

    @Timed
    public Release start(Release release, User user) {
        this.decorateWithMetadata(release);
        Changes changes = release.start();
        this.processChangesAndPublishOperations(changes, user);
        return release;
    }

    @Timed
    public Release start(Release release, User user, boolean releaseStartedImmediatelyAfterBeingCreated, boolean isPartOfBulkOperation) {
        this.decorateWithMetadata(release);
        Changes changes = isPartOfBulkOperation ? release.startAsPartOfBulkOperation() : release.start(releaseStartedImmediatelyAfterBeingCreated);
        this.processChangesAndPublishOperations(changes, user);
        return release;
    }

    @Timed
    public Release abort(String releaseId, String abortComment, boolean isPartOfBulkOperation) {
        Release release = this.releaseRepository.findById(releaseId);
        Preconditions.checkState((boolean)release.hasNoAutomatedTaskRunning(), (String)"The release %s could not be aborted because it has automated tasks that are in progress.", (Object)release.getTitle());
        Preconditions.checkState((release.getStatus() != ReleaseStatus.COMPLETED ? 1 : 0) != 0, (String)"You can not abort completed release.", (Object)release.getTitle());
        this.teamService.decorateWithStoredTeams(release);
        this.decorateWithMetadata(release);
        Changes changes = isPartOfBulkOperation ? release.abortAsPartOfBulkOperation(abortComment) : release.abort(abortComment);
        this.publishBeforeEvents(changes);
        this.applyChanges(changes, User.AUTHENTICATED_USER);
        this.publishAfterEvents(changes);
        this.failDependentGates(changes, release.getTitle());
        return release;
    }

    @Timed
    public Release resume(String releaseId) {
        Release release = this.releaseRepository.findById(releaseId);
        Preconditions.checkState((boolean)release.isPaused(), (String)"Only paused releases may be restarted. Release '%s' is %s.", (Object)release.getTitle(), (Object)release.getStatus());
        this.decorateWithMetadata(release);
        Changes changes = release.resume();
        this.processChangesAndPublishOperations(changes, User.AUTHENTICATED_USER);
        return release;
    }

    @Timed
    public void startPendingTask(String taskId, Release release, String comment, User user) {
        boolean shouldConsiderBlackoutPeriods = User.SYSTEM.equals((Object)user);
        if (shouldConsiderBlackoutPeriods) {
            this.decorateWithMetadata(release);
        }
        Changes changes = release.startPendingTask(taskId);
        changes.addComment(release.getTask(taskId), comment);
        this.processChangesAndPublishOperations(changes, user);
    }

    @VisibleForTesting
    void executePostActions(Changes changes) {
        changes.getPostActions().forEach(action -> action.accept((PostActionVisitor)this));
    }

    private void publishBeforeEvents(Changes changes) {
        XLReleaseOperations.runActionInterceptors(changes.getOperations(), this.eventBus);
    }

    private void publishAfterEvents(Changes changes) {
        XLReleaseOperations.publishEvents(changes.getOperations(), this.eventBus);
    }

    @Timed
    public void finishCustomScriptTask(Release release, String taskId, String comment, String executionId, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> scriptResults) {
        CustomScriptTask task = (CustomScriptTask)release.getTask(taskId);
        Changes changes = new Changes();
        scriptResults.ifPresent(s -> changes.addAll(this.scriptResultsService.resolveScriptTaskResults((Task)task, (DefaultScriptService.BaseScriptTaskResults)s)));
        if (task.isWaitingForSignal()) {
            logger.info("Will not complete task: '{}', staying in progress until task condition is met.", (Object)taskId);
        } else if (task.isStillExecutingScript(executionId)) {
            if (task.isAbortScriptInProgress()) {
                this.fail(changes, (Task)task, "Abort script finished.", logArtifactId, Optional.empty(), User.SYSTEM, false);
            } else {
                this.markTaskAsDone(changes, release, TaskStatus.COMPLETED, taskId, comment, logArtifactId, Optional.empty(), User.LOG_OUTPUT);
            }
        } else {
            logger.debug("Will not complete task: '$taskId', it has been aborted.");
        }
    }

    @Timed
    public void finishScriptTask(Release release, String taskId, String comment, String executionId, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> scriptResults) {
        Task task = release.getTask(taskId);
        Changes changes = new Changes();
        scriptResults.ifPresent(sr -> changes.addAll(this.scriptResultsService.resolveScriptTaskResults(task, (DefaultScriptService.BaseScriptTaskResults)sr)));
        if (task.isStillExecutingScript(executionId)) {
            this.markTaskAsDone(changes, release, TaskStatus.COMPLETED, taskId, comment, logArtifactId, Optional.empty(), User.LOG_OUTPUT);
        } else {
            logger.debug("Will not complete task: '$taskId', it has been aborted.");
        }
    }

    private void markTaskAsDone(Changes changes, Release release, TaskStatus targetStatus, String taskId, String addedComment, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> scriptResults, User user) {
        this.decorateWithMetadata(release);
        Task task = release.getTask(taskId);
        scriptResults.ifPresent(baseScriptTaskResults -> changes.addAll(this.scriptResultsService.resolveScriptTaskResults(task, (DefaultScriptService.BaseScriptTaskResults)baseScriptTaskResults)));
        if (User.LOG_OUTPUT.equals((Object)user)) {
            this.attachScriptOutput(changes, task, addedComment, logArtifactId);
        } else {
            changes.addComment(task, addedComment);
        }
        if (targetStatus.isDoneInAdvance()) {
            changes.addAll(task.markAsDone(taskId, targetStatus));
        } else {
            changes.addAll(release.markTaskAsDone(taskId, targetStatus));
        }
        this.processChangesAndPublishOperations(changes, user);
    }

    @Timed
    public void markTaskAsDone(Release release, TaskStatus targetStatus, String taskId, String addedComment, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> scriptResults, User user) {
        this.markTaskAsDone(new Changes(), release, targetStatus, taskId, addedComment, logArtifactId, scriptResults, user);
    }

    @Timed
    public void markTaskAsDone(Release release, TaskStatus targetStatus, String taskId, String addedComment, User user) {
        this.markTaskAsDone(release, targetStatus, taskId, addedComment, Optional.empty(), Optional.empty(), user);
    }

    @Timed
    public void scriptFailed(String taskId, String scriptFailMessage, String scriptExecutionId, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> scriptResults, User user) {
        Object task = this.taskRepository.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
        Changes changes = new Changes();
        scriptResults.ifPresent(s -> changes.addAll(this.scriptResultsService.resolveScriptTaskResults((Task)task, (DefaultScriptService.BaseScriptTaskResults)s)));
        if (task.isStillExecutingScript(scriptExecutionId)) {
            this.fail(changes, (Task)task, FailureReasons.SCRIPT_TASK_FAILED.format(new Object[]{scriptFailMessage}), logArtifactId, Optional.empty(), user, false);
        } else {
            logger.debug("Will not fail task: '{}', it has been aborted.", (Object)task.getId());
            this.attachScriptOutput(changes, (Task)task, scriptFailMessage, logArtifactId);
            this.processChangesAndPublishOperations(changes, User.LOG_OUTPUT);
        }
    }

    @Timed
    public void fail(Task task, String addedComment, Optional<DefaultScriptService.BaseScriptTaskResults> baseScriptTaskResults, User user) {
        this.fail(new Changes(), task, addedComment, Optional.empty(), baseScriptTaskResults, user, false);
    }

    @Timed
    public void fail(Task task, String addedComment, User user) {
        this.fail(new Changes(), task, addedComment, Optional.empty(), Optional.empty(), user, false);
    }

    private void fail(Changes changes, Task task, String addedComment, Optional<String> logArtifactId, Optional<DefaultScriptService.BaseScriptTaskResults> baseScriptTaskResults, User user, boolean fromAbort) {
        Release release = task.getRelease();
        baseScriptTaskResults.ifPresent(s -> changes.addAll(this.scriptResultsService.resolveScriptTaskResults(task, (DefaultScriptService.BaseScriptTaskResults)s)));
        if (User.LOG_OUTPUT.equals((Object)user)) {
            changes.addAll(release.failTask(task.getId(), "", fromAbort));
            this.attachScriptOutput(changes, task, addedComment, logArtifactId);
        } else {
            changes.addAll(release.failTask(task.getId(), addedComment, user, fromAbort));
        }
        this.publishBeforeEvents(changes);
        this.processChanges(changes, user);
        this.publishAfterEvents(changes);
        if (release.isAbortOnFailure() && release.isAborted()) {
            this.failDependentGates(changes, release.getTitle());
        }
    }

    @Timed
    public void retry(Task task, String addedComment) {
        Release release = task.getRelease();
        this.decorateWithMetadata(release);
        Changes changes = release.retryTask(task.getId());
        changes.addComment(task, addedComment);
        this.processChangesAndPublishOperations(changes, User.AUTHENTICATED_USER);
    }

    @Timed
    public Task startWithInput(String taskId, List<Variable> variables) {
        Object task = this.taskRepository.findById(taskId);
        Task updated = this.updateVariables(variables, (Task)task);
        Release release = updated.getRelease();
        this.decorateWithMetadata(release);
        this.processChangesAndPublishOperations(release.startWithInput(taskId), User.AUTHENTICATED_USER);
        return task;
    }

    private Task updateVariables(List<Variable> variables, Task task) {
        Map inputVariablesByKey = VariableHelper.indexByKey(variables);
        task.getInputVariables().stream().filter(variable -> inputVariablesByKey.containsKey(variable.getKey())).forEach(variable -> variable.setUntypedValue(((Variable)inputVariablesByKey.get(variable.getKey())).getValue()));
        return this.taskRepository.update(task);
    }

    @Timed
    public void abortTask(Task task, String addedComment) {
        this.scriptLifeCycle.tryAborting(task.getExecutionId());
        String comment = FailureReasons.SCRIPT_TASK_ABORTED.format(new Object[]{addedComment});
        if (task.isAbortScriptInProgress()) {
            comment = FailureReasons.ABORT_SCRIPT_TASK_ABORTED.format(new Object[]{addedComment});
        }
        this.fail(new Changes(), task, comment, Optional.empty(), Optional.empty(), User.AUTHENTICATED_USER, true);
    }

    @Timed
    public void reopenTask(Task task, String addedComment) {
        Changes changes = task.reopen();
        changes.addComment(task, addedComment);
        this.publishBeforeEvents(changes);
        this.applyChanges(changes, User.AUTHENTICATED_USER);
        this.publishAfterEvents(changes);
    }

    private void completeDependentGates(Changes changes) {
        Collection<String> completableGateIds = this.dependencyService.getCompletableGateIds(this.toPlanItems(changes.getUpdatedItems()));
        for (String gateId : completableGateIds) {
            this.releaseActorService.markTaskAsDoneAsync(TaskStatus.COMPLETED, gateId, null, User.SYSTEM);
        }
    }

    private void failDependentGates(Changes changes, String releaseTitle) {
        Collection<String> failableGateIds = this.dependencyService.getFailableGateIds(this.toPlanItems(changes.getUpdatedItems()));
        for (String gateId : failableGateIds) {
            this.releaseActorService.failTaskAsync(gateId, FailureReasons.GATE_TASK_DEPENDS_ON_AN_ABORTED_RELEASE.format(new Object[]{releaseTitle}), User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
        }
    }

    private void attachScriptOutput(Changes changes, Task task, String addedComment, Optional<String> logArtifactId) {
        if (logArtifactId.isPresent()) {
            changes.linkScriptOutputLog(task, logArtifactId.get());
        } else {
            changes.addAttachment(task, addedComment.getBytes(StandardCharsets.UTF_8), new SimpleDateFormat("'script_output_'yyyyMMddHHmmss'.log'").format(new Date()), "text/plain");
        }
    }

    private Set<PlanItem> toPlanItems(Set<ConfigurationItem> updatedItems) {
        return updatedItems.stream().filter(PlanItem.class::isInstance).map(PlanItem.class::cast).collect(Collectors.toSet());
    }

    private void applyChanges(Changes changes, User user) {
        this.changeExecutionService.applyChanges(changes, user);
    }

    @Timed
    public void resumeTask(String taskId) {
        this.executeTask((Task)this.taskRepository.findById(taskId));
    }

    @Timed
    public void executeTask(Task task) {
        TaskExecutor<? extends Task> taskExecutor = this.taskExecutorsPerType.get(task.getClass());
        Preconditions.checkArgument((taskExecutor != null ? 1 : 0) != 0, (String)"Cannot execute task because there is no executor defined for task type '%s'", (Object)task.getType().toString());
        Release release = task.getRelease();
        if (release == null || !release.isAllowPasswordsInAllFields()) {
            taskExecutor.execute((Task)task, SensitiveValueScrubber.disabled());
            return;
        }
        Map passwordVariables = release.getPasswordVariableValues();
        passwordVariables.forEach((key, value) -> {
            String decryptedValue = PasswordEncrypter.getInstance().ensureDecrypted(value);
            passwordVariables.put(key, decryptedValue);
        });
        Changes changes = new Changes();
        if (task instanceof BaseScriptTask) {
            task.freezeVariablesInCustomFields(passwordVariables, passwordVariables, changes, true);
        }
        SensitiveValueScrubber scrubber = new SensitiveValueScrubber(changes.getVariablesUsed(), passwordVariables);
        taskExecutor.execute((Task)task, scrubber);
    }

    @Timed
    public void executePrecondition(Task task) {
        this.scriptServices.get("jython").executePrecondition(task).thenAccept(r -> r.save(this.releaseActorService));
    }

    @Timed
    public void executeFacetCheck(Task task) {
        this.scriptServices.get("jython").executeFacetCheck(task).thenAccept(r -> r.save(this.releaseActorService));
    }

    @Timed
    void executeFailureHandler(Task task) {
        long timeout = XlrConfig.getInstance().timeoutSettings().failureHandlerTimeout().toSeconds();
        try {
            this.scriptServices.get("jython").executeFailureHandler(task).thenAccept(r -> r.executeCallback(this.releaseActorService, this.recoverCallback(task), (Function1<Throwable, ExecuteRecoverAction>)this.fallbackCallback(task)));
        }
        catch (Exception e) {
            String message = String.format("Failure handler of task [%s] with script execution [%s] was terminated due to timeout of [%s] seconds. Consider to increase 'xl.timeouts.failureHandlerTimeout' property", task.getId(), task.getExecutionId(), timeout);
            logger.warn(message);
            this.releaseActorService.addCommentToTask(task.getId(), message);
        }
    }

    @Timed
    void executeAbortScript(Task task) {
        Preconditions.checkArgument((boolean)(task instanceof CustomScriptTask), (String)"Cannot execute abort script because task is not an instance of CustomScriptTask", (Object)task.getType().toString());
        ((CustomScriptTask)task).resetSchedule();
        this.executeTask(task);
    }

    @Timed
    public void taskPreconditionValidated(String taskId, Release release) {
        this.decorateWithMetadata(release);
        Changes changes = release.taskPreconditionValidated(taskId);
        this.processChangesAndPublishOperations(changes, User.LOG_OUTPUT);
    }

    @Timed
    public void postponeUntilEnvironmentsAreReserved(String taskId, Date postponeUntil, String comment) {
        Object task = this.taskRepository.findById(taskId);
        Changes changes = task.postponeUntilEnvironmentsAreReserved(postponeUntil);
        this.processChangesAndPublishOperations(changes, User.LOG_OUTPUT);
    }

    @Override
    public ReleaseActorService exec() {
        return this.releaseActorService;
    }

    @Override
    public TaskRepository taskRepo() {
        return this.taskRepository;
    }

    @Override
    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    private void processChangesAndPublishOperations(Changes changes, User user) {
        this.publishBeforeEvents(changes);
        this.processChanges(changes, user);
        this.publishAfterEvents(changes);
        this.completeDependentGates(changes);
    }

    private void processChanges(Changes changes, User user) {
        this.taskBackup.backupTasks(changes.getTasksToBackup());
        this.applyChanges(changes, user);
        this.executePostActions(changes);
    }

    private void decorateWithMetadata(Release release) {
        this.decoratorService.decorate((ConfigurationItem)release, Arrays.asList(BlackoutMetadata.BLACKOUT(), ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES(), ReleaseServerUrlDecorator.SERVER_URL()));
    }
}

