package com.xebialabs.xltest.fitnesse;

import java.util.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.ImportFailedException;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.utils.OverthereFileComparator;
import com.xebialabs.xltest.utils.TestToolCategory;
import com.xebialabs.xltest.utils.glob.FileMatcher;

public class FitNesseTestTool extends BaseTestTool {
    private final static Logger LOG = LoggerFactory.getLogger(FitNesseTestTool.class);

    @Override
    public String getName() {
        return "FitNesse";
    }

    @Override
    public List<Importable> findImportables(OverthereFile remoteResultPath, FileMatcher fileMatcher) throws ImportFailedException {
        LOG.debug("findImportables({},{})", remoteResultPath, fileMatcher);
        LocalFile resultPath = retrieveFiles(remoteResultPath);

        Collection<OverthereFile> fitNesseRoots = findTestResultPaths(resultPath, fileMatcher);

        try {
            List<Importable> importables = new ArrayList<>();
            for (OverthereFile fitNesseRoot : fitNesseRoots) {
                LocalFile localFile = (LocalFile) fitNesseRoot;
                importables.addAll(new PageHistoryExtractor(localFile.getFile()).createImportables());
            }
            return importables;
        } catch (Exception e) {
            throw new ImportFailedException("Unable to determine what to import from FitNesse path " + remoteResultPath, e);
        }
    }

    @Override
    public String getDefaultSearchPattern() {
        return "**/FitNesseRoot";
    }

    @Override
    public String getCategory() {
        return TestToolCategory.FUNCTIONAL;
    }

}
